/*
  This JavaScript engine saves only the
  'myOptions' && 'myChoose' combobox
  contents into a session file and after
  reloading the current page reads the
  current contents from the session and
  reloads that into the comboboxes
  Budapest, 2013-11-27
*/

// cbMyOption is the selected ComboBox */
var cbMyOptions;
// cbMyChoose is the selected ComboBox */
var cbMyChoose;

window.onload=function() {
  // get the cbMyOptions select with ID=sizes
  cbMyOptions = document.getElementById('myOptions');
  // the following statement gets the cbMyOptionsect and sets the index to the cookie content if
  // there IS a cookie, else it sets it to 0
  var idx = readCookie("myLBIndex") || 0;
  // make sure it is a number
  cbMyOptions.selectedIndex = parseInt(idx);
  
  cbMyChoose = document.getElementById('myChoose');
  var idxCh = readCookie("myLBCHIndex") || 0;
  cbMyChoose.selectedIndex = parseInt(idxCh);
  
  // now call the function and pass the selected to it
  // myComboBoxState();
}

function myComboBoxState() {
  // myOptions ComboBox
  var mydataIndex = cbMyOptions.selectedIndex;
  var mydata = cbMyOptions[mydataIndex].text;
  // myOptions ComboBox cookies
  setCookie("myLBIndex",mydataIndex,1);
  setCookie("myLBData",mydata,1);
  
  // myChoose ComboBox
  var mychooseIndex = cbMyChoose.selectedIndex;
  var mychoose = cbMyChoose[mychooseIndex].text;
  // myChoose ComboBox cookies
  setCookie("myLBCHIndex",mychooseIndex,1);
  setCookie("myLBCHData",mychoose,1);
}

function setCookie(cookieName,cookieValue,nDays) {
  var today = new Date();
  var expire = new Date();
  if (nDays==null || nDays==0)
    nDays=1;
  expire.setTime(today.getTime() + 3600000*24*nDays);
  document.cookie = cookieName+"="+escape(cookieValue)
                 + ";expires="+expire.toGMTString();
}

function readCookie(cookieName) {
  var theCookie=" "+document.cookie;
  var ind=theCookie.indexOf(" "+cookieName+"=");
  
  if (ind==-1)
    ind=theCookie.indexOf(";"+cookieName+"=");
  if (ind==-1 || cookieName=="")
    return "";
  var ind1=theCookie.indexOf(";",ind+1);
  if (ind1==-1)
    ind1=theCookie.length; 
  
  return unescape(theCookie.substring(ind+cookieName.length+2,ind1));
}