<?php
// $Id: pnadmin.php
// LICENSE
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License (GPL)
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WIthOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// To read the license please visit http://www.gnu.org/copyleft/gpl.html
// ----------------------------------------------------------------------
// Filename: 1.0
// Based on : pnDProject
// Purpose of file:  Admin functions for dplink
// ----------------------------------------------------------------------

/**
 * the main administration function
 */
function dplink_admin_main()
{

    // Create output object
    $output = new pnHTML();

    // Security check
    if (!pnSecAuthAction(0, 'dplink::', '::', ACCESS_ADMIN)) {
        $output->Text(pnVarPrepHTMLDisplay(_SHIMLINKNOAUTH));
        return $output->GetOutput();
    }

    // Add menu to output
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->Text(dplink_adminmenu());
    $output->SetInputMode(_PNH_PARSEINPUT);

    // Return the output that has been generated by this function
    return $output->GetOutput();
}

/*
 * Main administration menu
 */
function dplink_adminmenu() {

   $theme = pnUserGetTheme();
	pnThemeLoad($theme);

    // Create output object
    $output = new pnHTML();

    // Security check
    if (!pnSecAuthAction(0, 'dplink::', '::', ACCESS_ADMIN)) {
        $output->Text(pnVarPrepHTMLDisplay(_SHIMLINKNOAUTH));
        return $output->GetOutput();
    }

	//Title
	ob_start();
	OpenTable();
	$oTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($oTable);
	$output->Title(pnVarPrepHTMLDisplay('<b>'._SHIMLINK.'</b>'));
    $output->Text(pnVarPrepHTMLDisplay(_SHIMLINKMODIFYCONFIG));
	ob_start();
	CloseTable();
	$cTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($cTable);

	// Start form
    $output->FormStart(pnModURL('dplink', 'admin', 'updateconfig'));

    // Add an authorisation ID
    $output->FormHidden('authid', pnSecGenAuthKey());


    // Start the table that holds the information to be modified.
    ob_start();
	OpenTable();
	$oTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($oTable);
	$output->TableStart();

	// dplink location
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODSUBJECT));
    $row[] = $output->FormText('url', pnModGetVar('dplink', 'url'), 50, 50);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// Warning
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODWARNING));
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');


	// Use I-frame
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODWRAP));
    $row[] = $output->FormCheckbox('use_wrap', pnModGetVar('dplink', 'use_wrap'));
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');

	// Open in New >Window
    $row = array();
    $output->SetOutputMode(_PNH_RETURNOUTPUT);
    $row[] = $output->Text(pnVarPrepHTMLDisplay(_MODWINDOW));
    $row[] = $output->FormCheckbox('use_window', pnModGetVar('dplink', 'use_window'));
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableAddrow($row, 'left');


	$output->TableEnd();
	ob_start();
	CloseTable();
	$cTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($cTable);

	// End form
    //$output->Linebreak(1);
	ob_start();
	OpenTable();
	$oTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($oTable);
	$output->Text('<div align="center"><br>');
    $output->FormSubmit(pnVarPrepHTMLDisplay(_SHIMLINKUPDATE));
	$output->Text('<br><br></div>');
	ob_start();
	CloseTable();
	$cTable = ob_get_contents();
	ob_end_clean();
	$output->SetInputMode(_PNH_VERBATIMINPUT);
	$output->Text($cTable);
    $output->FormEnd();

	// Return the output that has been generated by this function
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
	return $output->GetOutput();
}

function dplink_admin_updateconfig()
{
    // Get parameters from whatever input we need.
	$_loc = pnVarCleanFromInput('url');
	$_window = pnVarCleanFromInput('use_window');
	$_wrap = pnVarCleanFromInput('use_postwrap');


    // Confirm authorisation code.
    if (!pnSecConfirmAuthKey()) {
        pnSessionSetVar('errormsg', _BADAUTHKEY);
        pnRedirect(pnModURL('dplink', 'admin', ''));
        return true;
    }

    // Update module variables.
    pnModSetVar('dplink', 'url', $_loc);
    pnModSetVar('dplink', 'use_window', $_window);
    pnModSetVar('dplink', 'use_postwrap', $_wrap);

    // This function generated no output, and so now it is complete we redirect
    // the user to an appropriate page for them to carry on their work
    pnRedirect('admin.php');

    // Return
    return true;
}
?>
