<?php
  require('../../aniBuilder.php');
  require('../../'.ANIBUILDER_VERSION.'/ebuilder/ebuilder.php');
	$EBUILDER=new Ebuilder();
  
  /* get a new line independent of the environment: cli, web */
  function getNewLine() {
    /* new line char */
    if (php_sapi_name() === 'cli')
      $eol="\n";
    else
     $eol="<br />";
    
    return $eol;
  }
  
  $eol=getNewLine();
  /* debug mode */
  $isDebug=false;

  /****************************************************************************/
  /*************************** MYSQL / MARIADB TEST ***************************/
  /****************************************************************************/
  
  /* connection parameters only for the test, database sql file can be found in sql subdirectory */
  $driver='mysql';
  $host='localhost';
  $port='3306';
  $username='pdotest';
  $passwd='pdotest';
  $dbname='pdotest';
  $dsn="mysql:host=".$host.";port=".$port.";dbname=".$dbname;
  
  /****************************/
  /* NEW AND MORE SIMPLE TOOL */
  /****************************/
  
  /* get instance of PDOToolHelper class */
  $db=new PDOToolHelper($dsn,$username,$passwd,false,false,"utf8",null,true,false);
  
  /* get instance of a PDOToolManifest class from the PDOTool class */
  $manifest=$db->Manifest();
  /* set error log mode true to show error on screen or false to log in log file */
  $db->setErrorLog(true);
  
  /************************** SELECT **************************/
  $db->Connect(false);
  echo $db->getPDO($isDebug)."; ".$db->readMessage().$eol.$eol;

  /* query */
  echo " * Without prepare * ".$eol;
  $query="SELECT * FROM animals";
  echo  $query.$eol.$eol;

  /* get the result set */
  echo "1) WHILE and FETCH".$eol;
  $rows=$db->runQuery($query);
  if ($rows!=false) {
    echo "<table border=\"1\">";
    while ($row=$rows->fetch()) {
      echo "<tr><td>".$row['animal_id']."</td><td>".$row['animal_type']."</td><td>".$row['animal_name']."</td></tr>";
    }
    echo "</table>";
  }
  
  echo "2) FOR and FETCHALL".$eol;
  $rows=$db->runQuery($query);
  $rowsAll=$rows->fetchAll();
  if ($rows!=false) {
    echo "<table border=\"1\">";
    for ($i=0;$i<count($rowsAll);++$i) {
      echo "<tr><td>".$rowsAll[$i]["animal_id"]."</td><td>".$rowsAll[$i]["animal_type"]."</td><td>".$rowsAll[$i]["animal_name"]."</td></tr>";
    }
    echo "</table>";
  }
  echo $eol;
  
  /* query */
  echo " * With prepare * ".$eol;
  $query="SELECT * FROM animals";
  echo  $query.$eol.$eol;

  /* get the result set */
  echo "1) WHILE and FETCH".$eol;
  $rows=$db->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
  $db->ExecQueryPrep();
  $rows=$db->ResultSetPrep(PDO::FETCH_ASSOC);
  
  $i=0;
  $result="";
  echo "<table border=\"1\">";
  if ($rows!=false) {
    while ($i<count($rows)) {
      $result.="<tr><td>".$rows[$i]['animal_id']."</td><td>".$rows[$i]['animal_type']."</td><td>".$rows[$i]['animal_name']."</td></tr>";
      ++$i;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo $result;
  echo "</table>";
  
  echo "2) FOR and FETCHALL".$eol;
  $rows=$db->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
  $db->ExecQueryPrep();
  $rows=$db->ResultSetPrep(PDO::FETCH_ASSOC);
  $result="";
  echo "<table border=\"1\">";
  if ($rows!=false) {
    for ($i=0;$i<count($rows);++$i) {
      $result.="<tr><td>".$rowsAll[$i]["animal_id"]."</td><td>".$rowsAll[$i]["animal_type"]."</td><td>".$rowsAll[$i]["animal_name"]."</td></tr>";
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo $result;
  echo "</table>";
  
  /***************/
  /* OLDER TOOLS */
  /***************/
  
  /* selected fields */
  $selectFields=array('animal_id','animal_type','animal_name');
  /* set where condition */
  $whereConditions=array('animal_type'=>'koala');
  /* select with where and bind param use select method */
  $q=$db->SelectPrep('animals');
  /* print array result */
  $manifest->PA($q);
  echo "<table border=\"1\">";
  /* print array result in a table */
  foreach ($q as $key => $val) {
    echo "<tr>";
    foreach ($val as $mykey => $myval) {
      echo '<td><pre>',print_r( $mykey.' '.$myval,true),'</pre></td>';
    }
    echo "</tr>";
  }
  echo "</table>";
  
  $selectFields=array('animal_id','animal_type');
  /* set where condition */
  $whereConditions=array();
  /* select with where and bind param use select method */
  $q=$db->SelectPrep('animals');
  // print array result
  $manifest->PA($q);
  
  /************************** INSERT **************************/
  /* insert into these fields */
  $dataArray=array('animal_type'=>'ciculi','animal_name'=>'Surcee');
  /* use insert function */
  $q=$db->InsertPrep('animals',$dataArray);
  if ($manifest->PA($q))
    echo "Add a new record";
  else
    echo "Has not been added a new record";
  
  /************************** UPDATE **************************/
  /* update array data */
  $dataArray=array("animal_type"=>"kutyuli");
  //$dataArray=array("animal_type"=>"kutyUlee");
  /* where condition */
  $aWhere="animal_id = 25";
  /* call update function */
  $q=$db->UpdatePrep("animals",$dataArray,$aWhere,"");
  /* print affected rows */
  $manifest->PA($q);
  
  /************************** DELETE **************************/
  /* where condition array */
  $aWhere="animal_id = 24";
  /* call delete function */
  $q=$db->DeletePrep("animals",$aWhere);
  /* print affected rows */
  $manifest->PA($q);
  
  /************************** RUN A QUERY **************************/
  //$q=$db->pdoQuery('select * from animals limit 5;')->showQuery()->results();
  $q=$db->ExecuteCommandPrep('select * from animals limit 5;');
  /* print array result */
  $manifest->PA($q);
  $q=$db->ExecuteCommandPrep('select * from animals where (animal_type = ? OR animal_name = ?) ;',array('Kutyuli','Kormoska'));
  /* print array result */
  $manifest->PA($q);
  
  /************************** NUMBER OF ROWS **************************/
  $q=$db->RowCountPrep();
  /* print affected rows */
  $manifest->PA('<b>Row count:</b> '.$q);
?>
