<?php
  require('../../aniBuilder.php');
  require('../../'.ANIBUILDER_VERSION.'/ebuilder/ebuilder.php');
  $ebuilder=new EBuilder();
  
  /* PHP default path of the $_SESSION array */
  $dir=session_save_path();
  $useAPCU=false;
  /* new cache object: cache_name, cache_dir, cache_extension: optional, isSalt: default false */
  if (!$useAPCU)
    $cache=new CacheTool($useAPCU,"test",$dir,".cache",false);
  else
    $cache=new CacheTool($useAPCU);
  //$cache=new CacheTool("test",$dir,".cache",true);
  //$cache=new CacheTool(false);
  
  /* set the autosave into a file function, default: cache can be found only in the memory */
  $autoSave=false;
  if ($autoSave)
    $cache->setAutoSave(true);
  
  /* delete unnecessary cache objects */
  $cache->deleteExpired();
  
  /* 1st cache object: key-value pair */
  $key="myKey";
  $value="myValue";
  $expire=30;
  /* set the cache in the memory/file */
  $cacheArray=$cache->Setter($key,$value,$expire);
  
  /* 2nd cache object: key-value pair */
  $key2="myKey2";
  $value2="myValue2";
  $expire=30;
  /* set the cache in the memory/file */
  $cacheArray=$cache->Setter($key2,$value2,$expire);
  
  /* if autosave function is disabled, can be saved the cache manually */
  // $cache->saveCache();
  
  /* get the cache object content */
  echo $key." = ".$cache->Getter($key)."<br>";
  echo $key2." = ".$cache->Getter($key2)."<br>";
  
  
  echo "APCU test:<br>";
  /* APCU test, delete is automatically after expiration time($ttl) */
  if ($cache->_checkAPCU()) {
    /* add to the APCU */
    if ($cache->_addAPCU($key,$value,$expire))
      echo "Add the new '".$key."' key with the '".$value."' value to the APCU!<br>";
    echo "APCU: ".$cache->_fetchAPCU($key)."<br>";
    
    /* update the APCU */
    if ($cache->_updateAPCU($key,"EzNeMaZ",$expire))
      echo "APCU: ".$cache->_fetchAPCU($key)."<br>";
    
    var_dump($cache->_infoAPCU());
    var_dump($cache->_smaInfoAPCU());
    
    /* delete from the APCU */
    $cache->_delAPCU($key);
    echo "APCU: ".$cache->_fetchAPCU($key)."<br>";
    
    var_dump($cache->_infoAPCU());
    var_dump($cache->_smaInfoAPCU());
    
    $cache->_clearAPCU();
    
    var_dump($cache->_infoAPCU());
    var_dump($cache->_smaInfoAPCU());
  }
?>
