<?php
	/***********************************************/
	/* a class to open an Excel file, which uses   */
	/*  the Vadim Tkachenko's PHPExcelReader class */
	/***********************************************/
	class phpExcelEngine {
		/* constructor: cannot make an object */
		private function __construct() {}
		
		/* returns with the first column value */
		private static function make_alpha_from_numbers($number) {
			$numeric="ABCDEFGHIJKLMNOPQRSTUVWXYZ";
			
			if ($number<strlen($numeric)) {
				return $numeric[$number];
			}
			else {
				$dev_by=floor($number/strlen($numeric));
				return "".phpExcelEngine::make_alpha_from_numbers($dev_by-1).phpExcelEngine::make_alpha_from_numbers($number-($dev_by*strlen($numeric)));
			}
		}
		
		/** open an Excel file without any formatting
		* $excelFile:		the Excel file we want to open
		* $xlsCodePage:	the code page of the opening Excel file
		* $siteCodePage:	the code page site where the opening Excel file will be showed
		*/
		public static function readExcelWithoutFormat($excelFile,$xlsCodePage='UTF-8',$siteCodePage) {
			require_once('phpExcelReader/phpExcelReader.php');
			
			$myExcelFile=new Spreadsheet_Excel_Reader();
			// Set output Encoding.
			$myExcelFile->setOutputEncoding($xlsCodePage);
			/***
			* if you want you can change 'iconv' to mb_convert_encoding:
			* $myExcelFile->setUTFEncoder('mb');
			*
			**/
			
			/***
			* By default rows & cols indeces start with 1
			* For change initial index use:
			* $myExcelFile->setRowColOffset(0);
			*
			**/
			
			/***
			*  Some function for formatting output.
			* $myExcelFile->setDefaultFormat('%.2f');
			* setDefaultFormat - set format for columns with unknown formatting
			*
			* $myExcelFile->setColumnFormat(4, '%.3f');
			* setColumnFormat - set format for column (apply only to number fields)
			*
			**/
			$myExcelFile->read($excelFile,$xlsCodePage);
			
			error_reporting(E_ALL ^ E_NOTICE);
			echo "<table border=\"1\">";
			for ($i=1;$i<=$myExcelFile->sheets[0]['numRows'];$i++) {
				echo "<tr>";
				for ($j=1;$j<=$myExcelFile->sheets[0]['numCols'];$j++) {
					echo "<td>";
					if ($siteCodePage==='UTF-8')
						echo nl2br(htmlentities(iconv(mb_detect_encoding($myExcelFile->sheets[0]['cells'][$i][$j], mb_detect_order(), true),
											 "UTF-8",
											 $myExcelFile->sheets[0]['cells'][$i][$j])));
					else
						echo $myExcelFile->sheets[0]['cells'][$i][$j];
					echo "</td>";
				}
				echo "</tr>";
			}
			echo "</table>";
		}
		
		/** open an Excel file with some formatting
		 * $excelFile:		the Excel file we want to open
		 * $codePage:			the code page of the opening Excel file
		 * $siteCodePage:	the code page site where the opening Excel file will be showed
		 * $maxRows:			how namy rows are showed, 0 is all rows
		 * $maxCols:			how many columns are showed, 0 is all columns
		*/
		public static function readExcelWithFormat($excelFile,$codePage='UTF-8',$siteCodePage,$maxRows=0,$maxCols=0) {
			require_once('phpExcelReader/phpExcelReader.php');
			
			/* Set to 0 not to allow changed VIA POST or GET */
			$allow_url_override=1;
			
			if (!$allow_url_override || !isset($file_to_include)) {
				$file_to_include=$excelFile;
			}
			
			if (!$allow_url_override || !isset($max_rows)) {
				$max_rows=$maxRows;
			}
			
			if (!$allow_url_override || !isset($max_cols)) {
				$max_cols=$maxCols;
			}
			
			/* 0 for off, 1 for on */
			if (!$allow_url_override || !isset($debug)) {
				$debug=0;
			}
			
			/* force the info in cells not to wrap unless stated explicitly (newline) */
			if (!$allow_url_override || !isset($force_nobr)) {
				$force_nobr=1;
			}
			
			$myExcelFile=new Spreadsheet_Excel_Reader();
			$myExcelFile->setOutputEncoding($codePage);
			$myExcelFile->read($file_to_include);
			error_reporting(E_ALL ^ E_NOTICE);
			
			echo "<style>
				.table_data {
					border-style: ridge;
					border-width: 1;
				}
				.tab_base {
					background: #81B7FA; /* light blue */
					font-weight: bold;
					border-style: ridge;
					border-width: 1;
					cursor: pointer;
				}
				.table_sub_heading {
					background: #CCCCCC; /* middle gray */
					font-weight: bold;
					border-style: ridge;
					border-width: 1;
				}
				.table_body {
					background: #F0F0F0; /* very light gray */
					font-wieght: normal;
					font-size: 12;
					font-family: Arial;
					border-style: ridge;
					border-width: 1;
					border-spacing: 0px;
					border-collapse: collapse;
				}
				.tab_loaded {
					background: #222222; /* dark gray */
					color: #F0F0F0;
					font-weight: bold;
					border-style: groove;
					border-width: 1;
					cursor: pointer;
				}
				</style>
			";
			
			echo "<script language='javascript' type='text/javascript'>
						var sheet_HTML = Array();\n";
			
			for ($sheet=0;$sheet<count($myExcelFile->sheets);$sheet++) {
				$table_output[$sheet].="<table class='table_body'>
				<tr>
				<td>&nbsp;</td>";
				
				for ($i=0;$i<$myExcelFile->sheets[$sheet]['numCols']&&($i<=$max_cols||$max_cols==0);$i++) {
					$table_output[$sheet].="<td class='table_sub_heading' align=center>".phpExcelEngine::make_alpha_from_numbers($i)."</td>";
				}
				
				for ($row=1;$row<=$myExcelFile->sheets[$sheet]['numRows']&&($row<=$max_rows||$max_rows==0);$row++) {
					$table_output[$sheet].="<tr><td class='table_sub_heading'>".$row."</td>";
					for ($col=1;$col<=$myExcelFile->sheets[$sheet]['numCols']&&($col<=$max_cols||$max_cols==0);$col++) {
						if ($myExcelFile->sheets[$sheet]['cellsInfo'][$row][$col]['colspan']>=1 && $myExcelFile->sheets[$sheet]['cellsInfo'][$row][$col]['rowspan']>=1) {
							$this_cell_colspan=" colspan=".$myExcelFile->sheets[$sheet]['cellsInfo'][$row][$col]['colspan'];
							$this_cell_rowspan=" rowspan=".$myExcelFile->sheets[$sheet]['cellsInfo'][$row][$col]['rowspan'];
							for ($i=1;$i<$myExcelFile->sheets[$sheet]['cellsInfo'][$row][$col]['colspan'];$i++) {
								$myExcelFile->sheets[$sheet]['cellsInfo'][$row][$col+$i]['dontprint']=1;
							}
							
							for ($i=1;$i<$myExcelFile->sheets[$sheet]['cellsInfo'][$row][$col]['rowspan'];$i++) {
								for ($j=0;$j<$myExcelFile->sheets[$sheet]['cellsInfo'][$row][$col]['colspan'];$j++) {
									$myExcelFile->sheets[$sheet]['cellsInfo'][$row+$i][$col+$j]['dontprint']=1;
								}
							}
						}
						else if ($myExcelFile->sheets[$sheet]['cellsInfo'][$row][$col]['colspan']>=1) {
							$this_cell_colspan=" colspan=".$myExcelFile->sheets[$sheet]['cellsInfo'][$row][$col]['colspan'];
							$this_cell_rowspan="";
							
							for ($i=1;$i<$myExcelFile->sheets[$sheet]['cellsInfo'][$row][$col]['colspan'];$i++) {
								$myExcelFile->sheets[$sheet]['cellsInfo'][$row][$col+$i]['dontprint']=1;
							}
						}
						else if ($myExcelFile->sheets[$sheet]['cellsInfo'][$row][$col]['rowspan']>=1) {
							$this_cell_colspan="";
							$this_cell_rowspan=" rowspan=".$myExcelFile->sheets[$sheet]['cellsInfo'][$row][$col]['rowspan'];
							
							for ($i=1;$i<$myExcelFile->sheets[$sheet]['cellsInfo'][$row][$col]['rowspan'];$i++) {
								$myExcelFile->sheets[$sheet]['cellsInfo'][$row+$i][$col]['dontprint']=1;
							}
						}
						else {
							$this_cell_colspan="";
							$this_cell_rowspan="";
						}
						
						if (!($myExcelFile->sheets[$sheet]['cellsInfo'][$row][$col]['dontprint'])) {
							$table_output[$sheet].="<td class='table_data' $this_cell_colspan $this_cell_rowspan>&nbsp;";
							
							if ($force_nobr) {
								$table_output[$sheet].="<nobr>";
							}
							
							if ($siteCodePage==='UTF-8')
								/* http://stackoverflow.com/questions/7979567/php-convert-any-string-to-utf-8-without-knowing-the-original-character-set-or */
								$table_output[$sheet].=nl2br(htmlentities(iconv(mb_detect_encoding($myExcelFile->sheets[$sheet]['cells'][$row][$col], mb_detect_order(), true),
																				 																					 "UTF-8",
																																									 $myExcelFile->sheets[$sheet]['cells'][$row][$col])));
							else
								echo $myExcelFile->sheets[0]['cells'][$i][$j];
							if ($force_nobr) {
								$table_output[$sheet].="</nobr>";
							}
							
							$table_output[$sheet].="</td>";
						}
					}
					
					$table_output[$sheet].="</tr>";
				}
				
				$table_output[$sheet].="</table>";
				$table_output[$sheet]=str_replace("\n","",$table_output[$sheet]);
				$table_output[$sheet]=str_replace("\r","",$table_output[$sheet]);
				$table_output[$sheet]=str_replace("\t"," ",$table_output[$sheet]);
				
				if ($debug) {
					$debug_output=print_r($myExcelFile->sheets[$sheet],true);
					$debug_output=str_replace("\n","\\n",$debug_output);
					$debug_output=str_replace("\r","\\r",$debug_output);
					$table_output[$sheet].="<pre>$debug_output</pre>";
				}
				
				echo "sheet_HTML[$sheet] = \"$table_output[$sheet]\";\n";
			}
			
			echo "function change_tabs(sheet) {
				for (i=0;i<",count($myExcelFile->sheets),";i++) {
					document.getElementById('sheet_tab_' + i).className='tab_base';
				}
				document.getElementById('table_loader_div').innerHTML=sheet_HTML[sheet];
				document.getElementById('sheet_tab_'+sheet).className='tab_loaded';
			}
			</script>";
			
			echo "
				<table class=\"table_body\" name=\"tab_table\">
				<tr>";
			for ($sheet=0;$sheet<count($myExcelFile->sheets);$sheet++) {
				echo "<td class=\"tab_base\" id=\"sheet_tab_$sheet\" align=\"center\"
							 onclick=\"change_tabs(".$sheet.");\">".$myExcelFile->boundsheets[$sheet]['name']."</td>";
				echo "<td></td>";
			}
			
			echo "</tr>";
			echo "</table>
			<div id=\"table_loader_div\"></div>
			<script language=\"javascript\" type=\"text/javascript\">
				change_tabs(0);
			</script>";
		}
	}
?>