<?php
  /**
   * Helper class for using more simple the PHP Data Object (PDO) Tool Class
   * 
   * created by garai, September 2020.
  **/
  
  class PDOToolHelper {
    /* the database connection object */
    private $DBCONN;
    private $dsn=null;
    private $user=null;
    private $pass=null;
    private $isMSSQL=false;
    private $isOra=false;
    private $codepage=null;
    private $oraTbl=null;
    private $isPrepare=null;
    private $setErrorMode=null;
    private $prep=null;
    
    /* Constructor: uses the PDOTool class from the '__pdo_tool.php' PHP file */
    public function __construct($dsn,$user,$pass,$isMSSQL,$isOra,$codepage=null,$oraTbl=null,$isPrepare=null,$setErrorMode=null) {
      $this->DBCONN=null;
      $this->dsn=$dsn;
      $this->user=$user;
      $this->pass=$pass;
      $this->isMSSQL=$isMSSQL;
      $this->isOra=$isOra;
      $this->codepage=$codepage;
      $this->oraTbl=$oraTbl;
      $this->isPrepare=$isPrepare;
      $this->setErrorMode=$setErrorMode;
      $this->DBCONN=new PDOTool($this->dsn,$this->user,$this->pass,$this->isMSSQL,$this->isOra,$this->codepage,$this->oraTbl);
    }
    
    /* connect to the database, without connection cannot work the methods of the PDOTool class engine */
    public function Connect() {
      if ($this->isPrepare)
        $this->DBCONN->Connect(true);
      else
        $this->DBCONN->Connect(false);
      
      if ($this->setErrorMode)
        $this->DBCONN->setErrorLog(true);
      else
        $this->DBCONN->setErrorLog(false);
    }
    
    /* disconnect from the database */
    public function Disconnect() {
      $this->DBCONN->Disconnect();
    }
    
    /* get the currently used PDO object */
    public function GetPDO($isDebug) {
      return $this->DBCONN->getPDO($isDebug);
    }
    
    /* get the last PDO message */
    public function readMessage() {
      return $this->DBCONN->readMessage();
    }
    
    /*******************/
    /* WITHOUT PREPARE */
    /*******************/
    
    /* RUN A QUERY AND GET A RESULT SET */
    public function RunQuery($query,$isFetchAll=false) {
      if ($isFetchAll)
        return $this->DBCONN->runQuery($query)->fetchAll();
      else
        return $this->DBCONN->runQuery($query);
    }
    
    /* EXEC A QUERY TO INSERT, UPDATE, DELETE */
    public function ExecQuery($query) {
      return $this->DBCONN->execQuery($query);
    }
    
    /* GET THE RESULT SET AFTER EXECUTING A QUERY */
    public function ResultSet() {
      return $this->DBCONN->fetchAll();
    }
    
    /************************/
    /* END: WITHOUT PREPARE */
    /************************/
    
    /**************************************************/
    /* WITH PREPARE, NEWER AND MORE SEPARATED METHODS */
    /**************************************************/
    
    /* PREPARE */
    public function Prepare($query,$driverOptions=null) {
      $this->prep=$this->DBCONN->prepareQuery($query,$driverOptions);
    }
    
    /* BIND */
    public function BindPrep($param,$value,$type=null) {
      $this->DBCONN->Bind($param,$value,$type);
    }
    
    /* begin a transaction */
    public function BeginTransaction() {
      $this->DBCONN->beginTransaction();
    }
    
    /* finish a transaction */
    public function EndTransaction() {
      $this->DBCONN->endTransaction();
    }
    
    /* cancel a transaction */
    public function CancelTransaction() {
      $this->DBCONN->cancelTransaction();
    }
    
    /* execute a prepared query (in case of SELECT) */
    public function ExecQueryPrep() {
      $this->DBCONN->Execute();
    }
    
    /* get only the next row from the result set after using the ExecQueryPrep() method */
    public function NextRowPrep($fetchStyle=PDO::FETCH_ASSOC) {
      return $this->DBCONN->getNextRow($fetchStyle);
    }
    
    /* get the total result set after using the ExecQueryPrep() method */
    public function ResultSetPrep($fetchStyle=PDO::FETCH_ASSOC) {
      return $this->DBCONN->getAllRows($fetchStyle);
    }
    
    /* get the row count of the result set after using the ExecQueryPrep() method */
    public function RowCountPrep() {
      return $this->DBCONN->rowCount();
    }
    
    /* get the column count of the result set after using the ExecQueryPrep() method */
    public function ColumnCountPrep() {
      return $this->DBCONN->columnCount();
    }
    
    /* get the last inserted ID value after using the ExecQueryPrep() method */
    public function GetLastInsertedID() {
      return $this->DBCONN->getLastInsertedId();
    }
    
    /* execute an SQL query which is going to prepare and get back the result array(SELECT) or the affected row(s)(INSERT,UPDATE,DELETE,REPLACE) */
    public function ExecuteCommandPrep($sql,$bind='') {
      $this->DBCONN->ExecuteCommand($sql,$bind);
    }
    
    /* SELECT with prepared option, use the ExecuteCommand($sql,$bind='') function of the PDOTool class */
    public function SelectPrep($table,$filter='',$bind='',$fields='*') {
      return $this->DBCONN->SelectPTC($table,$filter,$bind,$fields);
    }
    
    /* INSERT or REPLACE with prepared option, use the ExecuteCommand($sql,$bind='') function of the PDOTool class */
    public function InsertPrep($table,$info,$replace=false,$owner='') {
      return $this->DBCONN->InsertPTC($table,$info,$replace,$owner);
    }
    
    /* UPDATE with prepared option, use the ExecuteCommand($sql,$bind='') function of the PDOTool class */
    public function UpdatePrep($table,$info,$where,$bind='',$owner='') {
      return $this->DBCONN->UpdatePTC($table,$info,$where,$bind,$owner);
    }
    
    /* DELETE with prepared option, use the ExecuteCommand($sql,$bind='') function of the PDOTool class */
    public function DeletePrep($table,$where,$bind='') {
      return $this->DBCONN->DeletePTC($table,$where,$bind);
    }
    
    /*******************************************************/
    /* END: WITH PREPARE, NEWER AND MORE SEPARATED METHODS */
    /*******************************************************/
    
    /**************************************************/
    /* WITH PREPARE, OLDER AND LESS SEPARATED METHODS */
    /**************************************************/
    
    /* get a new PDOToolManifest class object */
    public function Manifest() {
      return $this->DBCONN->Manifest();
    }
    
    /* SELECT with prepared option, orig method */
    public function SelectOPrep($table='',$info=array(),$where=array(),$fields='') {
      return $this->DBCONN->Select($table,$info,$where,$fields);
    }
    
    /* INSERT with prepared option */
    public function InsertOPrep($table,$info) {
      return $this->DBCONN->Insert($table,$info,$replace);
    }
    
    /* UPDATE with prepared option */
    public function UpdateOPrep($table='',$info=array(),$where=array(),$fields='') {
      return $this->DBCONN->Update($table,$info,$where,$fields);
    }
    
    /* DELETE with prepared option */
    public function DeleteOPrep($table,$where=array(),$fields='') {
      return $this->DBCONN->Delete($table,$where,$fields);
    }
    
    /* set the PDO Error Mode: false = to get an error log file, true = to show error on screen */
    public function SetErrorLog($mode=false) {
      return $this->DBCONN->setErrorLog($mode);
    }
    
    public function ShowQuery($logfile=false) {
      return $this->DBCONN->showQuery($logfile)->results();
    }
    
    /*******************************************************/
    /* END: WITH PREPARE, OLDER AND LESS SEPARATED METHODS */
    /*******************************************************/
  }
?>
