<?php
/*
	A very simple, yet robust, config file reader for PHP5.3
	1.1		Added booleanize(), this version was never released.
	1.2		Added AUTOBOOL and associated logic
			ConfigKeys that match ^b[A-Z] will automatically
			be interpreted as boolean vars. If set to anything other than
			true or yes (case insensitive) the ConfigKey will be unset.
	1.3		Added the ability to assign array values dynamically.
			Duplicate keys will create an array, each associated value
			for that key will become an array element.
*/

class	ConfigReaderTool {
	var $param=array();
	var $ERROR="";
	var $AUTOBOOL=false;
	var $Key=null;
	
	public function __construct($ConfigFile='') {
		global $php_errormsg;
		ini_set('track_errors',1);
		
		if (!empty($ConfigFile)) {
			// get current config
			$this->get_config($ConfigFile);
		}
	}
	
	/* https://stackoverflow.com/questions/46492621/how-to-resolve-this-deprecated-function-each-php */
	private function emulEach(&$arr) {
    $key = key($arr);
    $result = ($key === null) ? false : [$key, current($arr), 'key' => $key, 'value' => current($arr)];
    next($arr);
    return $result;
  }
	
	private function parse_config($ConfigContents) {
		$ContentsArray=preg_split("/\n/",$ConfigContents);
		// foreach ($ConfigContents as $key => $line)
		while (list($key,$line)=$this->emulEach($ContentsArray)) {
			if (preg_match("/[a-zA-Z0-9=]/",$line)) {
				$this->set_config($line);
			}
		}
	}
	
	// is the current line contains a hashmark
	private function is_contain_hashmark($ConfigLine) {
    $result=false;
    
    for ($i=0;$i<strlen($ConfigLine)-1;$i++) {
      if ($ConfigLine[$i]=='#')
        $result=true;
    }
    
    return $result;
	}
	
	// is the current line contains an equal line (=)
	private function is_contain_equal_sign($ConfigLine) {
    $result=false;
    
    for ($i=0;$i<strlen($ConfigLine)-1;$i++) {
      if ($ConfigLine[$i]=='=')
        $result=true;
    }
    
    return $result;
	}
	
	private function set_config($ConfigLine) {
		// get file content if the lines contain equal line
		// split of each line is equal line (=) sign
    if ((!$this->is_contain_hashmark($ConfigLine)) && ($this->is_contain_equal_sign($ConfigLine))) {
      list($ConfigKey,$ConfigVal)=preg_split("/=/",$ConfigLine);
      // Remove spaces and tabs from the Key (before = sign)
      $Key=preg_replace("/[ 	]/",	"",$ConfigKey);
      // Remove whitespace leading up to the Val (after = sign)
      // $ConfigVal=preg_replace("/^[ 	]+/","",$ConfigVal);
      $ConfigVal=trim($ConfigVal);
      
      if (!preg_match("/^'/",$ConfigVal)) {
        // Remove whitespace in $ConfigVal if no ' at beginning of Val
        $Val=preg_replace("/[ 	]/",	"",$ConfigVal);			
      }
      else {
        // Strip the leading ' and trailing '
        $Val=preg_replace("/^'/","",$ConfigVal);
        $Val=preg_replace("/'$/","",$Val);
      }
      
      if (!$this->Key) {
        $this->Key=$Val;
        $this->param[$Key]=$Val;
      }
      else {
        $thisKey=$this->Key;
        if (!is_array($thisKey)) {
          settype($thisKey,"array");
        }
        $count=count($thisKey);
        $thisKey[$count]=$Val;
        $this->Key=$thisKey;
        $this->param[$Key]=$thisKey;
      }
      
      if ($this->AUTOBOOL) {
        if (preg_match("/b[a-zA-Z0-9]/",$Key)) {
          $this->booleanize($Key);
        }
      }
		}
		
		return;
	}
	
	private function error( $errorMsg,$die=0) {
		$this->ERROR = '[ConfigReader]: '.$errorMsg;
		@error_log($this->ERROR,0);
		return;
	}
	
	private function booleanize($ConfigKey) {
		$ConfigVal=$this->$ConfigKey;
		if (preg_match("/(true|yes)/",$ConfigVal)) {
			$this->$ConfigKey=true;
			$this->param[$ConfigKey]=true;
			$Return=true;
		}
		else {
			unset($this->param[$ConfigKey]);
			unset($this->$ConfigKey);
			$Return = false;
		}
		return($Return);
	}
	
	public function get_config($ConfigFile) {
		$contents='';
		
		if (empty($ConfigFile)) {
			$this->error('No ConfigFile to read',0);
			return;
		}
		if (!file_exists($ConfigFile)) {
			$this->error('['.$ConfigFile.'] does not exist',0);
			return;
		}
		
		// read the config file
		$fd=fopen($ConfigFile,"r");
		if ((!$fd) || (empty($fd))) {
			$this->error('File error: ['.$php_errormsg.']',0);
			return false;
		}
		// get content
		$contents.=fread($fd,filesize($ConfigFile));
		fclose($fd);
		if (empty($contents)) {
			$this->error('Config file has no data',0);
			return false;
		}
		// try to parse the content
		$this->parse_config($contents);
		unset($contents);
		return ($this->param);
	}
}
?>