<?php
  require_once('_include/session.php');
  if (PROG_LANG=='') {
    die ('Current language has not been set!');
  }
  else {
    if (file_exists('_lang/'.PROG_LANG.'.php')) {
      require_once('_lang/'.PROG_LANG.'.php');
    }
    else {
      die ('Current language file (_lang/'.PROG_LANG.'.php) does not exist!');
    }
  }
  
  $mypath=dirname(realpath(__FILE__));
  if (ini_get('session.save_path')=="")
    ini_set('session.save_path',$mypath.'/_sessions');
  
  /**
   * delete all old session files
  **/
  if (substr(ini_get('session.save_path'), 0, 4) != '/tmp') {
    foreach (glob(rtrim(ini_get('session.save_path'), '/') .'/sess_*') as $filename) {
      if (filemtime($filename) + ini_get('session.gc_maxlifetime') < time())
        @unlink($filename);
    }
  }
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" >
<html xmlns="http://www.w3.org/1999/xhtml" lang="hu" xml:lang="hu">
<head>
  <?php require_once('header.php'); ?>
  <title><?php echo PROG_NAME.'\'s Login Page'; ?></title>
  <script type="text/javascript">
  function OpenInNewTab(url) {
    var win = window.open(url, '_blank');
    win.focus();
  }
  </script>
</head>

<body>
  <!-- FULL CONTENT DIV -->
  <div id="fullContent"><?php echo $LNG_018; ?>
<?php
  /**
   * User has already logged in, so display relavent links, including
   * a link to the admin center if the user is an administrator.
  **/
  if ($session->logged_in) {
    echo "<form method=\"post\" action=\"entry.php?u=$session->username\">";
?>

    <!-- LOGGED IN HEADER DIV -->
    <div id="loginHeaderEntry">
<?php echo '<h1>'.$LNG_012.'</h1>'; ?>
    </div>
  <!-- END: LOGGED IN HEADER DIV -->
  
    <!-- LOGGED IN WELCOME DIV -->
    <div id="loginWelcomeEntry">
<?php echo $LNG_013.'<b> '.$session->username.'</b>'.$LNG_014.'<br><br>'; ?>
    </div>
    <!-- END LOGGED IN WELCOME DIV -->
  
    <!-- LOGGED IN BUTTON DIV -->
    <div id="loginButtonEntry">
<?php
    echo "<table border=\"2\"><tr bordercolor=\"red\">";
    // check the browser
    preg_match('/MSIE (.*?);/', $_SERVER['HTTP_USER_AGENT'], $matches);
    if (count($matches)<2)
      preg_match('/Trident\/\d{1,2}.\d{1,2}; rv:([0-9]*)/', $_SERVER['HTTP_USER_AGENT'], $matches); 
    // if IE with Trident engine
    if (count($matches)>1) {
      // new user
      if ($session->logged_in && $session->isAdmin())
        echo "<td><input type=\"button\" onclick=\"window.location.href('register.php');\" value=\"$LNG_024\"></td>";
      
      // create a new webcontent
      echo "<td><input type=\"button\" onclick=\"window.open('blog_save.php?u=".$session->username."');\" value=\"$LNG_CREA\"></td>";
      // read and edit any saved webcontent
      echo "<td><input type=\"button\" onclick=\"window.open('blog_read.php?user=".$session->username."');\" value=\"$LNG_READ\"></td>";
      // delete any saved webcontent
      echo "<td><input type=\"button\" onclick=\"window.open('blog_del.php?user=".$session->username."');\" value=\"$LNG_DEL\"></td>";
      // user management
      echo "<td><input type=\"button\" onclick=\"window.location.href('userinfo.php?u=".$session->username."');\" value=\"$LNG_015\"></td>";
      echo "<td><input type=\"button\" onclick=\"window.location.href('useredit.php?u=".$session->username."');\" value=\"$LNG_016\"></td>";
      // logged and registered user list
      if ($session->isAdmin()) {
        echo "<td><input type=\"button\" onclick=\"window.location.href('admin.php');\" value=\"$LNG_017\"></td>";
        echo "<td><input type=\"button\" onclick=\"OpenInNewTab('aniSettings.php');\" value=\"$LNG_017M\"></td>";
      }
      // logout
      echo "<td><input type=\"button\" onclick=\"window.location.href('process.php');\" value=\"$STD_004\"></td>";
    }
    // else if non-IE with other engine like Gecko (Firefox), Blink (Chrome, from Opera 15), Presto (till Opera 12), WebKit (Safari)
    else {
      // new user
      if ($session->logged_in && $session->isAdmin())
        echo "<td><a href=\"register.php\"><input type=\"button\" value=\"".$LNG_024."\" /></a></td>";
      
      // webcontent read and write
      echo "<td><a href=\"blog_save.php?u=".$session->username."\" target=\"_blank\"><input type=\"button\" value=\"".$LNG_CREA."\" /></a></td>";
      echo "<td><a href=\"blog_read.php?u=".$session->username."\" target=\"_blank\"><input type=\"button\" value=\"".$LNG_READ."\" /></a></td>";
      echo "<td><a href=\"blog_del.php?u=".$session->username."\" target=\"_blank\"><input type=\"button\" value=\"".$LNG_DEL."\" /></a></td>";
      // user management
      echo "<td><a href=\"userinfo.php?u=".$session->username."\"><input type=\"button\" value=\"".$LNG_015."\" /></a></td>";
      echo "<td><a href=\"useredit.php?u=".$session->username."\"><input type=\"button\" value=\"".$LNG_016."\" /></a></td>";
      // logged and registered user list
      if ($session->isAdmin()) {
        echo "<td><a href=\"admin.php\"><input type=\"button\" value=\"".$LNG_017."\" /></a></td>";
        echo "<td><a href=\"aniSettings.php\" target=\"_blank\"><input type=\"button\" value=\"".$LNG_017M."\" /></a></td>";
      }
      // logout
      echo "<td><a href=\"process.php\"><input type=\"button\" value=\"".$STD_004."\" /></a></td>";
    }
    echo "</tr></table>";
?>
    </div>
    <!-- END: LOGGED IN BUTTON DIV -->
  
<?php
    echo "</form>";
  }
  /**
   * User has not logged in, so display relevant need informations,
   * as username, password and other: remember me option
   * and of course oll buttons
  **/
  else {
?>
  
    <!-- HEADER DIV -->
    <div id="headerEntry"><h2><?php echo $LNG_019; ?></h2></div>
    <!-- END: HEADER DIV -->
    
    <!-- ERROR DIV -->
    <div id="errorEntry">
<?php
    /**
     * User not logged in, display the login form.
     * If user has already tried to login, but errors were
     * found, display the total number of errors.
     * If errors occurred, they will be displayed.
    **/
    if ($form->num_errors > 0)
      echo "<font size=\"2\" color=\"#ff0000\">".$form->num_errors.$STD_007."</font>";
?>
    </div>
    <!-- END: ERROR DIV -->
  
    <!-- MAIN FORM FOR LOGIN A USER -->
    <form action="process.php" method="post">
      <!-- DATA DIV -->
      <div id="dataEntry">
        <table align="left" border="0" cellspacing="0" cellpadding="3">
          <!-- USERNAME -->
          <tr>
            <td><?php echo $STD_001; ?></td><td><input type="text" name="user" maxlength="30" value="<?php echo $form->value("user"); ?>"></td>
          </tr>
          <!-- PASSWORD -->
          <tr>
            <td><?php echo $STD_002; ?></td><td><input type="password" name="pass" maxlength="30" value="<?php echo $form->value("pass"); ?>"></td>
          </tr>
          <!-- REMEBER ME -->
          <tr>
            <td colspan="2" align="left">
              <input type="checkbox" name="remember" <?php if ($form->value("remember") != "") { echo $LNG_020; } ?>>
              <font size="2"><?php echo $LNG_021; ?></font>
            </td>
          </tr>
        </table>
        <!-- MISSING USERNAME ERROR MESSAGE -->
        <div id="dataEntryMissingPasswd"><?php echo $form->error("pass"); ?></div>
        <!-- MISSING PASSWORD ERROR MESSAGE -->
        <div id="dataEntryMissingName"><?php echo $form->error("user"); ?></div>
      </div>
      <!-- END: DATA DIV -->
      
      <!-- BUTTON DIV -->
      <div id="buttonEntry">
        <input type="hidden" name="sublogin" value="1" />
        <input type="submit" value="<?php echo $STD_003; ?>" />
  <?php
    // check the browser
    if (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE'))
      echo "<td><button onclick=\"window.location.href('forgotpass.php');\">$LNG_022</button>";
    else
      echo "<a href=\"forgotpass.php\"><input type=\"button\" value=\"".$LNG_022."\" /></a>";
  ?>
      </div>
      <!-- END: BUTTON DIV -->
    </form>
    <!-- END: MAIN FORM FOR LOGIN A USER -->
<?php
  }
?>
    
    <!-- FOOTER DIV -->
    <div id="footerEntry">
<?php
  /**
   * Just a little page footer, tells how many registered members
   * there are, how many users currently logged in and viewing site,
   * and how many guests viewing site. Active users are displayed,
   * with link to their user information.
  **/
  echo '<b>'.$LNG_025.'</b> '.$database->getNumMembers().'<br>';
  echo $LNG_026.$database->num_active_users.$LNG_027;
  echo $database->num_active_guests.$LNG_028.'<br><br>';
  // Current active users list only for registered users
  if ($session->logged_in) {
    echo '<b>'.$LNG_029.'</b><br>';
    require_once('_include/view_active.php');
  }
?>
    </div>
    <!-- END: FOOTER DIV -->
    
  </div>
  <!-- FULL CONTENT DIV -->
</body>
</html>
