<?php
	class MySQLiTool {
		// the current MySQL/MariaDB connection value
		private $mysqli;
		// hostname
		private $HOST;
		// the current MySQL/MariaDB database name
		private $DB;
		// the current interface to a MySQL/MariaDB database of the PHP
		// both interfaces are supported: object-oriented (OOP) and procedural
		private $iface;
		// MariaDB / MySQL character sets
		private $charset=array(
													 'big5',
													 'dec8',
													 'cp850',
													 'hp8',
													 'koi8r',
													 'latin1',
													 'latin2',
													 'swe7',
													 'ascii',
													 'ujis',
													 'sjis',
													 'hebrew',
													 'tis620',
													 'euckr',
													 'koi8u',
													 'gb2312',
													 'greek',
													 'cp1250',
													 'gbk',
													 'latin5',
													 'armscii8',
													 'utf8',
													 'ucs2',
													 'cp866',
													 'keybcs2',
													 'macce',
													 'macroman',
													 'cp852',
													 'latin7',
													 'utf8mb4',
													 'cp1251',
													 'utf16',
													 'cp1256',
													 'cp1257',
													 'utf32',
													 'binary',
													 'geostd8',
													 'cp932',
													 'eucjpms'
													);
		
		/**
		 * Constructor
		**/
		public function __construct($host,$port='',$name,$passwd,$db='',$setCharset=false) {
			$this->DB=$db;
			$charset='';
			
			if (($host=='') && ($port=''))
        die('The hostname and the port number is empty!');
			
			try {
				/* object-oriented interface */
				$this->mysqli=new MySQLi($host,$name,$passwd,$this->DB,$port);
				
				if (!$this->mysqli->connect_errno)
					$this->iface='OOP';
				/* procedural interface */
				else {
					printf("Connect failed: %s %s\n", $this->mysqli->connect_errno,'; try to connect with the procedural method!');
					$this->mysqli= mysqli_connect($host,$name,$passwd,$this->DB,$port);
					$this->iface='PROCEDURAL';
					}
			}
			catch (Exception $e) {
				/* object-oriented interface error message */
				if ($this->mysqli->connect_errno)
					printf("Connect failed: %s\n", $this->mysqli->connect_errno);
				/* procedural interface error message */
				else if (mysqli_connect_errno($this->mysqli))
					printf("Connect failed: %s\n", mysqli_connect_error());
				die ('Cannot connect to '.$hostinfo.' host! '.$e);
			}
			
			if ($setCharset) {
				/* set MySQL/MariaDB character set */
				mysqli_set_charset($this->mysqli,$this->GetDBCharacterSet());
			}
			
			return ($this->mysqli);
		}
		
		/**
		 * Destructor
		**/
		public function __destruct() {
			$this->mysqli=null;
		}
		
		/**
		 * Get the MySQL/MariaDB database character set
		**/
		public function GetDBCharacterSet() {
			/* get MySQL/MariaDB character set */
			$dump=$this->mysqli->get_charset();
			foreach ($dump as $index => $value) {
				if ($index=='charset') {
					foreach ($this->charset as $ind => $val) {
						// if the current character can be found in the charecter set array
						if ($val==$value)
							return $value;
					}
				}
			}
		}
		
		/**
		 * IFace - return with the current supported
		 * interface to the database of the PHP
		**/
		public function IFace() {
			return ($this->iface);
		}
		
		/**
		 * Connection - return with the current connection parameters
		**/
		public function Connection() {
			if (MySQLiTool::IsConnected()) {
				$proc=mysqli_thread_id($this->mysqli);
				echo '<br>--------------------------------------<br>';
				$connection='Host info: '.mysqli_get_host_info($this->mysqli).'<br>';
				$connection.='Server info: '.mysqli_get_server_info($this->mysqli).'<br>';
				$connection.='Client info: '.mysqli_get_client_info($this->mysqli).'<br>';
				$connection.='Client char encoding: '.mysqli_character_set_name($this->mysqli).'<br>';
				$connection.='Proto info: '.mysqli_get_proto_info($this->mysqli).'<br>';
				$connection.='Current connection ID: '.mysqli_thread_id($this->mysqli);
				echo '<br>';
				$connection.='<br>--------------------------------------<br>'; 
				
				return ($connection);
			}
		}
		
		/**
		 * Statistic - return with the current database statistic parameters
		**/
		public function Statistic() {
			$stat='<br>---------------------------------------------------------><br>';
			if ($this->iface==='OOP')
				$stat.=$this->mysqli->stat();
			else if ($this->iface='PROCEDURAL')
				$stat.=mysqli_stat($this->mysqli);
			$stat.='<br>---------------------------------------------------------><br>';
			
			return ($stat);		
		}
		
		/**
		 * Close - close the current database connection
		**/
		public function Close() {
			if (MySQLiTool::IsConnected())
				mysqli_close($this->mysqli);
			
			return (true);
		}
		
		public function GetConnection() {
			return (var_dump(get_object_vars($this)));
		}
		
		/**
		 * GetLink - check the database connection
		**/
		public function GetLink() {
			return (MySQLiTool::IsConnected());
		}
		
		/**
		 * GetObject - return with the '$this->mysqli' object
		**/
		public function GetObject() {
			return ($this->mysqli);
		}
		
		/**
		 * GetError - return with the currently error message of the '$this->mysqli' object
		**/
		public function GetError() {
			return (mysqli_error($this->mysqli));
		}
		
		/**
		 * IsConnected - check whether can be found
		 * a database connection or not
		**/
		public function IsConnected() {
			//if ($this->mysqli!='') {
			//if ($this->mysqli!==null) {
			if (!mysqli_connect_errno()) {
				return true;
			}
			
			return false;
		}
		
		/**
		 * SelectDatabase - select the current database
		**/
		public function SelectDatabase($dbname) {
			if (($this->DB==='') && ($dbname!='')) {
				$dba=mysqli_select_db($this->mysqli,$dbname) or die ('Cannot connect '.$dbname.' database!');
			}
			
			$curr_db=mysqli_query($this->mysqli,"SELECT DATABASE()") or die(mysqli_error($this->mysqli));
			return (mysqli_fetch_row($curr_db));
		}
		
		/**
		 * ExecuteCommand - run the current SQL command
		**/
		public function ExecuteCommand($sql) {
			if ($sql==='')
				die('The SQL command cannot be empty!');
			
			if ($this->iface==='OOP')
				return ($this->mysqli->query($sql));
			else if ($this->iface='PROCEDURAL')
				return (mysqli_query($this->mysqli, $sql));
		}
		
		/**
		 * GetRows - returns the number of rows affected
		 * by the last INSERT, UPDATE, REPLACE or DELETE query
		**/
		public function GetRows() {
			return (mysqli_affected_rows($this->mysqli));
		}
		
		/**
		 * NumRows - get the number of rows in a result
		**/
		public function NumRows($result) {
			if ($result==='')
				die('The set of result cannot be empty!');
			
			if ($this->iface==='OOP')
				return ($result->num_rows);
			else if ($this->iface='PROCEDURAL')
				return (mysqli_num_rows($result));
			
		}
		
		/**
		 * FetchArray - fetch a result row
		 * as an associative, a numeric array, or both
		 * resulttype: the possible values for this parameter
		 * are the constants MYSQLI_ASSOC, MYSQLI_NUM, or MYSQLI_BOTH
		 * default is MYSQLI_BOTH
		**/
		public function FetchArray($result,$fetch=MYSQLI_BOTH) {
			if ($result==='')
				die('The set of result cannot be empty!');
			
			if ($this->iface==='OOP')
				return ($result->fetch_array($fetch));
			else if ($this->iface='PROCEDURAL')
				return (mysqli_fetch_array($result));
		}
		
		/**
		 * FetchAssoc - fetch a result row as an associative array
		**/
		public function FetchAssoc($result) {
			if ($result==='')
				die('The set of result cannot be empty!');
			
			if ($this->iface==='OOP')
				return ($result->fetch_assoc());
			else if ($this->iface='PROCEDURAL')
				return (mysqli_fetch_assoc($result));
		}
	}
?>