<?php
  /* source: http://stackoverflow.com/questions/2237291/reading-and-writing-configuration-files */
	session_start();
  
  $aniConfigClass='_include/aniConfigClass.php';
  if (file_exists($aniConfigClass))
    require_once($aniConfigClass);
  $fileName='_include/constants.standard.php';
  
	// the config file field values
	$config=array();
	
	// program language
	$progLang=array('en','hu');
	
	// API for database connection
	$apiDatabase=array('MySQLi','PDO');
	
	// the config file field names without values
	$configFields=array(
								'PROG_LANG',
								'API',
								'DRIVER',
								'DB_SERVER',
								'DB_PORT',
								'DB_NAME',
								'DB_USER',
								'DB_PASS',
								'WINDOW_MODE',
								'PAG_ORDER',
								'MAX_BLOG_HIT',
								'RECORDS_PER_PAGE');
								
	// blog show mode: according (ACC), pagination (PAG)
	$winMode=array('ACC','PAG');
	
	// pagination mode: order is ascend (ASC) or descend mode (DSC)
	$pagOrder=array('ASC','DSC');
	
	// the web fields and the button captions
	$captionFields=array(
								'aniSetting',
								'Language',
								'Database API',
								'Database driver',
								'Database server',
								'Database port',
								'Database name',
								'Database username',
								'Database password',
								'Windows mode',
								'Pagination order',
								'Max. blog hit',
								'Records per page',
								'Update',
								'Main menu');
	
	// Moccasin, PapayaWhip
	$colorCodes=array('#FFE4B5','#FFEFD5');
  $msg='';
	$un1='';
	$main='';
	$use_smtp='';
	
	if ((isset($_POST['action'])) && ($_POST['action'] == "update")) {
		$config[$configFields[0]]=$_POST['language'];
    $config[$configFields[1]]=$_POST['db_api'];
    $config[$configFields[2]]=$_POST['db_driver'];
    $config[$configFields[3]]=$_POST['db_server'];
    $config[$configFields[4]]=$_POST['db_port'];
    $config[$configFields[5]]=$_POST['db_name'];
    $config[$configFields[6]]=$_POST['db_uname'];
    $config[$configFields[7]]=$_POST['db_passwd'];
    $config[$configFields[8]]=$_POST['win_mode'];
    $config[$configFields[9]]=$_POST['pag_order'];
    $config[$configFields[10]]=$_POST['max_blog_hit'];
    $config[$configFields[11]]=$_POST['rec_per_page'];
    aniConfigClass::WriteConfig($fileName,$config);
		
		$msg = "<blockquote><div class=message>Settings updated successfully...</div></blockquote>";
		
		if (file_exists($fileName)) {
      $config=aniConfigClass::ReadConfig($fileName);
      $language=$config[$configFields[0]];
      $db_api=$config[$configFields[1]];
      $db_driver=$config[$configFields[2]];
      $db_server=$config[$configFields[3]];
      $db_port=$config[$configFields[4]];
      $db_name=$config[$configFields[5]];
      $db_uname=$config[$configFields[6]];
      $db_passwd=$config[$configFields[7]];
      $win_mode=$config[$configFields[8]];
      $pag_order=$config[$configFields[9]];
      $max_blog_hit=$config[$configFields[10]];
      $rec_per_page=$config[$configFields[11]];
		}
		unset($_POST['action']);
	}
	else {
		if (file_exists($fileName)) {
      $config=aniConfigClass::ReadConfig($fileName);
      $language=$config[$configFields[0]];
      $db_api=$config[$configFields[1]];
      $db_driver=$config[$configFields[2]];
      $db_server=$config[$configFields[3]];
      $db_port=$config[$configFields[4]];
      $db_name=$config[$configFields[5]];
      $db_uname=$config[$configFields[6]];
      $db_passwd=$config[$configFields[7]];
      $win_mode=$config[$configFields[8]];
      $pag_order=$config[$configFields[9]];
      $max_blog_hit=$config[$configFields[10]];
      $rec_per_page=$config[$configFields[11]];
		}
		else {
      $language='';
      $db_api='';
      $db_driver='';
      $db_server='';
      $db_port='';
      $db_name='';
      $db_uname='';
      $db_passwd='';
      $win_mode='';
      $pag_order='';
      $max_blog_hit='';
      $rec_per_page='';
		}
	}
	
	$reqUri=$_SERVER["REQUEST_URI"];
	$reqUriScript=basename($_SERVER['PHP_SELF']);
	$reqUriLen=intval(strlen($reqUri));
	$reqUriScriptLen=intval(strlen($reqUriScript));
	$redirectPath=substr($reqUri,0,$reqUriLen-$reqUriScriptLen);
	
	$main.="<div class=heading>".$captionFields[0]."</div>";
  if ((isset($_POST['action'])) && ($_POST['action'] == "update"))
		$main.=$msg;
	$main.="<table width='100%' cellpadding=2 cellspacing=2>
      <form name='' action='".$_SERVER['PHP_SELF']."' method='POST'>
        <input type=hidden name=action value=update>
        <tr bgcolor=$colorCodes[0]>
          <td align=right width=150>$captionFields[1]</td>
          <td align=left>
            <input class=textField type=text name='language' value='$language' />
            <select class=textField name='language' onChange=combo(this, 'language') onMouseOut=comboInit(this, 'language')>
              <option>$progLang[0]</option>
              <option>$progLang[1]</option>
            </select>
            <span class=error_text id=language></span>
          </td>
        </tr>
        <tr bgcolor=$colorCodes[1]>
          <td align=right>$captionFields[2]</td>
          <td align=left>
            <input class=textField type=text name='db_api' value='$db_api' />
            <select class=textField name='db_api' onChange=combo(this, 'db_api') onMouseOut=comboInit(this, 'db_api')>
              <option>$apiDatabase[0]</option>
              <option>$apiDatabase[1]</option>
            </select>
            <span class=error_text id=db_api></span>
          </td>
        </tr>
        <tr bgcolor=$colorCodes[0]>
          <td align=right>$captionFields[3]</td>
          <td align=left>
            <input class=textField type=text name='db_driver' value='$db_driver' />
            <select class=textField name='db_driver' onChange=combo(this, 'db_driver') onMouseOut=comboInit(this, 'db_driver')>
              <option>mysql</option>
            </select>
            <span class=error_text id=db_driver></span>
          </td>
        </tr>
        <tr bgcolor=$colorCodes[1]>
          <td align=right>$captionFields[4]</td>
          <td align=left>
            <input class=textField type=text name='db_server' value='$db_server' /> [Usually localhost]
            <span class=error_text id=db_server></span>
          </td>
        </tr>
        <tr><td></td></tr>
        <tr bgcolor=$colorCodes[0]>
          <td align=right>$captionFields[5]</td>
          <td align=left>
            <input class=textField type=text name='db_port' value='$db_port' /> [Usually 3306(MySQL) or 5432(PostgreSQL)]
            <span class=error_text id=db_port></span>
          </td>
        </tr>
        <tr bgcolor=$colorCodes[1]>
          <td align=right>$captionFields[6]</td>
          <td align=left>
            <input class=textField type=text name='db_name' value='$db_name' />
            <span class=error_text id=db_name></span>
          </td>
        </tr>
        <tr bgcolor=$colorCodes[0]>
          <td align=right>$captionFields[7]</td>
          <td align=left>
            <input class=textField type=text name='db_uname' value='$db_uname' />
            <span class=error_text id=db_uname></span>
          </td>
        </tr>
        <tr bgcolor=$colorCodes[1]>
          <td align=right>$captionFields[8]</td>
          <td align=left>
            <input class=textField type=text name='db_passwd' value='$db_passwd' />
            <span class=error_text id=db_passwd></span>
          </td>
        </tr>
        <tr><td></td></tr>
        <tr bgcolor=$colorCodes[0]>
          <td align=right>$captionFields[9]</td>
          <td align=left>
            <input class=textField type=text name='win_mode' value='$win_mode' />
            <select class=textField name='win_mode' onChange=combo(this, 'win_mode') onMouseOut=comboInit(this, 'win_mode')>
              <option>$winMode[0]</option>
              <option>$winMode[1]</option>
            </select>
            <span class=error_text id=win_mode></span>
          </td>
        </tr>
        <tr bgcolor=$colorCodes[1]>
          <td align=right>$captionFields[10]</td>
          <td align=left>
            <input class=textField type=text name='pag_order' value='$pag_order' />
            <select class=textField name='pag_order' onChange=combo(this, 'pag_order') onMouseOut=comboInit(this, 'pag_order')>
              <option>$pagOrder[0]</option>
              <option>$pagOrder[1]</option>
            </select>
            <span class=error_text id=pag_order></span>
          </td>
        </tr>
        <tr bgcolor=$colorCodes[0]>
          <td align=right>$captionFields[11]</td>
          <td align=left>
            <input class=textField type=text name='max_blog_hit' value='$max_blog_hit' />
            <span class=error_text id=max_blog_hit></span>
          </td>
        </tr>
        <tr bgcolor=$colorCodes[1]>
          <td align=right>$captionFields[12]</td>
          <td align=left>
            <input class=textField type=text name='rec_per_page' value='$rec_per_page' />
            <span class=error_text id=rec_per_page></span>
          </td>
        </tr>
        <tr bgcolor=$colorCodes[0]>
          <td>&nbsp;</td>
          <td align=left>
            <input class=button type=submit value='$captionFields[13]' />
          </td>
        </tr>
      </form>
      <form name='close' action='".$redirectPath."' method='POST'>
        <tr bgcolor=$colorCodes[1]>
          <td>&nbsp;</td>
          <td align=left>
            <button a href='#'>$captionFields[14]</a></button>
          </td>
        </tr> 
      </form>
    </table>
    <script language=javascript>
      function comboInit(thelist) {
        theinput = document.getElementById(theinput);  
        var idx = thelist.selectedIndex;
        var content = thelist.options[idx].innerHTML;
        if (theinput.value == '')
          theinput.value = content;	
      }
      
      function combo(thelist, theinput) {
        theinput = document.getElementById(theinput);  
        var idx = thelist.selectedIndex;
        var content = thelist.options[idx].innerHTML;
        theinput.value = content;	
      }
    </script>";
    /*
    <script language=javascript>
      $(document).ready;
      var validator = new Validator('form');
      validator.addValidation('admin_username','req','');
      validator.addValidation('admin_password','req','');
      validator.addValidation('admin_name','req','');
      validator.addValidation('admin_email','req','');
      validator.addValidation('admin_email','email','');
      validator.addValidation('charset','req','');
      validator.addValidation('site_url','req','');
      validator.addValidation('opennewsletter_dir','req','');
      validator.addValidation('db_file','req','');
    </script>";
		*/
		
  require_once('_include/aniTemplate.php');
?>