<?php
   /**
   * Form.php
   *
   * The Form class is meant to simplify the task of keeping
   * track of errors in user submitted forms and the form
   * field values that were entered correctly.
   *
   */
   
   class Form {
      var $values = array();  // Holds submitted form field values
      var $errors = array();  // Holds submitted form error messages
      var $num_errors;        // The number of errors in submitted form
      var $correct = array(); // Holds submitted form correct messages
      var $num_correct;       // The number of correct in submitted form
      
      /* Class constructor */
      public function __construct() {
         /**
         * Get form value, correct and error arrays, used when there
         * is an error or there is a correct message with a user-submitted form.
         */
         if (isset($_SESSION['value_array']) && isset($_SESSION['error_array'])) {
            if (isset($_SESSION['value_array']))
               $this->values = $_SESSION['value_array'];
            if (isset($_SESSION['error_array']))
               $this->errors = $_SESSION['error_array'];
            $this->num_errors = count($this->errors);
            if (isset($_SESSION['correct_array']))
               $this->correct = $_SESSION['correct_array'];
            $this->num_correct = count($this->correct);
            
            unset($_SESSION['value_array']);
            unset($_SESSION['error_array']);
            unset($_SESSION['correct_array']);
         }
         else {
            $this->num_errors = 0;
         }
      }
      
      /**
      * setValue - Records the value typed into the given
      * form field by the user.
      */
      public function setValue($field, $value) {
         $this->values[$field] = $value;
      }
      
      /**
      * setError - Records new form error given the form
      * field name and the error message attached to it.
      */
      public function setError($field, $errmsg) {
         $this->errors[$field] = $errmsg;
         $this->num_errors = count($this->errors);
      }
      
      /**
      * setCorrect - Records new form correct given the form
      * field name and the correct message attached to it.
      */
      public function setCorrect($field, $crrmsg) {
         $this->correct[$field] = $crrmsg;
         $this->num_correct = count($this->correct);
      }
      
      /**
      * value - Returns the value attached to the given
      * field, if none exists, the empty string is returned.
      */
      public function value($field) {
         if (array_key_exists($field,$this->values))
            return htmlspecialchars(stripslashes($this->values[$field]));
         else
            return "";
      }
      
      /**
      * error - Returns the error message attached to the
      * given field, if none exists, the empty string is returned.
      */
      public function error($field) {
         if (array_key_exists($field,$this->errors))
            return "<font size=\"2\" color=\"#ff0000\">".$this->errors[$field]."</font>";
         else
            return "";
      }
      
      /**
      * correct - Returns the correct message attached to the
      * given field, if none exists, the empty string is returned.
      */
      public function correct($field) {
         if ($this->num_correct>0) {
            if (array_key_exists($field,$this->correct))
               return "<font size=\"2\" color=\"#ff0000\">".$this->correct[$field]."</font>";
            else
               return "";   
         }
      }
      
      /* getErrorArray - Returns the array of error messages */
      public function getErrorArray() {
         return $this->errors;
      }
      
      /* getCorrectArray - Returns the array of correct messages */
      public function getCorrectArray() {
         return $this->correct;
      }
   };
   
?>