<?php
class InternetTool {
  private $LOCALIP;
  private $REMOTEIP;
	
	public function __construct() {
    $this->LOCALIP =null;
		$this->REMOTEIP=null;
  }
	
	public function __destruct() {
		$this->LOCALIP =null;
		$this->REMOTEIP=null;
	}
	
	// set the local and the remote IP adresses
	public function SetIPAdresses($remote_ip) {
    $this->LOCALIP =$_SERVER['REMOTE_ADDR'];
    $this->REMOTEIP=$remote_ip;
	}
  
  // check any email address validation
  public function is_valid_email($email) {
		// shorter checker 1.
		//return preg_match('/^[_\.0-9a-zA-Z-]+@([0-9a-zA-Z][0-9a-zA-Z-]+\.
		//									)+[a-zA-Z]{2,6}$/i', $email);
		// shorter checker 2.
		//return preg_match('/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.
		//									[a-z0-9-]+)*(\.[a-z]{2,3})$/i', $email);
		
		// completly checker
		if (preg_match('/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.
										[a-z0-9-]+)*(\.[a-z]{2,3})$/i', $email)) {
    	list($username,$domain)=preg_split('/@/',$email);
    	if(!checkdnsrr($domain,'MX')) {
      	return false;
    	}
    	return true;
  	}
  	
		return false;
  }
	
	// hide any email address
  public function hide_email($email) {
    $character_set = '+-.0123456789@ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz';
    //$character_set = '+-.0123456789@AÁBCDEÉFGHIÍJKLMNOÓÖŐPQRSTUÚÜŰVWXYZ_aábcdeéfghiíjklmnoóöőpqrstuúüűvwxyz';
    $key = str_shuffle($character_set);
    $cipher_text = '';
    $id = 'e'.rand(1,999999999);
    
    for ($i=0;$i<strlen($email);$i+=1)
      $cipher_text.= $key[strpos($character_set,$email[$i])];
    
    $script = 'var a="'.$key.'";var b=a.split("").sort().join("");var c="'.$cipher_text.'";var d="";';
    $script.= 'for(var e=0;e<c.length;e++)d+=b.charAt(a.indexOf(c.charAt(e)));';
    $script.= 'document.getElementById("'.$id.'").innerHTML="<a href=\\"mailto:"+d+"\\">"+d+"</a>"';
    $script = "eval(\"".str_replace(array("\\",'"'),array("\\\\",'\"'), $script)."\")"; 
    $script = '<script type="text/javascript">/*<![CDATA[*/'.$script.'/*]]>*/</script>';
    
    return '<span id="'.$id.'">[javascript protected email address]</span>'.$script;
  }
  
  // send a new email to a valid email address
  public function SendMail($to, $subject, $message, $additional_headers) {
    if (($to!='') && (($subject!='') ||
				($message!='')) && ($additional_headers!='')) {
      if ($this->is_valid_email($to)==true) {
        mail($to, $subject, $message, 'From: '.$additional_headers);
        return true;  
      }
      else {
        echo 'Not valid email address!';
				return false;
      }
    }
    else {
			echo 'The Sender, Subject/Message or From field(s) is/are empty!';
      return false;    
    }
  }
  
  // check our intra- or internet connection
  public function PingTest($pingmode) {
		// first method to check connection
    if ($pingmode==1) {
      if(getenv('OS')=='Windows_NT') {
        echo 'Your OS: '.getenv('OS').'<br />Your IP address: '.
							$this->LOCALIP.'<br />';
        $exec			=exec('ping -n 3 -l 64 '.$this->REMOTEIP);
        $arrayMain=explode(' ', $exec );
				$arrayEnd	=end($arrayMain);
				
        //return $exec;
				return $arrayEnd;
      }
      else {
        echo 'Info about your OS: '.php_uname().'<br />';
        echo 'Your op. system:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; '.PHP_OS.
             '<br />Your IP address:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.
						 $this->LOCALIP.'<br />';
        $exec			=exec('ping -c 3 -s 64 -t 64 '.$this->REMOTEIP);
				$arrayMain=explode('=', $exec );
				$arrayEnd	=end($arrayMain);
				
				return $arrayEnd;
      }
    }
    // second method to check connection
    elseif ($pingmode==2) {
      echo 'Your IP address:&nbsp;'.$this->LOCALIP.
					 '<br />Remote IP:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
					 &nbsp;&nbsp;'.$this->REMOTEIP;
      $s =microtime();
      $fp=fsockopen('udp://'.$this->REMOTEIP, 13, $errno, $errstr, 30);
      $e =microtime();
      $tt=$e-$s;
      
			if ($fp)
        fclose($fp);
    
      return ($tt.' ms');
    }
  }
	
	public function GetHostname($remote_ip) {
		if ($remote_ip!='')
			return gethostbyaddr($remote_ip);
		else
			return false;
	}
	
	public function GetHostIpAddress($remote_hostname) {
		if ($remote_hostname!='')
			return gethostbyname($remote_hostname);
		else
			return false;
	}
	
	public function Traceroute($remote_address) {
		$result='';
		$wincommand=`C:\\Windows\\system32\\tracert.exe $remote_address`;
		$linuxcommand=`/usr/sbin/traceroute $remote_address`;
		$runcommand='';
		
		if ($remote_address!='') {
			// check OS
			if (PHP_OS=='WINNT')
				$runcommand=trim(nl2br($wincommand));
			else
				$runcommand=trim(nl2br($linuxcommand));
			// if we do not have have correct result
			if (!$result.=$runcommand) {
					$result.='Traceroute failed. Host may not be active.'; 
					$msg.='</blockquote></p>';
				}
			// else we show the result
			else {
				return $result;
			}
		}
		else {
			return false;
		}
	}
	
	// get the browser datas of the current user
  public function GetClientBrowser() {
    // check the browser
    preg_match('/MSIE (.*?);/', $_SERVER['HTTP_USER_AGENT'], $matches);
    if (count($matches)<2)
      preg_match('/Trident\/\d{1,2}.\d{1,2}; rv:([0-9]*)/', $_SERVER['HTTP_USER_AGENT'], $matches); 
    // if IE with Trident engine
    if (count($matches)>1) {
			// do something in case of the browser is IE
    }
    else {
			// do something in case of the browser is not the IE, for example Firefox/Chrome/Opera/Safari
    }
    
		$u_agent=$_SERVER['HTTP_USER_AGENT']; 
    $bname='Unknown';
    $platform='Unknown';
    $version='';
    
    // first get the platform?
    if (preg_match('/linux/i', $u_agent)) {
      $platform='linux';
    }
    else if (preg_match('/macintosh|mac os x/i', $u_agent)) {
      $platform='mac';
    }
    else if (preg_match('/windows|win32/i', $u_agent)) {
      $platform='windows';
    }     
    
    // next get the name of the useragent yes seperately and for good reason
    //if (preg_match('/MSIE/i',$u_agent) && !preg_match('/Opera/i',$u_agent)) {
		if (((preg_match('/MSIE/i',$u_agent)) || (preg_match('/Trident/i',$u_agent))) && !preg_match('/Opera/i',$u_agent)) {
      $bname='Internet Explorer'; 
      $ub="MSIE"; 
    } 
    else if (preg_match('/Firefox/i',$u_agent)) { 
      $bname='Mozilla Firefox'; 
      $ub="Firefox"; 
    } 
    else if (preg_match('/Chrome/i',$u_agent)) { 
      $bname='Google Chrome'; 
      $ub="Chrome"; 
    } 
    else if (preg_match('/Safari/i',$u_agent)) { 
      $bname='Apple Safari'; 
      $ub="Safari"; 
    } 
    else if (preg_match('/Opera/i',$u_agent)) { 
      $bname='Opera'; 
      $ub="Opera"; 
    } 
    else if (preg_match('/Netscape/i',$u_agent)) { 
      $bname='Netscape'; 
      $ub="Netscape"; 
    } 
    
    // finally get the correct version number
    $known=array('Version', $ub, 'other');
    $pattern='#(?<browser>'.join('|', $known).')[/ ]+(?<version>[0-9.|a-zA-Z.]*)#';
    if (!preg_match_all($pattern, $u_agent, $matches)) {
      // we have no matching number just continue
    }
    
    // see how many we have
    $i=count($matches['browser']);
    if ($i!=1) {
      //we will have two since we are not using 'other' argument yet
      //see if version is before or after the name
      if (strripos($u_agent,"Version")<strripos($u_agent,$ub)) {
        $version=$matches['version'][0];
      }
      else {
        $version=$matches['version'];
      }
    }
    else {
      $version=$matches['version'][0];
    }     
    
    // check if we have a number
    if ($version==null || $version=="") {
      $version="?";
    }
    
    return array(
      'userAgent' => $u_agent,
      'name'      => $bname,
      'version'   => $version,
      'platform'  => $platform,
      'pattern'   => $pattern
    );
  }
}
?>