<?php
	class MySQLiTool {
		// the current MySQL/MariaDB connection value
		private $mysqli;
		// the current MySQL/MariaDB database name
		private $DB;
		// the current interface to a MySQL/MariaDB database of the PHP
		// both interfaces are supported: object-oriented (OOP) and procedural
		private $iface;
		
		public function __construct($host,$port='',$name,$passwd,$db='') {
			$this->DB=$db;
			
			try {
				/* object-oriented interface */
				$this->mysqli= new mysqli($host,$name,$passwd,$this->DB,$port);
				if (!$this->mysqli->connect_errno)
					$this->iface='OOP';
				/* procedural interface */
				else {
					printf("Connect failed: %s %s\n", $this->mysqli->connect_errno,'; try to connect with the procedural method!');
					$this->mysqli= mysqli_connect($host,$name,$passwd,$this->DB,$port);
					$this->iface='PROCEDURAL';
					}
				}
			catch (Exception $e) {
				/* object-oriented interface error message */
				if ($this->mysqli->connect_errno)
					printf("Connect failed: %s\n", $this->mysqli->connect_errno);
				/* procedural interface error message */
				else if (mysqli_connect_errno($this->mysqli))
					printf("Connect failed: %s\n", mysqli_connect_error());
				die ('Cannot connect to '.$hostinfo.' host! '.$e);
			}
			
			return ($this->mysqli);
		}
		
		public function __destruct() {
			$this->mysqli=null;
		}
		
		/**
		 * IFace - return with the current supported
		 * interface to the database of the PHP
		*/
		public function IFace() {
			return ($this->iface);
		}
		
		/**
		 * Connection - return with the current connection parameters
		*/
		public function Connection() {
			if (MySQLiTool::IsConnected()) {
				$proc=mysqli_thread_id($this->mysqli);
				echo '<br>--------------------------------------<br>';
				$connection='Host info: '.mysqli_get_host_info($this->mysqli).'<br>';
				$connection.='Server info: '.mysqli_get_server_info($this->mysqli).'<br>';
				$connection.='Client info: '.mysqli_get_client_info($this->mysqli).'<br>';
				$connection.='Client char encoding: '.mysqli_client_encoding($this->mysqli).'<br>';
				$connection.='Proto info: '.mysqli_get_proto_info($this->mysqli).'<br>';
				$connection.='Current connection ID: '.mysqli_thread_id($this->mysqli);
				echo '<br>';
				$connection.='<br>--------------------------------------<br>'; 
				
				return ($connection);
			}
		}
		
		/**
		 * Statistic - return with the current database statistic parameters
		*/
		public function Statistic() {
			$stat='<br>---------------------------------------------------------><br>';
			if ($this->iface==='OOP')
				$stat.=$this->mysqli->stat();
			else if ($this->iface='PROCEDURAL')
				$stat.=mysqli_stat($this->mysqli);
			$stat.='<br>---------------------------------------------------------><br>';
			
			return ($stat);		
		}
		
		/**
		 * Close - close the current database connection
		*/
		public function Close() {
			if (MySQLiTool::IsConnected())
				mysqli_close($this->mysqli);
			
			return (true);
		}
		
		public function GetConnection() {
			return (var_dump(get_object_vars($this)));
		}
		
		/**
		 * GetLink - check the database connection
		*/
		public function GetLink() {
			return (MySQLiTool::IsConnected());
		}
		
		/**
		 * IsConnected - check whether can be found
		 * a database connection or not
		*/
		public function IsConnected() {
			//if ($this->mysqli!='') {
			if ($this->mysqli!==null) {
				return true;
			}
			
			return false;
		}
		
		/**
		 * SelectDatabase - select the current database
		*/
		public function SelectDatabase($dbname) {
			if (($this->DB==='') && ($dbname!='')) {
				$dba=mysqli_select_db($this->mysqli,$dbname) or die ('Cannot connect '.$dbname.' database!');
			}
			
			$curr_db=mysqli_query($this->mysqli,"SELECT DATABASE()") or die(mysqli_error($this->mysqli));
			return (mysqli_fetch_row($curr_db));
		}
		
		/**
		 * ExecuteCommand - run the current SQL command
		*/
		public function ExecuteCommand($sql) {
			if ($sql==='')
				die('The SQL command cannot be empty!');
			
			if ($this->iface==='OOP')
				return ($this->mysqli->query($sql));
			else if ($this->iface='PROCEDURAL')
				return (mysqli_query($this->mysqli, $sql));
		}
		
		/**
		 * GetRows - returns the number of rows affected
		 * by the last INSERT, UPDATE, REPLACE or DELETE query
		*/
		public function GetRows() {
			return (mysqli_affected_rows($this->mysqli));
		}
		
		/**
		 * NumRows - get the number of rows in a result
		*/
		public function NumRows($result) {
			if ($result==='')
				die('The set of result cannot be empty!');
			
			if ($this->iface==='OOP')
				return ($result->num_rows);
			else if ($this->iface='PROCEDURAL')
				return (mysqli_num_rows($result));
			
		}
		
		/**
		 * FetchArray - fetch a result row
		 * as an associative, a numeric array, or both
		 * resulttype: the possible values for this parameter
		 * are the constants MYSQLI_ASSOC, MYSQLI_NUM, or MYSQLI_BOTH
		 * default is MYSQLI_BOTH
		*/
		public function FetchArray($result,$fetch=MYSQLI_BOTH) {
			if ($result==='')
				die('The set of result cannot be empty!');
			
			if ($this->iface==='OOP')
				return ($result->fetch_array($fetch));
			else if ($this->iface='PROCEDURAL')
				return (mysqli_fetch_array($result));
		}
		
		/**
		 * FetchAssoc - fetch a result row as an associative array
		*/
		public function FetchAssoc($result) {
			if ($result==='')
				die('The set of result cannot be empty!');
			
			if ($this->iface==='OOP')
				return ($result->fetch_assoc());
			else if ($this->iface='PROCEDURAL')
				return (mysqli_fetch_assoc($result));
		}
	}
?>