<?php
  /**
   * A SMALL PICTURE GALLERY ENGINE HAS BEEN WRITTEN BY GARAI, 2013 august.
   * IT IS BASED ON EBUILDER CLASS LIBRARY COLLECTION (EBuilder CLC).
   * THIS ENGINE USES THE FileTool CLASS OF Ebuilder CLC.
   * IT CONTAINS A CONFIRURATOR AND A PROCESS SECTION.
   * I. CONFIGURATOR
   * - INCLUDE EBuilder CLC
   * - INCLUDE FileTool CLASS
   * - SET UP VARIABLES
   * II. PROCESS SECTION
   * IN THIS AREA CAN BE FOUND THE PROCESS ENGINE, WHICH IN SUCCESSFULLY
   * CASE WILL BE RETURNED AN ARRAY WITH THE CURRENT PICTURE ORDER, IN
   * UNSUCCESSFULLY CASE WILL BE RETURNED WITH AN ERROR MESSAGE. TO CALL
   * THIS ROUTINE CAN BE SUCCESSFULLY SHOW ALL NEEDED PICTURES OF ANY
   * GALLERY WITH THE CORRECT ORDER.
   * TO MAKE THE PROCESS MORE COMFORTABLE THE FOUR BASE PARAMETERS IS
   * READ FROM _display.txt FILE. TO MODIFY THE GALLERY STYLE NEED TO
   * MODIFY THE _display.txt FILE PARAMETER(S).
  */
  
  define("ANIMAGIC","animagiC");
	define("ANIMAGIC_VERSION","0.1.1");
	/**
   * CONFIGURATOR SECTION
  */
  // include the EBuilder engine
	if (file_exists(ANIBUILDER_MAIN_DIR.ANIBUILDER_VERSION.'/'.EBUILDER_CLC.'/ebuilder.php'))
    require_once(ANIBUILDER_MAIN_DIR.ANIBUILDER_VERSION.'/'.EBUILDER_CLC.'/ebuilder.php');
	else
		die('The EBuilder class and its database class cannot be found and loaded!');
  // create a new EBuilder object
  $EBUILDER=new Ebuilder();
  // create a new FileTool object
  $MYFILE=new FileTool();
  // current original picture files path
  $currOrigPath='';
  // current thumbs picture files path
  $currThumbsPath='';
	// define how many pictures will be created a new row
  // maximum picture number in one row
  $picNumberInARow='';
	// using a fractal variable needs to set up a limit value
  // if the fractal reaches the limit value then it happens something
  // (in this case it will be created a new row in the main table tag)
  $fractalLimit='';
  // current gallery name
  $galleryName='';
	// picture extension
	$picExtension='';
	// pictures order in a gallery - in a string value
	$img_order_in_string='';
	// save in an array all the picture files of the $currThumbsPath directory in original order
  $fileList=array();
  // current file name must read to get current config
	$img_file_name='';
	// current gallery is ordered or not - default is orderless
	$img_img_order=false;
  // current file content in a dynamic array
  $currConfig=array();
  
  /**
   * PROCESS SECTION
  */
  /**
	 * DelSpaceChars
	 * delete unvisible space chars from end of the current line
	*/
	function DelSpaceChars($theString) {
		//$tmpString=substr($theString, 0, -2);
		//$tmpString=mb_substr($tmpString, 0, -2);
		
		//return $tmpString;
		return (trim($theString));
	}
	
	/**
	 * ReadDisplay needs only a file name
	*/
	function ReadDisplay($filename) {
    global $EBUILDER;
    global $MYFILE;
		global $img_file_name;
		global $currConfig;
    // temporarly string
    $tmpString='';
    // a pointer
    $currConfigCounter=0;
    // string delimiter
    $delimit='|';
		// file remark character
		$remark='#';
    
    if (($filename!='') && (file_exists($filename))) {
      $img_file_name=$filename;
			$fileContent=$MYFILE->ReadFile($img_file_name,$delimit,$remark);
			
      // read the current string content
      for ($i=0; $i<strlen($fileContent); $i++) {
        // check if it can be found: '=' or a delimiter character
        if (($fileContent[$i]==='=') || ($fileContent[$i]===$delimit)) {
          // when the currConfigCounter pointer shows 1 or 3 value
          // 1: the second parameter from the file
          // 3: the fourth parameter from the file
					// 5: pictures number in a row
					// 7: fractal value
					// 9: current gallery name
					// 11: file extension
					// 13: picture order
					// 15: ordered or unordered array (default is unordered)
          if (($currConfigCounter===1) || ($currConfigCounter===3) ||
							($currConfigCounter===5) || ($currConfigCounter===7) || 
							($currConfigCounter===9) || ($currConfigCounter===11) ||
							($currConfigCounter===13) || ($currConfigCounter===15)) {
            // if there is a space char in the tmpString temporarly string
						// then it cannot be return with the correct configuration
						// that is why it must delete last 2 characters from the
						// current substring (substr() or mb_substr() methods)
            $tmpString=DelSpaceChars($tmpString);
          }
          // save the current string into the currConfig array
          $currConfig[$currConfigCounter]=$tmpString;
          // increase the currConfigCounter pointer
          ++$currConfigCounter;
          // clear the tmpString temporarly string value
          $tmpString='';
        }
        // it cannot be found '=' or delimiter character
        else {
          // save the next character of the fileContent string
          // in the tmpString temporarly string
          $tmpString.=$fileContent[$i];
        }
      }
    }
    else {
      die(__METHOD__.':: '.'The '.$filename.' is missing!!');
    }
		
    return ($currConfig);
  }
	/**
	 * StringTester
	 * checks that the given string is empty or not
	*/
	function StringTester($tmpCont) {
		$result=true;
		
		if ((strlen($tmpCont))===0)
			$result=false;
		else if (empty($tmpCont))
			$result=false;
		
		return ($result);
	}
	
	/**
	 * Delimiter
	 * use the delimiter to store every standalone parameter
	 * in well-separated parameters
	*/
	function Delimiter() {
    global $MYFILE;
		global $currOrigPath;
    global $currThumbsPath;
    global $picNumberInARow;
		global $fractalLimit;
    global $galleryName;
		global $picExtension;
		global $img_order_in_string;
		global $img_file_name;
		global $img_img_order;
		global $currConfig;
		
		// get the file content which has been saved in an array
		ReadDisplay(LOAD_FILE);
		
    // check the standard parameters content
		if (($currConfig[0]!=='ORIG_IMG_PATH') || ($currConfig[2]!=='THUMB_IMG_PATH') ||
        ($currConfig[4]!=='IMG_ROW') || ($currConfig[6]!=='FRACTAL') ||
				($currConfig[8]!=='IMG_GALLERY_NAME') || ($currConfig[10]!=='IMG_EXTENSION') ||
        ($currConfig[12]!=='IMG_GALLERY_ORDER') || ($currConfig[14]!=='IMG_IMG_ORDER'))	
			die('The '.$img_file_name.' file content is corrupt! Missing any main configuration name!');
    
		// check the dynamically changeable parameters value
    if ((StringTester($currConfig[1])) && (StringTester($currConfig[3])) &&
        (StringTester($currConfig[5])) && (StringTester($currConfig[7])) &&
				(StringTester($currConfig[9])) && (StringTester($currConfig[11])) &&
        (StringTester($currConfig[13])) && (StringTester($currConfig[15])) ) {
			// define the current pictures path
			$currOrigPath=$currConfig[1];
			// define the current thumb pictures path
			$currThumbsPath=$currConfig[3];
			// define how many pictures will be created a new row
			// maximum picture number in one row
			$picNumberInARow=$currConfig[5];
			// using a fractal variable needs to set up a limit value
			// if the fractal reaches the limit value then it happens something
			// (in this case it will be created a new row in the main table tag)
			$fractalLimit=$currConfig[7];
			// current gallery name
			$galleryName=$currConfig[9];
			// current file extension
			$picExtension=$currConfig[11];
			// current gallery order in a string
			$img_order_in_string=$currConfig[13];
			// current gallery is ordered or not - change the type of the readed parameter from string to bool
			$img_img_order=(bool)$currConfig[15];
		}
		else {
			die(__METHOD__.':: '.'The '.$img_file_name.' is corrupt, it may be parameter(s) is(are) missing!!');
		}
	}
	
	/**
	 * ImgOrder returns an array with numbers
	 * which shows the current pictures order
	*/
	function ImgOrder() {
		global $img_order_in_string;
		$tmpIntImgOrder=array();
		$tmpStrValue='';
		
		// get the main configuration from the readed file as parameters
		Delimiter();
		
		if (!is_null(count($img_order_in_string))) {
			for ($i=0; $i<strlen($img_order_in_string); $i++) {
				// it is not important that how long string can be found
				// between two ',' characters, because all character
				// will be added to the temporarly string which will
				// be saved into the temporarly array which will be returned
				// now let's see the routine:
				// if current charachter is not a ','
				// then add the character to the temporarly string
				if ($img_order_in_string[$i]!==',') {
					$tmpStrValue.=$img_order_in_string[$i];
				}
				// if current charachter is a ','
				// then add the temporarly string to the temporarly array
				else {
					$tmpIntImgOrder[]=(int)$tmpStrValue;
					$tmpStrValue='';
				}
			}
			// because the last temporarly string has not been added yet
			// it is time to do it
			$tmpIntImgOrder[]=(int)$tmpStrValue;
		}
		else {
			die(__METHOD__.':: '.'The '.$img_file_name.' is corrupt, it may be the image order is missing!!');
		}
		
		return ($tmpIntImgOrder);
	}
	
	/**
   * LoadImages function parameters:
   * 
   * $tmpPicOrder:      picture order in the current gallery
   * $currPicPath:      path of all picture 
   * $currPicThumbPath: path of all thumb pictures
   * $galName:          current gallery name
   * $fileExt:          current file extension ('ALL_FILES' or an extension)
  */
  //function LoadImages($tmpPicOrder,$currPicPath,$currPicThumbPath,$galName,$fileExt) {
	function LoadImages() {
    global $MYFILE;
		global $currOrigPath;
    global $currThumbsPath;
    global $picNumberInARow;
		global $fractalLimit;
    global $galleryName;
		global $picExtension;
		global $img_order_in_string;
		global $img_file_name;
		global $img_img_order;
		global $currConfig;
		global $fileList;
    $fileList=array();
		// save in an array all the picture files of the $currThumbsPath directory in a user order
    $tempFileList=array();
		
		// - load the parameters -
    // create a new temporarly array to save any new order inside of the original one
    // the new order can be condescended by an array of numbers - till length of the original array
    $currOrd=ImgOrder();
		
		// get all thumbs - may be with a special extension - from the current thumbs directory
		// $img_img_order value shows wheter the gallery is ordered or not
		$fileList=$MYFILE->Get_Files($currThumbsPath,$picExtension,$img_img_order);
		
		// if all the files in the gallery can be found
		if ($fileList) {
      if (!is_dir($currOrigPath))
        die(__METHOD__.':: '.getcwd().$currOrigPath.' directory does not exist!');
      
      // check the original and current order arrays arrays lenght
      if (count($fileList)===count($currOrd)) {
				// count the current array pointer
        $counter=0;
        while ($counter<count($fileList)) {
					$tempFileList[$counter]=$fileList[$currOrd[$counter]];
          ++$counter;
        }
        // load the temporarly array into the original one
        $fileList=$tempFileList;
      }
      else {
        // if current order array is empty
        if (count($currOrd)===0)
          die(__METHOD__.':: '.'The current order array is empty!');
        // the original and current order arrays arrays lenght are different
        else
          die(__METHOD__.':: '.'Arrays have different length!');
      }
    }
    else {
      // if fileList array has problem then show the error message of the FileTool class
      die($MYFILE->Get_Message());
    }
  }
?>