<?php
   /**
   * Process.php
   * 
   * The Process class is meant to simplify the task of processing
   * user submitted forms, redirecting the user to the correct
   * pages if errors are found, or if form is successful, either
   * way. Also handles the logout procedure.
   *
   */
   
   /**
   * Standard upload directory
   */
   define("UPLOAD_DIR", __DIR__."/uploads");
   define("UPLOADS", "/uploads/");
   include('_include/session.php');
   
   class Process {
      var $image_path;     // Holds current image path
      var $currFullPath;   // Holds current page URI
      
      /* Class constructor */
      public function __construct() {
         global $session;
         
         /* User submitted login form */
         if (isset($_POST['sublogin'])) {
            $this->procLogin();
         }
         /* User submitted registration form */
         else if (isset($_POST['subjoin'])) {
            $this->procRegister();
         }
         /* User submitted forgot password form */
         else if (isset($_POST['subforgot'])) {
            $this->procForgotPass();
         }
         /* User submitted edit account form */
         else if (isset($_POST['subedit'])) {
            $this->procEditAccount();
         }
         /* User submitted create new blog form */
         else if (isset($_POST['subblogcreate'])) {
            $this->procCreateBlog();
         }
         /* User submitted create new blog form */
         else if (isset($_POST['subblogedit'])) {
            $this->procEditBlog();
         }
         /* User submitted create new blog form */
         else if (isset($_POST['subblogdelete'])) {
            $this->procDeleteBlog();
         }
         /* User submitted upload new image form */
         else if (isset($_POST['MAX_FILE_SIZE'])) {
            $this->uploadImage();
         }
         /**
          * The only other reason user should be directed here
          * is if he wants to logout, which means user is
          * logged in currently.
          */
         else if ($session->logged_in) {
            $this->procLogout();
         }
         /**
          * Should not get here, which means user is viewing this page
          * by mistake and therefore is redirected.
          */
          else {
             header("Location: entry.php");
          }
      }
      
      /**
      * procLogin - Processes the user submitted login form, if errors
      * are found, the user is redirected to correct the information,
      * if not, the user is effectively logged in to the system.
      */
      public function procLogin() {
         global $session, $form;
         
         /* Login attempt: 1 means success, 0 means fail */
         $retval = $session->login($_POST['user'], $_POST['pass'], isset($_POST['remember']));
         
         /* Login successful */
         if ($retval) {
            //header("Location: ".$session->referrer);
            header("Location: ".$session->referrer.'?u='.$session->username);
         }
         /* Login failed */
         else {
            $_SESSION['value_array'] = $_POST;
            $_SESSION['error_array'] = $form->getErrorArray();
            header("Location: ".$session->referrer);
         }
      }
      
      /**
      * procLogout - Simply attempts to log the user out of the system
      * given that there is no logout form to process.
      */
      public function procLogout() {
         global $session;
         
         $retval = $session->logout();
         header("Location: entry.php");
      }
      
      /**
      * procRegister - Processes the user submitted registration form,
      * if errors are found, the user is redirected to correct the
      * information, if not, the user is effectively registered with
      * the system and an email is (optionally) sent to the newly
      * created user.
      */
      public function procRegister() {
         global $session, $form;
         
         /* Convert username to all lowercase (by option) */
         if (ALL_LOWERCASE) {
            $_POST['user'] = strtolower($_POST['user']);
         }
         /* Registration attempt */
         $retval = $session->register($_POST['user'], $_POST['pass'], $_POST['email']);
         
         /* Registration Successful */
         if ($retval == 0) {
            $_SESSION['reguname'] = $_POST['user'];
            $_SESSION['regsuccess'] = true;
            header("Location: ".$session->referrer.'?u='.$session->username);
         }
         /* Error found with form */
         else if ($retval == 1) {
            $_SESSION['value_array'] = $_POST;
            $_SESSION['error_array'] = $form->getErrorArray();
            header("Location: ".$session->referrer);
         }
         /* Registration attempt failed */
         else if ($retval == 2) {
            $_SESSION['reguname'] = $_POST['user'];
            $_SESSION['regsuccess'] = false;
            header("Location: ".$session->referrer);
         }
      }
      
      /**
      * procForgotPass - Validates the given username then if
      * everything is fine, a new password is generated and
      * emailed to the address the user gave on sign up.
      */
      public function procForgotPass() {
         include('_lang/'.PROG_LANG.'.php');
         global $database, $session, $mailer, $form;
         
         /* Username error checking */
         $subuser = $_POST['user'];
         $field = "user";  //Use field name for username
         if (!$subuser || strlen($subuser = trim($subuser)) == 0) {
            $form->setError($field, $STD_010.'<br>');
         }
         else {
            /* Make sure username is in database */
            $subuser = stripslashes($subuser);
            if (strlen($subuser) < 5 || strlen($subuser) > 30 ||
                !preg_match("/^([0-9.a-zA-Z])+$/", $subuser) ||
                (!$database->usernameTaken($subuser))) {
               $form->setError($field, $STD_011.'<br>');
            }
         }
         
         /* Errors exist, have user correct them */
         if ($form->num_errors > 0) {
            $_SESSION['value_array'] = $_POST;
            $_SESSION['error_array'] = $form->getErrorArray();
         }
         /* Generate new password and email it to user */
         else {
            /* Generate new password */
            $newpass = $session->generateRandStr(8);
            
            /* Get email of user */
            $usrinf = $database->getUserInfo($subuser);
            $email  = $usrinf['email'];
            
            /* Attempt to send the email with new password */
            if ($mailer->sendNewPass($subuser,$email,$newpass)) {
               /* Email sent, update database */
               $database->updateUserField($subuser, "password", md5($newpass));
               $_SESSION['forgotpass'] = true;
            }
            /* Email failure, do not change password */
            else {
               $_SESSION['forgotpass'] = false;
            }
         }
         
         header("Location: ".$session->referrer);
      }
      
      /**
      * procEditAccount - Attempts to edit the user's account
      * information, including the password, which must be verified
      * before a change is made.
      */
      public function procEditAccount() {
         global $session, $form;
         
         /* Account edit attempt */
         $retval = $session->editAccount($_POST['curpass'], $_POST['newpass'], $_POST['email']);
   
         /* Account edit successful */
         if ($retval) {
            $_SESSION['useredit'] = true;
            header("Location: ".$session->referrer);
         }
         /* Error found with form */
         else {
            $_SESSION['value_array'] = $_POST;
            $_SESSION['error_array'] = $form->getErrorArray();
            // back to the current site
            header("Location: ".$session->referrer);
         }
      }
      
      /**
       * curPageURL - Get the current page URL
      */
      public function curPageURL() {
         $pageURL = 'http';
         if ($_SERVER["HTTPS"] == "on")
            $pageURL .= "s";
         
         $pageURL .= "://";
         if ($_SERVER["SERVER_PORT"] != "80") {
            $pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
         }
         else {
            $pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
         }
         
         return $pageURL;
      }
      
      /**
       * curPageName - Get the current page name only
      */
      public function curPageName() {
         return substr($_SERVER["SCRIPT_NAME"],strrpos($_SERVER["SCRIPT_NAME"],"/")+1);
      }
      
      /**
       * curPageURLCheckSSL - Check the current URL address protocol: with or without SSL (http or https)
      */
      public function curPageURLCheckSSL($currData) {
         $pos = 0;
         $result = '';
         
         if ($currData != '') {
            // length of the current $currData string
            $pos=strlen($currData);
            // we are looking for the first ':' (colon)
            while ($currData[$currPos]!=':') {
               $result .= $currData[$currPos];
               ++$currPos;
            }
         }
         
         // compare the current protocol with the standard ones
         if($result==='http') {
            return ('http');
         }
         else if($result==='https') {
            return ('https');
         }
         else {
            die($result.' THIS IS UNKNOWN.');
         }
      }
      
      public function curPageURLWithoutFileName() {
         $pos = 0;
         $result = '';
         
         if ($this->currFullPath != '') {
            // find the current file name in the current full path
            $pos=strlen($this->currFullPath);
            while ($this->currFullPath[$pos] != '/') {
               --$pos;
            }
            // delete file name from the current full path
            for ($i=0; $i<$pos; $i++) {
               $result .= $this->currFullPath[$i];
            }
         }
         
         // if current protocol is the https we need to correct the URL path
         if ($this->curPageURLCheckSSL($result)==='https')
            $result = $this->curPageURLWithoutSSL($result);
         
         return $result;
      }
      
      // it needs to save the image absolute path without ssl
      public function curPageURLWithoutSSL($currData) {
         $pos     = 0;
         $currPos = 0;
         $result  = '';
         
         if ($currData != '') {
            // length of the current $currData string
            $pos=strlen($currData);
            // we are looking for the first ':' (colon)
            while ($currData[$currPos]!=':') {
               $result .= $currData[$currPos];
               ++$currPos;
            }
            // delete 's' char - as SSL - from the https protocol
            $result = str_replace('s','',$result);
            // now we have to insert the current characters - this is,
            // as we know, the first ':' (colon) character
            $result .= $currData[$currPos];
            // we need to increase the current position - it will continue
            // to read the $currData string till it can be found a new : (colon)
            ++$currPos;
            
            // we are looking for the second ':' (colon)
            while ($currData[$currPos]!=':') {
               $result .= $currData[$currPos];
               ++$currPos;
            }
            
            // we are looking for the next '/' (slash) - from this slash we can
            // read continuously our $currData string and copy all of characters
            // into the $result string
            while ($currData[$currPos]!='/') {
               ++$currPos;
            }
            
            // we can copy any other characters from the currData string into the $result one
            for ($currPos; $currPos < $pos; ++$currPos) {
               $result .= $currData[$currPos];
            }
         }
         
         return ($result);
      }
      
      /**
      * HTMLWithoutNewLine - do no save the blog content <br /> tag into the database
      */
      public function HTMLWithoutNewLine($strData) {
         $currData=htmlspecialchars($_POST['blog_comment'],ENT_QUOTES);
         $result = '';
         
         // in normal way: htmlspecialchars gives this: [&lt;br /&gt;] which means 12 characters in any string
         // but in the nicEdit gives only the last 10 characters: [&lt;br&gt;]
         // which we do not want to use: it means <br />
         if (($currData[strlen($currData)-6]='b') && ($currData[strlen($currData)-5]='r')) {
            for ($i=0;$i<strlen($currData)-10;$i++)
              $result.=$currData[$i];
         }
         
         return ($result);
      }
      
      /**
      * procCreateBlog - create a new blog entry into the database
      */
      public function procCreateBlog() {
         global $session, $form;
         $checkbox = '0';
         $note_temp = '';
         
         /* Save new blog attempt */
         if (isset($_POST['blog_note'])) {
            $checkbox = '1';
            /* if the new blog is a new note, then we save the first 50 characters of the full content */
            if (strlen($_POST['blog_comment'])>50) {
               for ($i=0; $i<51; $i++) {
                  $note_temp.=$_POST['blog_comment'][$i];   
              }
              $_POST['blog_comment'] = $note_temp;
            }
         }
         else {
            $checkbox = '0';
         }
         
         // save the content without the last <br /> HTML tag
         $_POST['blog_comment'] = $this->HTMLWithoutNewLine($note_temp);
         // start the saving process
         $retval = $session->createNewBlog($_POST['blog_user'],
                                           $_POST['blog_title'],
                                           $_POST['blog_comment'],
                                           $checkbox,
                                           $_POST['blog_link'],
                                           $_SESSION['image_path']);
         /* Create blog successful */
         if ($retval == 0) {
            $_SESSION['newblogsuccess'] = true;
            header("Location: ".$session->referrer.'?u='.$session->username);
         }
         /* Create blog failed */
         else if ($retval == 1) {
            $_SESSION['value_array'] = $_POST;
            $_SESSION['error_array'] = $form->getErrorArray();
            $_SESSION['blog_title'] = $_POST['blog_title'];
            header("Location: ".$session->referrer.'?u='.$session->username);
         }
         else if ($retval == 2) {
            $_SESSION['newblogsuccess'] = false;
         }
      }
      
      /**
      * procEditBlog - edit an existing blog entry
      */
      public function procEditBlog() {
         global $session, $form;
         $checkbox = '0';
         
         // get current record
         $currString = $_POST['submit'];
         $currRecord = '';
         $cnt = 0;
         while ($currString[$cnt] != '.') {
            $currRecord .= $currString[$cnt];
            ++$cnt;
         }
         
         // get title and content from blog_read.php form
         // where we know the current record
         $currUser=$_POST[$currRecord.'_blog_user'];
         $currTitle=$_POST[$currRecord.'_blog_title'];
         $currContent=$_POST[$currRecord.'_blog_comment'];
         $currLink=$_POST[$currRecord.'_blog_link'];
         
         if ($currTitle != '' && $currContent != '') {
            // create the current UPDATE command to the database
            $currCommand = "UPDATE ".TBL_BLOGS." SET title='$currTitle',content='$currContent',link='$currLink' WHERE id='$currRecord'";
            $retval = $session->readSavedBlog($currCommand);   
         }
         else {
            $retval = 0;
         }
         if ($retval == 1) {
            $_SESSION['editblogsuccess'] = true;
            header("Location: ".$session->referrer.'?u='.$session->username);
         }
      }
      
       /**
      * procDeleteBlog - delete an existing blog entry
      */
      public function procDeleteBlog() {
         global $session, $form;
         
         /* get current record */
         $currStringDelete = $_POST['submit'];
         $currRecordDelete = '';
         $cntDelete = 0;
         while ($currStringDelete[$cntDelete] != '.') {
            $currRecordDelete .= $currStringDelete[$cntDelete];
            ++$cntDelete;
         }
         
         // get title and content from blog_read.php form
         // where we know the current record
         $currUser=$_POST[$currRecordDelete.'_blog_user_del'];
         $currTitle=$_POST[$currRecordDelete.'_blog_title_del'];
         $currContent=$_POST[$currRecordDelete.'_blog_comment_del'];
         $currLink=$_POST[$currRecordDelete.'_blog_link_del'];
         
         if ($currTitle != '' && $currContent != '') {
            // create the current UPDATE command to the database
            $currCommand = "UPDATE ".TBL_BLOGS." SET active='0' WHERE id='$currRecordDelete'";
            $retval = $session->readSavedBlog($currCommand);   
         }
         else {
            $retval = 0;
         }
         if ($retval == 1) {
            $_SESSION['delblogsuccess'] = true;
            header("Location: ".$session->referrer.'?u='.$session->username);
         }
      }
      
      /**
			 * correctImagePath - if the current image path contains
			 * a backslash (\) then we need to insert a new one
			 * before any backslash to store the current SQL command
			*/
			public function correctImagePath($currImagePath) {
				 $result='';
				 
         /**
          * any Windows operating system always uses the backslash (\) to sign
          * all directories and files pathes. if we want to store it in a database
          * then we need to supplement our full path with a new backslash (\) sign
          * in every places where to find backslash at all
				 */
         for ($i=0; $i<strlen($currImagePath); $i++) {
						if ($currImagePath[$i]=='\\') {
							 $result.='\\\\';
						}
						else
							 $result.=$currImagePath[$i];
				 }
         
				 return $result;
			}
      
      /**
       * onlyEngChars - file name can contain only the 26 english characters
      */
      public function onlyEngChars($currString) {
         $inline=array("á","Á","é","É","í","Í","ó","Ó","ö","Ö","ő","Ő","ú","Ú","ü","Ü","ű","Ű"," ");
         $outline=array("a","A","e","E","i","I","o","O","O","O","o","O","u","U","U","U","u","U","_");
         
         return(str_replace($inline,$outline,$currString));
      }
      
      /**
      * uploadImage - upload an image into the uploads directory
      */
      public function uploadImage() {
         mb_internal_encoding("UTF-8");
         global $session, $form;
         
         unset($_SESSION['correct_array']);
         unset($_SESSION['error_array']);
         
         /* if upload button has been pressed */
         if (isset($_POST['blog_image_submit'])) {
            /* current date */
            $curr_date=date('Y').'.'.date('m').'.'.date('d');
            /* standard path where to upload the current image file */
            $target=UPLOAD_DIR.'/'.$curr_date.'/';
            $target=$this->correctImagePath($target);
            /* if the current directory does not exist create it with full access */
            $mode=0777;
            if (!file_exists($target))
               mkdir($target,$mode);
            
            /* uploaded file renames the $_FILES superglobal variable file name (orig file name) */
            $file_name = $_FILES['file']['name'];
            $file_name = $this->onlyEngChars($file_name);
            /* temporarly path where to upload the current image file */
            $tmp_dir = $_FILES['file']['tmp_name'];
            
            // try to upload the current image file
            $retval = $session->uploadNewImage($tmp_dir, $target, $file_name);
            
            // if the upload process has been successfull
            if ($retval==0) {
               // current processor file name
               $this->currFullPath = $this->curPageURL();
               // get the current image path and set it into the $_SESSION global variable
               $_SESSION['image_path'] = $this->curPageURLWithoutFileName();
               $_SESSION['image_path'] .= UPLOADS.$curr_date.'/'.$file_name;
               $_SESSION['image_path'] = $_SESSION['image_path'];
               $_SESSION['value_array'] = $_POST;
               $_SESSION['correct_array'] = $form->getCorrectArray();
               $_SESSION['blog_image_correct'] = $_POST['blog_image_correct'];
               header("Location: ".$session->referrer.'?u='.$session->username);
            }
            // if the upload process has not been successfull
            else if ($retval==1) {
               $_SESSION['value_array'] = $_POST;
               $_SESSION['error_array'] = $form->getErrorArray();
               $_SESSION['blog_image_error'] = $_POST['blog_image_error'];
               header("Location: ".$session->referrer.'?u='.$session->username);
            }
         }
      }
   };
   
   /* Initialize process */
   $process = new Process;
?>