<?php
  /**
   * CONFIGURATOR SECTION
   * MODIFICATIONS OF THE FIRST AND THE SECOND PARAMETERS CAN BE INACCESSIBLE THE DESIRED GALLERY
  */
  // define a directory which contains the diferrent galleries setting files
  define("CONFIG_CONTENT","_onboard/");
  // define a filename which contains the diferrent galleries setting parameters
  define("LOAD_FILE",CONFIG_CONTENT."_display.txt");
  // define file extension: ALL_FILES, or any other extension (in this case: it is important upper and lower case)
  //define("FILE_EXT","ALL_FILES");
  define("FILE_EXT","jpg");
  // define the name of the current gallery name
  define("NAME_OF_GALLERY","Asztalos munkák a\'la Kozma");
  // define a new picture order
  $picOrder=array(0,1,2,3,4,5);
  /**
   * END: CONFIGURATOR SECTION
  */
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" >
<html xmlns="http://www.w3.org/1999/xhtml" lang="hu" xml:lang="hu">
<head>
<?php
    // set the header
    if (file_exists('header.php'))
      require_once('header.php');
?>
<title><?php echo 'Gallery test'; ?></title>
</head>

<body>
  <!-- LOAD PICTURES METHOD -->
<?php
  if (file_exists('coproc_pic_order.php')) {
    require_once('coproc_pic_order.php');
    
    // first need to get all parameters from the _display.txt file
    if (file_exists(LOAD_FILE)) {
      $currConfig=ReadDisplay(LOAD_FILE);
      if (($currConfig[0]!=='ORIG_IMG_PATH') || ($currConfig[2]!=='THUMB_IMG_PATH') ||
          ($currConfig[4]!=='IMG_ROW') || ($currConfig[6]!=='FRACTAL'))
        die('Config file content is corrupt!');
    }
    else{
      die('The '.LOAD_FILE.' cannot be found!');
    }
    
    // define the current pictures path
    $curGalleryPath=$currConfig[1];
    // define the current thumb pictures path
    $curGalleryThumbPath=$currConfig[3];
    // define how many pictures will be created a new row
    // maximum picture number in one row
    $picNumberInARow=$currConfig[5];
    // using a fractal variable needs to set up a limit value
    // if the fractal reaches the limit value then it happens something
    // (in this case it will be created a new row in the main table tag)
    $fractalLimit=$currConfig[7];
    // current gallery name
    $curGalleryName=NAME_OF_GALLERY;
    // current file extension
    $curFileExt=FILE_EXT;
    
    // now it can be used the picture loader method
    LoadImages($picOrder,$curGalleryPath,$curGalleryThumbPath,$curGalleryName,$curFileExt);
  }
  else
   die('The process_pic_order.php file cannot be found!');
?>
  <!-- MAIN GALLERY -->
  <div class="main-gallery">
    <table cellpadding="0" cellspacing="16">
      <tr><td  colspan='6'></td></tr>
      <tr>
<?php
  // the fileList - in process_pic_order.php - array pointer counter
  $cnt=0;
  
  // get and use the current array to show pictures from
  // the 1st one to the last one in the current order
  foreach ($fileList as $key => $currFile) {
    // create a fraction - after every $picNumberInARow picture creates a new row
    if ($picNumberInARow!=0)
      $fraction=($key%($picNumberInARow))/($picNumberInARow);
    else
      die('Invalid method: division by zero!<br />You have to define the \'picture number in a row\' value!');
    // this script uses Clearbox gallery
    // if the gallery engine has been changed
    // then it is the time to execute it in this script
    // Clearbox parameter: the galleryName value can be found in process_pic_order.php
?>
        <td class='mgImg'>
          <a href="<?php echo $currOrigPath.$currFile; ?>"
             rel="clearbox[gallery=<?php echo $galleryName; ?>]"
             title="<?php echo $MYFILE->FileNameWithoutExt($currFile); ?>">
            <img src="<?php echo $currThumbsPath.$currFile; ?>" />
          </a>
        </td>
<?php
    // in process_pic_order.php can be found
    // the fraction and the fractalLimit parameters
    // if the counter reaches the picNumberInARow value
    // then close the current row and creates a new one
    if ($fraction==$fractalLimit) {
      echo "</tr>";
      echo "<tr>";
    }
    // increases the fileList array pointer counter
    ++$cnt;
  }
?>
      </tr>
    </table>
  <!-- END: MAIN GALLERY -->
  </div>
</body>
</html>