<?php
class MySQLiTool {
	private $conn;	
	
	public function __construct($host,$port,$name,$passwd) {
		if (($host!='') && ($port!='') &&  
			  ($name!='') && ($passwd!='')) {
			$hostinfo=$host.':'.$port;
			try {
				$this->conn=mysqli_connect($hostinfo,$name,$passwd);
			}
			catch (Exception $e) {
				die ('Cannot connect to '.$hostinfo.' host! '.$e);
			}
			
			return ($this->conn);
		}
		else {
			$this->conn='';
		} 
	}
	
	public function __destruct() {
		$this->conn=null;
	}
	
	public function Connection() {
		if (MySQLiTool::IsConnected()) {
			$proc=mysqli_thread_id($this->conn);
			echo '<br>--------------------------------------<br>';
			$connection='Host info: '.mysqli_get_host_info($this->conn).'<br>';
			$connection.='Server info: '.mysqli_get_server_info($this->conn).'<br>';
			$connection.='Client info: '.mysqli_get_client_info($this->conn).'<br>';
			$connection.='Client char encoding: '.mysqli_client_encoding($this->conn).'<br>';
			$connection.='Proto info: '.mysqli_get_proto_info($this->conn).'<br>';
			$connection.='Current connection ID: '.mysqli_thread_id($this->conn);
			echo '<br>';
			$connection.='<br>--------------------------------------<br>'; 
			
			return ($connection);
		}
	}
	
	public function Close() {
		if (MySQLiTool::IsConnected()!='')
			mysqli_close($this->conn);
			return (true);
	}
	
	public function GetConnection() {
		return (var_dump(get_object_vars($this)));
	}
	
	public function GetLink() {
		return ($this->conn);
	}
	
	public function IsConnected() {
		if ($this->conn!='') {
			return true;
		}
		
		return false;
	}
	
	public function SelectDatabase($dbname) {
		if ($dbname!='') {
			$dba=mysqli_select_db($this->conn,$dbname) or die ('Cannot connect '.$dbname.' database!');
		}
		
		$curr_db=mysqli_query($this->conn,"SELECT DATABASE()") or die(mysql_error());
		return (mysqli_fetch_row($curr_db));
	}
	
	public function Statistic() {
		$stat='<br>---------------------------------------------------------><br>';
		$stat.=mysqli_stat($this->conn);
		$stat.='<br>---------------------------------------------------------><br>';
		return ($stat);		
	}
	
	public function ExecuteCommand($sql) {
		return (mysqli_query($sql, $this->conn));
	}
	
	public function GetRows() {
		return (mysqli_affected_rows($this->conn));
	}
}
?>