<?php
class InternetTool {
  private $LOCALIP;
  private $REMOTEIP;
	
	public function __construct($remote_ip) {
    $this->LOCALIP =NULL;
    $this->LOCALIP =$_SERVER['REMOTE_ADDR'];
    $this->REMOTEIP=NULL;
    $this->REMOTEIP=$remote_ip;
  }
	
	public function __destruct() {
		$this->LOCALIP =null;
		$this->REMOTEIP=null;
	}
  
  // check any email address validation
  public function is_valid_email($email) {
		// shorter checker 1.
		//return preg_match('/^[_\.0-9a-zA-Z-]+@([0-9a-zA-Z][0-9a-zA-Z-]+\.
		//									)+[a-zA-Z]{2,6}$/i', $email);
		// shorter checker 2.
		//return preg_match('/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.
		//									[a-z0-9-]+)*(\.[a-z]{2,3})$/i', $email);
		
		// completly checker
		if (preg_match('/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.
										[a-z0-9-]+)*(\.[a-z]{2,3})$/i', $email)) {
    	list($username,$domain)=preg_split('/@/',$email);
    	if(!checkdnsrr($domain,'MX')) {
      	return false;
    	}
    	return true;
  	}
  	
		return false;
  }
  
  // send a new email to a valid email address
  public function SendMail($to, $subject, $message, $additional_headers) {
    if (($to!='') && (($subject!='') ||
				($message!='')) && ($additional_headers!='')) {
      if ($this->is_valid_email($to)==true) {
        mail($to, $subject, $message, 'From: '.$additional_headers);
        return true;  
      }
      else {
        echo 'Not valid email address!';
				return false;
      }
    }
    else {
			echo 'The Sender, Subject/Message or From field(s) is/are empty!';
      return false;    
    }
  }
  
  // check our intra- or internet connection
  public function PingTest($pingmode) {
		// first method to check connection
    if ($pingmode==1) {
      if(getenv('OS')=='Windows_NT') {
        echo 'Your OS: '.getenv('OS').'<br />Your IP address: '.
							$this->LOCALIP.'<br />';
        $exec			=exec('ping -n 3 -l 64 '.$this->REMOTEIP);
        $arrayMain=explode(' ', $exec );
				$arrayEnd	=end($arrayMain);
				
        //return $exec;
				return $arrayEnd;
      }
      else {
        echo 'Info about your OS: '.php_uname().'<br />';
        echo 'Your op. system:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; '.PHP_OS.
             '<br />Your IP address:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.
						 $this->LOCALIP.'<br />';
        $exec			=exec('ping -c 3 -s 64 -t 64 '.$this->REMOTEIP);
				$arrayMain=explode('=', $exec );
				$arrayEnd	=end($arrayMain);
				
				return $arrayEnd;
      }
    }
    // second method to check connection
    elseif ($pingmode==2) {
      echo 'Your IP address:&nbsp;'.$this->LOCALIP.
					 '<br />Remote IP:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
					 &nbsp;&nbsp;'.$this->REMOTEIP;
      $s =microtime();
      $fp=fsockopen('udp://'.$this->REMOTEIP, 13, $errno, $errstr, 30);
      $e =microtime();
      $tt=$e-$s;
      
			if ($fp)
        fclose($fp);
    
      return ($tt.' ms');
    }
  }
	
	public function GetHostname($remote_ip) {
		if ($remote_ip!='')
			return gethostbyaddr($remote_ip);
		else
			return false;
	}
	
	public function GetHostIpAddress($remote_hostname) {
		if ($remote_hostname!='')
			return gethostbyname($remote_hostname);
		else
			return false;
	}
	
	public function Traceroute($remote_address) {
		$result='';
		$wincommand=`C:\\Windows\\system32\\tracert.exe $remote_address`;
		$linuxcommand=`/usr/sbin/traceroute $remote_address`;
		$runcommand='';
		
		if ($remote_address!='') {
			// check OS
			if (PHP_OS=='WINNT')
				$runcommand=trim(nl2br($wincommand));
			else
				$runcommand=trim(nl2br($linuxcommand));
			// if we do not have have correct result
			if (!$result.=$runcommand) {
					$result.='Traceroute failed. Host may not be active.'; 
					$msg.='</blockquote></p>';
				}
			// else we show the result
			else {
				return $result;
			}
		}
		else {
			return false;
		}
	}
}
?>