<?php
// A class to manage httpd group files used for Basic Authentication
class Htgroup {
	var	$VERSION='Revision 0.1';
	// Set to true for M$ BloatWare servers
	var $WIN32=false;
	// Filename Holder
	var $FILE='';
	// Last error message
	var $ERROR='';
	// Is the FILE empty?
	var $EMPTY=false;
	// Raw htpasswd contents
	var $CONTENTS='';
	// check whether $FILE exists or not
	var $EXISTS=false;
	// check whether $FILE passes all tests or not
	var $SANE=false;
	// check whether user is an idiot or not
	var $IDIOT=false;
	// logs errors to error_log if set
	var $DEBUG=true;
	// Array of [index#][(user|pass)]=value
	var $GROUPS=array();
	// Counter - total number of users in $FILE
	// Zero based indexing on $GROUPS
	var $GROUPCOUNT=0;
	
	// constructor
	public function __construct($groupFile='') {
		global $php_errormsg;
		ini_set('track_errors',1);
		
		if (!empty($groupFile)) {
			$this->initialize($groupFile);
		}
		return;
	}
	
	private function initialize($groupFile) {
		$this->FILE=$groupFile;
		// Seed the random number gen
		srand((double)microtime()*1000000);
		if (empty($groupFile)) {
			// PHP is going to bitch about this, this is here just because
			$this->error('Invalid initialize() or new() method:
										No file specified!',1);
			// Just in case
			exit;
		}
		if (file_exists($this->FILE)) {
			$this->EXISTS=true;
			if ($this->sane($this->FILE)) {
				$this->SANE=true;
				$this->htReadFile();
			}
			else {
				// Preserve the error generated by sane()
				return;
			}
		}
		else {
			// Non-existant files are safe
			$this->SANE=true;
		}
		return;
	}
	
	public function do_not_blame_cdi() {
		$this->IDIOT=true;
		$this->error('No sanity checking on files',0);
		return;
	}
	
	public function sane($filename) {
		if ($this->IDIOT) {
			return true;
		}
		// If it's a Win32 box, there's no sense in doing all this
		if ($this->WIN32) {
			// You're on your own
			return true;
		}
		//	Some kind of *nix machine - let's do some
		//	rudimentary checks
		if (!(is_readable($filename))) {
			$this->error('File ['.$filename.'] not readable.',0);
			return false;
		}
		if (!(is_writeable($filename))) {
			$this->error('File ['.$filename.'] not writeable.',0);
			return false;
		}
		if (is_dir($filename)) {
			$this->error('File ['.$filename.'] is a directory.',0);
			return false;
		}
		if (is_link($filename)) {
			$this->error('File ['.$filename.'] is a symlink.',0);
			return false;
		}
		return true;
	}
	
	public function version() {
		return $this->VERSION;
	}
	
	public function error($errMsg,$die) {
		$this->ERROR='[Htgroup] '.$errMsg;
		if ((!($this->DEBUG)) && ($die != 1)) {
			return;
		}
		if ($this->DEBUG) {
			error_log($this->ERROR,0);
		}
		if ($die==1) {
			echo '<b> ERROR : '.$this->ERROR.'</b><br><br>';
			exit;
		}
		return;
	}
	
	public function htReadFile() {
		$Mytemp=array();
		$Myjunk=array();
		$count=0;
		$empty=false;
		$contents='';
		$filename=$this->FILE;
		if (file_exists($filename))
			$filesize=filesize($filename);
		else
			$this->error('FATAL File cannot be found ['.$php_errormsg.']',1);
		
		if ($filesize<3) {
			$empty = true;
		}
		if (!($empty)) {
			$this->EMPTY=false;
			$fd=fopen( $filename, "r" );
			if (empty($fd)) {
				$this->error('FATAL File access error ['.$php_errormsg.']',1);
				// Just in case
				exit;
			}
			$contents=fread($fd,filesize($filename));
			fclose($fd);
			$this->CONTENTS=$contents;
			$Mytemp=preg_split("/\n/",$contents);
			for($count=0;$count<count($Mytemp);$count++) {
				$group='';
				$user='';
				if (empty($Mytemp[$count])) {
					break;
				}
				if (preg_match("/^(\n|\W)(.?)/",$Mytemp[$count]))	{
					break;
				}
				if (!(preg_match("/:/",$Mytemp[$count]))) {
					$group=$Mytemp[$count];
					$errno=($count+1);
					$this->ERROR('FATAL invalid group ['.$group.']
												on line ['.$errno.'] in ['.$filename.']',1);
				}
				list ($group,$users)=split(":",$Mytemp[$count]);
				if (($group!='')) {
					$users=preg_replace("/^([ 	]+)/","",$users);
					$UArray=explode(" ",$users);
					$Myjunk[$group]=$UArray;
				}
			}
			$this->GROUPS=$Myjunk;
			$this->GROUPCOUNT=$count;
		}
		else {
			// Empty file. Label it as such
			$this->GROUPS=$Myjunk;
			$this->GROUPCOUNT=-1;
			$this->EMPTY=true;
		}
		
		return;
	}
	
	public function isGroup($GroupID) {
		if (empty($GroupID)) {
			return false;
		}
		$match=false;
		$MyTemp=$this->GROUPS;
		while (list($group,$users)=each($MyTemp)) {
			if ($GroupID==$group) {
				$match=true;
			}
		}
		
		return $match;
	}
	
	public function getGroupNum($GroupID) {
		$groupNum=-1;
		$count=0;
		if (empty($GroupID)) {
			return $groupNum;
		}
		if (!$this->isGroup($GroupID)) {
			$this->error('Group ['.$GroupID.'] does not exist',0);
			return $groupNum;
		}
		$MyTemp=$this->GROUPS;
		while (list($group,$users)=each($MyTemp)) {
			if ($GroupID==$group) {
				$groupNum=$count;
			}
			$count++;
		}
		return $groupNum;
	}
	
	public function renameGroup($GroupID,$NewID) {
		if (empty($GroupID)) {
			return false;
		}
		if (empty($NewID)) {
			return false;
		}
		$match=false;
		if (!$this->isGroup($GroupID)) {
			$this->error('Cannot rename non-existant group.',0);
			return false;
		}
		if ($this->isGroup($NewID)) {
			$this->error('New group ['.$NewID.'] already exists.',0);
			return false;
		}
		$MyTemp=$this->GROUPS;
		$MyTemp[$NewID]=$MyTemp[$GroupID];
		unset($MyTemp[$GroupID]);
		$this->GROUPS=$MyTemp;
		$this->htWriteFile();
		return true;
	}
	
	public function addGroup($GroupID,$Users='') {
		if (empty($GroupID)) {
			return false;
		}
		if (!empty($Users)) {
			if ((gettype($Users))!='array') {
				$this->error('Invalid data type ['.$Users.'], expected array.',0);
				return false;
			}
		}
		else {
			$Users=array();
		}
		if ($this->isGroup($GroupID)) {
			$this->error('Group ['.$GroupID.'] already exists.',0);
			return false;
		}
		$MyTemp=$this->GROUPS;
		$MyTemp[$GroupID]=$Users;
		$this->GROUPS=$MyTemp;
		$this->htWriteFile();
		return true;
	}
	
	public function isUserInGroup ($UserID, $GroupID) {
		if (empty($UserID)) {
			return false;
		}
		if ($this->EMPTY) {
			return false;
		}
		if (!$this->isGroup($GroupID)) {
			return false;
		}
		$Group=$this->GROUPS[$GroupID];
		if (empty($Group)) {
			$this->error('Specified Group ['.$GroupID.']',0);
			return false;
		}
		while (list($key,$user)=each($Group)) {
			if ($UserID==$user) {
				$found=true;
			}
		}
		return $found;
  }
	
	public function getGroups() {
		$Groups=array();
		if ($this->EMPTY) {
			return false;
		}
		$MyTemp=$this->GROUPS;
		while (list($GroupID,$users)=each($MyTemp)) {
			$Groups[$GroupID]=$GroupID;
		}
		return $Groups;
	}
	
	public function getUsers() {
		$Groups=array();
		$Users=array();
		$Return=array();
		$MyTemp=$this->GROUPS;
		
		while (list($GroupID,$users)=each($MyTemp)) {
			while (list($key,$UserName)=each($users)) {
				if (!$Return[$UserName]) {
					$Return[$UserName]=$UserName;
				}
			}
		}
		
		return $Return;
	}
	
	public function getGroupsForUser($UserID) {
		if (empty($UserID)) {
			return false;
		}
		$Groups=array();
		$count=0;
		$found=true;
		$MyTemp=$this->GROUPS;
		while (list($GroupID,$users)=each($MyTemp)) {
			if ($this->isUserInGroup($UserID,$GroupID)) {
				$found=true;
				$Groups[$count]=$GroupID;
			}
			$count++;
		}
		if (!$found) {
			unset($Groups);
		}
		return $Groups;
  }
	
	public function getUsersForGroup($GroupID) {
		$Users=array();
		$count=0;
		$found=false;
		if (empty($GroupID)) {
			unset($Users);
			return $Users;
		}
		$MyTemp=$this->GROUPS;
		while (list($GroupName,$users)=each($MyTemp)) {
			if ($GroupID==$GroupName) {
				$found=true;
				$Users=$users;
			}
		}
		if (!$found) {
			unset($Users);
		}
		return $Users;
  }
	
	public function addUser($UserID,$GroupID) {
		$Groups=$this->GROUPS;
		$Users=$Groups[$GroupID];
		$count=count($Users);
		$Users[$count]=$UserID;
		$Groups[$GroupID]=$Users;
		$this->GROUPS=$Groups; 
	}
	
	public function addUserToGroup($UserID,$GroupID) {
		if (empty($UserID)) {
			$this->error('Cannot add empty userid.',0);
			return false;
		}
		if (empty($GroupID)) {
			$this->error('Cannot add user without group',0);
			return false;
		}
		if (!$this->isGroup($GroupID)) {
			$this->error('Creating new group ['.$GroupID.']',0);
			$this->addGroup($GroupID,$UserID);
			return true;
		}
		if ((gettype($UserID))!='array') {
			// Add one user to the array
			if ($this->isUserInGroup($UserID,$GroupID)) {
				$this->error('User ['.$UserID.'] is already a member
											of ['.$GroupID.']',0);
				return false;
			}
			else {
				$this->addUser($UserID,$GroupID);
			}
		}
		else {
			// Add multiple users to the array
			while (list($key,$UserName)=each($UserID)) {
				if ($this->isUserInGroup($UserName,$GroupID)) {
					$this->error('Skipping ['.$UserName.'], already a member
												of ['.$GroupID.']',0);
				}
				else {
					// add users
					$this->addUser($UserName,$GroupID);
				}
			}
		}
		//	Finished adding - save the file
		$this->htWriteFile();
		return true;
	}
	
	public function deleteUser($UserID,$GroupID) {
		$Group=$this->GROUPS[$GroupID];
		if (empty($Group)) {
			$this->error('Specified Group ['.$GroupID.'] does not exist.',0);
			return false;
		}
		while (list($key,$user)=each($Group)) {
			if ($user==$UserID) {
				unset($this->GROUPS[$GroupID][$key]);
				return true;
			}
		}
	}
	
	public function deleteUserFromGroup($UserID,$GroupID) {
		$removed=false;
		if (empty($UserID))	{
			return false;
		}
		if ($this->EMPTY)	{
			return false;
		}
		if ((gettype($UserID))=='array') {
			// Delete multiple users from array
			while(list($key,$UserName)=each($UserID)) {
				if ($this->isUserInGroup($UserName,$GroupID)) {
					if (!$this->deleteUser($UserName,$GroupID)) {
						return false;
					}
				}
				else {
					$this->error('Skipping ['.$UserName.'],
												not found in ['.$GroupID.']',0);
				}
			}
		}
		else {
			//	Delete one user from the array
			if (!$this->isUserInGroup($UserID,$GroupID)) {
				$this->error('User ['.$UserID.'] is not a member
											of group ['.$GroupID.']',0);
				return false;
			}
			else {
				$this->deleteUser($UserID,$GroupID);
			}
		}
		//	Finished deleting - save the file
		$this->htWriteFile();
		return true;
	}
	
	public function deleteGroup($GroupID) {
		$removed=false;
		if (empty($GroupID)) {
			return false;
		}
		if ($this->EMPTY) {
			return false;
		}
		$Group=$this->GROUPS[$GroupID];
		if(empty($Group)) {
			$this->error('Specified Group ['.$GroupID.'] does not exist.',0);
			return $removed;
		}
		unset($this->GROUPS[$GroupID]);
		$removed=true;
		$this->htWriteFile();
		return $removed;
	}
	
	public function htWriteFile() {
		$filename=$this->FILE;
		$tempfile=tempnam("./","fort");
		if (!copy($filename, $tempfile)) {
			$this->error('FATAL cannot create backup file
									 ['.$tempfile.'] : ['.$php_errormsg.']',1);
			exit;
		}
		$fd=fopen($tempfile,"w");
		if (empty($fd)) {
			$myerror=$php_errormsg;
			unlink($tempfile);
			$this->error('FATAL File ['.$tempfile.'] access error ['.$myerror.']',1);
			exit;
		}
		$MyTemp=$this->GROUPS;
		while (list($GroupName,$UserNames)=each($MyTemp)) {
			if (!empty($GroupName)) {
				fwrite($fd, $GroupName.':');
				if ((gettype($UserNames))!='array') {
					$UserNames=preg_replace("/([ 	]+)/","",$UserNames);
					if (!empty($UserNames)) {
						fwrite($fd,' '.$UserNames);
					}
				}
				else {
					while (list($key,$User)=each($UserNames)) {
						$User=preg_replace("/([ 	]+)/","",$User);
						if (!empty($User)) {
							fwrite($fd, ' '.$User);
						}
					}
				}
				fwrite($fd, "\n");
			}
		}
		fclose($fd);
		if (!copy($tempfile, $filename)) {
			// Stash the error, see above
			$myerror=$php_errormsg;
			unlink($tempfile);
			$this->error('FATAL cannot copy file ['.$filename.'] ['.$myerror.']',1);
			// Just in case
			exit;
		}
		unlink($tempfile);
		if (file_exists($tempfile)) {
			// Not fatal but it should be noted
			$this->error('Could not unlink ['.$tempfile.'] : ['.$php_errormsg.']',0);
		}
		$this->CONTENTS='';
		$this->GROUPS='';
		$this->initialize($filename);
		return true;
	}
}
?>
