<?php
  namespace aniDateTime;
  use DateTime,DateTimeZone;
  require_once("aniDateTime/DateTime.php");
  
  function timestamp_ms() {
    $milliseconds = null;
    
    $times = gettimeofday();
    $seconds = strval($times["sec"]);
    $milliseconds = strval(floor($times["usec"]));
    $missingleadingzeros = 6-strlen($milliseconds);
    // $milliseconds = strval(floor($times["usec"]/1000));
    // $missingleadingzeros = 3-strlen($milliseconds);
    
    if ($missingleadingzeros>0) {
      for ($i=0;$i<$missingleadingzeros;$i++)
        $milliseconds = '0'.$milliseconds;
    }
    
    return floatval($seconds.$milliseconds);
  }
  
  // default timestamp
  $aniDT=time();
  // extended timestamp: default timestamp with milliseconds and microseconds
  $aniDTms=timestamp_ms();
  // timezone
  $aniDTzone='Europe/Budapest';
  $aniDTzoneSecond='Pacific/Chatham';
  date_default_timezone_set($aniDTzone);
  // human readable date and time of the current moment in the UTF8601 format
  // http://php.net/manual/en/function.date.php
  $aniDThuman=date("c",strtotime("now"));
  //$testDate='2018-03-03T03:03:03+02:00';
  $testDate='2011-10-02T23:25:42Z';
  
  echo "<h2>The aniDateTime Test Events</h2>";
  
  echo "1) <b>PHP DateTime class demo</b> which shows the current timestamp in the ISO8601 format (http://php.net/manual/en/function.date.php):<br />";
  $date=new DateTime();
  $date->setTimezone(new DateTimeZone($aniDTzone));
  $date->setTimestamp($aniDT);
  echo "&nbsp;&nbsp;&nbsp;&nbsp;$aniDT&nbsp;==>&nbsp;{$date->format('c')}";
  echo "<br /><br />";
  
  echo "1) Array of the '<b>gettimeofday(false)</b>' function parse, default value is 'false', 'false' parameter can be left:<br />";
  echo "&nbsp;&nbsp;&nbsp;&nbsp;[sec]: <b>".gettimeofday()["sec"]."</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;==>&nbsp;timestamp, seconds since the Unix Epoch<br />".
       "&nbsp;&nbsp;&nbsp;&nbsp;[usec]: <b>".gettimeofday()["usec"]."</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;==>&nbsp;microseconds<br />".
       "&nbsp;&nbsp;&nbsp;&nbsp;[minuteswest]: <b>".gettimeofday()["minuteswest"]."</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;==>&nbsp;minutes west of Greenwich<br />".
       "&nbsp;&nbsp;&nbsp;&nbsp;[dsttime]: <b>".gettimeofday()["dsttime"]."</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;==>&nbsp;type of dst correction";
  echo "<br />";
  echo "2) The '<b>gettimeofday(true)</b>' function parse, returns with a float value:<br />";
  echo "&nbsp;&nbsp;&nbsp;&nbsp;".gettimeofday(true);
  echo "<br /><br />";
  
  // analyze the given timestamp and the microseconds
  echo "3) <b>Default timestamp</b> and the <b>extended timestamp</b> analysis:<br />";
  echo "&nbsp;&nbsp;&nbsp;&nbsp;".$aniDTms." is a ".gettype($aniDTms)." value";
  echo "<br /><br />";
  
  // default timstamp, no milliseconds, no microseconds
  $aniDT1=aniDateTime::fromTimestamp($aniDT);
  echo "4) <b>aniDateTime::fromTimestamp(timestamp_value)</b>:<br />";
  echo "&nbsp;&nbsp;&nbsp;&nbsp;".$aniDT1;
  echo "<br /><br />";
  
  $aniDT2=aniDateTime::fromMillisTimestamp($aniDTms,$aniDTzone,"float");
  echo "5) <b>aniDateTime::fromTimestamp(timestamp_value,TimeZone,\"float\")</b>:<br />";
  echo "&nbsp;&nbsp;&nbsp;&nbsp;".$aniDT2;
  echo "<br /><br />";
  
  // parse a human datetime value, e.g. 2018-01-01T12:00:00+0100
  aniDateTime::setTimestampType("int");
  echo "6) <b>aniDateTime::parse(human_date_time_value,TimeZone,false)</b>:<br />";
  echo "&nbsp;&nbsp;&nbsp;&nbsp;".$aniDThuman."<br />";
  if (date('I'))
    echo "&nbsp;&nbsp;&nbsp;&nbsp;".aniDateTime::parse($aniDThuman,Format::ISO_8601_CET_S,$aniDTzone,true);
  else
    echo "&nbsp;&nbsp;&nbsp;&nbsp;".aniDateTime::parse($aniDThuman,Format::ISO_8601_CET_W,$aniDTzone,true);
  echo aniDateTime::parse($aniDThuman,Format::getIso8601Cet(),null,true);
  echo "<br /><br />";
  echo "&nbsp;&nbsp;&nbsp;&nbsp;".$testDate."<br />";
  // echo "&nbsp;&nbsp;&nbsp;&nbsp;".aniDateTime::parse($testDate,Format::getIso8601Cet(),$aniDTzone,true);
  echo "<br /><br />";
  
  // create a datetime 
  aniDateTime::setTimestampType("int");
  echo "7) <b>aniDateTime::now(TimeZone)</b>:<br />";
  echo "&nbsp;&nbsp;&nbsp;&nbsp;".aniDateTime::now($aniDTzoneSecond);
  echo "<br /><br />";
  
  $date=new DateTime("now",new DateTimeZone($aniDTzoneSecond));
  $dateForm = $date->format('Y-m-d H:i:s');
  echo (strtotime($dateForm))." / ";
  echo $dateForm;
?>
