<?php
  namespace aniDateTime;
  
  /**
   * A collection of helpful methods for dealing with \DateTime objects.
  **/
  class Utils {
    /**
     * Gets the timestamp from a \DateTime instance. Calling getTimestamp() on a
     * \DateTime object can corrupt it. For more details see \aniDateTime\DateTime's
     * documentation, section [1.2 Timestamp corruption].
     *
     * @param \DateTime $dateTime a \DateTime object
     *
     * @return int the date time's timestamp; the number of seconds since UNIX
     * epoch
    **/
    public static function extractTimestamp(\DateTime $dateTime) {
      return intval($dateTime->format('U'));
    }
    
    /**
     * Gets the timestamp from a \DateTime instance. Calling getTimestamp() on a
     * \DateTime object can corrupt it. For more details see \aniDateTime\DateTime's
     * documentation, section [1.2 Timestamp corruption].
     *
     * @param \DateTime $dateTime a \DateTime object
     *
     * @return float the date time's timestamp; the number of seconds since UNIX
     * epoch
    **/
    public static function extractTimestampFloat(\DateTime $dateTime) {
      return floatval($dateTime->format('u'));
    }
    
    /**
     * Gets the microseconds field of a \DateTime instance. The \DateTime class
     * does not fully support microsecond precision, so even though it stores
     * said precision, there is no equivalant getter to read it back out.
     *
     * @param \DateTime $dateTime a \DateTime object
     *
     * @return int the microsecond of the second of the instant of the
     * date time
    **/
    public static function extractMicroseconds(\DateTime $dateTime) {
      return intval($dateTime->format('u'));
    }
  }
?>