<?php
  namespace aniDateTime;
  
  /**
   * Valid date formats to be used with \Bronto\Date\DateTime::toString.
  **/
  class Format {
    // timezone offset value
    private static $UTC_OFFSET = null;
    // DateTime formats
    const MYSQL_DATE_TIME = 'Y-m-d H:i:s';
    const ISO_8601_UTC    = 'Y-m-d\TH:i:s.u\Z';
    const SALESFORCE      = 'Y-m-d\TH:i:s\+0000';
    // winter
    const ISO_8601_CET_W  = 'Y-m-d\TH:i:s\+01:00';
    // summer
    const ISO_8601_CET_S  = 'Y-m-d\TH:i:s\+02:00';
    const ISO_8601        = 'Y-m-d\TH:i:sO';
    const COOKIE          = 'l, d-M-y H:i:s T';
    // Date formats
    const MYSQL_DATE      = 'Y-m-d';
    
    public static function getUtcOffset() {
      return Format::$UTC_OFFSET = date('Z')/3600;
    }
    
    public static function getIso8601Cet() {
      $retval = "";
      
      if ((Format::getUtcOffset() >= 0) && (Format::getUtcOffset() < 10))
        $retval = "+0".Format::getUtcOffset().":00";
      else if ((Format::getUtcOffset() < 0) && (Format::getUtcOffset() > -10))
        $retval = "-0".Format::getUtcOffset().":00";
      else if (Format::getUtcOffset() >= 10)
        $retval = "+".Format::getUtcOffset().":00";
      else if (Format::getUtcOffset() <= -10)
        $retval = "-".Format::getUtcOffset.":00";
      
      return 'Y-m-d\TH:i:s'."\\".$retval;
    }
  }
?>
