<?php
  require('../../aniBuilder.php');
  require('../../'.ANIBUILDER_VERSION.'/ebuilder/ebuilder.php');
	$EBUILDER=new Ebuilder();
  
  /* get a new line independent of the environment: cli, web */
  function getNewLine() {
    /* new line char */
    if (php_sapi_name() === 'cli')
      $eol="\n";
    else
     $eol="<br />";
    
    return $eol;
  }
  
  $eol=getNewLine();
  /* debug mode */
  $isDebug=false;

  /****************************************************************************/
  /*************************** MYSQL / MARIADB TEST ***************************/
  /****************************************************************************/
  
  /* connection parameters only for the test, database sql file can be found in sql subdirectory */
  $driver='mysql';
  $host='localhost';
  $port='3306';
  $username='pdotest';
  $passwd='pdotest';
  $dbname='pdotest';
  $dsn="mysql:host=".$host.";port=".$port.";dbname=".$dbname;
  
  /****************************/
  /* NEW AND MORE SIMPLE TOOL */
  /****************************/
  
  /* get instance of PDOTool class */
  $db=new PDOTool($dsn, $username, $passwd, false, false, null, null);
  /* get instance of a PDOToolManifest class from the PDOTool class */
  $manifest=$db->Manifest();
  /* set error log mode true to show error on screen or false to log in log file */
  $db->setErrorLog(true);
  
  /************************** SELECT **************************/
  $db->Connect(false);
  echo $db->getPDO($isDebug).$eol.
       $db->readMessage().$eol.$eol;

  /* query */
  echo " * Without prepare * ".$eol;
  $query="SELECT * FROM animals";
  echo  $query.$eol.$eol;

  /* get the result set */
  echo "1) WHILE and FETCH".$eol;
  $rows=$db->runQuery($query);
  if ($rows!=false) {
    echo "<table border=\"1\">";
    while ($row=$rows->fetch()) {
      echo "<tr><td>".$row['animal_id']."</td><td>".$row['animal_type']."</td><td>".$row['animal_name']."</td></tr>";
    }
    echo "</table>";
  }
  
  echo "2) FOR and FETCHALL".$eol;
  $rows=$db->runQuery($query);
  $rowsAll=$rows->fetchAll();
  if ($rows!=false) {
    echo "<table border=\"1\">";
    for ($i=0;$i<count($rowsAll);++$i) {
      echo "<tr><td>".$rowsAll[$i]["animal_id"]."</td><td>".$rowsAll[$i]["animal_type"]."</td><td>".$rowsAll[$i]["animal_name"]."</td></tr>";
    }
    echo "</table>";
  }
  echo $eol;
  
  /* query */
  echo " * With prepare * ".$eol;
  $query="SELECT * FROM animals";
  echo  $query.$eol.$eol;

  /* get the result set */
  echo "1) WHILE and FETCH".$eol;
  $rows=$db->prepareQuery($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
  $db->Execute();
  echo "<table border=\"1\">";
  if ($rows!=false) {
    while ($row=$rows->fetch()) {
      echo "<tr><td>".$row['animal_id']."</td><td>".$row['animal_type']."</td><td>".$row['animal_name']."</td></tr>";
    }
  }
  echo "</table>";
  
  echo "2) FOR and FETCHALL".$eol;
  $rows=$db->prepareQuery($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
  $db->Execute();
  if ($rows!=false) {
    $rowsAll=$rows->fetchAll();
    echo "<table border=\"1\">";
    for ($i=0;$i<count($rowsAll);++$i) {
      echo "<tr><td>".$rowsAll[$i]["animal_id"]."</td><td>".$rowsAll[$i]["animal_type"]."</td><td>".$rowsAll[$i]["animal_name"]."</td></tr>";
    }
    echo "</table>";
  }
  echo $eol;
  
  /***************/
  /* OLDER TOOLS */
  /***************/
  
  /* selected fields */
  $selectFields=array('animal_id','animal_type','animal_name');
  /* set where condition */
  $whereConditions=array('animal_type'=>'koala');
  /* select with where and bind param use select method */
  $q=$db->Select('animals',$selectFields,$whereConditions);
  print_r($db->showQuery()->Results());
  /* print array result */
  $manifest->PA($q);
  echo "<table border=\"1\">";
  /* print array result in a table */
  foreach ($q as $key => $val) {
    echo "<tr>";
    foreach ($val as $mykey => $myval) {
      echo '<td><pre>',print_r( $mykey.' '.$myval,true),'</pre></td>';
    }
    echo "</tr>";
  }
  echo "</table>";
  
  $selectFields=array('animal_id','animal_type');
  /* set where condition */
  $whereConditions=array();
  /* select with where and bind param use select method */
  $q=$db->Select('animals',$selectFields,$whereConditions, 'ORDER BY animal_id DESC LIMIT 5');
  print_r($db->showQuery()->Results());
  // print array result
  $manifest->PA($q);
  
  /************************** INSERT **************************/
  /* insert into these fields */
  $dataArray=array('animal_type'=>'ciculi','animal_name'=>'Surcee');
  /* use insert function */
  $q=$db->Insert('animals',$dataArray);
  echo "Last inserted ID: ".$db->showQuery()->getLastInsertId();
  $manifest->PA($q);
  
  /************************** UPDATE **************************/
  /* update array data */
  $dataArray=array('animal_type'=>'kutyuli');
  /* where condition array */
  //$aWhere=array('animal_id'=>24);
  $aWhere=array('animal_name'=>'Surcee');
  /* call update function */
  $q=$db->Update('animals',$dataArray,$aWhere);
  echo "Affected row(s): ".($db->showQuery()->affectedRows());
  /* print affected rows */
  $manifest->PA($q);
  
  /************************** DELETE **************************/
  /* where condition array */
  $aWhere=array('animal_type'=>'kutyuli', 'animal_name'=>'Kormoska');
  /* call delete function */
  $q=$db->Delete('animals',$aWhere);
  echo "Affected row(s): ".($db->showQuery()->affectedRows());
  /* print affected rows */
  $manifest->PA($q);
  
  /************************** RUN A QUERY **************************/
  $q=$db->pdoQuery('select * from animals limit 5;')->showQuery()->results();
  /* print array result */
  $manifest->PA($q);
  $q = $db->pdoQuery('select * from animals where (animal_type = ? OR animal_name = ?) ;',array('Kutyuli','Kormoska'))->showQuery()->results();
  /* print array result */
  $manifest->PA($q);
  
  /************************** NUMBER OF ROWS **************************/
  $q=$db->Count('animals');
  /* print affected rows */
  $manifest->PA('<b>Row count:</b> '.$q);
  
  /************************** SECOND TEST WITH USING THE ANOTHER METHODS: PTC METHODS **************************/
  echo 'N E W&nbsp;&nbsp;&nbsp;M E T H O D S<br /><br />';
  
  /************************** SELECT **************************/
  $q=$db->SelectPTC('animals','WHERE animal_type=\'koala\'','','animal_id,animal_type');
  foreach ($q as $key => $val) {
    foreach ($val as $one => $two)
      echo $two.';';
  }
  echo '<br /><br />';
  
  $q=$db->SelectPTC('animals','','ORDER BY animal_id DESC LIMIT 5','*');
  foreach ($q as $key => $val) {
    foreach ($val as $one => $two)
      echo $two.';';
    echo '<br />';
  }
  echo '<br /><br />';
  
  /************************** INSERT **************************/
  $q=array("animal_type" => "ciculiPDO",
					 "animal_name" => "Kormoska a PDO");
  $result=$db->InsertPTC('animals',$q,true);
  if ($result)
    echo 'INSERTED';
  else
    echo 'INSERT - OOPS!';
  echo '<br /><br />';
  
  /************************** UPDATE **************************/
  $q=array("animal_type" => "ciculiPDORe",
					 "animal_name" => "Kormoska a PDORe");
  $result=$db->UpdatePTC('animals',$q,"animal_id>10",'');
  if ($result)
    echo 'UPDATED';
  else
    echo 'UPDATE - OOPS!';
  echo '<br /><br />';
  
  /************************** DELETE **************************/
  $animal_id_min=15;
  $animal_id_max=25;
  $result=$db->DeletePTC('animals'," animal_id>".$animal_id_min." AND animal_id<".$animal_id_max,'');
  if ($result)
    echo 'DELETED';
  else
    echo 'DELETE - OOPS! (The WHERE condition: animal_id>'.$animal_id_min.' AND animal_id<'.$animal_id_max.')';
  
  /************************ DISCONNECT ************************/
  $db->Disconnect();
  echo "\n<br /><br />Disconnected";
?>
