<?php
  /** aniBuilderCC
   * This application is going to use the aniBuilderCC,
   * which is a component collection (CC), not a typical framework
  **/
  if (file_exists('../../../../aniBuilder/aniBuilder.php'))
    require_once('../../../../aniBuilder/aniBuilder.php');
  else
    die('The \'../../../../aniBuilder/aniBuilder.php\' file does not exists!');
  
  /* The core part of the aniBuilderCC is the eBuilder, which is a class library collection (CLC) */
  if (file_exists('../../../../aniBuilder/'.ANIBUILDER_VERSION.'/ebuilder/ebuilder.php'))
    require_once('../../../../aniBuilder/'.ANIBUILDER_VERSION.'/ebuilder/ebuilder.php');
  else
    die('The \'../../../../aniBuilder/'.ANIBUILDER_VERSION.'/ebuilder/ebuilder.php\' file does not exists!');
  /* import the anisysloG component */
  if (file_exists('../../../../aniBuilder/'.ANIBUILDER_VERSION.'/anisysloG/aniSysLog.php'))
    require_once('../../../../aniBuilder/'.ANIBUILDER_VERSION.'/anisysloG/aniSysLog.php');
  else
    die('The \'../../../../aniBuilder/'.ANIBUILDER_VERSION.'/anisysloG/aniSysLog.php\' file does not exists!');
  
  require_once('pdoHelperTest.conf.php');
  
  /* import all class of the Ebuilder CLC */
  $EBUILDER=new Ebuilder();
  /* call the anisysloG constructor */
  $aniSyslog=new AniSysLog("log/pdoTest.log",$logFileSize,$logTypeIndex);
  /* data source name  */
  $dsn="";
  /* the PDOToolHelper class object */
  $DBCONN=null;
  
  /** Check RDBMS
   * check the value of the $_POST["rdbms"] array element:
   * which RDBMS has been used
  **/
  if (isset($_POST["rdbms"])) {
    if ($_POST["rdbms"]=="MariaDB") {
      $dsn="mysql:host=".$mysqlHostname.";port=".$mysqlPort.";dbname=".$mysqlDbname;
      $DBCONN=new PDOToolHelper($dsn,$mysqlUsername,$mysqlPw,$mysqlIsMSSQL,$mysqlIsOra,$mysqlCodepage,$mysqlOraTbl,$mysqlIsPrepareTrue,$mysqlSetErrorModeFalse);
      
      /* connect to the selected RDBMS */
      $DBCONN->Connect(true);
      $dataArray=null;
      
      /* INSERT */
      if ((isset($_POST["operation"])) && ($_POST["operation"]=="Insert")) {
        if ((isset($_POST["mariadb_cat_name"])) && ($_POST["mariadb_cat_name"]!="")) {
          if ((isset($_POST["mariadb_cat_remark"])) && ($_POST["mariadb_cat_remark"]!="")) {
            $query="INSERT INTO cats(name,remark) VALUES('".$_POST["mariadb_cat_name"]."','".$_POST["mariadb_cat_remark"]."')";
            $dataArray=array('name'=>$_POST["mariadb_cat_name"],
                             'remark'=>$_POST["mariadb_cat_remark"]
                            );
          }
          else {
            $query="INSERT INTO cats(name,remark) VALUES('".$_POST["mariadb_cat_name"]."','NO_REMARK')";
            $dataArray=array('name'=>$_POST["mariadb_cat_name"],
                             'remark'=>"NO_REMARK"
                            );
          }
        }
        
        /* without prepare */
        $isFetchAll=false;
        $result=$DBCONN->ExecQuery($query,$isFetchAll);
        /* with prepare */
        $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
        $DBCONN->BeginTransaction();
        //$DBCONN->ExecuteCommandPrep($query);
        $DBCONN->InsertPrep($mysqlTable,$dataArray,false);
        $DBCONN->EndTransaction();
        
        /* LOG */
        $aniSyslog->LogInfo("MariaDB: added a new cat record with the '".$_POST["mariadb_cat_name"]."' name and the '".$_POST["mariadb_cat_remark"]."' remark.");
      }
      /* UPDATE */
      else if ($_POST["operation"]=="Update") {
        if ((isset($_POST["selectMariaDBUpdate"])) && ($_POST["selectMariaDBUpdate"]!="")) {
          if ((isset($_POST["mariadb_cat_name_new"])) && ($_POST["mariadb_cat_name_new"]!="")) {
            /* whether or not the PDO uses prepare method */
            $isPrepare=true;
            $query="UPDATE cats SET name = '".$_POST["mariadb_cat_name_new"]."' WHERE id = ".$_POST['selectMariaDBUpdate'];
            $dataArray=array('name'=>$_POST["mariadb_cat_name_new"]);
            $where="id = ".$_POST['selectMariaDBUpdate'];
            
            /* without prepare */
            if (!$isPrepare) {
              $isFetchAll=false;
              $result=$DBCONN->ExecQuery($query,$isFetchAll);
            }
            /* with prepare */
            else {
              $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
              $DBCONN->BeginTransaction();
              //$DBCONN->ExecuteCommandPrep($query);
              $DBCONN->UpdatePrep("cats",$dataArray,$where,"");
              $DBCONN->EndTransaction();
            }
            /* LOG */
            $aniSyslog->LogInfo("MariaDB: changed an old cat record with the '".$_POST["mariadb_cat_name_new"]."' name where id = '".$_POST["selectMariaDBUpdate"]."' has been found.");
          }
        }
      }
      /* DELETE */
      else if ($_POST["operation"]=="Delete") {
        if ((isset($_POST["selectMariaDBDelete"])) && ($_POST["selectMariaDBDelete"]!="")) {
          /* whether or not the PDO uses prepare method */
          $isPrepare=true;
          $query="DELETE FROM cats WHERE id = ".$_POST['selectMariaDBDelete'];
          $where="id = ".$_POST['selectMariaDBDelete'];
          
          /* without prepare */
          if (!$isPrepare) {
            $isFetchAll=false;
            $result=$DBCONN->ExecQuery($query,$isFetchAll);
          }
          /* with prepare */
          else {
            $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
            $DBCONN->BeginTransaction();
            //$DBCONN->ExecuteCommandPrep($query);
            $DBCONN->DeletePrep("cats",$where,"");
            $DBCONN->EndTransaction();
          }
          /* LOG */
          $aniSyslog->LogInfo("MariaDB: deleted an old cat record where id = '".$_POST["selectMariaDBDelete"]."' has been found.");
        }
      }
      
      /* disconnect */
      $DBCONN->Disconnect();
    }
    else if ($_POST["rdbms"]=="OracleDB") {
      $dsn="oci:dbname=".$oraDbTNS.";charset=".$oraCodepage;
      $DBCONN=new PDOToolHelper($dsn,$oraUsername,$oraPw,$oraIsMSSQL,$oraIsOra,$oraCodepage,$oracleTestTable,$oraIsPrepareTrue,$oraSetErrorModeFalse);
      
      /* connect to the selected RDBMS */
      $DBCONN->Connect(true);
      $dataArray=null;
      
      /* get the last ID */
      $query="SELECT id FROM ".$oraTable." ORDER BY id DESC FETCH FIRST 1 ROWS ONLY";
      $lastIDarray=$DBCONN->RunQuery($query,false);
      $lastIDCurr=$lastIDarray->fetch();
      $lastID=$lastIDCurr[0]+1;
      $query="";
      
      /* INSERT */
      if ((isset($_POST["operation"])) && ($_POST["operation"]=="Insert")) {
        if ((isset($_POST["oradb_cat_name"])) && ($_POST["oradb_cat_name"]!="")) {
          if ((isset($_POST["oradb_cat_remark"])) && ($_POST["oradb_cat_remark"]!="")) {
            $query="INSERT INTO ".$oraTable." VALUES(".$lastID.",'".$_POST["oradb_cat_name"]."','*".$_POST["oradb_cat_remark"]."*')";
            $dataArray=array('ID'=>$lastID,
                             'NAME'=>$_POST["oradb_cat_name"],
                             'REMARK'=>"_".$_POST["oradb_cat_remark"]."_"
                            );
          }
          else {
            $query="INSERT INTO ".$oraTable." VALUES(".$lastID.",'".$_POST["oradb_cat_name"]."','NO_REMARK')";
            $dataArray=array('ID'=>$lastID,
                             'NAME'=>$_POST["oradb_cat_name"],
                             'REMARK'=>"NO_REMARK"
                            );
          }
        }
        
        /* without prepare */
        //$isFetchAll=false;
        //$result=$DBCONN->ExecQuery($query,$isFetchAll);
        /* with prepare */
        $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
        $DBCONN->BeginTransaction();
        //$DBCONN->ExecuteCommandPrep($query);
        $DBCONN->InsertPrep(strtoupper($oraTable),$dataArray,false,strtoupper($oraUsername));
        $DBCONN->EndTransaction();
        
        /* LOG */
        $aniSyslog->LogInfo("Oracle DB: added a new cat record with the '".$_POST["oradb_cat_name"]."' name and the '".$_POST["oradb_cat_remark"]."' remark.");
      }
      /* UPDATE */
      else if ($_POST["operation"]=="Update") {
        if ((isset($_POST["selectOracleDBUpdate"])) && ($_POST["selectOracleDBUpdate"]!="")) {
          if ((isset($_POST["oradb_cat_name_new"])) && ($_POST["oradb_cat_name_new"]!="")) {
            /* whether or not the PDO uses prepare method */
            $isPrepare=true;
            $query="UPDATE ".$oraTable." SET NAME = '".$_POST["oradb_cat_name_new"]."' WHERE ID = ".$_POST['selectOracleDBUpdate'];
            $dataArray=array('NAME'=>$_POST["oradb_cat_name_new"]);
            $where="ID = ".$_POST['selectOracleDBUpdate'];
            
            /* without prepare */
            if (!$isPrepare) {
              $isFetchAll=false;
              $result=$DBCONN->ExecQuery($query,$isFetchAll);
            }
            /* with prepare */
            else {
              $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
              $DBCONN->BeginTransaction();
              //$DBCONN->ExecuteCommandPrep($query);
              $DBCONN->UpdatePrep(strtoupper($oraTable),$dataArray,$where,"",strtoupper($oraUsername));
              $DBCONN->EndTransaction();
            }
            /* LOG */
            $aniSyslog->LogInfo("Oracle DB: changed an old cat record with the '".$_POST["oradb_cat_name_new"]."' name where id = '".$_POST["selectOracleDBUpdate"]."' has been found.");
          }
        }
      }
      /* DELETE */
      else if ($_POST["operation"]=="Delete") {
        if ((isset($_POST["selectOracleDBDelete"])) && ($_POST["selectOracleDBDelete"]!="")) {
          /* whether or not the PDO uses prepare method */
          $isPrepare=true;
          $query="DELETE FROM cats WHERE ID = ".$_POST['selectOracleDBDelete'];
          $where="ID = ".$_POST['selectOracleDBDelete'];
          
          /* without prepare */
          if (!$isPrepare) {
            $isFetchAll=false;
            $result=$DBCONN->ExecQuery($query,$isFetchAll);
          }
          /* with prepare */
          else {
            $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
            $DBCONN->BeginTransaction();
            //$DBCONN->ExecuteCommandPrep($query);
            $DBCONN->DeletePrep(strtoupper($oraTable),$where,"");
            $DBCONN->EndTransaction();
          }
          /* LOG */
          $aniSyslog->LogInfo("Oracle DB: deleted an old cat record where id = '".$_POST["selectOracleDBDelete"]."' has been found.");
        }
      }
      
      /* disconnect */
      $DBCONN->Disconnect();
    }
    else if ($_POST["rdbms"]=="PostgreSQL") {
      $dsn="pgsql:host=".$pgsqlHostname.";port=".$pgsqlPort.";dbname=".$pgsqlDbname;
      $DBCONN=new PDOToolHelper($dsn,$pgsqlUsername,$pgsqlPw,$pgsqlIsMSSQL,$pgsqlIsOra,$pgsqlCodepage,$pgsqlOraTbl,$pgsqlIsPrepareTrue,$pgsqlSetErrorModeFalse);
      
      /* connect to the selected RDBMS */
      $DBCONN->Connect(true);
      $dataArray=null;
      
      /* INSERT */
      if ((isset($_POST["operation"])) && ($_POST["operation"]=="Insert")) {
        if ((isset($_POST["postgre_cat_name"])) && ($_POST["postgre_cat_name"]!="")) {
          if ((isset($_POST["postgre_cat_remark"])) && ($_POST["postgre_cat_remark"]!="")) {
            $query="INSERT INTO cats(name,remark) VALUES('".$_POST["postgre_cat_name"]."','".$_POST["postgre_cat_remark"]."')";
            $dataArray=array('name'=>$_POST["postgre_cat_name"],
                             'remark'=>$_POST["postgre_cat_remark"]
                            );
          }
          else {
            $query="INSERT INTO cats(name,remark) VALUES('".$_POST["postgre_cat_name"]."','NO_REMARK')";
            $dataArray=array('name'=>$_POST["postgre_cat_name"],
                             'remark'=>"NO_REMARK"
                            );
          }
        }
        
        /* without prepare */
        $isFetchAll=false;
        $result=$DBCONN->ExecQuery($query,$isFetchAll);
        /* with prepare */
        $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
        $DBCONN->BeginTransaction();
        $DBCONN->InsertPrep($mysqlTable,$dataArray,false);
        $DBCONN->EndTransaction();
        
        /* LOG */
        $aniSyslog->LogInfo("PostgreSQL: added a new cat record with the '".$_POST["postgre_cat_name"]."' name and the '".$_POST["postgre_cat_remark"]."' remark.");
      }
      /* UPDATE */
      else if ($_POST["operation"]=="Update") {
        if ((isset($_POST["selectPostgreSQLUpdate"])) && ($_POST["selectPostgreSQLUpdate"]!="")) {
          if ((isset($_POST["postgre_cat_name_new"])) && ($_POST["postgre_cat_name_new"]!="")) {
            /* whether or not the PDO uses prepare method */
            $isPrepare=true;
            $query="UPDATE cats SET name = '".$_POST["postgre_cat_name_new"]."' WHERE id = ".$_POST['selectPostgreSQLUpdate'];
            $dataArray=array('name'=>$_POST["postgre_cat_name_new"]);
            $where="id = ".$_POST['selectPostgreSQLUpdate'];
            
            /* without prepare */
            if (!$isPrepare) {
              $isFetchAll=false;
              $result=$DBCONN->ExecQuery($query,$isFetchAll);
            }
            /* with prepare */
            else {
              $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
              $DBCONN->BeginTransaction();
              $DBCONN->UpdatePrep("cats",$dataArray,$where,"");
              $DBCONN->EndTransaction();
            }
            /* LOG */
            $aniSyslog->LogInfo("PostgreSQL: changed an old cat record with the '".$_POST["postgre_cat_name_new"]."' name where id = '".$_POST["selectPostgreSQLUpdate"]."' has been found.");
          }
        }
      }
      /* DELETE */
      else if ($_POST["operation"]=="Delete") {
        if ((isset($_POST["selectPostgreSQLDelete"])) && ($_POST["selectPostgreSQLDelete"]!="")) {
          /* whether or not the PDO uses prepare method */
          $isPrepare=true;
          $query="DELETE FROM cats WHERE id = ".$_POST['selectPostgreSQLDelete'];
          $where="id = ".$_POST['selectPostgreSQLDelete'];
          
          /* without prepare */
          if (!$isPrepare) {
            $isFetchAll=false;
            $result=$DBCONN->ExecQuery($query,$isFetchAll);
          }
          /* with prepare */
          else {
            $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
            $DBCONN->BeginTransaction();
            $DBCONN->DeletePrep("cats",$where,"");
            $DBCONN->EndTransaction();
          }
          /* LOG */
          $aniSyslog->LogInfo("PostgreSQL: deleted an old cat record where id = '".$_POST["selectPostgreSQLDelete"]."' has been found.");
        }
      }
      
      /* disconnect */
      $DBCONN->Disconnect();
    }
    else if ($_POST["rdbms"]=="SQLite") {
      $dsn="sqlite:sqlite/garai.sqlite";
      $DBCONN=new PDOToolHelper($dsn,"","",false,false,null,null,true,false);
      
      /* connect to the selected RDBMS */
      $DBCONN->Connect(false);
      $dataArray=null;
      
      /* INSERT */
      if ((isset($_POST["operation"])) && ($_POST["operation"]=="Insert")) {
        if ((isset($_POST["sqlite_cat_name"])) && ($_POST["sqlite_cat_name"]!="")) {
          if ((isset($_POST["sqlite_cat_remark"])) && ($_POST["sqlite_cat_remark"]!="")) {
            $query="INSERT INTO cats(name,remark) VALUES('".$_POST["sqlite_cat_name"]."','".$_POST["sqlite_cat_remark"]."')";
            $dataArray=array('name'=>$_POST["sqlite_cat_name"],
                             'remark'=>$_POST["sqlite_cat_remark"]
                            );
          }
          else {
            $query="INSERT INTO cats(name,remark) VALUES('".$_POST["sqlite_cat_name"]."','NO_REMARK')";
            $dataArray=array('name'=>$_POST["sqlite_cat_name"],
                             'remark'=>"NO_REMARK"
                            );
          }
        }
        
        /* without prepare */
        $isFetchAll=false;
        $result=$DBCONN->ExecQuery($query,$isFetchAll);
        /* with prepare */
        $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
        $DBCONN->BeginTransaction();
        $DBCONN->InsertPrep($mysqlTable,$dataArray,false);
        $DBCONN->EndTransaction();
        
        /* LOG */
        $aniSyslog->LogInfo("SQLite: added a new cat record with the '".$_POST["sqlite_cat_name"]."' name and the '".$_POST["sqlite_cat_remark"]."' remark.");
      }
      /* UPDATE */
      else if ($_POST["operation"]=="Update") {
        if ((isset($_POST["selectSQLiteUpdate"])) && ($_POST["selectSQLiteUpdate"]!="")) {
          if ((isset($_POST["sqlite_cat_name_new"])) && ($_POST["sqlite_cat_name_new"]!="")) {
            /* whether or not the PDO uses prepare method */
            $isPrepare=true;
            $query="UPDATE cats SET name = '".$_POST["sqlite_cat_name_new"]."' WHERE id = ".$_POST['selectSQLiteUpdate'];
            $dataArray=array('name'=>$_POST["sqlite_cat_name_new"]);
            $where="id = ".$_POST['selectSQLiteUpdate'];
            
            /* without prepare */
            if (!$isPrepare) {
              $isFetchAll=false;
              $result=$DBCONN->ExecQuery($query,$isFetchAll);
            }
            /* with prepare */
            else {
              $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
              $DBCONN->BeginTransaction();
              $DBCONN->UpdatePrep("cats",$dataArray,$where,"");
              $DBCONN->EndTransaction();
            }
            /* LOG */
            $aniSyslog->LogInfo("SQLite: changed an old cat record with the '".$_POST["sqlite_cat_name_new"]."' name where id = '".$_POST["selectSQLiteUpdate"]."' has been found.");
          }
        }
      }
      /* DELETE */
      else if ($_POST["operation"]=="Delete") {
        if ((isset($_POST["selectSQLiteDelete"])) && ($_POST["selectSQLiteDelete"]!="")) {
          /* whether or not the PDO uses prepare method */
          $isPrepare=true;
          $query="DELETE FROM cats WHERE id = ".$_POST['selectSQLiteDelete'];
          $where="id = ".$_POST['selectSQLiteDelete'];
          
          /* without prepare */
          if (!$isPrepare) {
            $isFetchAll=false;
            $result=$DBCONN->ExecQuery($query,$isFetchAll);
          }
          /* with prepare */
          else {
            $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
            $DBCONN->BeginTransaction();
            $DBCONN->DeletePrep("cats",$where,"");
            $DBCONN->EndTransaction();
          }
          /* LOG */
          $aniSyslog->LogInfo("SQLite: deleted an old cat record where id = '".$_POST["selectSQLiteDelete"]."' has been found.");
        }
      }
      
      /* disconnect */
      $DBCONN->Disconnect();
    }
    else if ($_POST["rdbms"]=="MSSQL") {
      $dsn="sqlsrv:server=".$mssqlHostname.";Database=".$mssqlDbname;
      $DBCONN=new PDOToolHelper($dsn,$mssqlUsername,$mssqlPw,$mssqlIsMSSQL,$mssqlIsOra,$mssqlCodepage,$mssqlOraTbl,$mssqlIsPrepareTrue,$mssqlSetErrorModeFalse);
      
      /* connect to the selected RDBMS */
      $DBCONN->Connect(true);
      $dataArray=null;
      
      /* INSERT */
      if ((isset($_POST["operation"])) && ($_POST["operation"]=="Insert")) {
        if ((isset($_POST["mssql_cat_name"])) && ($_POST["mssql_cat_name"]!="")) {
          if ((isset($_POST["mssql_cat_remark"])) && ($_POST["mssql_cat_remark"]!="")) {
            $query="INSERT INTO cats(name,remark) VALUES('".$_POST["mssql_cat_name"]."','".$_POST["mssql_cat_remark"]."')";
            $dataArray=array('name'=>$_POST["mssql_cat_name"],
                             'remark'=>$_POST["mssql_cat_remark"]
                            );
          }
          else {
            $query="INSERT INTO cats(name,remark) VALUES('".$_POST["mssql_cat_name"]."','NO_REMARK')";
            $dataArray=array('name'=>$_POST["mssql_cat_name"],
                             'remark'=>"NO_REMARK"
                            );
          }
        }
        
        /* without prepare */
        $isFetchAll=false;
        $result=$DBCONN->ExecQuery($query,$isFetchAll);
        /* with prepare */
        $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
        $DBCONN->BeginTransaction();
        $DBCONN->InsertPrep($mysqlTable,$dataArray,false);
        $DBCONN->EndTransaction();
        
        /* LOG */
        $aniSyslog->LogInfo("MSSQL: added a new cat record with the '".$_POST["mssql_cat_name"]."' name and the '".$_POST["mssql_cat_remark"]."' remark.");
      }
      /* UPDATE */
      else if ($_POST["operation"]=="Update") {
        if ((isset($_POST["selectMSSQLUpdate"])) && ($_POST["selectMSSQLUpdate"]!="")) {
          if ((isset($_POST["mssql_cat_name_new"])) && ($_POST["mssql_cat_name_new"]!="")) {
            /* whether or not the PDO uses prepare method */
            $isPrepare=true;
            $query="UPDATE cats SET name = '".$_POST["mssql_cat_name_new"]."' WHERE id = ".$_POST['selectMSSQLUpdate'];
            $dataArray=array('name'=>$_POST["mssql_cat_name_new"]);
            $where="id = ".$_POST['selectMSSQLUpdate'];
            
            /* without prepare */
            if (!$isPrepare) {
              $isFetchAll=false;
              $result=$DBCONN->ExecQuery($query,$isFetchAll);
            }
            /* with prepare */
            else {
              $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
              $DBCONN->BeginTransaction();
              $DBCONN->UpdatePrep("cats",$dataArray,$where,"");
              $DBCONN->EndTransaction();
            }
            /* LOG */
            $aniSyslog->LogInfo("MSSQL: changed an old cat record with the '".$_POST["mssql_cat_name_new"]."' name where id = '".$_POST["selectMSSQLUpdate"]."' has been found.");
          }
        }
      }
      /* DELETE */
      else if ($_POST["operation"]=="Delete") {
        if ((isset($_POST["selectMSSQLDelete"])) && ($_POST["selectMSSQLDelete"]!="")) {
          /* whether or not the PDO uses prepare method */
          $isPrepare=true;
          $query="DELETE FROM cats WHERE id = ".$_POST['selectMSSQLDelete'];
          $where="id = ".$_POST['selectMSSQLDelete'];
          
          /* without prepare */
          if (!$isPrepare) {
            $isFetchAll=false;
            $result=$DBCONN->ExecQuery($query,$isFetchAll);
          }
          /* with prepare */
          else {
            $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
            $DBCONN->BeginTransaction();
            $DBCONN->DeletePrep("cats",$where,"");
            $DBCONN->EndTransaction();
          }
          /* LOG */
          $aniSyslog->LogInfo("MSSQL: deleted an old cat record where id = '".$_POST["selectMSSQLDelete"]."' has been found.");
        }
      }
      
      /* disconnect */
      $DBCONN->Disconnect();
    }
    
    /* reset the $_POST[] array and disable to create a new or update/delete any older record */
    unset($_POST);
    unset($_REQUEST);
    header("Location: {$_SERVER['HTTP_REFERER']}");
  }
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" >
<html xmlns="http://www.w3.org/1999/xhtml" lang="hu" xml:lang="hu">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <link rel="stylesheet" type="text/css" href="bootstrap/css/reset.css">
  <link rel="stylesheet" type="text/css" href="bootstrap/css/bootstrap.min.css">
  <script type="text/javascript" src="bootstrap/js/jquery-3.3.1.js" ></script>
  <script type="text/javascript" src="bootstrap/js/bootstrap.min.js" ></script>
  <title>PHP PDO test</title>
</head>

<body>
  <div class="container">
    <div class="row">
      <div class="col-md-12">
<?php
  if (php_sapi_name() === 'cli')
    echo "Operating system: ".getOS($opsys).", default locale: ".locale_get_default();
  else
    echo "Operating system: ".getOS().",  default locale: ".locale_get_default();
?>
      </div>
    </div>
    
    <div class="row">
      <div class="col-md-12">
        <!-- menu content -->
        <ul class="nav nav-tabs pagination pagination-lg" id="nav">
          <li class="previous"><a href="#">&laquo;</a></li>
          <li><a href="#mariadb" data-toggle="tab">MariaDB 10</a></li>
          <li><a href="#oracle" data-toggle="tab">Oracle 18 XE</a></li>
          <li><a href="#postgresql" data-toggle="tab">PostgreSQL 12</a></li>
          <li><a href="#sqlite" data-toggle="tab">SQLite 3</a></li>
          <li><a href="#mssql" data-toggle="tab">MSSQL Server 2019</a></li>
          <li class ="next"><a href="#">&raquo;</a></li>
        </ul>
        <!-- END: menu content -->
        
        <!-- Tab content -->
        <div class="tab-content">
          <!-- Tab pane -->
          <div class="tab-pane" id="mariadb">
            <!-- New row -->
            <div class="row">
              <div class="col-lg-7">
<?php
  $dsn="mysql:host=".$mysqlHostname.";port=".$mysqlPort.";dbname=".$mysqlDbname;
  $DBCONN=new PDOToolHelper($dsn,$mysqlUsername,$mysqlPw,$mysqlIsMSSQL,$mysqlIsOra,$mysqlCodepage,$mysqlOraTbl,$mysqlIsPrepareTrue,$mysqlSetErrorModeFalse);
  $DBCONN->Connect(true);
  echo $DBCONN->getPDO($isDebug).": ".$DBCONN->readMessage().$eol.$eol;
?>
              </div>
            </div>
            
            <!-- New row -->
            <div class="row">
              <!-- New grid: without prepare -->
              <div class="col-lg-3">
<?php
  /* query */
  echo " * Without prepare * ".$eol;
  $query="SELECT * FROM ".$mysqlTable;
  echo  $query.$eol.$eol;
  
  echo "<button type=\"button\" class=\"btn btn-basic btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#mariaDBWithoutPrepWhile\">MariaDB, WHILE, ExecQuery and FETCH</button>".$eol;
  $isFetchAll=false;
  /* get the result set */
  $rows=null;
  $rows=$DBCONN->RunQuery($query,$isFetchAll);
  if ($rows!=false) {
    $result="";
    $result.="1) MariaDB, WHILE, ExecQuery and FETCH".$eol;
    while ($row=$rows->fetch()) {
      $result.=$row['id'].";".$row['name'].";".$row['remark'].$eol;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("mariaDBWithoutPrepWhile",$result,"btn-success");
  
  echo "<button type=\"button\" class=\"btn btn-basic btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#mariaDBWithoutPrepFor\">MariaDB, FOR, ExecQuery and FETCHALL</button>".$eol;
  $isFetchAll=true;
  /* get the result set */
  $rowsAll=$DBCONN->RunQuery($query,$isFetchAll);
  if ($rows!=false) {
    $result="";
    $result.="2) MariaDB, FOR, ExecQuery and FETCHALL".$eol;
    for ($i=0;$i<count($rowsAll);++$i) {
      $result.=$rowsAll[$i]["id"].";".$rowsAll[$i]["name"].";".$rowsAll[$i]["remark"].$eol;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("mariaDBWithoutPrepFor",$result,"btn-success");
?>
              <!-- END: WITHOUT PREPARE -->
              </div>
              <!-- End: new gid without prepare -->
              
              <!-- New grid: with prepare -->
              <div class="col-lg-4">
<?php
  /* query */
  echo " * With prepare * ".$eol;
  $query="SELECT * FROM ".$mysqlTable;
  echo  $query.$eol.$eol;
  
  echo "<button type=\"button\" class=\"btn btn-primary btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#mariaDBWithPrepWhileExec\">1a) MariaDB, WHILE, ExecQueryPrep and READ RESULT SET</button>".$eol;
  $rows=null;
  $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
  $DBCONN->BeginTransaction();
  $DBCONN->ExecQueryPrep();
  $DBCONN->EndTransaction();
  $rows=$DBCONN->ResultSetPrep(PDO::FETCH_ASSOC);
  
  $i=0;
  $result="";
  $result.="1a) MariaDB, WHILE, ExecQueryPrep and READ RESULT SET".$eol;
  if ($rows!=false) {
    while ($i<count($rows)) {
      $result.=$rows[$i]['id'].";".$rows[$i]['name'].";".$rows[$i]['remark'].$eol;
      ++$i;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("mariaDBWithPrepWhileExec",$result,"btn-success");
  
  echo "<button type=\"button\" class=\"btn btn-primary btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#mariaDBWithPrepWhileSelectPrep\">1b) MariaDB, WHILE, SelectPrep and READ RESULT SET</button>".$eol;
  $rows=null;
  $isUsedOldPrep=false;
  $DBCONN->BeginTransaction();
  $rows=$DBCONN->SelectPrep("cats");
  $DBCONN->EndTransaction();
  
  if ($isUsedOldPrep) {
    $manifest=$DBCONN->Manifest();
    /* set error log mode true to show error on screen or false to log in log file */
    $DBCONN->SetErrorLog(true);
    $selectFields=array('id','name','remark');
    /* set where condition */
    $whereConditions=array();
    /* select with where and bind param use select method */
    $select=$DBCONN->SelectOPrep('cats',$selectFields,$whereConditions,'');
    /* can be shown the SQL query with syntax highlight */
    $DBCONN->ShowQuery();
    /* can be shown the result set */
    $manifest->PA($select);
  }
  
  $i=0;
  $result="";
  $result.="1b) MariaDB, WHILE, SelectPrep and READ RESULT SET".$eol;
  if (is_array($rows)) {
    while ($i<count($rows)) {
      $result.=$rows[$i]['id'].";".$rows[$i]['name'].";".$rows[$i]['remark'].$eol;
      ++$i;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("mariaDBWithPrepWhileSelectPrep",$result,"btn-success");
  
  echo "<button type=\"button\" class=\"btn btn-primary btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#mariaDBWithPrepForExec\">2a) MariaDB, FOR, ExecQueryPrep and READ RESULT SET</button>".$eol;
  $rows=null;
  $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
  $DBCONN->BeginTransaction();
  $DBCONN->ExecQueryPrep();
  $DBCONN->EndTransaction();
  $rows=$DBCONN->ResultSetPrep(PDO::FETCH_ASSOC);
  
  $result="";
  $result.="2a) MariaDB, FOR, ExecQueryPrep and READ RESULT SET".$eol;
  if ($rows!=false) {
    for ($i=0;$i<count($rows);++$i) {
      $result.=$rowsAll[$i]["id"].";".$rowsAll[$i]["name"].";".$rowsAll[$i]["remark"].$eol;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("mariaDBWithPrepForExec",$result,"btn-success");
  
  echo "<button type=\"button\" class=\"btn btn-primary btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#mariaDBWithPrepForSelectPrep\">2b) MariaDB, FOR, SelectPrep and READ RESULT SET</button>".$eol;
  $rows=null;
  $isUsedOldPrep=true;
  $DBCONN->BeginTransaction();
  $rows=$DBCONN->SelectPrep("cats");
  $DBCONN->EndTransaction();
  
  if ($isUsedOldPrep) {
    $manifest=$DBCONN->Manifest();
    /* set error log mode true to show error on screen or false to log in log file */
    $DBCONN->SetErrorLog(true);
    $selectFields=array('id','name','remark');
    /* set where condition */
    $whereConditions=array('id'=>5);
    /* select with where and bind param use select method */
    $select=$DBCONN->SelectOPrep('cats',$selectFields,$whereConditions,'');
    /* can be shown the SQL query with syntax highlight */
    $DBCONN->ShowQuery();
    /* can be shown the result set */
    $manifest->PA($select);
  }
  
  $result="";
  $result.="2b) MariaDB, FOR, SelectPrep and READ RESULT SET".$eol;
  if (is_array($rows)) {
    for ($i=0;$i<count($rows);++$i) {
      $result.=$rowsAll[$i]["id"].";".$rowsAll[$i]["name"].";".$rowsAll[$i]["remark"].$eol;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("mariaDBWithPrepForSelectPrep",$result,"btn-success");
  echo $eol;
  
  /* disconnect */
  $DBCONN->Disconnect();
	echo "Disconnected";
?>  
              <!-- END: WITH PREPARE -->
              </div>
              <!-- End: new grid with prepare -->
            </div>
            <!-- End: new row -->
            
            <div class="row">
              <div class="col-lg-12">&nbsp;</div>
            </div>
            
            <!-- New row: captions of INSERT, UPDATE, DELETE operations -->
            <div class="row">
              <div class="col-lg-4"><p><kbd>ADD A NEW CAT</kbd></p></div>
              <div class="col-lg-4"><p><kbd>UPDATE ANY CAT</kbd></p></div>
              <div class="col-lg-4"><p><kbd>DELETE ANY CAT</kbd></p></div>
            </div>
            
            <!-- New row: INSERT, UPDATE, DELETE -->
            <div class="row">
              <!-- New grid: INSERT -->
              <div class="col-lg-4">
                <!-- new form to INSERT -->
                <form role="form" id="frmMariaDBInsert" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                  <div class="row">
                    <input type="text" class="form-control" id="mariadb_cat_name" name="mariadb_cat_name" style="width: 150px; float: left;"
                           onfocus="this.value=''"
                           value="<?php if (isset($_POST["mariadb_cat_name"])) { if ($_POST["mariadb_cat_name"]=="") { echo "NEW CAT NAME"; }
                                                                    /* else { echo $_POST["mariadb_cat_name"]; } */ } ?>"
                           placeholder="<?php echo "NEW CAT"; ?>" />
                    <input type="text" class="form-control" id="mariadb_cat_remark" name="mariadb_cat_remark" style="width: 150px; float: left;"
                           onfocus="this.value=''"
                           value="<?php if (isset($_POST["mariadb_cat_remark"])) { if ($_POST["mariadb_cat_remark"]=="") { echo "NEW CAT REMARK"; }
                                                                    /* else { echo $_POST["mariadb_cat_remark"]; } */ } ?>"
                           placeholder="<?php echo "NEW CAT REMARK"; ?>" />
                    <input type="hidden" id="rdbms" name="rdbms" value="MariaDB">
                    <input type="hidden" id="operation" name="operation" value="Insert">
                    <input type="submit" class="btn btn-warning" id="submitMariaDB" name="submitMariaDB" value="Rock It!">
                  </div>
                </form>
              </div>
              <!-- End: new grid -->
              
              <!-- New grid: UPDATE -->
              <div class="col-lg-4">
                <!-- new form to UPDATE -->
                <form role="form" id="frmMariaDBUpdate" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                  <div class="row">
                    <select class="form-control" id="selectMariaDBUpdate" name="selectMariaDBUpdate" style="width: 150px; float: left;">
                      <option value="">Select a cat</option>
<?php
  if (is_array($rows)) {
    for ($i=0;$i<count($rows);++$i) {
?>
                      <option value="<?php echo $rowsAll[$i]["id"]; ?>"><?php echo $rowsAll[$i]["name"]; ?></option>
<?php
    }
  }
?>
                    </select>
                    <input type="text" class="form-control" id="mariadb_cat_name_new" name="mariadb_cat_name_new" style="width: 150px; float: left;"
                             onfocus="this.value=''"
                             value="<?php if (isset($_POST["mariadb_cat_name_new"])) { if ($_POST["mariadb_cat_name_new"]=="") { echo "NEW CAT NAME"; } /* else { echo $_POST["mariadb_cat_name_new"]; } */ } ?>"
                             placeholder="<?php echo "NEW CAT NAME"; ?>" />
                    <input type="hidden" id="rdbms" name="rdbms" value="MariaDB" />
                    <input type="hidden" id="operation" name="operation" value="Update" />
                    <input type="submit" class="btn btn-warning" id="submitMariaDB" name="submitMariaDB" value="Rock It!" />
                  </div>
                </form>
              </div>
              <!-- End: new grid -->
              
              <!-- New grid: DELETE -->
              <div class="col-lg-4">
                <!-- new form to DELETE -->
                <form role="form" id="frmMariaDBDelete" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                  <div class="row">
                    <select class="form-control" id="selectMariaDBDelete" name="selectMariaDBDelete" style="width: 150px; float: left;">
                      <option value="">Select a cat</option>
<?php
  if (is_array($rows)) {
    for ($i=0;$i<count($rows);++$i) {
?>
                      <option value="<?php echo $rowsAll[$i]["id"]; ?>"><?php echo $rowsAll[$i]["name"]; ?></option>
<?php
    }
  }
?>
                    </select>
                    <input type="hidden" id="rdbms" name="rdbms" value="MariaDB">
                    <input type="hidden" id="operation" name="operation" value="Delete">
                    <input type="submit" class="btn btn-warning" id="submitMariaDB" name="submitMariaDB" value="Rock It!">
                  </div>
                  
                </form>
              </div>
              <!-- End: new grid -->
            </div>
            <!-- End: New row: INSERT, UPDATE, DELETE -->
          </div>
          <!-- End: Tab pane -->
          
          <!-- Tab pane -->
          <div class="tab-pane" id="oracle">
            <!-- New row -->
            <div class="row">
              <div class="col-lg-7">
<?php
  $dsn="oci:dbname=".$oraDbTNS.";charset=".$oraCodepage;
  $DBCONN=new PDOToolHelper($dsn,$oraUsername,$oraPw,$oraIsMSSQL,$oraIsOra,$oraCodepage,$oracleTestTable,$oraIsPrepareTrue,$oraSetErrorModeTrue);
  $DBCONN->Connect(true);
  echo $DBCONN->getPDO($isDebug)." ".$DBCONN->readMessage().$eol.$eol;
  $query="ALTER SESSION SET current_schema = ".$oraDbname;
  $rows=$DBCONN->RunQuery($query);
?>
              </div>
            </div>
            
            <!-- New row: without prepare -->
            <div class="row">
              <!-- New grid: without prepare -->
              <div class="col-lg-3">
<?php
  /* query */
  echo " * Without prepare * ".$eol;
  $query="SELECT * FROM ".$oraTable." ORDER BY id";
  echo  $query.$eol.$eol;
  
  echo "<button type=\"button\" class=\"btn btn-basic btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#oraDBWithoutPrepWhile\">OraDB, WHILE, ExecQuery and FETCH</button>".$eol;
  $isFetchAll=false;
  /* get the result set */
  $rows=null;
  $rows=$DBCONN->RunQuery($query,$isFetchAll);
  if ($rows!=false) {
    $result="";
    $result.="1) Oracle DB, WHILE, ExecQuery and FETCH".$eol;
    while ($row=$rows->fetch()) {
      $result.=$row['ID'].";".$row['NAME'].";".$row['REMARK'].$eol;
    }
  }
  echo showModal("oraDBWithoutPrepWhile",$result,"btn-success");
  
  echo "<button type=\"button\" class=\"btn btn-basic btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#oraDBWithoutPrepFor\">OraDB, FOR, ExecQuery and FETCHALL</button>".$eol;
  $isFetchAll=true;
  /* get the result set */
  $rowsAll=$DBCONN->RunQuery($query,$isFetchAll);
  if ($rows!=false) {
    $result="";
    $result.="2) Oracle DB, FOR, ExecQuery and FETCHALL".$eol;
    for ($i=0;$i<count($rowsAll);++$i) {
      $result.=$rowsAll[$i]["ID"].";".$rowsAll[$i]["NAME"].";".$rowsAll[$i]["REMARK"].$eol;
    }
  }
  echo showModal("oraDBWithoutPrepFor",$result,"btn-success");
?>
              </div>
              <!-- End: new grid without prepare -->
              
              <!-- New grid: with prepare -->
              <div class="col-lg-4">
<?php
  /* query */
  echo " * With prepare * ".$eol;
  $query="SELECT * FROM ".$oraTable." ORDER BY id";
  echo  $query.$eol.$eol;
  
  echo "<button type=\"button\" class=\"btn btn-primary btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#oraDBWithPrepWhileExec\">1a) Oracle DB, WHILE, ExecQueryPrep and READ RESULT SET</button>".$eol;
  $rows=null;
  $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
  $DBCONN->BeginTransaction();
  $DBCONN->ExecQueryPrep();
  $DBCONN->EndTransaction();
  $rows=$DBCONN->ResultSetPrep(PDO::FETCH_ASSOC);
  
  $i=0;
  $result="";
  $result.="1a) Oracle DB, WHILE, ExecQueryPrep and READ RESULT SET".$eol;
  if ($rows!=false) {
    while ($i<count($rows)) {
      $result.=$rows[$i]['ID'].";".$rows[$i]['NAME'].";".$rows[$i]['REMARK'].$eol;
      ++$i;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("oraDBWithPrepWhileExec",$result,"btn-success");
  
  echo "<button type=\"button\" class=\"btn btn-primary btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#oraDBWithPrepWhileSelectPrep\">1b) Oracle DB, WHILE, SelectPrep and READ RESULT SET</button>".$eol;
  $rows=null;
  $isUsedOldPrep=false;
  $DBCONN->BeginTransaction();
  $rows=$DBCONN->SelectPrep("cats","ORDER BY id");
  $DBCONN->EndTransaction();
  
  if ($isUsedOldPrep) {
    $manifest=$DBCONN->Manifest();
    /* set error log mode true to show error on screen or false to log in log file */
    $DBCONN->SetErrorLog(true);
    $selectFields=array('ID','NAME','REMARK');
    /* set where condition */
    $whereConditions=array();
    /* select with where and bind param use select method */
    $select=$DBCONN->SelectOPrep('cats',$selectFields,$whereConditions,'');
    /* can be shown the SQL query with syntax highlight */
    $DBCONN->ShowQuery();
    /* can be shown the result set */
    $manifest->PA($select);
  }
  
  $i=0;
  $result="";
  $result.="1b) Oracle DB, WHILE, SelectPrep and READ RESULT SET".$eol;
  if (is_array($rows)) {
    while ($i<count($rows)) {
      $result.=$rows[$i]['ID'].";".$rows[$i]['NAME'].";".$rows[$i]['REMARK'].$eol;
      ++$i;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("oraDBWithPrepWhileSelectPrep",$result,"btn-success");
  
  echo "<button type=\"button\" class=\"btn btn-primary btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#oraDBWithPrepForExec\">2a) Oracle DB, FOR, ExecQueryPrep and READ RESULT SET</button>".$eol;
  $rows=null;
  $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
  $DBCONN->BeginTransaction();
  $DBCONN->ExecQueryPrep();
  $DBCONN->EndTransaction();
  $rows=$DBCONN->ResultSetPrep(PDO::FETCH_ASSOC);
  
  $result="";
  $result.="2a) Oracle DB, FOR, ExecQueryPrep and READ RESULT SET".$eol;
  if ($rows!=false) {
    for ($i=0;$i<count($rows);++$i) {
      $result.=$rowsAll[$i]["ID"].";".$rowsAll[$i]["NAME"].";".$rowsAll[$i]["REMARK"].$eol;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("oraDBWithPrepForExec",$result,"btn-success");
  
  echo "<button type=\"button\" class=\"btn btn-primary btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#oraDBWithPrepForSelectPrep\">2b) Oracle DB, FOR, SelectPrep and READ RESULT SET</button>".$eol;
  $rows=null;
  $isUsedOldPrep=true;
  $DBCONN->BeginTransaction();
  $rows=$DBCONN->SelectPrep("cats","ORDER BY id");
  $DBCONN->EndTransaction();
  
  if ($isUsedOldPrep) {
    $manifest=$DBCONN->Manifest();
    /* set error log mode true to show error on screen or false to log in log file */
    $DBCONN->SetErrorLog(true);
    $selectFields=array('ID','NAME','REMARK');
    /* set where condition */
    $whereConditions=array('id'=>5);
    /* select with where and bind param use select method */
    $select=$DBCONN->SelectOPrep('cats',$selectFields,$whereConditions,'');
    /* can be shown the SQL query with syntax highlight */
    $DBCONN->ShowQuery();
    /* can be shown the result set */
    $manifest->PA($select);
  }
  
  $result="";
  $result.="2b) Oracle DB, FOR, SelectPrep and READ RESULT SET".$eol;
  if (is_array($rows)) {
    for ($i=0;$i<count($rows);++$i) {
      $result.=$rowsAll[$i]["ID"].";".$rowsAll[$i]["NAME"].";".$rowsAll[$i]["REMARK"].$eol;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("oraDBWithPrepForSelectPrep",$result,"btn-success");
  
  /* disconnect */
  $DBCONN->Disconnect();
	echo "Disconnected";
?>
              </div>
              <!-- End: new grid with prepare -->
            </div>
            <!-- End: new row -->
            
            <!-- New row: captions of INSERT, UPDATE, DELETE operations -->
            <div class="row">
              <div class="col-lg-4"><p><kbd>ADD A NEW CAT</kbd></p></div>
              <div class="col-lg-4"><p><kbd>UPDATE ANY CAT</kbd></p></div>
              <div class="col-lg-4"><p><kbd>DELETE ANY CAT</kbd></p></div>
            </div>
            
            <!-- New row: INSERT, UPDATE, DELETE -->
            <div class="row">
              <!-- New grid: INSERT -->
              <div class="col-lg-4">
                <!-- new form to INSERT -->
                <form role="form" id="frmOracleDBInsert" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                  <div class="row">
                    <input type="text" class="form-control" id="oradb_cat_name" name="oradb_cat_name" style="width: 150px; float: left;"
                           onfocus="this.value=''"
                           value="<?php if (isset($_POST["oradb_cat_name"])) { if ($_POST["oradb_cat_name"]=="") { echo "NEW CAT NAME"; }
                                                                    /* else { echo $_POST["oradb_cat_name"]; } */ } ?>"
                           placeholder="<?php echo "NEW CAT"; ?>" />
                    <input type="text" class="form-control" id="oradb_cat_remark" name="oradb_cat_remark" style="width: 150px; float: left;"
                           onfocus="this.value=''"
                           value="<?php if (isset($_POST["oradb_cat_remark"])) { if ($_POST["oradb_cat_remark"]=="") { echo "NEW CAT REMARK"; }
                                                                    /* else { echo $_POST["oradb_cat_remark"]; } */ } ?>"
                           placeholder="<?php echo "NEW CAT REMARK"; ?>" />
                    <input type="hidden" id="rdbms" name="rdbms" value="OracleDB">
                    <input type="hidden" id="operation" name="operation" value="Insert">
                    <input type="submit" class="btn btn-warning" id="submitOracleDB" name="submitOracleDB" value="Rock It!">
                  </div>
                </form>
              </div>
              <!-- End: new grid -->
              
              <!-- New grid: UPDATE -->
              <div class="col-lg-4">
                <!-- new form to UPDATE -->
                <form role="form" id="frmOracleDBUpdate" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                  <div class="row">
                    <select class="form-control" id="selectOracleDBUpdate" name="selectOracleDBUpdate" style="width: 150px; float: left;">
                      <option value="">Select a cat</option>
<?php
  if (is_array($rows)) {
    for ($i=0;$i<count($rows);++$i) {
?>
                      <option value="<?php echo $rowsAll[$i]["ID"]; ?>"><?php echo $rowsAll[$i]["NAME"]; ?></option>
<?php
    }
  }
?>
                    </select>
                    <input type="text" class="form-control" id="oradb_cat_name_new" name="oradb_cat_name_new" style="width: 150px; float: left;"
                             onfocus="this.value=''"
                             value="<?php if (isset($_POST["oradb_cat_name_new"])) { if ($_POST["oradb_cat_name_new"]=="") { echo "NEW CAT NAME"; } /* else { echo $_POST["oradb_cat_name_new"]; } */ } ?>"
                             placeholder="<?php echo "NEW CAT NAME"; ?>" />
                    <input type="hidden" id="rdbms" name="rdbms" value="OracleDB" />
                    <input type="hidden" id="operation" name="operation" value="Update" />
                    <input type="submit" class="btn btn-warning" id="submitOracleDB" name="submitOracleDB" value="Rock It!" />
                  </div>
                </form>
              </div>
              <!-- End: new grid -->
              
              <!-- New grid: DELETE -->
              <div class="col-lg-4">
                <!-- new form to DELETE -->
                <form role="form" id="frmOracleDBDelete" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                  <div class="row">
                    <select class="form-control" id="selectOracleDBDelete" name="selectOracleDBDelete" style="width: 150px; float: left;">
                      <option value="">Select a cat</option>
<?php
  if (is_array($rows)) {
    for ($i=0;$i<count($rows);++$i) {
?>
                      <option value="<?php echo $rowsAll[$i]["ID"]; ?>"><?php echo $rowsAll[$i]["NAME"]; ?></option>
<?php
    }
  }
?>
                    </select>
                    <input type="hidden" id="rdbms" name="rdbms" value="OracleDB">
                    <input type="hidden" id="operation" name="operation" value="Delete">
                    <input type="submit" class="btn btn-warning" id="submitOracleDB" name="submitOracleDB" value="Rock It!">
                  </div>
                </form>
              </div>
              <!-- End: new grid -->
            </div>
            <!-- End: New row: INSERT, UPDATE, DELETE -->
          </div>
          <!-- End: Tab pane -->
          
          <!-- Tab pane -->
          <div class="tab-pane" id="postgresql">
            <!-- New row -->
            <div class="row">
              <div class="col-lg-7">
<?php
  $dsn="pgsql:host=".$pgsqlHostname.";port=".$pgsqlPort.";dbname=".$pgsqlDbname;
  $DBCONN=new PDOToolHelper($dsn,$pgsqlUsername,$pgsqlPw,$pgsqlIsMSSQL,$pgsqlIsOra,$pgsqlCodepage,$pgsqlOraTbl,$pgsqlIsPrepareTrue,$pgsqlSetErrorModeFalse);
  $DBCONN->Connect(true);
  echo $DBCONN->getPDO($isDebug)." ".$DBCONN->readMessage().$eol.$eol;
?>
              </div>
            </div>
            
            <!-- New row -->
            <div class="row">
              <!-- New grid: without prepare -->
              <div class="col-lg-3">
<?php
  /* query */
  echo " * Without prepare * ".$eol;
  $query="SELECT * FROM ".$pgsqlTable;
  echo  $query.$eol.$eol;
  
  echo "<button type=\"button\" class=\"btn btn-basic btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#postgreDBWithoutPrepWhile\">PostgreSQL, WHILE, ExecQuery and FETCH</button>".$eol;
  $isFetchAll=false;
  /* get the result set */
  $rows=null;
  $rows=$DBCONN->RunQuery($query,$isFetchAll);
  if ($rows!=false) {
    $result="";
    $result.="1) PostgreSQL, WHILE, ExecQuery and FETCH".$eol;
    while ($row=$rows->fetch()) {
      $result.=$row['id'].";".$row['name'].";".$row['remark'].$eol;
      // echo getUTF8string($row['id']).";".getUTF8string($row['name']).";".getUTF8string($row['remark']).$eol;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("postgreDBWithoutPrepWhile",$result,"btn-success");
  
  echo "<button type=\"button\" class=\"btn btn-basic btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#postgreDBWithoutPrepFor\">PostgreSQL, FOR, ExecQuery and FETCHALL</button>".$eol;
  $isFetchAll=true;
  /* get the result set */
  $rowsAll=$DBCONN->RunQuery($query,$isFetchAll);
  if ($rows!=false) {
    $result="";
    $result.="2) PostgreSQL, FOR, ExecQuery and FETCHALL".$eol;
    for ($i=0;$i<count($rowsAll);++$i) {
      $result.=$rowsAll[$i]["id"].";".$rowsAll[$i]["name"].";".$rowsAll[$i]["remark"].$eol;
      // echo getUTF8string($rowsAll[$i]["id"]).";".getUTF8string($rowsAll[$i]["name"]).";".getUTF8string($rowsAll[$i]["remark"]).$eol;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("postgreDBWithoutPrepFor",$result,"btn-success");
?>
                
              </div>
              <!-- End: new grid without prepare -->
              
              <!-- New grid: with prepare -->
              <div class="col-lg-4">
<?php
  /* query */
  echo " * With prepare * ".$eol;
  $query="SELECT * FROM ".$pgsqlTable;
  echo  $query.$eol.$eol;
  
  echo "<button type=\"button\" class=\"btn btn-primary btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#postgreDBWithPrepWhileExec\">1a) PostgreSQL, WHILE, ExecQueryPrep and READ RESULT SET</button>".$eol;
  $rows=null;
  $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
  $DBCONN->BeginTransaction();
  $DBCONN->ExecQueryPrep();
  $DBCONN->EndTransaction();
  $rows=$DBCONN->ResultSetPrep(PDO::FETCH_ASSOC);
  
  $i=0;
  $result="";
  $result.="1a) PostgreSQL, WHILE, ExecQueryPrep and READ RESULT SET".$eol;
  if ($rows!=false) {
    while ($i<count($rows)) {
      $result.=$rows[$i]['id'].";".$rows[$i]['name'].";".$rows[$i]['remark'].$eol;
      ++$i;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("postgreDBWithPrepWhileExec",$result,"btn-success");
  
  echo "<button type=\"button\" class=\"btn btn-primary btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#postgreDBWithPrepWhileSelectPrep\">1b) PostgreSQL, WHILE, SelectPrep and READ RESULT SET</button>".$eol;
  $rows=null;
  $isUsedOldPrep=false;
  $DBCONN->BeginTransaction();
  $rows=$DBCONN->SelectPrep("cats");
  $DBCONN->EndTransaction();
  
  if ($isUsedOldPrep) {
    $manifest=$DBCONN->Manifest();
    /* set error log mode true to show error on screen or false to log in log file */
    $DBCONN->SetErrorLog(true);
    $selectFields=array('id','name','remark');
    /* set where condition */
    $whereConditions=array();
    /* select with where and bind param use select method */
    $select=$DBCONN->SelectOPrep('cats',$selectFields,$whereConditions,'');
    /* can be shown the SQL query with syntax highlight */
    $DBCONN->ShowQuery();
    /* can be shown the result set */
    $manifest->PA($select);
  }
  
  $i=0;
  $result="";
  $result.="1b) PostgreSQL, WHILE, SelectPrep and READ RESULT SET".$eol;
  if (is_array($rows)) {
    while ($i<count($rows)) {
      $result.=$rows[$i]['id'].";".$rows[$i]['name'].";".$rows[$i]['remark'].$eol;
      ++$i;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("postgreDBWithPrepWhileSelectPrep",$result,"btn-success");
  
  echo "<button type=\"button\" class=\"btn btn-primary btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#postgreDBWithPrepForExec\">2a) PostgreSQL, FOR, ExecQueryPrep and READ RESULT SET</button>".$eol;
  $rows=null;
  $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
  $DBCONN->BeginTransaction();
  $DBCONN->ExecQueryPrep();
  $DBCONN->EndTransaction();
  $rows=$DBCONN->ResultSetPrep(PDO::FETCH_ASSOC);
  
  $result="";
  $result.="2a) PostgreSQL, FOR, ExecQueryPrep and READ RESULT SET".$eol;
  if ($rows!=false) {
    for ($i=0;$i<count($rows);++$i) {
      $result.=$rowsAll[$i]["id"].";".$rowsAll[$i]["name"].";".$rowsAll[$i]["remark"].$eol;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("postgreDBWithPrepForExec",$result,"btn-success");
  
  echo "<button type=\"button\" class=\"btn btn-primary btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#postgreDBWithPrepForSelectPrep\">2b) PostgreSQL, FOR, SelectPrep and READ RESULT SET</button>".$eol;
  $rows=null;
  $isUsedOldPrep=true;
  $DBCONN->BeginTransaction();
  $rows=$DBCONN->SelectPrep("cats");
  $DBCONN->EndTransaction();
  
  if ($isUsedOldPrep) {
    $manifest=$DBCONN->Manifest();
    /* set error log mode true to show error on screen or false to log in log file */
    $DBCONN->SetErrorLog(true);
    $selectFields=array('id','name','remark');
    /* set where condition */
    $whereConditions=array('id'=>5);
    /* select with where and bind param use select method */
    $select=$DBCONN->SelectOPrep('cats',$selectFields,$whereConditions,'');
    /* can be shown the SQL query with syntax highlight */
    $DBCONN->ShowQuery();
    /* can be shown the result set */
    $manifest->PA($select);
  }
  
  $result="";
  $result.="2b) PostgreSQL, FOR, SelectPrep and READ RESULT SET".$eol;
  if (is_array($rows)) {
    for ($i=0;$i<count($rows);++$i) {
      $result.=$rowsAll[$i]["id"].";".$rowsAll[$i]["name"].";".$rowsAll[$i]["remark"].$eol;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("postgreDBWithPrepForSelectPrep",$result,"btn-success");
  
  /* disconnect */
  $DBCONN->Disconnect();
	echo "Disconnected";
?>  
              <!-- END: WITH PREPARE -->
              </div>
              <!-- End: new grid with prepare -->
            </div>
            <!-- End: new row -->
            
            <!-- New row: captions of INSERT, UPDATE, DELETE operations -->
            <div class="row">
              <div class="col-lg-4"><p><kbd>ADD A NEW CAT</kbd></p></div>
              <div class="col-lg-4"><p><kbd>UPDATE ANY CAT</kbd></p></div>
              <div class="col-lg-4"><p><kbd>DELETE ANY CAT</kbd></p></div>
            </div>
            
            <!-- New row: INSERT, UPDATE, DELETE -->
            <div class="row">
            
              <!-- New grid: INSERT -->
              <div class="col-lg-4">
                <!-- new form to INSERT -->
                <form role="form" id="frmPostgreSQLInsert" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                  <div class="row">
                    <input type="text" class="form-control" id="postgre_cat_name" name="postgre_cat_name" style="width: 150px; float: left;"
                           onfocus="this.value=''"
                           value="<?php if (isset($_POST["postgre_cat_name"])) { if ($_POST["postgre_cat_name"]=="") { echo "NEW CAT NAME"; }
                                                                    /* else { echo $_POST["postgre_cat_name"]; } */ } ?>"
                           placeholder="<?php echo "NEW CAT"; ?>" />
                    <input type="text" class="form-control" id="postgre_cat_remark" name="postgre_cat_remark" style="width: 150px; float: left;"
                           onfocus="this.value=''"
                           value="<?php if (isset($_POST["postgre_cat_remark"])) { if ($_POST["postgre_cat_remark"]=="") { echo "NEW CAT REMARK"; }
                                                                    /* else { echo $_POST["postgre_cat_remark"]; } */ } ?>"
                           placeholder="<?php echo "NEW CAT REMARK"; ?>" />
                    <input type="hidden" id="rdbms" name="rdbms" value="PostgreSQL">
                    <input type="hidden" id="operation" name="operation" value="Insert">
                    <input type="submit" class="btn btn-warning" id="submitPostgreSQL" name="submitPostgreSQL" value="Rock It!">
                  </div>
                </form>
              </div>
              <!-- End: new grid -->
              
              <!-- New grid: UPDATE -->
              <div class="col-lg-4">
                <!-- new form to UPDATE -->
                <form role="form" id="frmPostgreSQLUpdate" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                  <div class="row">
                    <select class="form-control" id="selectPostgreSQLUpdate" name="selectPostgreSQLUpdate" style="width: 150px; float: left;">
                      <option value="">Select a cat</option>
<?php
  if (is_array($rows)) {
    for ($i=0;$i<count($rows);++$i) {
?>
                      <option value="<?php echo $rowsAll[$i]["id"]; ?>"><?php echo $rowsAll[$i]["name"]; ?></option>
<?php
    }
  }
?>
                    </select>
                    <input type="text" class="form-control" id="postgre_cat_name_new" name="postgre_cat_name_new" style="width: 150px; float: left;"
                             onfocus="this.value=''"
                             value="<?php if (isset($_POST["postgre_cat_name_new"])) { if ($_POST["postgre_cat_name_new"]=="") { echo "NEW CAT NAME"; } /* else { echo $_POST["postgre_cat_name_new"]; } */ } ?>"
                             placeholder="<?php echo "NEW CAT NAME"; ?>" />
                    <input type="hidden" id="rdbms" name="rdbms" value="PostgreSQL" />
                    <input type="hidden" id="operation" name="operation" value="Update" />
                    <input type="submit" class="btn btn-warning" id="submitPostgreSQL" name="submitPostgreSQL" value="Rock It!" />
                  </div>
                </form>
              </div>
              <!-- End: new grid -->
              
              <!-- New grid: DELETE -->
              <div class="col-lg-4">
                <!-- new form to DELETE -->
                <form role="form" id="frmPostgreSQLDelete" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                  <div class="row">
                    <select class="form-control" id="selectPostgreSQLDelete" name="selectPostgreSQLDelete" style="width: 150px; float: left;">
                      <option value="">Select a cat</option>
<?php
  if (is_array($rows)) {
    for ($i=0;$i<count($rows);++$i) {
?>
                      <option value="<?php echo $rowsAll[$i]["id"]; ?>"><?php echo $rowsAll[$i]["name"]; ?></option>
<?php
    }
  }
?>
                    </select>
                    <input type="hidden" id="rdbms" name="rdbms" value="PostgreSQL">
                    <input type="hidden" id="operation" name="operation" value="Delete">
                    <input type="submit" class="btn btn-warning" id="submitPostgreSQL" name="submitPostgreSQL" value="Rock It!">
                  </div>
                  
                </form>
              </div>
              <!-- End: new grid -->
            </div>
            <!-- End: New row: INSERT, UPDATE, DELETE -->
          </div>
          <!-- End: Tab pane -->
          
          <!-- Tab pane -->
          <div class="tab-pane" id="sqlite">
            <!-- New row -->
            <div class="row">
              <div class="col-lg-7">
<?php
  $dsn="sqlite:sqlite/garai.sqlite";
  $DBCONN=new PDOToolHelper($dsn,"","",false,false,null,null,true,false);
  $DBCONN->Connect(true);
  $string=str_replace(array("\n","\r","<br />"),'',$DBCONN->getPDO($isDebug))." ";
  $string.=str_replace(array("\n","\r","<br />"),'',$DBCONN->readMessage());
  echo $string.$eol.$eol;
?>
              </div>
            </div>
            
            <!-- New row -->
            <div class="row">
              <!-- New grid without prepare -->
              <div class="col-lg-3">
<?php
  /* query */
  echo " * Without prepare * ".$eol;
  $query="SELECT * FROM cats";
  echo  $query.$eol.$eol;
  
  echo "<button type=\"button\" class=\"btn btn-basic btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#sqliteDBWithoutPrepWhile\">SQLite, WHILE, ExecQuery and FETCH</button>".$eol;
  $isFetchAll=false;
  /* get the result set */
  $rows=null;
  $rows=$DBCONN->RunQuery($query,$isFetchAll);
  if ($rows!=false) {
    $result="";
    $result.="1) SQLite, WHILE, ExecQuery and FETCH".$eol;
    while ($row=$rows->fetch()) {
      $result.=$row['id'].";".$row['name'].";".$row['remark'].$eol;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("sqliteDBWithoutPrepWhile",$result,"btn-success");
  
  echo "<button type=\"button\" class=\"btn btn-basic btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#sqliteDBWithoutPrepFor\">SQLite, FOR, ExecQuery and FETCHALL</button>".$eol;
  $isFetchAll=true;
  /* get the result set */
  $rowsAll=$DBCONN->RunQuery($query,$isFetchAll);
  if ($rows!=false) {
    $result="";
    $result.="2) SQLite, FOR, ExecQuery and FETCHALL".$eol;
    for ($i=0;$i<count($rowsAll);++$i) {
      $result.=$rowsAll[$i]["id"].";".$rowsAll[$i]["name"].";".$rowsAll[$i]["remark"].$eol;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("sqliteDBWithoutPrepFor",$result,"btn-success");
?>
              </div>
              <!-- End: new grid without prepare -->
              
              <!-- New grid: with prepare -->
              <div class="col-lg-4">
<?php
  /* query */
  echo " * With prepare * ".$eol;
  $query="SELECT * FROM cats";
  echo  $query.$eol.$eol;
  
  echo "<button type=\"button\" class=\"btn btn-primary btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#sqliteDBWithPrepWhileExec\">1a) SQLite, WHILE, ExecQueryPrep and READ RESULT SET</button>".$eol;
  $rows=null;
  $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
  $DBCONN->BeginTransaction();
  $DBCONN->ExecQueryPrep();
  $DBCONN->EndTransaction();
  $rows=$DBCONN->ResultSetPrep(PDO::FETCH_ASSOC);
  
  $i=0;
  $result="";
  $result.="1a) SQLite, WHILE, ExecQueryPrep and READ RESULT SET".$eol;
  if ($rows!=false) {
    while ($i<count($rows)) {
      $result.=$rows[$i]['id'].";".$rows[$i]['name'].";".$rows[$i]['remark'].$eol;
      ++$i;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("sqliteDBWithPrepWhileExec",$result,"btn-success");
  
  echo "<button type=\"button\" class=\"btn btn-primary btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#sqliteDBWithPrepWhileSelectPrep\">1b) SQLite, WHILE, SelectPrep and READ RESULT SET</button>".$eol;
  $rows=null;
  $isUsedOldPrep=false;
  $DBCONN->BeginTransaction();
  $rows=$DBCONN->SelectPrep("cats");
  $DBCONN->EndTransaction();
  
  if ($isUsedOldPrep) {
    $manifest=$DBCONN->Manifest();
    /* set error log mode true to show error on screen or false to log in log file */
    $DBCONN->SetErrorLog(true);
    $selectFields=array('id','name','remark');
    /* set where condition */
    $whereConditions=array();
    /* select with where and bind param use select method */
    $select=$DBCONN->SelectOPrep('cats',$selectFields,$whereConditions,'');
    /* can be shown the SQL query with syntax highlight */
    $DBCONN->ShowQuery();
    /* can be shown the result set */
    $manifest->PA($select);
  }
  
  $i=0;
  $result="";
  $result.="1b) SQLite, WHILE, SelectPrep and READ RESULT SET".$eol;
  if (is_array($rows)) {
    while ($i<count($rows)) {
      $result.=$rows[$i]['id'].";".$rows[$i]['name'].";".$rows[$i]['remark'].$eol;
      ++$i;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("sqliteDBWithPrepWhileSelectPrep",$result,"btn-success");
  
  echo "<button type=\"button\" class=\"btn btn-primary btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#sqliteDBWithPrepForExec\">2a) SQLite, FOR, ExecQueryPrep and READ RESULT SET</button>".$eol;
  $rows=null;
  $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
  $DBCONN->BeginTransaction();
  $DBCONN->ExecQueryPrep();
  $DBCONN->EndTransaction();
  $rows=$DBCONN->ResultSetPrep(PDO::FETCH_ASSOC);
  
  $result="";
  $result.="2a) SQLite, FOR, ExecQueryPrep and READ RESULT SET".$eol;
  if ($rows!=false) {
    for ($i=0;$i<count($rows);++$i) {
      $result.=$rowsAll[$i]["id"].";".$rowsAll[$i]["name"].";".$rowsAll[$i]["remark"].$eol;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("sqliteDBWithPrepForExec",$result,"btn-success");
  
  echo "<button type=\"button\" class=\"btn btn-primary btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#sqliteDBWithPrepForSelectPrep\">2b) SQLite, FOR, SelectPrep and READ RESULT SET</button>".$eol;
  $rows=null;
  $isUsedOldPrep=true;
  $DBCONN->BeginTransaction();
  $rows=$DBCONN->SelectPrep("cats");
  $DBCONN->EndTransaction();
  
  if ($isUsedOldPrep) {
    $manifest=$DBCONN->Manifest();
    /* set error log mode true to show error on screen or false to log in log file */
    $DBCONN->SetErrorLog(true);
    $selectFields=array('id','name','remark');
    /* set where condition */
    $whereConditions=array('id'=>5);
    /* select with where and bind param use select method */
    $select=$DBCONN->SelectOPrep('cats',$selectFields,$whereConditions,'');
    /* can be shown the SQL query with syntax highlight */
    $DBCONN->ShowQuery();
    /* can be shown the result set */
    $manifest->PA($select);
  }
  
  $result="";
  $result.="2b) SQLite, FOR, SelectPrep and READ RESULT SET".$eol;
  if (is_array($rows)) {
    for ($i=0;$i<count($rows);++$i) {
      $result.=$rowsAll[$i]["id"].";".$rowsAll[$i]["name"].";".$rowsAll[$i]["remark"].$eol;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("sqliteDBWithPrepForSelectPrep",$result,"btn-success");
  
  /* disconnect */
  $DBCONN->Disconnect();
	echo "Disconnected";
?>  
              <!-- END: WITH PREPARE -->
              </div>
              <!-- End: new grid with prepare -->
            </div>
            <!-- End: new row -->
            
            <!-- New row: captions of INSERT, UPDATE, DELETE operations -->
            <div class="row">
              <div class="col-lg-4"><p><kbd>ADD A NEW CAT</kbd></p></div>
              <div class="col-lg-4"><p><kbd>UPDATE ANY CAT</kbd></p></div>
              <div class="col-lg-4"><p><kbd>DELETE ANY CAT</kbd></p></div>
            </div>
            
            <!-- New row: INSERT, UPDATE, DELETE -->
            <div class="row">
              <!-- New grid: INSERT -->
              <div class="col-lg-4">
                <!-- new form to INSERT -->
                <form role="form" id="frmSQLiteInsert" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                  <div class="row">
                    <input type="text" class="form-control" id="sqlite_cat_name" name="sqlite_cat_name" style="width: 150px; float: left;"
                           onfocus="this.value=''"
                           value="<?php if (isset($_POST["sqlite_cat_name"])) { if ($_POST["sqlite_cat_name"]=="") { echo "NEW CAT NAME"; }
                                                                    /* else { echo $_POST["sqlite_cat_name"]; } */ } ?>"
                           placeholder="<?php echo "NEW CAT"; ?>" />
                    <input type="text" class="form-control" id="sqlite_cat_remark" name="sqlite_cat_remark" style="width: 150px; float: left;"
                           onfocus="this.value=''"
                           value="<?php if (isset($_POST["sqlite_cat_remark"])) { if ($_POST["sqlite_cat_remark"]=="") { echo "NEW CAT REMARK"; }
                                                                    /* else { echo $_POST["sqlite_cat_remark"]; } */ } ?>"
                           placeholder="<?php echo "NEW CAT REMARK"; ?>" />
                    <input type="hidden" id="rdbms" name="rdbms" value="SQLite">
                    <input type="hidden" id="operation" name="operation" value="Insert">
                    <input type="submit" class="btn btn-warning" id="submitSQLite" name="submitSQLite" value="Rock It!">
                  </div>
                </form>
              </div>
              <!-- End: new grid -->
              
              <!-- New grid: UPDATE -->
              <div class="col-lg-4">
                <!-- new form to UPDATE -->
                <form role="form" id="frmSQLiteUpdate" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                  <div class="row">
                    <select class="form-control" id="selectSQLiteUpdate" name="selectSQLiteUpdate" style="width: 150px; float: left;">
                      <option value="">Select a cat</option>
<?php
  if (is_array($rows)) {
    for ($i=0;$i<count($rows);++$i) {
?>
                      <option value="<?php echo $rowsAll[$i]["id"]; ?>"><?php echo $rowsAll[$i]["name"]; ?></option>
<?php
    }
  }
?>
                    </select>
                    <input type="text" class="form-control" id="sqlite_cat_name_new" name="sqlite_cat_name_new" style="width: 150px; float: left;"
                             onfocus="this.value=''"
                             value="<?php if (isset($_POST["sqlite_cat_name_new"])) { if ($_POST["sqlite_cat_name_new"]=="") { echo "NEW CAT NAME"; } /* else { echo $_POST["sqlite_cat_name_new"]; } */ } ?>"
                             placeholder="<?php echo "NEW CAT NAME"; ?>" />
                    <input type="hidden" id="rdbms" name="rdbms" value="SQLite" />
                    <input type="hidden" id="operation" name="operation" value="Update" />
                    <input type="submit" class="btn btn-warning" id="submitSQLite" name="submitSQLite" value="Rock It!" />
                  </div>
                </form>
              </div>
              <!-- End: new grid -->
              
              <!-- New grid: DELETE -->
              <div class="col-lg-4">
                <!-- new form to DELETE -->
                <form role="form" id="frmSQLiteDelete" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                  <div class="row">
                    <select class="form-control" id="selectSQLiteDelete" name="selectSQLiteDelete" style="width: 150px; float: left;">
                      <option value="">Select a cat</option>
<?php
  if (is_array($rows)) {
    for ($i=0;$i<count($rows);++$i) {
?>
                      <option value="<?php echo $rowsAll[$i]["id"]; ?>"><?php echo $rowsAll[$i]["name"]; ?></option>
<?php
    }
  }
?>
                    </select>
                    <input type="hidden" id="rdbms" name="rdbms" value="SQLite">
                    <input type="hidden" id="operation" name="operation" value="Delete">
                    <input type="submit" class="btn btn-warning" id="submitSQLite" name="submitSQLite" value="Rock It!">
                  </div>
                  
                </form>
              </div>
              <!-- End: new grid -->
            </div>
            <!-- End: New row: INSERT, UPDATE, DELETE -->
          </div>
          <!-- End: Tab pane -->
          
          <!-- Tab pane -->
          <div class="tab-pane" id="mssql">
            <!-- New row -->
            <div class="row">
              <div class="col-lg-7">
<?php
  $dsn="sqlsrv:server=".$mssqlHostname.";Database=".$mssqlDbname;
  $DBCONN=new PDOToolHelper($dsn,$mssqlUsername,$mssqlPw,$mssqlIsMSSQL,$mssqlIsOra,$mssqlCodepage,$mssqlOraTbl,$mssqlIsPrepareTrue,$mssqlSetErrorModeFalse);
  $DBCONN->Connect(true);
  echo $DBCONN->getPDO($isDebug)." ".$DBCONN->readMessage().$eol.$eol;
?>
              </div>
            </div>
            
            <!-- New row -->
            <div class="row">
              <!-- New grid without prepare -->
              <div class="col-lg-3">
<?php
  /* query */
  echo " * Without prepare * ".$eol;
  $query="SELECT * FROM ".$mssqlTable;
  echo  $query.$eol.$eol;
  
  echo "<button type=\"button\" class=\"btn btn-basic btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#mssqlDBWithoutPrepWhile\">MSSQL, WHILE, ExecQuery and FETCH</button>".$eol;
  $isFetchAll=false;
  /* get the result set */
  $rows=null;
  $rows=$DBCONN->RunQuery($query,$isFetchAll);
  if ($rows!=false) {
    $result="";
    $result.="1) MSSQL, WHILE, ExecQuery and FETCH".$eol;
    while ($row=$rows->fetch()) {
      $result.=$row['id'].";".$row['name'].";".$row['remark'].$eol;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("mssqlDBWithoutPrepWhile",$result,"btn-success");
  
  echo "<button type=\"button\" class=\"btn btn-basic btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#mssqlDBWithoutPrepFor\">MSSQL, FOR, ExecQuery and FETCHALL</button>".$eol;
  $isFetchAll=true;
  /* get the result set */
  $rowsAll=$DBCONN->RunQuery($query,$isFetchAll);
  if ($rows!=false) {
    $result="";
    $result.="2) MSSQL, FOR, ExecQuery and FETCHALL".$eol;
    for ($i=0;$i<count($rowsAll);++$i) {
      $result.=$rowsAll[$i]["id"].";".$rowsAll[$i]["name"].";".$rowsAll[$i]["remark"].$eol;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("mssqlDBWithoutPrepFor",$result,"btn-success");
?>
              </div>
              <!-- End: new grid without prepare -->
              
              <!-- New grid with prepare -->
              <div class="col-lg-4">
<?php
  /* query */
  echo " * With prepare * ".$eol;
  $query="SELECT * FROM ".$mssqlTable;
  echo  $query.$eol.$eol;
  
  echo "<button type=\"button\" class=\"btn btn-primary btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#mssqlDBWithPrepWhileExec\">1a) MSSQL, WHILE, ExecQueryPrep and READ RESULT SET</button>".$eol;
  $rows=null;
  $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
  $DBCONN->BeginTransaction();
  $DBCONN->ExecQueryPrep();
  $DBCONN->EndTransaction();
  $rows=$DBCONN->ResultSetPrep(PDO::FETCH_ASSOC);
  
  $i=0;
  $result="";
  $result.="1a) MSSQL, WHILE, ExecQueryPrep and READ RESULT SET".$eol;
  if ($rows!=false) {
    while ($i<count($rows)) {
      $result.=$rows[$i]['id'].";".$rows[$i]['name'].";".$rows[$i]['remark'].$eol;
      ++$i;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("mssqlDBWithPrepWhileExec",$result,"btn-success");
  
  echo "<button type=\"button\" class=\"btn btn-primary btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#mssqlDBWithPrepWhileSelectPrep\">1b) MSSQL, WHILE, SelectPrep and READ RESULT SET</button>".$eol;
  $rows=null;
  $isUsedOldPrep=false;
  $DBCONN->BeginTransaction();
  $rows=$DBCONN->SelectPrep("cats");
  $DBCONN->EndTransaction();
  
  if ($isUsedOldPrep) {
    $manifest=$DBCONN->Manifest();
    /* set error log mode true to show error on screen or false to log in log file */
    $DBCONN->SetErrorLog(true);
    $selectFields=array('id','name','remark');
    /* set where condition */
    $whereConditions=array();
    /* select with where and bind param use select method */
    $select=$DBCONN->SelectOPrep('cats',$selectFields,$whereConditions,'');
    /* can be shown the SQL query with syntax highlight */
    $DBCONN->ShowQuery();
    /* can be shown the result set */
    $manifest->PA($select);
  }
  
  $i=0;
  $result="";
  $result.="1b) MSSQL, WHILE, SelectPrep and READ RESULT SET".$eol;
  if (is_array($rows)) {
    while ($i<count($rows)) {
      $result.=$rows[$i]['id'].";".$rows[$i]['name'].";".$rows[$i]['remark'].$eol;
      ++$i;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("mssqlDBWithPrepWhileSelectPrep",$result,"btn-success");
  
  echo "<button type=\"button\" class=\"btn btn-primary btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#mssqlDBWithPrepForExec\">2a) MSSQL, FOR, ExecQueryPrep and READ RESULT SET</button>".$eol;
  $rows=null;
  $DBCONN->Prepare($query,array(PDO::ATTR_CURSOR => PDO::CURSOR_FWDONLY));
  $DBCONN->BeginTransaction();
  $DBCONN->ExecQueryPrep();
  $DBCONN->EndTransaction();
  $rows=$DBCONN->ResultSetPrep(PDO::FETCH_ASSOC);
  
  $result="";
  $result.="2a) MSSQL, FOR, ExecQueryPrep and READ RESULT SET".$eol;
  if ($rows!=false) {
    for ($i=0;$i<count($rows);++$i) {
      $result.=$rowsAll[$i]["id"].";".$rowsAll[$i]["name"].";".$rowsAll[$i]["remark"].$eol;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("mssqlDBWithPrepForExec",$result,"btn-success");
  
  echo "<button type=\"button\" class=\"btn btn-primary btn-sm btn-block\" data-toggle=\"modal\" data-target=\"#mssqlDBWithPrepForSelectPrep\">2b) MSSQL, FOR, SelectPrep and READ RESULT SET</button>".$eol;
  $rows=null;
  $isUsedOldPrep=true;
  $DBCONN->BeginTransaction();
  $rows=$DBCONN->SelectPrep("cats");
  $DBCONN->EndTransaction();
  
  if ($isUsedOldPrep) {
    $manifest=$DBCONN->Manifest();
    /* set error log mode true to show error on screen or false to log in log file */
    $DBCONN->SetErrorLog(true);
    $selectFields=array('id','name','remark');
    /* set where condition */
    $whereConditions=array('id'=>5);
    /* select with where and bind param use select method */
    $select=$DBCONN->SelectOPrep('cats',$selectFields,$whereConditions,'');
    /* can be shown the SQL query with syntax highlight */
    $DBCONN->ShowQuery();
    /* can be shown the result set */
    $manifest->PA($select);
  }
  
  $result="";
  $result.="2b) MSSQL, FOR, SelectPrep and READ RESULT SET".$eol;
  if (is_array($rows)) {
    for ($i=0;$i<count($rows);++$i) {
      $result.=$rowsAll[$i]["id"].";".$rowsAll[$i]["name"].";".$rowsAll[$i]["remark"].$eol;
    }
  }
  else {
    if ((is_array($rows)) && (count($rows)>0)) {
      $result=explode(" ",$rows);
      ob_start();
      var_dump($result);
      $result=ob_get_clean();
    }
    else {
      $result="No record or message has been found.";
    }
  }
  echo showModal("mssqlDBWithPrepForSelectPrep",$result,"btn-success");
  
  /* disconnect */
  $DBCONN->Disconnect();
	echo "Disconnected";
?>
              </div>
              <!-- End: new grid with prepare -->
            </div>
            <!-- End: new row -->
            
            <!-- New row: captions of INSERT, UPDATE, DELETE operations -->
            <div class="row">
              <div class="col-lg-4"><p><kbd>ADD A NEW CAT</kbd></p></div>
              <div class="col-lg-4"><p><kbd>UPDATE ANY CAT</kbd></p></div>
              <div class="col-lg-4"><p><kbd>DELETE ANY CAT</kbd></p></div>
            </div>
            
            <!-- New row: INSERT, UPDATE, DELETE -->
            <div class="row">
              <!-- New grid: INSERT -->
              <div class="col-lg-4">
                <!-- new form to INSERT -->
                <form role="form" id="frmMSSQLInsert" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                  <div class="row">
                    <input type="text" class="form-control" id="mssql_cat_name" name="mssql_cat_name" style="width: 150px; float: left;"
                           onfocus="this.value=''"
                           value="<?php if (isset($_POST["mssql_cat_name"])) { if ($_POST["mssql_cat_name"]=="") { echo "NEW CAT NAME"; }
                                                                    /* else { echo $_POST["mssql_cat_name"]; } */ } ?>"
                           placeholder="<?php echo "NEW CAT"; ?>" />
                    <input type="text" class="form-control" id="mssql_cat_remark" name="mssql_cat_remark" style="width: 150px; float: left;"
                           onfocus="this.value=''"
                           value="<?php if (isset($_POST["mssql_cat_remark"])) { if ($_POST["mssql_cat_remark"]=="") { echo "NEW CAT REMARK"; }
                                                                    /* else { echo $_POST["mssql_cat_remark"]; } */ } ?>"
                           placeholder="<?php echo "NEW CAT REMARK"; ?>" />
                    <input type="hidden" id="rdbms" name="rdbms" value="MSSQL">
                    <input type="hidden" id="operation" name="operation" value="Insert">
                    <input type="submit" class="btn btn-warning" id="submitMSSQL" name="submitMSSQL" value="Rock It!">
                  </div>
                </form>
              </div>
              <!-- End: new grid -->
              
              <!-- New grid: UPDATE -->
              <div class="col-lg-4">
                <!-- new form to UPDATE -->
                <form role="form" id="frmMSSQLUpdate" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                  <div class="row">
                    <select class="form-control" id="selectMSSQLUpdate" name="selectMSSQLUpdate" style="width: 150px; float: left;">
                      <option value="">Select a cat</option>
<?php
  if (is_array($rows)) {
    for ($i=0;$i<count($rows);++$i) {
?>
                      <option value="<?php echo $rowsAll[$i]["id"]; ?>"><?php echo $rowsAll[$i]["name"]; ?></option>
<?php
    }
  }
?>
                    </select>
                    <input type="text" class="form-control" id="mssql_cat_name_new" name="mssql_cat_name_new" style="width: 150px; float: left;"
                             onfocus="this.value=''"
                             value="<?php if (isset($_POST["mssql_cat_name_new"])) { if ($_POST["mssql_cat_name_new"]=="") { echo "NEW CAT NAME"; } /* else { echo $_POST["mssql_cat_name_new"]; } */ } ?>"
                             placeholder="<?php echo "NEW CAT NAME"; ?>" />
                    <input type="hidden" id="rdbms" name="rdbms" value="MSSQL" />
                    <input type="hidden" id="operation" name="operation" value="Update" />
                    <input type="submit" class="btn btn-warning" id="submitMSSQL" name="submitMSSQL" value="Rock It!" />
                  </div>
                </form>
              </div>
              <!-- End: new grid -->
              
              <!-- New grid: DELETE -->
              <div class="col-lg-4">
                <!-- new form to DELETE -->
                <form role="form" id="frmMSSQLDelete" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
                  <div class="row">
                    <select class="form-control" id="selectMSSQLDelete" name="selectMSSQLDelete" style="width: 150px; float: left;">
                      <option value="">Select a cat</option>
<?php
  if (is_array($rows)) {
    for ($i=0;$i<count($rows);++$i) {
?>
                      <option value="<?php echo $rowsAll[$i]["id"]; ?>"><?php echo $rowsAll[$i]["name"]; ?></option>
<?php
    }
  }
?>
                    </select>
                    <input type="hidden" id="rdbms" name="rdbms" value="MSSQL">
                    <input type="hidden" id="operation" name="operation" value="Delete">
                    <input type="submit" class="btn btn-warning" id="submitMSSQL" name="submitMSSQL" value="Rock It!">
                  </div>
                  
                </form>
              </div>
              <!-- End: new grid -->
            </div>
            <!-- End: New row: INSERT, UPDATE, DELETE -->
          </div>
          <!-- End: Tab pane -->
        </div>
        <!-- End: Tab content -->
      </div>
      <!-- End: col-12-lg -->
    </div>
    <!-- End: row -->
  </div>
  <!-- End: container -->
</body>
</html>
