<?php
	/* get a new line independent of the environment: cli, web */
	function getNewLine() {
		/* new line char */
		if (php_sapi_name() === 'cli')
			$eol="\n";
		else
			$eol="<br />";
		
		return $eol;
	}
	
	/* get the currently running operating system */
	function getOS($cliOS="") {
		if (php_sapi_name() === 'cli')
			$user_agent=$cliOS;
		else
			$user_agent=$_SERVER['HTTP_USER_AGENT'];
    
    $os_platform="Unknown OS Platform";
    $os_array   = array(
                        '/windows nt 10/i'      =>  'Windows 10',
                        '/windows nt 6.3/i'     =>  'Windows 8.1',
                        '/windows nt 6.2/i'     =>  'Windows 8',
                        '/windows nt 6.1/i'     =>  'Windows 7',
                        '/windows nt 6.0/i'     =>  'Windows Vista',
                        '/windows nt 5.2/i'     =>  'Windows Server 2003/XP x64',
                        '/windows nt 5.1/i'     =>  'Windows XP',
                        '/windows xp/i'         =>  'Windows XP',
                        '/windows nt 5.0/i'     =>  'Windows 2000',
                        '/windows me/i'         =>  'Windows ME',
                        '/win98/i'              =>  'Windows 98',
                        '/win95/i'              =>  'Windows 95',
                        '/win16/i'              =>  'Windows 3.11',
                        '/macintosh|mac os x/i' =>  'Mac OS X',
                        '/mac_powerpc/i'        =>  'Mac OS 9',
                        '/linux/i'              =>  'Linux',
                        '/ubuntu/i'             =>  'Ubuntu',
                        '/iphone/i'             =>  'iPhone',
                        '/ipod/i'               =>  'iPod',
                        '/ipad/i'               =>  'iPad',
                        '/android/i'            =>  'Android',
                        '/blackberry/i'         =>  'BlackBerry',
                        '/webos/i'              =>  'Mobile'
                       );
    foreach ($os_array as $regex => $value) {
      if (preg_match($regex,$user_agent))
        $os_platform=$value;
    }
    
    return $os_platform;
	}
  
  function getUTF8string($text) {
    return utf8_encode(preg_replace_callback('/\\\\x([0-9a-fA-F]{2})/',function($a){return pack('H*',$a[1]);},$text));
  }
  
  function showModal($modalName,$modalContent,$btnStyle="btn-default") {
    $modal="";
    $modal.="<div id=\"".$modalName."\" class=\"modal fade\" role=\"dialog\" tabindex=\"-1\">";
    $modal.="<div class=\"modal-dialog\">";
    $modal.="<div class=\"modal-content\">";
    $modal.="<div class=\"modal-header\">";
    $modal.="<button type=\"button\" class=\"close\" data-dismiss=\"modal\">&times;</button>";
    $modal.="<h4 class=\"modal-title\">Result set</h4>";
    $modal.="</div>";
    $modal.="<div class=\"modal-body\">";
    $modal.=$modalContent;
    $modal.="</div>";
    $modal.="<div class=\"modal-footer\">";
    $modal.="<button type=\"button\" class=\"btn ".$btnStyle."\" data-dismiss=\"modal\">Close</button>";
    $modal.="</div>";
    $modal.="</div>";
    $modal.="</div>";
    $modal.="</div>";
    
    return $modal;
  }
?>
