<html>
<head>
	<title>Unix grep under PHP</title>
	<style>
		body  { margin: 100px; background-color: #112233; color: #FFFFFF; font-family: Arial;}
    input { background-color: #EEBB77; font-size: 100%;}
    h1    { text-align: center; color: #EEBB77; display: inline;}
    h3    { text-align: center; color: #EEBB77; display: inline;}
    xmp   { display: inline;}
	</style>
</head>

<body>
<?php
	header('Content-Type: text/html; charset=UTF-8');
	// time when this script starts 
	$startTime=time();
	require_once('../../aniBuilder.php');
  require_once('../../'.ANIBUILDER_VERSION.'/ebuilder/ebuilder.php');
	$ebuilder=new EBuilder();
	
	/**************/
	/* PARAMETERS */
	/**************/
	// define the empty file extension
	define("EMPTYEXTENSION", "EMPTY");
	// the path of the directory to be searched
	$filepath=getcwd();
	$standardfilepath='textGrepDiff';
	// search string
	//$searchFor='szilva';
	if (isset($_POST['search']))
		$searchFor=$_POST['search'];
	else
		$searchFor='';
	// search type: 'all', 'allInFile', 'phrase'
	$searchForType=array('all', 'allInFile', 'phrase');
	// case sensitive or insensitive: false, true
	$searchForCaseSensitive=false;
	// search count only: 'no', 'yes'
	$searchForCountOnly='no';
	// The extentions delimiter
	$filesWithExtentionsToBeSearchedDelim=',';
	// The extentions temporarly array
	$filesWithExtentionsToBeSearchedArray=array('log','txt','');
	// The extentions to be searched
	$filesWithExtentionsToBeSearched='';
	/*******************/
	/* END: PARAMETERS */
	/*******************/
	
	if (!is_dir($filepath))
		die('The <b>"'.$filepath.'"</b> path does not exist!');
	
	// new search class object
	$classGrepSearch=ClassGrepSearch::getInstance();
	// if file extensions have been declared then the current file extensions load into the new object
	if (count($filesWithExtentionsToBeSearchedArray)!==0)
		ClassGrepSearch::$extensions=$filesWithExtentionsToBeSearchedArray;
	else
		die('No file extension has been declared! It\'s needed to read any file content!');
	
	// check the empty file extension
	foreach ($filesWithExtentionsToBeSearchedArray as $num => $oneline) {
		if (($oneline==='&nbsp;') || ($oneline===' ') || ($oneline===''))
			$filesWithExtentionsToBeSearched.=EMPTYEXTENSION.$filesWithExtentionsToBeSearchedDelim;
		else
			$filesWithExtentionsToBeSearched.=$filesWithExtentionsToBeSearchedArray[$num].$filesWithExtentionsToBeSearchedDelim;
	}
	$filesWithExtentionsToBeSearched=rtrim($filesWithExtentionsToBeSearched,$filesWithExtentionsToBeSearchedDelim);
	
	$_POST['path']=$filepath;
	if (isset($_POST['path']))
		$scanDir=$_POST['path'];
	else
		$scanDir=$standardfilepath;
	
	// set the value for the string to be searched 
	$_POST['search']=$searchFor;
	if (isset($_POST['search']))
		$searchString=$_POST['search'];
	else
		$searchString='6b929c881c153f39ade73a5cc4942f4dd83c05e62c4b3b6e716dd92242b64e6c6eecc808d06edfced3039b6a4768af7428bc32ac4db845bd6329136816686979';
	
	if (isset($_POST['searchtype']))
		$searchType=$_POST['searchtype'];
	else
		$searchType='6b929c881c153f39ade73a5cc4942f4dd83c05e62c4b3b6e716dd92242b64e6c6eecc808d06edfced3039b6a4768af7428bc32ac4db845bd6329136816686979';
	
	$_POST['casesensitive']=$searchForCaseSensitive;
	if (isset($_POST['casesensitive']))
		$caseSensitive=$_POST['casesensitive'];
	else
		$caseSensitive=false;
	
	$_POST['searchcountonly']=$searchForCountOnly;
	if (isset($_POST['searchcountonly']))
		$searchCountOnly=$_POST['searchcountonly'];
	else
		$searchCountOnly='no';
	
	// creates an array of all the provided extentions
	$classGrepSearch->createArrayOfExtentions($filesWithExtentionsToBeSearchedDelim,$filesWithExtentionsToBeSearched);
	// Sets the search type
	$classGrepSearch->setSearchType($searchType);
	$classGrepSearch->setSearchString($searchString);
	$classGrepSearch->setScanDir($scanDir);
	$classGrepSearch->setCaseSensitive(($caseSensitive==true) ? true : false);
	$fileCounter=$classGrepSearch->readDir($scanDir);
	$htmlLines='';
	
	// print information
	$tempMessage=$classGrepSearch->lastStrReplace($filesWithExtentionsToBeSearchedDelim,"AND ",$filesWithExtentionsToBeSearched);
	$extMessage='';
	for ($i=0;$i<strlen($tempMessage);$i++) {
		if ($tempMessage[$i]===',')
			$extMessage.=$tempMessage[$i].' ';
		else
			$extMessage.=$tempMessage[$i];
	}
	$tempMessage=null;
	
	echo "<h3><center>Search files content like the Unix grep command</center></h3><hr>";
	echo "The files with <font color='red'><b>".
			 $extMessage.
			 "</b></font> extentions are scanned in <font color='red'><b>".
			 $classGrepSearch->getScanDir().
			 "</b></font> directory for the pattern/string '<font color='red'><b>".
			 $classGrepSearch->getSearchString().
			 "</b></font>' and was found it in the following <font color='red'><b> $fileCounter </b></font>file(s): <br />";
	
	$arrayOfFilenames=$classGrepSearch->getarrayOfFilenames();
	$occurance=null;
	for ($i=0,$j=0;$i<sizeof($arrayOfFilenames);$i++) {
		$fileName=str_replace($_SERVER['DOCUMENT_ROOT'],"",$arrayOfFilenames[$i]);
		$linkName=str_replace($_SERVER['DOCUMENT_ROOT'],"Z:",$arrayOfFilenames[$i]);
		$classGrepSearch->setGlobalCount(0);
		
		if ($searchCountOnly!="yes")
			$htmlLines=$classGrepSearch->createLinesFromFile($scanDir.$fileName,$classGrepSearch,'#EEBB77');
		else
			$classGrepSearch->setGlobalCount($classGrepSearch->getSearchCount($scanDir.$fileName));
		
		if ($htmlLines!="" || $searchCountOnly=="yes") {
			echo "<br /><b> ".
					(($j++)+1).
					") </b><font color='green'><b> <a href='".
					"getFileContents.php?file_path=".
					urlencode($classGrepSearch->getScanDir().$fileName).
					"' target='_blank' style='color:green;text-decoration:none'> ".
					$fileName.
					" </a> </font></b> [".$classGrepSearch->getGlobalCount(). " time(s)]";
			echo "<br />".$htmlLines;
		}
		$occurance.=$classGrepSearch->getScanDir().$fileName.'; ';
	}
	
	//calulate the time (in seconds) to execute this script
	$endTime=time();
	$totalTime=($endTime-$startTime);
	// total time taken to execute this script
	$timeTaken=$classGrepSearch->convertSecToMins($totalTime);
	$fileCountEnd=sizeof($classGrepSearch->getDirFile());
	$dirCountEnd=sizeof($classGrepSearch->getDirArray());
	echo "<hr><center><h4 >Info: Searched in <font color='#EEBB77'>".$fileCountEnd;
	if ($fileCountEnd==1)
		echo "</font> file in <font color='#EEBB77'>$dirCountEnd";
	else
		echo "</font> files in <font color='#EEBB77'>$dirCountEnd";
	if ($dirCountEnd==1)
		echo "</font> directory. ";
	else
		echo "</font> directories. ";
	echo "Total time taken: <font color='#EEBB77'> $timeTaken </font> </b></h4></center>";
?>
	 <form method="post">
		<table align="center">
			<tr>
				<td>METHOD: <select id="searchtype" name="searchtype">
					<option value="<?php echo $searchForType[0]; ?>" <?php if ((isset($_POST['searchtype'])) && $_POST['searchtype']=="$searchForType[0]") echo "selected"; ?>><?php echo $searchForType[0]; ?></option>
					<option value="<?php echo $searchForType[1]; ?>" <?php if ((isset($_POST['searchtype'])) && $_POST['searchtype']=="$searchForType[1]") echo "selected"; ?>><?php echo $searchForType[1]; ?></option>
					<option value="<?php echo $searchForType[2]; ?>" <?php if ((isset($_POST['searchtype'])) && $_POST['searchtype']=="$searchForType[2]") echo "selected"; ?>><?php echo $searchForType[2]; ?></option>
				</select>&nbsp;&nbsp;&nbsp;</td>
				<td>SEARCH: <input type="text" name="search" size="50" value="<?php echo $searchFor; ?>" />&nbsp;&nbsp;&nbsp;<input type="submit" value="Let's dance!"></td>
				<td><input type="text" name="path" size="50" hidden readonly value="<?php echo $filepath; ?>" /></td>
			</tr>
		</table>
		<table align="center" style="width: auto;">
			<tr><td></td><td></td></tr><tr><td></td><td></td></tr>
			<tr align="left" style='color: #EEBB77;'><td>Directory searched</td><td><font color="red"><b><?php echo $dirCountEnd; ?></b></font></td><td></td></tr>
			<tr align="left" style='color: #EEBB77;'><td>Files searched</td><td><font color="red"><b><?php echo $fileCountEnd ?></b></font></td><td></td></tr>
			<tr align="left" style='color: #EEBB77;'><td>Files matched</td><td><font color="red"><b><?php echo $fileCounter ?></b></font></td><td></td></tr>
			<tr align="left" style='color: #EEBB77;'><td>Occurances</td><td><font color="red"><b><?php echo $occurance ?></b></font></td></tr>
		</table>
	</form>
</body>
</html>