<HTML> 
	<HEAD> 
	    <TITLE>File_1.0 - A wrapper class to common PHP file operations

</TITLE> 
	</HEAD>

	<BODY>

<!-- INDEX BEGIN -->

<UL>

	<LI><A HREF="#NAME">NAME</A>
	<LI><A HREF="#SYNOPSIS">SYNOPSIS</A>
	<LI><A HREF="#DESCRIPTION">DESCRIPTION</A>
	<LI><A HREF="#METHODS">METHODS</A>
	<UL>

		<LI><A HREF="#new_File_">new File()</A>
		<LI><A HREF="#clear_cache_void_">clear_cache( void )</A>
		<LI><A HREF="#is_sane_fileName_must_exist_0">is_sane( $fileName,$must_exist=0,$noSymLinks=0,$noDirs=0 )</A>
		<LI><A HREF="#read_file_fileName_">read_file( $fileName )</A>
		<LI><A HREF="#strip_read_fileName_">strip_read( $fileName )</A>
		<LI><A HREF="#write_file_fileName_data_">write_file( $fileName, $data )</A>
		<LI><A HREF="#copy_file_oldFile_newFile_">copy_file( $oldFile, $newFile )</A>
		<LI><A HREF="#get_files_path_fileExt_AL">get_files( $path, $fileExt = 'ALL_FILES')</A>
		<LI><A HREF="#is_owner_fileName_uid_">is_owner( $fileName, $uid = "" )</A>
		<LI><A HREF="#is_inGroup_fileName_gid_">is_inGroup( $fileName, $gid = "" )</A>
		<LI><A HREF="#get_real_uid_">get_real_uid()</A>
		<LI><A HREF="#get_real_gid_">get_real_gid()</A>
	</UL>

	<LI><A HREF="#VARIABLES">VARIABLES</A>
	<UL>

		<LI><A HREF="#ERROR_string_">ERROR (string)</A>
		<LI><A HREF="#BUFFER_integer_default_1_">BUFFER (integer, default -1 )</A>
		<LI><A HREF="#STATCACHE_array_default_NULL_">STATCACHE ( array, default NULL )</A>
		<LI><A HREF="#TEMPDIR_string_default_tmp_">TEMPDIR ( string, default '/tmp' )</A>
		<LI><A HREF="#REALUID_integer_default_1_">REALUID ( integer, default = -1 )</A>
		<LI><A HREF="#REALGID_integer_default_1_">REALGID ( integer, default = -1 )</A>
	</UL>

	<LI><A HREF="#EXAMPLES">EXAMPLES</A>
	<LI><A HREF="#DOCUMENTATION">DOCUMENTATION</A>
	<LI><A HREF="#INSTALLATION">INSTALLATION</A>
	<LI><A HREF="#BUGS">BUGS</A>
	<LI><A HREF="#VERSION">VERSION</A>
	<LI><A HREF="#AUTHOR">AUTHOR</A>
	<LI><A HREF="#LICENSE">LICENSE</A>
	<LI><A HREF="#AVAILABILITY">AVAILABILITY</A>
	<LI><A HREF="#HISTORY">HISTORY</A>
</UL>
<!-- INDEX END -->

<HR>
<P>
<H1><A NAME="NAME">NAME

</A></H1>
File_1.0 - A wrapper class to common PHP file operations


<P>

<P>
<HR>
<H1><A NAME="SYNOPSIS">SYNOPSIS

</A></H1>
<PRE>    include(&quot;class.File.php3&quot;);
    $File = new File;
    $fakeUid = getmyuid();
</PRE>

<P>

<PRE>    $RealUid = $File-&gt;get_real_uid();
    $RealGid = $File-&gt;get_real_gid();
    echo &quot;Process claims to be UID [$fakeUid]&lt;BR&gt;\n&quot;;
    echo &quot;Process is -really- [$RealUid / $RealGid] &lt;BR&gt;\n&quot;;
</PRE>

<P>

<PRE>    $oldFile = '/path/to/old.html';
    $newFile = '/path/to/the/new.html';
    if(!$File-&gt;copy_file($oldFile,$newFile))
    {
        echo &quot;$File-&gt;ERROR &lt;BR&gt;\n&quot;;
        exit;
    }
    $contents = $File-&gt;read_file($contents);
    echo &quot;&lt;PRE&gt;$contents&lt;/PRE&gt;\n&quot;;
    unlink($newFile);
    if(!$File-&gt;write_file($newFile,$contents))
    {
        echo &quot;$File-&gt;ERROR &lt;BR&gt;\n&quot;;
        exit;
    }
    $plainText = $File-&gt;strip_read($newFile);
    echo &quot;&lt;PRE&gt;$plainText&lt;/PRE&gt;\n&quot;;
    if($File-&gt;is_owner($newFile))
    {
        echo &quot;File UID and process UID match&lt;BR&gt;\n&quot;;
    } else { echo &quot;File UID and process UID mismatch&lt;BR&gt;\n&quot;; }
</PRE>

<P>

<PRE>    if($File-&gt;is_inGroup($newFile))
    {
        echo &quot;File GID and process GID match&lt;BR&gt;\n&quot;;
    } else { echo &quot;File GID and process GID mismatch&lt;BR&gt;\n&quot;; }
</PRE>

<P>

<PRE>    exit;
</PRE>

<P>

<P>
<HR>
<H1><A NAME="DESCRIPTION">DESCRIPTION

</A></H1>
File is a wrapper class to common PHP file functions. It encapsulates error
checking during file operations, reducing the amount of code in your own
programs and avoiding redundancy. I basically got tired of re-writing these
methods over and over again in every new program I wrote, so I threw them
all into a single class.


<P>

<P>
<HR>
<H1><A NAME="METHODS">METHODS

</A></H1>
<P>
<HR>
<H2><A NAME="new_File_">new File()

</A></H2>
To create a new File object, simply call new File without arguments.


<P>

<P>
<HR>
<H2><A NAME="clear_cache_void_">clear_cache( void )

</A></H2>
Any time a <CODE>stat()</CODE> is performed on a file (usually during an
<CODE>is_owner()</CODE> or <CODE>is_inGroup()</CODE> call, the
<CODE>stat()</CODE> results are stored in the <STRONG>STATCACHE</STRONG>
variable. Calling <CODE>clear_cache()</CODE> forces the class to clear the
cached data.


<P>

<P>
<HR>
<H2><A NAME="is_sane_fileName_must_exist_0">is_sane( $fileName,$must_exist=0,$noSymLinks=0,$noDirs=0 )

</A></H2>
The <CODE>is_sane()</CODE> method performs several checks on a given file.
The checks are performed based upon the values given in the <STRONG>must_exist</STRONG>,
<STRONG>noSymLinks</STRONG>, and <STRONG>noDirs</STRONG> flags. If all three flags are set to zero, the method automatically assumes
the file is sane and returns true. If any of the flags are set to a value
other than zero, that check must be true for <CODE>is_sane()</CODE> to
return true. Here's an example;


<P>

<PRE>    $File-&gt;is_sane($fileName,1,0,0)
        // will return true if a file, directory,
        // or symlink exists with that name.
</PRE>

<P>

<PRE>    $File-&gt;is_sane($fileName,1,0,1)
        // will return true if a file or symlink with that
        // name exists, but will return false of the filename
        // is a directory or doesn't exist
</PRE>

<P>

<PRE>    $File-&gt;is_sane($fileName,1,1,1)
        // will return true if the file exists, but will return
        // false if the file is a symlink or a directory.
</PRE>

<P>

<PRE>    $File-&gt;is_sane($fileName,0,1,1)
        // will return true so long as the name does not point
        // to a symlink or a directory, regardless if a file
        // exists by that name.
</PRE>

<P>

<CODE>is_sane()</CODE> will set the <STRONG>ERROR</STRONG> variable if any of the checks fail, so be sure to check it if
<CODE>is_sane()</CODE> fails.


<P>

<P>
<HR>
<H2><A NAME="read_file_fileName_">read_file( $fileName )

</A></H2>
This method returns the raw file contents, or null on failure. It will not
read directories but symlinks are considered ``ok''.


<P>

<P>
<HR>
<H2><A NAME="strip_read_fileName_">strip_read( $fileName )

</A></H2>
This reads the file and performs an <CODE>fgetss()</CODE> on the file
contents, stripping any HTML and PHP tags from the file, leaving (for the
most part) plain text. Returns the results or null on failure.


<P>

<P>
<HR>
<H2><A NAME="write_file_fileName_data_">write_file( $fileName, $data )

</A></H2>
Saves the contents of <CODE>$data</CODE> to the file specified. Returns
true on success, false on failure. If the file pointed to by
<CODE>$fileName</CODE> already exists, the class first copies that file to
a temporary file, <STRONG>appends</STRONG> the data to the temporary file, and then tries to copy the temporary file
over the original. This is the best method I can think of to preserve the
original file's integrity should a conflict or error occur. This method
should be relatively safe from process conflicts. (more than one process
trying to write the file at one time.)


<P>

<P>
<HR>
<H2><A NAME="copy_file_oldFile_newFile_">copy_file( $oldFile, $newFile )

</A></H2>
Saves the contents of <CODE>$oldFile</CODE> as $newFile. If the old file
does not exist or if the new file already exists, this method will abort
and return false.


<P>

<P>
<HR>
<H2><A NAME="get_files_path_fileExt_AL">get_files( $path, $fileExt = 'ALL_FILES')

</A></H2>
This method will gather a listing of all files matching <STRONG>$fileExt</STRONG> and return the results as an array, where each element in the array will be
a file name. (sans path). If <STRONG>$fileExt</STRONG> is not specified, returns all files found. This method, in order to prevent
infinite loops, will <STRONG>IGNORE</STRONG> sub and parent directories. Only the directory pointed to by <STRONG>$path</STRONG> will be read. Returns null if unable to read the contents of the directory.


<P>

<P>
<HR>
<H2><A NAME="is_owner_fileName_uid_">is_owner( $fileName, $uid = "" )

</A></H2>
Given a user ID, will return true if that user id owns the specified file.
If UID is not specified, the method assumes itself. (ie, it will check to
see if the PHP process UID owns the filename) This is very usefull, since
the built in PHP methods <CODE>is_readable()</CODE> and
<CODE>is_writeable()</CODE> routinely lie about read and write
capabilities. (They return true if the read and write bits on the file are
set, <STRONG>regardless</STRONG> of whether the process can actually read or write to those files. (Which
make <CODE>is_readble()</CODE> and <CODE>is_writeable()</CODE> completely
useless IMHO). If the UID is specified, will return true of that UID is the
owner of the specified file, false otherwise. See also
<CODE>get_real_uid()</CODE> since this method uses that.


<P>

<P>
<HR>
<H2><A NAME="is_inGroup_fileName_gid_">is_inGroup( $fileName, $gid = "" )

</A></H2>
Identical to <CODE>is_owner()</CODE> except that it works on the GID
instead of the UID.


<P>

<P>
<HR>
<H2><A NAME="get_real_uid_">get_real_uid()

</A></H2>
This method will return the user ID of the PHP process itself. It does
<STRONG>not</STRONG> use the built in php method <CODE>getmyuid(),</CODE> which is 99% of the
time a lieing sack of puss that is best ignored. This method determines
it's user id by creating a temporary file, and then performing a
<CODE>stat()</CODE> check on the file. The results of this method are
cached by the class for more efficient results. (So if you call this method
right after a <CODE>new(),</CODE> the class will perform a teensy-bit
faster)


<P>

<P>
<HR>
<H2><A NAME="get_real_gid_">get_real_gid()

</A></H2>
Identical (literally) to a <CODE>get_real_uid()</CODE> call. It returns the
group ID of the process that's running. I cheated here. When
<CODE>get_real_uid()</CODE> is called, it sets two global variables <STRONG>REALUID</STRONG> and <STRONG>REALGID</STRONG>. You can save yourself a function call here. If
<CODE>get_real_uid()</CODE> has already been called in your program, just
grab the contents of <STRONG>REALGID</STRONG> instead of calling this method.


<P>

<P>
<HR>
<H1><A NAME="VARIABLES">VARIABLES

</A></H1>
<P>
<HR>
<H2><A NAME="ERROR_string_">ERROR (string)

</A></H2>
This variable contains the text of the last test ERROR encountered. If a
test fails, the text description of why the test failed can be retrieved by
grabbing this variable.


<P>

<P>
<HR>
<H2><A NAME="BUFFER_integer_default_1_">BUFFER (integer, default -1 )

</A></H2>
This is the BUFFER used when performing an <CODE>strip_read()</CODE> call.
It defaults to the size of the file unless you override it. For the most
part you shouldn't need to change the buffer size.


<P>

<P>
<HR>
<H2><A NAME="STATCACHE_array_default_NULL_">STATCACHE ( array, default NULL )

</A></H2>
After any call to <CODE>is_owner()</CODE> or <CODE>is_inGroup(),</CODE>
this variable will contain the returned <CODE>stat()</CODE> array. You can
clear this variable on the fly by calling the <CODE>clear_cache()</CODE>
method.


<P>

<P>
<HR>
<H2><A NAME="TEMPDIR_string_default_tmp_">TEMPDIR ( string, default '/tmp' )

</A></H2>
The temporary directory used by the class when making temp files. The class
needs to be able to create temporary files. By default it will create those
files in '/tmp' unless you specify otherwise by overriding this variable,
for example;


<P>

<PRE>    include(&quot;class.File.php3&quot;);
    $File = new File;
    $File-&gt;TEMPDIR = 'C:\WINDOWS\TEMP';
</PRE>

<P>

<P>
<HR>
<H2><A NAME="REALUID_integer_default_1_">REALUID ( integer, default = -1 )

</A></H2>
This variable will contain the cached results of a
<CODE>get_real_uid()</CODE> or <CODE>get_real_gid()</CODE> call. The UID of
the process is stored in this variable.


<P>

<P>
<HR>
<H2><A NAME="REALGID_integer_default_1_">REALGID ( integer, default = -1 )

</A></H2>
Identical to REALUID, except of course this is the group ID of the current
process.


<P>

<P>
<HR>
<H1><A NAME="EXAMPLES">EXAMPLES

</A></H1>
see SYNOPSIS


<P>

<P>
<HR>
<H1><A NAME="DOCUMENTATION">DOCUMENTATION

</A></H1>
This is it.


<P>

<P>
<HR>
<H1><A NAME="INSTALLATION">INSTALLATION

</A></H1>
Copy the class file to the location specified in your PHP3.INI file.
Failing that, use the full path to the class file's location in your
<CODE>include()</CODE> directive.


<P>

<P>
<HR>
<H1><A NAME="BUGS">BUGS

</A></H1>
No bugs that I know if, I've been using this class in my own programs for
several months.


<P>

<P>
<HR>
<H1><A NAME="VERSION">VERSION

</A></H1>
Version 1.0 April 03, 1999 CDI, <A
HREF="MAILTO:cdi@thewebmasters.net">cdi@thewebmasters.net</A>


<P>

<P>
<HR>
<H1><A NAME="AUTHOR">AUTHOR

</A></H1>
Copyright (c) 1999, CDI - <A
HREF="MAILTO:cdi@thewebmasters.net.">cdi@thewebmasters.net.</A> All Rights
Reserved.


<P>

<P>
<HR>
<H1><A NAME="LICENSE">LICENSE

</A></H1>
This program is free software; you can redistribute it and/or modify it
under the GNU General Artistic License, with the following stipulations;


<P>

Changes or modifications must retain these Copyright statements. Changes or
modifications <STRONG>must</STRONG> be submitted to the AUTHOR, <A
HREF="MAILTO:cdi@thewebmasters.net.">cdi@thewebmasters.net.</A>


<P>

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE. See the Artistic License for more
details. This software is distributed <STRONG>AS-IS</STRONG>.


<P>

<P>
<HR>
<H1><A NAME="AVAILABILITY">AVAILABILITY

</A></H1>
<A
HREF="http://www.thewebmasters.net/php/">http://www.thewebmasters.net/php/</A>



<P>

<P>
<HR>
<H1><A NAME="HISTORY">HISTORY

</A></H1>
Version 1.0, initial public release


<P>

</DL>
    </BODY>

    </HTML>
