<?php
class StringTool {
  // original string from a client
	private $strMyString;
	// client string code page of any string
	private $CodeOrig;
	// default UTF-8 code page of any string
	private $CodeUTF8;
  
  // $strRemoteString: original string
  // $codeString: original code page
  // these parameters have to give the developer and/or the user
  // to the constructor when a new object creates
  public function __construct($strRemoteString, $codeString) {
		// set current string
		$this->strMyString=$strRemoteString;
		// set UTF-8 encoding
		$this->CodeUTF8='UTF-8';
		// set client encoding
		$this->CodeOrig=$codeString;
	}
	
	public function __destruct() {
		$this->strMyString=null;
		$this->CodeOrig		=null;
		$this->CodeUTF8		=null;
	}
	
  // convert any character or string from any code page to another one
  public function IConverter($codeFrom,$codeTo,$strWhat) {
    return (iconv($codeFrom,$codeTo,$strWhat));
  }
  
  // try to convert any string into UTF-8
  public function getUTF8string($text) {
    return utf8_encode(preg_replace_callback('/\\\\x([0-9a-fA-F]{2})/',function($a){return pack('H*',$a[1]);},$text));
  }
  
	// reverese any string character by character
  public function ReverseString() {
		// temporarly string: it is converted
		// from UTF-8 to original character code (for ex. ISO-8859-2)
		$strTemp='';
		// one character: it is converted
		// from original character code (for ex. ISO-8859-2) to UTF-8
		$mychar='';
		// reversed string
		$result='';
		
		// convert the string from utf-8 to original code
    $strTemp=$this->IConverter($this->CodeUTF8,
															 $this->CodeOrig,
															 $this->strMyString);
		// convert every character from original to utf-8 code
		for ($i=strlen($strTemp)-1; $i>=0; $i--) {
      $mychar=$this->IConverter($this->CodeOrig,
																$this->CodeUTF8,
																$strTemp[$i]);
			$result.=$mychar;
		}
		
		return $result;
	}
	
	// get back any character from any string
  public function GetAnyCharacter($iNumber,$myString) {
		// temporarly string: it is converted
		// from UTF-8 to original character code (for ex. ISO-8859-2)
		$strTemp='';
		// one character: it is converted
		// from original character code (for ex. ISO-8859-2) to UTF-8
		$mychar='';
		
		// convert the string from utf-8 to original code
		$strTemp=$this->IConverter($this->CodeUTF8,
															 $this->CodeOrig,
															 $myString);
		// if the number of character is not higher than length of the string
		if ($iNumber<=strlen($strTemp)-1)
			// convert this character
			// from original character code (for ex. ISO-8859-2) to UTF-8
      $mychar=$this->IConverter($this->CodeOrig,
																$this->CodeUTF8,
																$strTemp[$iNumber]);
		else
			$mychar='UNKNOWN CHARACTER';
			
		return $mychar;
	}
  
  // add backslash in a string before characters
  // that need to be quoted in database queries etc.
  public function AddBackslash() {
    return addslashes($this->strMyString);
  }
  
  // remove backslash in a string before characters
  // that need to be quoted in database queries etc.
  public function RemoveBackslash() {
    return stripslashes($this->strMyString);
  }
}
?>