<?php
  /**
   * procReadBlog: read and modify any blog
   *
   * @property: $user: who is th current user
  **/
  function procReadBlog($user) {
    require_once('_include/aniPagination.php');
		require('_lang/'.PROG_LANG.'.php');
    global $database, $form, $session;
		
    // current connection is MySQLi
		if (API==='MySQLi') {
      if (!$database->getCurrentConnection()) {
				echo $database->getCurrentInterface();
				die('Cannot connect to the database!');
			}
			
			/* get the current page mode: according or pagination */
			if (WINDOW_MODE=='ACC') {
				// current SQL command
				if ($user == 'admin')
					$q = "SELECT * FROM ".TBL_BLOGS." WHERE active = '1' ORDER BY id DESC";
				else
					$q = "SELECT * FROM ".TBL_BLOGS." WHERE active = '1' AND username = '$user' ORDER BY id DESC";
				
				// current result
				$result = $database->query($q);
				// how many rows can be found in the current result table
				$num_rows = $database->numRows($result);
				
				// if there is no result
				if ($num_rows == 0) {
				  echo $LNG_BLOG_NO_RECORD;
				  exit;
				}
			}
			else if (WINDOW_MODE=='PAG') {
				// instantiate the pagination object
				$pagination=new AniPagination();
				// set position of the next/previous page links
				$pagination->Navigation_Position(isset($_GET['navigation_position']) && in_array($_GET['navigation_position'],
																																												 array('left', 'right')) ? $_GET['navigation_position'] : 'outside');
				
				// how many rows can be found in the table after running the current SQL command
				if ($user == 'admin') {
					if (PAG_ORDER=='ASC') {
						if (MAX_BLOG_HIT!='') {
							$q="SELECT COUNT(*) AS 'rows' FROM (SELECT * FROM ".TBL_BLOGS." ORDER BY id DESC LIMIT ".MAX_BLOG_HIT.") ".TBL_BLOGS." WHERE active = '1'";
						}
						else {
							$q="SELECT COUNT(*) AS 'rows' FROM ".TBL_BLOGS." WHERE active = '1'";
						}
					}
					else if (PAG_ORDER=='DSC') {
						if (MAX_BLOG_HIT!='') {
							$q="SELECT COUNT(*) AS 'rows' FROM (SELECT * FROM ".TBL_BLOGS." ORDER BY id LIMIT ".MAX_BLOG_HIT.") ".TBL_BLOGS." WHERE active = '1'";
						}
						else {
							$q="SELECT COUNT(*) AS 'rows' FROM ".TBL_BLOGS." WHERE active = '1'";
						}
					}
				}
				else {
					if (PAG_ORDER=='ASC') {
						if (MAX_BLOG_HIT!='') {
							$q="SELECT COUNT(*) AS 'rows' FROM (SELECT * FROM ".TBL_BLOGS." ORDER BY id DESC LIMIT ".MAX_BLOG_HIT.") ".TBL_BLOGS." WHERE active = '1' AND username = '$user'";
						}
						else {
							$q="SELECT COUNT(*) AS 'rows' FROM ".TBL_BLOGS." WHERE active = '1' AND username = '$user'";
						}
					}
					else if (PAG_ORDER=='DSC') {
						if (MAX_BLOG_HIT!='') {
							$q="SELECT COUNT(*) AS 'rows' FROM (SELECT * FROM ".TBL_BLOGS." ORDER BY id LIMIT ".MAX_BLOG_HIT.") ".TBL_BLOGS." WHERE active = '1' AND username = '$user'";
						}
						else {
							$q="SELECT COUNT(*) AS 'rows' FROM ".TBL_BLOGS." WHERE active = '1' AND username = '$user'";
						}
					}
				}
				
				// current result
				$result = $database->query($q);
				// collect from the query, how many rows can be found in the current result table
				foreach ($result as $key => $value)
					foreach ($value as $k => $currRow)
						$num_rows = $currRow;
				
				// if there is no result
				if ($num_rows == 0) {
				  echo $LNG_BLOG_NO_RECORD;
				  exit;
				}
				
				// pass the total number of records to the pagination class
				$pagination->Records_Per_Page(RECORDS_PER_PAGE);
				// set the total records number
				$pagination->Records($num_rows);
				$pagination->Method('POST');
				$pagination->Padding(true);
				// set the pagination order: ascend(non-reverse) or descend(reverse)
				// the oldest or the newest blog can be found on the first place
				if (PAG_ORDER=='DSC')
					$pagination->Reverse(true);
				else if (PAG_ORDER=='ASC')
					$pagination->Reverse(false);
				// pagination labels: previous and next page
				$pagination->Labels($STD_PREV,$STD_NEXT);
				
				// select all records
				if ($user == 'admin'){
					if (PAG_ORDER=='ASC') {
						if (MAX_BLOG_HIT!='') {
							$q = "SELECT SQL_CALC_FOUND_ROWS * ".
									 "FROM (SELECT * FROM ".TBL_BLOGS." ORDER BY id DESC LIMIT ".MAX_BLOG_HIT.") ".TBL_BLOGS." ".
									 "WHERE active = '1' ".
									 "ORDER BY id DESC ".
									 "LIMIT ".(($pagination->Get_Page() - 1) * RECORDS_PER_PAGE).', '.RECORDS_PER_PAGE;
						}
						else {
							$q = "SELECT SQL_CALC_FOUND_ROWS * ".
									 "FROM ".TBL_BLOGS." ".
									 "WHERE active = '1' ".
									 "ORDER BY id DESC ".
									 "LIMIT ".(($pagination->Get_Page() - 1) * RECORDS_PER_PAGE).', '.RECORDS_PER_PAGE;
						}
					}
					else if (PAG_ORDER=='DSC') {
						$q = "SELECT SQL_CALC_FOUND_ROWS * ".
								 "FROM ".TBL_BLOGS." ".
								 "WHERE active = '1' ".
								 "ORDER BY id ".
								 "LIMIT ".(($pagination->Get_Page() - 1) * RECORDS_PER_PAGE).', '.RECORDS_PER_PAGE;
					}
				}
				else {
				  if (PAG_ORDER=='ASC') {
						if (MAX_BLOG_HIT!='') {
							$q = "SELECT SQL_CALC_FOUND_ROWS * ".
									 "FROM (SELECT * FROM ".TBL_BLOGS." ORDER BY id DESC LIMIT ".MAX_BLOG_HIT.") ".TBL_BLOGS." ".
									 "WHERE active = '1' AND username = '$user' ".
									 "ORDER BY id DESC ".
									 "LIMIT ".(($pagination->Get_Page() - 1) * RECORDS_PER_PAGE).', '.RECORDS_PER_PAGE;
						}
						else {
							$q = "SELECT SQL_CALC_FOUND_ROWS * ".
									 "FROM ".TBL_BLOGS." ".
									 "WHERE active = '1' AND username = '$user' ".
									 "ORDER BY id DESC ".
									 "LIMIT ".(($pagination->Get_Page() - 1) * RECORDS_PER_PAGE).', '.RECORDS_PER_PAGE;
						}
					}
					else if (PAG_ORDER=='DSC') {
						$q = "SELECT SQL_CALC_FOUND_ROWS * ".
								 "FROM ".TBL_BLOGS." ".
								 "WHERE active = '1' ".
								 "ORDER BY id ".
								 "LIMIT ".(($pagination->Get_Page() - 1) * RECORDS_PER_PAGE).', '.RECORDS_PER_PAGE;
					}
				}
				
				// current result
				$result = $database->query($q);
				// how many rows can be found in the current result table
				$num_rows = $database->fetchAssoc($database->query('SELECT FOUND_ROWS() AS rows'));
				
				// if there is no result
				if ($num_rows == 0) {
				  echo $LNG_BLOG_NO_RECORD;
				  exit;
				}
			}
			
			// create content table
			echo "<table id=\"contentTable\"><tbody><tr>";
			echo "<td id=\"rightPanel\">";
			// content div
			echo "<div id=\"accordion\">";
			
			// build new datas from the database and dropdown menus
			//while ($db_field = mysql_fetch_assoc($result)) {
			while ($db_field = $database->fetchAssoc($result)) {
				// timestamp
			  $time=$db_field['timestamp'];
				if (PROG_LANG=='hu')
          $datetime = date('Y.m.d H:i:s', $time);
        else
          $datetime = date('d.m.Y H:i:s', $time);
				// decode all HTML special characters
				$db_field['content']=stripslashes(html_entity_decode($db_field['content']));
				
				if (PROG_LANG=='hu')
			    $datetime = date('Y.m.d H:i:s', $time);
			  else
			    $datetime = date('d.m.Y H:i:s', $time);
				echo "<h3><a href=\"#\">".$db_field['title']."</a></h3>";
				echo "<div>";
			  echo "<p><b>$LNG_BLOG_22</b><input type=\"text\" style=\"color:#FF0000; background-color: #f7b400;\" size=\"46\" name=\"".
							$db_field['id']."_blog_user\" readonly value=\"".$db_field['username']."\"></p>";
			  echo "<p><b>$LNG_BLOG_23</b><input type=\"text\" style=\"color:#FF0000; background-color: #f7b400;\" size=\"46\" readonly value=\"".
							$datetime."\"></p>";
			  echo "<p><b>$LNG_BLOG_24</b><input type=\"text\" size=\"46\" name=\"".$db_field['id']."_blog_link\" value=\"".
							$db_field['link']."\"></p>";
			  echo "<p><b>$LNG_BLOG_25</b><input type=\"text\" size=\"46\" name=\"".$db_field['id']."_blog_title\" value=\"".
							$db_field['title']."\"></p>";
			  // only a textarea which is unusable to show the HTML tags!
				//echo "<p><b>$LNG_BLOG_26</b><br><textarea name=\"".$db_field['id']."_blog_comment\" cols=\"53\" rows=\"5\">".
				//			$db_field['content']."</textarea></p>";
				// in this case we have to use a WYSIWYG web-based text-editor: now it is the nicEdit - both PHP JavaScript solution is perfect
				echo "<p><b>$LNG_BLOG_26</b><br><textarea id=\"webdata".$db_field['id']."\" name=\"".$db_field['id']."_blog_comment\" cols=\"53\" rows=\"5\">".
							$db_field['content']."</textarea></p>";
				//echo '<script type="text/javascript">bkLib.onDomLoaded(function(){'.
				//		 'var myInstance = new nicEditor().panelInstance(\'webdata'.$db_field['id'].'\');});</script>';
				echo "<script type=\"text/javascript\">bkLib.onDomLoaded(function(){".
						 "var myInstance = new nicEditor().panelInstance('webdata".$db_field['id']."');});</script>";
				//echo "<p><b>$LNG_BLOG_26</b><br><div contenteditable=\"false\">".$db_field['content']."</div><br />";
				if ($db_field['image'] != '') {
					echo "<p><a id=\"actImage\" href=\"".$db_field['image']."\">".
							 "<img alt=\"actImage\" src=\"".$db_field['image']."\" width=\"20%\" height=\"20%\" /></a></p>";
				}
			  echo "<input type=\"hidden\" name=\"subblogedit\" value=\"1\">";
        echo "<input type=\"submit\" name=\"submit\" value=\"".$db_field['id'].". $LNG_BLOG_05\" />";
				echo "</div>";
			}
			// end: content div
			echo "</div>";
			
			// end: content table
			echo "</td>";
			echo "</tr></tbody></table>";
			
			// render the pagination links
			if (WINDOW_MODE=='PAG')
				$pagination->Render();
		}
		// current connection is PHP Data Object
    else if (API==='PDO') {
			/* get the current page mode: according or pagination */
			if (WINDOW_MODE=='ACC') {
				// current SQL command
				if ($user == 'admin')
					$q = "SELECT * FROM ".TBL_BLOGS." WHERE active = '1' ORDER BY id DESC";
				else
					$q = "SELECT * FROM ".TBL_BLOGS." WHERE active = '1' AND username = '$user' ORDER BY id DESC";
				
				// current result
				$result = $database->query($q);
				// how many rows can be found in the current result table
				$num_rows = $database->numRows($result);
				
				// if there is no result
				if ($num_rows == 0) {
				  echo $LNG_BLOG_NO_RECORD;
				  exit;
				}
			}
			else if (WINDOW_MODE=='PAG') {
				// instantiate the pagination object
				$pagination=new AniPagination();
				// set position of the next/previous page links
				$pagination->Navigation_Position(isset($_GET['navigation_position']) && in_array($_GET['navigation_position'],
																																												 array('left', 'right')) ? $_GET['navigation_position'] : 'outside');
				
				// how many rows can be found in the table after running the current SQL command
				if ($user == 'admin') {
					if (PAG_ORDER=='ASC') {
						if (MAX_BLOG_HIT!='') {
							$q="SELECT COUNT(*) AS 'rows' FROM (SELECT * FROM ".TBL_BLOGS." ORDER BY id DESC LIMIT ".MAX_BLOG_HIT.") ".TBL_BLOGS." WHERE active = '1'";
						}
						else {
							$q="SELECT COUNT(*) AS 'rows' FROM ".TBL_BLOGS." WHERE active = '1'";
						}
					}
					else if (PAG_ORDER=='DSC') {
						if (MAX_BLOG_HIT!='') {
							$q="SELECT COUNT(*) AS 'rows' FROM (SELECT * FROM ".TBL_BLOGS." ORDER BY id LIMIT ".MAX_BLOG_HIT.") ".TBL_BLOGS." WHERE active = '1'";
						}
						else {
							$q="SELECT COUNT(*) AS 'rows' FROM ".TBL_BLOGS." WHERE active = '1'";
						}
					}
				}
				else {
					if (PAG_ORDER=='ASC') {
						if (MAX_BLOG_HIT!='') {
							$q="SELECT COUNT(*) AS 'rows' FROM (SELECT * FROM ".TBL_BLOGS." ORDER BY id DESC LIMIT ".MAX_BLOG_HIT.") ".TBL_BLOGS." WHERE active = '1' AND username = '$user'";
						}
						else {
							$q="SELECT COUNT(*) AS 'rows' FROM ".TBL_BLOGS." WHERE active = '1' AND username = '$user'";
						}
					}
					else if (PAG_ORDER=='DSC') {
						if (MAX_BLOG_HIT!='') {
							$q="SELECT COUNT(*) AS 'rows' FROM (SELECT * FROM ".TBL_BLOGS." ORDER BY id LIMIT ".MAX_BLOG_HIT.") ".TBL_BLOGS." WHERE active = '1' AND username = '$user'";
						}
						else {
							$q="SELECT COUNT(*) AS 'rows' FROM ".TBL_BLOGS." WHERE active = '1' AND username = '$user'";
						}
					}
				}
				
				// current result
				$result = $database->query($q);
				// collect from the query, how many rows can be found in the current result table
				foreach ($result as $key => $value)
					foreach ($value as $k => $currRow)
						$num_rows = $currRow;
				
				// if there is no result
				if ($num_rows == 0) {
				  echo $LNG_BLOG_NO_RECORD;
				  exit;
				}
				
				// pass the total number of records to the pagination class
				$pagination->Records_Per_Page(RECORDS_PER_PAGE);
				// set the total records number
				$pagination->Records($num_rows);
				$pagination->Method('POST');
				$pagination->Padding(true);
				// set the pagination order: ascend(non-reverse) or descend(reverse)
				// the oldest or the newest blog can be found on the first place
				if (PAG_ORDER=='DSC')
					$pagination->Reverse(true);
				else if (PAG_ORDER=='ASC')
					$pagination->Reverse(false);
				// pagination labels: previous and next page
				$pagination->Labels($STD_PREV,$STD_NEXT);
				
				// select all records
				if ($user == 'admin'){
					if (PAG_ORDER=='ASC') {
						if (MAX_BLOG_HIT!='') {
							$q = "SELECT SQL_CALC_FOUND_ROWS * ".
									 "FROM (SELECT * FROM ".TBL_BLOGS." ORDER BY id DESC LIMIT ".MAX_BLOG_HIT.") ".TBL_BLOGS." ".
									 "WHERE active = '1' ".
									 "ORDER BY id DESC ".
									 "LIMIT ".(($pagination->Get_Page() - 1) * RECORDS_PER_PAGE).', '.RECORDS_PER_PAGE;
						}
						else {
							$q = "SELECT SQL_CALC_FOUND_ROWS * ".
									 "FROM ".TBL_BLOGS." ".
									 "WHERE active = '1' ".
									 "ORDER BY id DESC ".
									 "LIMIT ".(($pagination->Get_Page() - 1) * RECORDS_PER_PAGE).', '.RECORDS_PER_PAGE;
						}
					}
					else if (PAG_ORDER=='DSC') {
						$q = "SELECT SQL_CALC_FOUND_ROWS * ".
								 "FROM ".TBL_BLOGS." ".
								 "WHERE active = '1' ".
								 "ORDER BY id ".
								 "LIMIT ".(($pagination->Get_Page() - 1) * RECORDS_PER_PAGE).', '.RECORDS_PER_PAGE;
					}
				}
				else {
				  if (PAG_ORDER=='ASC') {
						if (MAX_BLOG_HIT!='') {
							$q = "SELECT SQL_CALC_FOUND_ROWS * ".
									 "FROM (SELECT * FROM ".TBL_BLOGS." ORDER BY id DESC LIMIT ".MAX_BLOG_HIT.") ".TBL_BLOGS." ".
									 "WHERE active = '1' AND username = '$user' ".
									 "ORDER BY id DESC ".
									 "LIMIT ".(($pagination->Get_Page() - 1) * RECORDS_PER_PAGE).', '.RECORDS_PER_PAGE;
						}
						else {
							$q = "SELECT SQL_CALC_FOUND_ROWS * ".
									 "FROM ".TBL_BLOGS." ".
									 "WHERE active = '1' AND username = '$user' ".
									 "ORDER BY id DESC ".
									 "LIMIT ".(($pagination->Get_Page() - 1) * RECORDS_PER_PAGE).', '.RECORDS_PER_PAGE;
						}
					}
					else if (PAG_ORDER=='DSC') {
						$q = "SELECT SQL_CALC_FOUND_ROWS * ".
								 "FROM ".TBL_BLOGS." ".
								 "WHERE active = '1' ".
								 "ORDER BY id ".
								 "LIMIT ".(($pagination->Get_Page() - 1) * RECORDS_PER_PAGE).', '.RECORDS_PER_PAGE;
					}
				}
				
				// current result
				$result = $database->query($q);
				// how many rows can be found in the current result table
				$num_rows = $database->fetchAssoc($database->query('SELECT FOUND_ROWS() AS \'rows\''));
				
				// if there is no result
				if ($num_rows[0] == 0) {
				  echo $LNG_BLOG_NO_RECORD;
				  exit;
				}
			}
			
			// create content table
			echo "<table id=\"contentTable\"><tbody><tr>";
			echo "<td id=\"rightPanel\">";
			// content div
			echo "<div id=\"accordion\">";
			
			foreach ($result as $db_field) {
				// timestamp
			  $time=$db_field['timestamp'];
				if (PROG_LANG=='hu')
          $datetime = date('Y.m.d H:i:s', $time);
        else
          $datetime = date('d.m.Y H:i:s', $time);
				// decode all HTML special characters
				$db_field['content']=stripslashes(html_entity_decode($db_field['content']));
				
			  if (PROG_LANG=='hu')
			    $datetime = date('Y.m.d H:i:s', $time);
			  else
			    $datetime = date('d.m.Y H:i:s', $time);
				echo "<h3><a href=\"#\">".$db_field['title']."</a></h3>";
				echo "<div>";
			  echo "<p><b>$LNG_BLOG_22</b><input type=\"text\" style=\"color:#FF0000; background-color: #f7b400;\" size=\"46\" name=\"".
							$db_field['id']."_blog_user\" readonly value=\"".$db_field['username']."\"></p>";
			  echo "<p><b>$LNG_BLOG_23</b><input type=\"text\" style=\"color:#FF0000; background-color: #f7b400;\" size=\"46\" readonly value=\"".
							$datetime."\"></p>";
			  echo "<p><b>$LNG_BLOG_24</b><input type=\"text\" size=\"46\" name=\"".$db_field['id']."_blog_link\" value=\"".
							$db_field['link']."\"></p>";
			  echo "<p><b>$LNG_BLOG_25</b><input type=\"text\" size=\"46\" name=\"".$db_field['id']."_blog_title\" value=\"".
							$db_field['title']."\"></p>";
			  // only a textarea which is unusable to show the HTML tags!
				//echo "<p><b>$LNG_BLOG_26</b><br><textarea name=\"".$db_field['id']."_blog_comment\" cols=\"53\" rows=\"5\">".
				//			$db_field['content']."</textarea></p>";
				// in this case we have to use a WYSIWYG web-based text-editor: now it is the nicEdit - both PHP JavaScript solution is perfect
				echo "<p><b>$LNG_BLOG_26</b><br><textarea id=\"webdata".$db_field['id']."\" name=\"".$db_field['id']."_blog_comment\" cols=\"53\" rows=\"5\">".
							$db_field['content']."</textarea></p>";
				//echo '<script type="text/javascript">bkLib.onDomLoaded(function(){'.
				//		 'var myInstance = new nicEditor().panelInstance(\'webdata'.$db_field['id'].'\');});</script>';
				echo "<script type=\"text/javascript\">bkLib.onDomLoaded(function(){".
						 "var myInstance = new nicEditor().panelInstance('webdata".$db_field['id']."');});</script>";
				//echo "<p><b>$LNG_BLOG_26</b><br><div contenteditable=\"false\">".$db_field['content']."</div><br />";
				if ($db_field['image'] != '') {
					echo "<p><a id=\"actImage\" href=\"".$db_field['image']."\">".
							 "<img alt=\"actImage\" src=\"".$db_field['image']."\" width=\"20%\" height=\"20%\" /></a></p>";
				}
			  echo "<input type=\"hidden\" name=\"subblogedit\" value=\"1\">";
			  echo "<input type=\"submit\" name=\"submit\" value=\"".$db_field['id'].". $LNG_BLOG_05\" />";
				echo "</div>";
			}
			// end: content div
			echo "</div>";
			
			// end: content table
			echo "</td>";
			echo "</tr></tbody></table>";
			
			// render the pagination links
			if (WINDOW_MODE=='PAG')
				$pagination->Render();
		}
	}
  
  /**
   * procDelBlog: delete any blog, does not support to constrict the record counts
   *
   * @property: $user: who is th current user
  **/
  function procDelBlog($user) {
		require_once('_include/aniPagination.php');
    require('_lang/'.PROG_LANG.'.php');
    global $database, $form, $session;
      
    // current connection is MySQLi
		if (API==='MySQLi') {
      if (!$database->getCurrentConnection()) {
				echo $database->getCurrentInterface();
				die('Cannot connect to the database!');
			}
      
			/* get the current page mode: according or pagination */
      if (WINDOW_MODE=='ACC') {
				// current SQL command
				if ($user == 'admin')
					$q = "SELECT * FROM ".TBL_BLOGS." WHERE active = '1' ORDER BY id DESC";
				else
					$q = "SELECT * FROM ".TBL_BLOGS." WHERE active = '1' AND username = '$user' ORDER BY id DESC";
				
				// current result
				$result = $database->query($q);
				// how many rows can be found in the current result table
				$num_rows = $database->numRows($result);
				
				// if there is no result
				if ($num_rows == 0) {
				  echo $LNG_BLOG_NO_RECORD;
				  exit;
				}
			}
			else if (WINDOW_MODE=='PAG') {
				// instantiate the pagination object
				$pagination=new AniPagination();
				// set position of the next/previous page links
				$pagination->Navigation_Position(isset($_GET['navigation_position']) && in_array($_GET['navigation_position'],
																																												 array('left', 'right')) ? $_GET['navigation_position'] : 'outside');
				
				// how many rows can be found in the table after running the current SQL command
				if ($user == 'admin') {
					$q="SELECT COUNT(*) AS 'rows' FROM ".TBL_BLOGS." WHERE active = '1'";
				}
				else {
					$q="SELECT COUNT(*) AS 'rows' FROM ".TBL_BLOGS." WHERE active = '1' AND username = '$user'";
				}
				
				// current result
				$result = $database->query($q);
				// collect from the query, how many rows can be found in the current result table
				foreach ($result as $key => $value)
					foreach ($value as $k => $currRow)
						$num_rows = $currRow;
				
				// pass the total number of records to the pagination class
				$pagination->Records_Per_Page(RECORDS_PER_PAGE);
				// set the total records number
				$pagination->Records($num_rows);
				$pagination->Method('POST');
				$pagination->Padding(true);
				// set the pagination order: ascend(non-reverse) or descend(reverse)
				// the oldest or the newest blog can be found on the first place
				if (PAG_ORDER=='DSC')
					$pagination->Reverse(true);
				else if (PAG_ORDER=='ASC')
					$pagination->Reverse(false);
				// pagination labels: previous and next page
				$pagination->Labels($STD_PREV,$STD_NEXT);
				
				if ($user == 'admin')
					$q = "SELECT SQL_CALC_FOUND_ROWS * ".
							 "FROM ".TBL_BLOGS." ".
							 "WHERE active = '1' ".
							 "ORDER BY id ".
							 "LIMIT ".(($pagination->Get_Page() - 1) * RECORDS_PER_PAGE).', '.RECORDS_PER_PAGE;
				else
				  $q = "SELECT SQL_CALC_FOUND_ROWS * ".
							 "FROM ".TBL_BLOGS." ".
							 "WHERE active = '1' AND username = '$user' ".
							 "ORDER BY id ".
							 "LIMIT ".(($pagination->Get_Page() - 1) * RECORDS_PER_PAGE).', '.RECORDS_PER_PAGE;
				
				// current result
				$result = $database->query($q);
				// how many rows can be found in the current result table
				$num_rows = $database->fetchAssoc($database->query('SELECT FOUND_ROWS() AS \'rows\''));
				
				// if there is no result
				if ($num_rows == 0) {
				  echo $LNG_BLOG_NO_RECORD;
				  exit;
				}
			}
      
      // create content table
      echo "<table id=\"contentTable\"><tbody><tr>";
      echo "<td id=\"rightPanel\">";
      // content div
      echo "<div id=\"accordion\">";
      
      // build new datas from the database and  dropdown menus
      while ($db_field = $database->fetchAssoc($result)) {
        // timestamp
        $time = $db_field['timestamp'];
        if (PROG_LANG=='hu')
          $datetime = date('Y.m.d H:i:s', $time);
        else
          $datetime = date('d.m.Y H:i:s', $time);
				// decode all HTML special characters
				$db_field['content']=stripslashes(html_entity_decode($db_field['content']));
      	
      	echo "<h3><a href=\"#\">".$db_field['title']."</a></h3>";
      	echo "<div>";
      	echo "<p><b>$LNG_BLOG_22</b><input type=\"text\" style=\"color:#FF0000; background-color: #f7b400;\" size=\"46\" name=\"".
      				$db_field['id']."_blog_user_del\" readonly value=\"".$db_field['username']."\"></p>";
        echo "<p><b>$LNG_BLOG_23</b><input type=\"text\" style=\"color:#FF0000; background-color: #f7b400;\" size=\"46\" value=\"".
      				$datetime."\" readonly></p>";
        echo "<p><b>$LNG_BLOG_24</b><input type=\"text\" style=\"color:#FF0000; background-color: #f7b400;\" size=\"46\" name=\"".
      				$db_field['id']."_blog_link_del\" readonly value=\"".$db_field['link']."\"></p>";
        echo "<p><b>$LNG_BLOG_25</b><input type=\"text\" style=\"color:#FF0000; background-color: #f7b400;\" size=\"46\" name=\"".
      				$db_field['id']."_blog_title_del\" readonly value=\"".$db_field['title']."\"></p>";
        //echo "<p><b>$LNG_BLOG_26</b><br><textarea name=\"".$db_field['id']."_blog_comment_del\" cols=\"53\" rows=\"5\">".$db_field['content']."</textarea></p>";
      	echo "<p><b>$LNG_BLOG_26</b><br><textarea id=\"webdata".$db_field['id']."\" name=\"".$db_field['id']."_blog_comment_del\" cols=\"53\" rows=\"5\">".
      				$db_field['content']."</textarea></p>";
      	//echo '<script type="text/javascript">bkLib.onDomLoaded(function(){'.
      	//		 'var myInstance = new nicEditor().panelInstance(\'webdata'.$db_field['id'].'\');});</script>';
      	echo "<script type=\"text/javascript\">bkLib.onDomLoaded(function(){".
      			 "var myInstance = new nicEditor().panelInstance('webdata".$db_field['id']."');});</script>";
      	if ($db_field['image'] != '')
					echo "<p><a id=\"actImage\" href=\"".$db_field['image']."\">".
							 "<img alt=\"actImage\" src=\"".$db_field['image']."\" width=\"20%\" height=\"20%\" /></a></p>";
        echo "<input type=\"hidden\" name=\"subblogdelete\" value=\"1\">";
        echo "<input type=\"submit\" name=\"submit\" value=\"".$db_field['id'].". $LNG_BLOG_28\" />";
      	echo "</div>";
      }
      
      // end: content div
      echo "</div>";
      // end: content table
      echo "</td>";
      echo "</tr></tbody></table>";
			
			// render the pagination links
			if (WINDOW_MODE=='PAG')
				$pagination->Render();
    }
    else if (API==='PDO') {
      /* get the current page mode: according or pagination */
      if (WINDOW_MODE=='ACC') {
				// current SQL command
				if ($user == 'admin')
					$q = "SELECT * FROM ".TBL_BLOGS." WHERE active = '1' ORDER BY id DESC";
				else
					$q = "SELECT * FROM ".TBL_BLOGS." WHERE active = '1' AND username = '$user' ORDER BY id DESC";
				
				// current result
				$result = $database->query($q);
				// how many rows can be found in the current result table
				$num_rows = $database->numRows($result);
				
				// if there is no result
				if ($num_rows == 0) {
				  echo $LNG_BLOG_NO_RECORD;
				  exit;
				}
			}
			else if (WINDOW_MODE=='PAG') {
				// instantiate the pagination object
				$pagination=new AniPagination();
				// set position of the next/previous page links
				$pagination->Navigation_Position(isset($_GET['navigation_position']) && in_array($_GET['navigation_position'],
																																												 array('left', 'right')) ? $_GET['navigation_position'] : 'outside');
				
				// how many rows can be found in the table after running the current SQL command
				if ($user == 'admin') {
					$q="SELECT COUNT(*) AS 'rows' FROM ".TBL_BLOGS." WHERE active = '1'";
				}
				else {
					$q="SELECT COUNT(*) AS 'rows' FROM ".TBL_BLOGS." WHERE active = '1' AND username = '$user'";
				}
				
				// current result
				$result = $database->query($q);
				// collect from the query, how many rows can be found in the current result table
				foreach ($result as $key => $value)
					foreach ($value as $k => $currRow)
						$num_rows = $currRow;
				
				// pass the total number of records to the pagination class
				$pagination->Records_Per_Page(RECORDS_PER_PAGE);
				// set the total records number
				$pagination->Records($num_rows);
				$pagination->Method('POST');
				$pagination->Padding(true);
				// set the pagination order: ascend(non-reverse) or descend(reverse)
				// the oldest or the newest blog can be found on the first place
				if (PAG_ORDER=='DSC')
					$pagination->Reverse(true);
				else if (PAG_ORDER=='ASC')
					$pagination->Reverse(false);
				// pagination labels: previous and next page
				$pagination->Labels($STD_PREV,$STD_NEXT);
				
				if ($user == 'admin')
					$q = "SELECT SQL_CALC_FOUND_ROWS * ".
							 "FROM ".TBL_BLOGS." ".
							 "WHERE active = '1' ".
							 "ORDER BY id ".
							 "LIMIT ".(($pagination->Get_Page() - 1) * RECORDS_PER_PAGE).', '.RECORDS_PER_PAGE;
				else
				  $q = "SELECT SQL_CALC_FOUND_ROWS * ".
							 "FROM ".TBL_BLOGS." ".
							 "WHERE active = '1' AND username = '$user' ".
							 "ORDER BY id ".
							 "LIMIT ".(($pagination->Get_Page() - 1) * RECORDS_PER_PAGE).', '.RECORDS_PER_PAGE;
				
				// current result
				$result = $database->query($q);
				// how many rows can be found in the current result table
				$num_rows = $database->fetchAssoc($database->query('SELECT FOUND_ROWS() AS rows'));
				
				// if there is no result
				if ($num_rows == 0) {
				  echo $LNG_BLOG_NO_RECORD;
				  exit;
				}
			}
			
			// create content table
			echo "<table id=\"contentTable\"><tbody><tr>";
			echo "<td id=\"rightPanel\">";
			// content div
			echo "<div id=\"accordion\">";
			
			foreach ($result as $db_field) {
				// timestamp
        $time = $db_field['timestamp'];
        if (PROG_LANG=='hu')
          $datetime = date('Y.m.d H:i:s', $time);
        else
          $datetime = date('d.m.Y H:i:s', $time);
				// decode all HTML special characters
				$db_field['content']=stripslashes(html_entity_decode($db_field['content']));
      	
      	echo "<h3><a href=\"#\">".$db_field['title']."</a></h3>";
      	echo "<div>";
      	echo "<p><b>$LNG_BLOG_22</b><input type=\"text\" style=\"color:#FF0000; background-color: #f7b400;\" size=\"46\" name=\"".
      				$db_field['id']."_blog_user_del\" readonly value=\"".$db_field['username']."\"></p>";
        echo "<p><b>$LNG_BLOG_23</b><input type=\"text\" style=\"color:#FF0000; background-color: #f7b400;\" size=\"46\" value=\"".
      				$datetime."\" readonly></p>";
        echo "<p><b>$LNG_BLOG_24</b><input type=\"text\" style=\"color:#FF0000; background-color: #f7b400;\" size=\"46\" name=\"".
      				$db_field['id']."_blog_link_del\" readonly value=\"".$db_field['link']."\"></p>";
        echo "<p><b>$LNG_BLOG_25</b><input type=\"text\" style=\"color:#FF0000; background-color: #f7b400;\" size=\"46\" name=\"".
      				$db_field['id']."_blog_title_del\" readonly value=\"".$db_field['title']."\"></p>";
        //echo "<p><b>$LNG_BLOG_26</b><br><textarea name=\"".$db_field['id']."_blog_comment_del\" cols=\"53\" rows=\"5\">".$db_field['content']."</textarea></p>";
      	echo "<p><b>$LNG_BLOG_26</b><br><textarea id=\"webdata".$db_field['id']."\" name=\"".$db_field['id']."_blog_comment_del\" cols=\"53\" rows=\"5\">".
      				$db_field['content']."</textarea></p>";
      	//echo '<script type="text/javascript">bkLib.onDomLoaded(function(){'.
      	//		 'var myInstance = new nicEditor().panelInstance(\'webdata'.$db_field['id'].'\');});</script>';
      	echo "<script type=\"text/javascript\">bkLib.onDomLoaded(function(){".
      			 "var myInstance = new nicEditor().panelInstance('webdata".$db_field['id']."');});</script>";
      	if ($db_field['image'] != '')
					echo "<p><a id=\"actImage\" href=\"".$db_field['image']."\">".
							 "<img alt=\"actImage\" src=\"".$db_field['image']."\" width=\"20%\" height=\"20%\" /></a></p>";
        echo "<input type=\"hidden\" name=\"subblogdelete\" value=\"1\">";
        echo "<input type=\"submit\" name=\"submit\" value=\"".$db_field['id'].". $LNG_BLOG_28\" />";
      	echo "</div>";
			}
			// end: content div
			echo "</div>";
			
			// end: content table
			echo "</td>";
			echo "</tr></tbody></table>";
			
			// render the pagination links
			if (WINDOW_MODE=='PAG')
				$pagination->Render(false,"accordion");
    }
  }
?>