<?php
   /**
   * UserEdit.php
   *
   * This page is for users to edit their account information
   * such as their password, email address, etc. Their
   * usernames can not be edited. When changing their
   * password, they must first confirm their current password.
   *
   */
   require_once('_include/session.php');
   if (PROG_LANG=='') {
      die ('Current language has not been set!');
   }
   else {
      if (file_exists('_lang/'.PROG_LANG.'.php')) {
         require_once('_lang/'.PROG_LANG.'.php');
      }
      else {
         die ('Current language file (_lang/'.PROG_LANG.'.php) does not exist!');
      }
   }
?>

<html>
<head>
<?php require_once('header.php'); ?>
<title><?php echo PROG_NAME.'\'s User Page'; ?></title>
</head>

<body>
<!-- FULL CONTENT DIV -->
<div id="fullContent"><?php echo $LNG_018; ?>
<?php
   /**
   * User has submitted form without errors and user's
   * account has been edited successfully.
   */
   if (isset($_SESSION['useredit'])) {
      unset($_SESSION['useredit']);
      
      echo "<div id=\"headerUserEdit\">";
      echo '<h1>'.$LNG_042.'</h1>';
      echo '<p><b>'.$session->username.'</b>'.$LNG_043.'</p>';
      echo "</div>";
      echo "<div id=\"fullsuccessUserEdit\">";
      if (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE')) {
         echo "<input type=\"button\" onclick=\"window.location.href('entry.php?u=".$session->username."');\" value=\"$LNG_004\">";
      }
      else {
         echo "<a href=\"entry.php\"><input type=\"button\" value=\"".$LNG_004."\" /></a>";
      }
      echo "</div>";
   }
   else {
?>

<?php
      /**
      * If user is not logged in, then do not display anything.
      * If user is logged in, then display the form to edit
      * account information, with the current email address
      * already in the field.
      */
      if ($session->logged_in) {
?>

<!-- HEADER DIV -->
<div id="headerUserEdit">
<h1><?php echo $LNG_044.$session->username; ?></h1>
</div>
<!-- END: HEADER DIV -->

<!-- ERROR DIV -->
<div id="errorUserEdit">
<?php
         if ($form->num_errors > 0) {
            echo "<font size=\"2\" color=\"#ff0000\">".$form->num_errors.$STD_007."</font>";
         }
?>
</div>
<!-- END: ERROR DIV -->

<!-- MAIN FORM FOR EDITING A USER -->
<form action="process.php" method="post">
<!-- DATA DIV -->
<div id="dataUserEdit">
<table align="left" border="0" cellspacing="0" cellpadding="3">
<tr>
   <td><?php echo $LNG_045.$STD_002; ?></td>
   <td><input type="password" name="curpass" maxlength="30" value="<?php echo $form->value("curpass"); ?>"></td>
   <td><?php echo $form->error("curpass"); ?></td>
</tr>
<tr>
   <td><?php echo $LNG_046.$STD_002; ?></td>
   <td><input type="password" name="newpass" maxlength="30" value="<?php echo $form->value("newpass"); ?>"></td>
   <td><?php echo $form->error("newpass"); ?></td>
</tr>
<tr>
   <td><?php echo $STD_006; ?></td>
   <td><input type="text" name="email" maxlength="50" value="
<?php
         if ($form->value("email") == '')
            echo $session->userinfo['email'];
         else
            echo $form->value("email");
?>"></td>
   <td><?php echo $form->error("email"); ?></td>
</tr>
</table>
</div>
<!-- END: DATA DIV -->

<!-- BUTTON DIV -->
<div id="buttonUserEdit">
<input type="hidden" name="subedit" value="1">
<input type="submit" value="<?php echo $LNG_047; ?>">
<?php
         if (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE')) {
            echo "<input type=\"button\" onclick=\"window.location.href('entry.php?u=".$session->username."');\" value=\"$LNG_004\">";
         }
         else {
            echo "<a href=\"entry.php\"><input type=\"button\" value=\"".$LNG_004."\" /></a>";
         }
?>
</div>
<!-- END: BUTTON DIV -->
</form>
<!-- END: MAIN FORM FOR EDITING A USER -->

<?php
      }
   }
?>
</div>
</body>
</html>