<?php
  /**
   * Constants.php
   *
   * This file is intended to group all constants to
   * make it easier for the site administrator to tweak
   * the login script.
   *
   */
  
  // the class which is used to read the standard config file
  $aniConfigClass='_include/aniConfigClass.php';
  if (file_exists($aniConfigClass))
    require_once($aniConfigClass);
  // the standard config file
  $fileName='_include/constants.standard.php';
  
  // the config file field names without values
	$configFields=array(
								'PROG_LANG',
								'API',
								'DRIVER',
								'DB_SERVER',
								'DB_PORT',
								'DB_NAME',
								'DB_USER',
								'DB_PASS',
								'WINDOW_MODE',
								'PAG_ORDER',
								'MAX_BLOG_HIT',
								'RECORDS_PER_PAGE');
  
  // first: all fields are empty
  $language='';
  $db_api='';
  $db_driver='';
  $db_server='';
  $db_port='';
  $db_name='';
  $db_uname='';
  $db_passwd='';
  $win_mode='';
  $pag_order='';
  $max_blog_hit='';
  $rec_per_page='';
  
  if (file_exists($fileName)) {
    $config=aniConfigClass::ReadConfig($fileName);
    $language=$config[$configFields[0]];
    $db_api=$config[$configFields[1]];
    $db_driver=$config[$configFields[2]];
    $db_server=$config[$configFields[3]];
    $db_port=$config[$configFields[4]];
    $db_name=$config[$configFields[5]];
    $db_uname=$config[$configFields[6]];
    $db_passwd=$config[$configFields[7]];
    $win_mode=$config[$configFields[8]];
    $pag_order=$config[$configFields[9]];
    $max_blog_hit=$config[$configFields[10]];
    $rec_per_page=$config[$configFields[11]];
	}
  
  /**
   * Default program name to show it in any browser
  */ 
  define("PROG_NAME", "anicodeR");
  
  /**
   * Current language setting: en, hu
  */
  define("PROG_LANG", $language);
  
  /**
   * API for the database connection
   *
   * @param: MySQLi, PDO
   */
  define("API", $db_api);
  
  /**
   * Database Constants - these constants are required
   * in order for there to be a successful connection
   * to the MySQL database. Make sure the information is
   * correct.
   */
  define("DRIVER", $db_driver);
  define("DB_SERVER", $db_server);
  define("DB_PORT", $db_port);
  define("DB_NAME", $db_name);
  define("DB_USER", $db_uname);
  define("DB_PASS", $db_passwd);
  
  /**
   * Set blog show mode to accordion or pagination: ACC, PAG
   * Set pagination mode: order is ascend or descend mode:
   * ASC (non-reverse), DSC(reverse)
   * Define how many records should be displayed on a page
   * when the system has been set to pagination technology
   * In case of pagination is determined how many rows
   * must show at all, this is the MAX_BLOG_HIT. If it is empty,
   * then all of rows will be shown
   * RECORDS_PER_PAGE will show only the maximum hit in a side,
   * it means: 1: only a hit, 2: two hits will be shown in a side
  **/
  define("WINDOW_MODE", $win_mode);
  define("PAG_ORDER", $pag_order);
  define("MAX_BLOG_HIT", $max_blog_hit);
	define("RECORDS_PER_PAGE", $rec_per_page);
  
  /**
   * Database Table Constants - these constants
   * hold the names of all the database tables used
   * in the script.
   */
  define("TBL_USERS", "users");
  define("TBL_ACTIVE_USERS",  "active_users");
  define("TBL_ACTIVE_GUESTS", "active_guests");
  define("TBL_BANNED_USERS",  "banned_users");
  define("TBL_BLOGS",  "p_blog");
  
  
  /**
   * Standard MD5 password, userid, userlevel and email
   * to a banned user who has been restored from the
   * TBL_BANNED_USERS table
  */
  define("RESTORE_MD5_PASS", "827ccb0eea8a706c4c34a16891f84e7b"); // means 12345
  define("RESTORE_USERID", "0");
  define("RESTORE_USERLEVEL", "1");
  define("RESTORE_USERMAIL", "nobody@nobody.com");
  
  /**
   * Special Names and Level Constants - the admin
   * page will only be accessible to the user with
   * the admin name and also to those users at the
   * admin user level. Feel free to change the names
   * and level constants as you see fit, you may
   * also add additional level specifications.
   * Levels must be digits between 0-9.
   */
  define("ADMIN_NAME", "admin");
  define("GUEST_NAME", "Guest");
  define("ADMIN_LEVEL", 9);
  define("USER_LEVEL",  1);
  define("GUEST_LEVEL", 0);
  
  /**
   * This boolean constant controls whether or
   * not the script keeps track of active users
   * and active guests who are visiting the site.
   */
  define("TRACK_VISITORS", true);
  
  /**
   * Timeout Constants - these constants refer to
   * the maximum amount of time (in minutes) after
   * their last page fresh that a user and guest
   * are still considered active visitors.
   */
  define("USER_TIMEOUT", 10);
  define("GUEST_TIMEOUT", 5);
  
  /**
   * Cookie Constants - these are the parameters
   * to the setcookie function call, change them
   * if necessary to fit your website. If you need
   * help, visit www.php.net for more info.
   * <http://www.php.net/manual/en/function.setcookie.php>
   */
  define("COOKIE_EXPIRE", 60*60*24*100);  //100 days by default
  define("COOKIE_PATH", "/");  //Avaible in whole domain
  
  /**
   * Email Constants - these specify what goes in
   * the from field in the emails that the script
   * sends to users, and whether to send a
   * welcome email to newly registered users.
   */
  define("EMAIL_FROM_NAME", "webmaster");
  define("EMAIL_FROM_ADDR", "admin@anicoder.hu");
  define("EMAIL_WELCOME", false);
  
  /**
   * This constant forces all users to have
   * lowercase usernames, capital letters are
   * converted automatically.
   */
  define("ALL_LOWERCASE", false);
?>