<?php
	 /**
	 * Database.php
	 * 
	 * The Database class is meant to simplify the task of accessing
	 * information from the website's database.
	 *
	 */
	 require_once('constants.php');
	 
	 /*************************************************/
	 /* A NEW CLASS ONLY TO LOAD THE EBuilder CLASSES */
	 /*************************************************/
	 class EBuilderClass {
			public static function load() {
				 if (file_exists('ebuilder/ebuilder.php'))
						require_once('ebuilder/ebuilder.php');
				 else if (file_exists('../ebuilder/ebuilder.php'))
						require_once('../ebuilder/ebuilder.php');
				 else if (file_exists('../../ebuilder/ebuilder.php'))
						require_once('../../ebuilder/ebuilder.php');
				 else
						die('The EBuilder class and its database class cannot be found and loaded!');
			}	
	 }
	 /* call the one and only EBuilderClass method */
	 EBuilderClass::load();
	 
	 /*******************************************************/
	 /* THE MAIN CLASS TO EXECUTE ALL DATABASE COMMANDS     */
	 /* NOW WE CAN USE THE EBuilder CLASSES AND ITS METHODS */
	 /*******************************************************/
	 class ANISQLDB {
			var $EBUILDER;					 // EBuilder class to using the MySQL datatase
			var $ANIDB;							 // The database connection
			var $ANIDBTYPE;					 // connection method: MySQLi or PDO
			var $connected;					 // Connection status to the MySQL/MariaDB server
	    var $num_active_users;   // Number of active users viewing site
	    var $num_active_guests;  // Number of active guests viewing site
	    var $num_members;        // Number of signed-up users
			var $codepage;					 // the current codepage only in case of using MySQLiTool class
			/* Note: call getNumMembers() to access $num_members! */
			
			/* Class constructor */
			public function __construct($connectType='MySQLi') {
				/* create new EBuilder class */
				if ($this->EBUILDER==null) {
				 $this->EBUILDER=new Ebuilder();
				 $this->ANIDBTYPE='';
				}
				else
				 echo 'GET';
				
				/* create a new connection */
				/* MySQLiTool class */
				if ($connectType==='MySQLi') {
					$this->ANIDB=new MySQLiTool(DB_SERVER,DB_PORT,DB_USER,DB_PASS);
					$this->codepage=$this->ANIDB->GetDBCharacterSet();
					
					/* check the connection status */
					$this->connected=$this->ANIDB->IsConnected();
					/* if we have a live connection with the MySQL server... */
					if ($this->connected)
						/* ...we can select our database */
						$this->ANIDB->SelectDatabase(DB_NAME) or die(mysql_error());
					else
						/* ...or close the script run */
						die('ERROR in connection: try to check in constants.php MySQL parameters!');
					 
					/**
					 * Only query database to find out number of members
					 * when getNumMembers() is called for the first time,
					 * until then, default value set.
					**/
					$this->num_members=-1;
					
					if (TRACK_VISITORS) {
						/* Calculate number of users at site */
						$this->calcNumActiveUsers();
						/* Calculate number of guests at site */
						$this->calcNumActiveGuests();
					}
					
					// API is the MySQLi
					$this->ANIDBTYPE='MySQLi';
				}
				/* PDOTool class */
				else if ($connectType==='PDO') {
					/* get instance of PDOTool class */
					$this->ANIDB=new PDOTool(DRIVER.":host=".DB_SERVER.";port=".DB_PORT.";dbname=".DB_NAME,DB_USER,DB_PASS);
					/* set error log mode true to show error on screen or false to log in log file */
					$this->ANIDB->setErrorLog(true);
					
					// API is the PDO
					$this->ANIDBTYPE='PDO';
				}
				else {
					die('Unknown connection type method! Only an empty string or the PDO keyword can be used!');
				}
			}
			
			/**
			 * Get the current MySQL/MariaDB character set
			*/
			public function ReadCharacterSet($connectType='MySQLi') {
				 if ($connectType==='MySQLi')
						return $this->codepage;
			}
			
			/**
			* confirmUserPass - Checks whether or not the given
			* username is in the database, if so it checks if the
			* given password is the same password in the database
			* for that user. If the user doesn't exist or if the
			* passwords don't match up, it returns an error code
			* (1 or 2). On success it returns 0.
			*/
			public function confirmUserPass($username,$password) {
				if ($this->ANIDBTYPE==='MySQLi') {
					/* Add slashes if necessary (for query) */
					if (!get_magic_quotes_gpc())
						$username=addslashes($username);
					
					/* Verify that user is in database */
					$q="SELECT password FROM ".TBL_USERS." WHERE username = '$username'";
					$result=$this->query($q);
					if (!$result || ($this->ANIDB->NumRows($result)<1))
						//Indicates usernpassword failure
						return 1;
					
					/* Retrieve password from result, strip slashes */
					$dbarray=$this->ANIDB->FetchArray($result);
					$dbarray['password']=stripslashes($dbarray['password']);
					$password=stripslashes($password);
					/* Validate that password is correct */
					if ($password==$dbarray['password'])
						//Success! Username and password confirmed
						return 0;
					else
					 //Indicates password failure
						return 2;
				}
				else if ($this->ANIDBTYPE==='PDO') {
					/* Add slashes if necessary (for query) */
					if (!get_magic_quotes_gpc())
						$username=addslashes($username);
					
					/* Verify that user is in database */
					$dbarray=$this->ANIDB->SelectPTC(TBL_USERS," WHERE username='$username'",'','password');
					if (!$dbarray)
						//Indicates usernpassword failure
						return 1;
					
					$dbarray[0]['password']=stripslashes($dbarray[0]['password']);
					$password=stripslashes($password);
					
					/* Validate that password is correct */
					if ($password==$dbarray[0]['password'])
						//Success! Username and password confirmed
						return 0;
					else
					 //Indicates password failure
						return 2;
				}
			}
			
			/**
			* confirmUserID - Checks whether or not the given
			* username is in the database, if so it checks if the
			* given userid is the same userid in the database
			* for that user. If the user doesn't exist or if the
			* userids don't match up, it returns an error code
			* (1 or 2). On success it returns 0.
			*/
			public function confirmUserID($username, $userid) {
				if ($this->ANIDBTYPE==='MySQLi') {
					/* Add slashes if necessary (for query) */
					if (!get_magic_quotes_gpc())
						$username = addslashes($username);
					
					/* Verify that user is in database */
					$q="SELECT userid FROM ".TBL_USERS." WHERE username='$username'";
					$result=$this->query($q);
					if (!$result || ($this->ANIDB->NumRows($result)<1))
					  return 1; //Indicates username failure
					
					/* Retrieve userid from result, strip slashes */
					$dbarray=$this->ANIDB->FetchArray($result);
					$dbarray['userid']=stripslashes($dbarray['userid']);
					$userid=stripslashes($userid);
					
					/* Validate that userid is correct */
					if($userid==$dbarray['userid'])
					  //Success! Username and userid confirmed
						return 0;
					else
					  //Indicates userid invalid
						return 2;
				}
				else if ($this->ANIDBTYPE==='PDO') {
					/* Add slashes if necessary (for query) */
					if (!get_magic_quotes_gpc())
						$username=addslashes($username);
					
					/* Verify that user is in database */
					$dbarray=$this->ANIDB->SelectPTC(TBL_USERS," WHERE username='$username'",'','userid');
					if (!$dbarray)
						//Indicates usernpassword failure
						return 1;
					
					$dbarray[0]['userid']=stripslashes($dbarray[0]['userid']);
					$userid=stripslashes($userid);
					
					/* Validate that userid is correct */
					if($userid==$dbarray[0]['userid'])
					  //Success! Username and userid confirmed
						return 0;
					else
					  //Indicates userid invalid
						return 2;
				}
			}
			
			/**
			* usernameTaken - Returns true if the username has
			* been taken by another user, false otherwise.
			*/
			public function usernameTaken($username) {
				if ($this->ANIDBTYPE==='MySQLi') {
					if (!get_magic_quotes_gpc())
						$username=addslashes($username);
				 
					$q="SELECT username FROM ".TBL_USERS." WHERE username='$username'";
					$result=$this->query($q);
					
					return ($this->ANIDB->NumRows($result)>0);
				}
				else if ($this->ANIDBTYPE==='PDO') {
					if (!get_magic_quotes_gpc())
						$username=addslashes($username);
					
					$result=$this->ANIDB->SelectPTC(TBL_USERS,"WHERE username='$username'",'','*');
					return ($this->ANIDB->NumRowsPTC()>0);
				}
			}
			
			/**
			* usernameBanned - Returns true if the username has
			* been banned by the administrator.
			*/
			public function usernameBanned($username) {
				if ($this->ANIDBTYPE==='MySQLi') {
					if (!get_magic_quotes_gpc())
						$username=addslashes($username);
					
					$q="SELECT username FROM ".TBL_BANNED_USERS." WHERE username='$username'";
					$result=$this->query($q);
					 
					return ($this->ANIDB->NumRows($result)>0);
				}
				else if ($this->ANIDBTYPE==='PDO') {
					if (!get_magic_quotes_gpc())
						$username=addslashes($username);
					
					$result=$this->ANIDB->SelectPTC(TBL_BANNED_USERS,"WHERE username='$username'",'','username');
					return ($this->ANIDB->NumRowsPTC()>0);
				}
			}
			
			/**
			* addNewUser - Inserts the given (username, password, email)
			* info into the database. Appropriate user level is set.
			* Returns true on success, false otherwise.
			*/
			public function addNewUser($username,$password,$email) {
				$time=time();
				/* If admin sign up, give admin user level */
				if (strcasecmp($username,ADMIN_NAME)==0)
				  $ulevel=ADMIN_LEVEL;
				else
					$ulevel=USER_LEVEL;
				
				if ($this->ANIDBTYPE==='MySQLi') {
					$q="INSERT INTO ".TBL_USERS." VALUES ('$username','$password','0',$ulevel,'$email',$time)";
					 
					return ($this->query($q));
				}
				else if ($this->ANIDBTYPE==='PDO') {
					$q=array(
							"username" => "$username",
							"password" => "$password",
							"userid" => 0,
							"userlevel" => "$ulevel",
							"email" => "$email",
							"timestamp" => "$time"
					);
					
					return ($this->ANIDB->InsertPTC(TBL_USERS,$q));
				}
			}
			
			/**
			* updateUserField - Updates a field, specified by the field
			* parameter, in the user's row of the database.
			*/
			public function updateUserField($username,$field,$value) {
				if ($this->ANIDBTYPE==='MySQLi') {
					$q="UPDATE ".TBL_USERS." SET ".$field." = '$value' WHERE username='$username'";
					
					return ($this->query($q));
				}
				else if ($this->ANIDBTYPE==='PDO') {
					$q=array("$field" => "$value");
					
					return ($this->ANIDB->UpdatePTC(TBL_USERS,$q,"username='$username'",''));
				}
			}
			
			/**
			* getUserInfo - Returns the result array from a mysql
			* query asking for all information stored regarding
			* the given username. If query fails, NULL is returned.
			*/
			public function getUserInfo($username) {
				if ($this->ANIDBTYPE==='MySQLi') {
					$q="SELECT * FROM ".TBL_USERS." WHERE username='$username'";
					$result=$this->query($q);
					
					/* Error occurred, return given name by default */
					if (!$result || ($this->ANIDB->NumRows($result)<1))
					  return NULL;
					
					/* Return result array */
					$dbarray=$this->ANIDB->FetchArray($result);
					
					return ($dbarray);
				}
				else if ($this->ANIDBTYPE==='PDO') {
					$dbarray=$this->ANIDB->SelectPTC(TBL_USERS," WHERE username='$username'",'','*');
					
					if (!$dbarray)
					  return NULL;
					
					/* $dbarray is an associative array which contains another array */
					foreach ($dbarray as $row => $result)
						foreach ($result as $a)
							/* the result is the given associative array */
							return $result;
				}
			}
			
			/**
			* getNumMembers - Returns the number of signed-up users
			* of the website, banned members not included. The first
			* time the function is called on page load, the database
			* is queried, on subsequent calls, the stored result
			* is returned. This is to improve efficiency, effectively
			* not querying the database when no call is made.
			*/
			public function getNumMembers() {
				if ($this->ANIDBTYPE==='MySQLi') {
					if ($this->num_members<0) {
						$q="SELECT * FROM ".TBL_USERS;
						$result=$this->query($q);
						$this->num_members=$this->ANIDB->NumRows($result);
					}
					
					return ($this->num_members);
				}
				else if ($this->ANIDBTYPE==='PDO') {
					if ($this->num_members<0) {
						$dbarray=$this->ANIDB->SelectPTC(TBL_USERS,"",'','*');
						echo $dbarray;
						foreach ($dbarray as $row => $result)
							foreach ($result as $a)
								echo $a;
					}
				}
			}
			
			/**
			* calcNumActiveUsers - Finds out how many active users
			* are viewing site and sets class variable accordingly.
			*/
			public function calcNumActiveUsers() {
				if ($this->ANIDBTYPE==='MySQLi') {
					/* Calculate number of users at site */
					$q="SELECT * FROM ".TBL_ACTIVE_USERS;
					$result=$this->query($q);
					$this->num_active_users=$this->ANIDB->NumRows($result);
				}
				else if ($this->ANIDBTYPE==='PDO') {
					$count=0;
					$dbarray=$this->ANIDB->SelectPTC(TBL_ACTIVE_USERS,"",'','*');
					
					foreach ($dbarray as $row => $result)
						foreach ($result as $qry)
							++$count;
					
					$this->num_active_users=($count/2); //$this->ANIDB->NumRowsPTC();
				}
			}
			
			/**
			* calcNumActiveGuests - Finds out how many active guests
			* are viewing site and sets class variable accordingly.
			*/
			public function calcNumActiveGuests() {
				if ($this->ANIDBTYPE==='MySQLi') {
					/* Calculate number of guests at site */
					$q="SELECT * FROM ".TBL_ACTIVE_GUESTS;
					$result=$this->query($q);
					$this->num_active_guests=$this->ANIDB->NumRows($result);
				}
				else if ($this->ANIDBTYPE==='PDO') {
					$count=0;
					$dbarray=$this->ANIDB->SelectPTC(TBL_ACTIVE_GUESTS,"",'','*');
					
					foreach ($dbarray as $row => $result)
							foreach ($result as $qry)
								++$count;
					
					$this->num_active_guests=($count/2); //$this->ANIDB->NumRowsPTC();
				}
			}
			
			/**
			* addActiveUser - Updates username's last active timestamp
			* in the database, and also adds him to the table of
			* active users, or updates timestamp if already there.
			*/
			public function addActiveUser($username,$time) {
				if ($this->ANIDBTYPE==='MySQLi') {
					$q="UPDATE ".TBL_USERS." SET timestamp = '$time' WHERE username='$username'";
					$this->query($q);
					
					if (!TRACK_VISITORS)
						return;
					
					$q="REPLACE INTO ".TBL_ACTIVE_USERS." VALUES ('$username','$time')";
					$this->query($q);
					$this->calcNumActiveUsers();
				}
				else if ($this->ANIDBTYPE==='PDO') {
					$q=array("timestamp" => "$time");
					$this->ANIDB->UpdatePTC(TBL_USERS,$q,"username=$username",'');
					
					if (!TRACK_VISITORS)
						return;
					$q=array(
						"username" => "$username",
						"timestamp" => "$time"
					);
					$result=$this->ANIDB->InsertPTC(TBL_ACTIVE_USERS,$q,true);
					$this->calcNumActiveUsers();
				}
			}
			
			/* addActiveGuest - Adds guest to active guests table */
			public function addActiveGuest($ip,$time) {
				if ($this->ANIDBTYPE==='MySQLi') {
					if (!TRACK_VISITORS)
						return;
					
					$q="REPLACE INTO ".TBL_ACTIVE_GUESTS." VALUES ('$ip','$time')";
					$this->query($q);
					$this->calcNumActiveGuests();
				}
				else if ($this->ANIDBTYPE==='PDO') {
					if (!TRACK_VISITORS)
						return;
					
					$q=array(
						"ip" => "$ip",
						"timestamp" => "$time"
					);
					$result=$this->ANIDB->InsertPTC(TBL_ACTIVE_GUESTS,$q,true);
					$this->calcNumActiveGuests();
				}
			}
			
			/* removeActiveUser */
			public function removeActiveUser($username) {
				if ($this->ANIDBTYPE==='MySQLi') {
					if (!TRACK_VISITORS)
						return;
					
					$q="DELETE FROM ".TBL_ACTIVE_USERS." WHERE username = '$username'";
					$this->query($q);
					$this->calcNumActiveUsers();
				}
				else if ($this->ANIDBTYPE==='PDO') {
					if (!TRACK_VISITORS)
						return;
					
					$this->ANIDB->DeletePTC(TBL_ACTIVE_USERS," username = '$username'",'');
					$this->calcNumActiveUsers();
				}
			}
			
			/* removeActiveGuest */
			public function removeActiveGuest($ip) {
				if ($this->ANIDBTYPE==='MySQLi') {
					if (!TRACK_VISITORS)
						return;
					
					$q="DELETE FROM ".TBL_ACTIVE_GUESTS." WHERE ip='$ip'";
					$this->query($q);
					$this->calcNumActiveGuests();
				}
				else if ($this->ANIDBTYPE==='PDO') {
					if (!TRACK_VISITORS)
						return;
					
					$this->ANIDB->DeletePTC(TBL_ACTIVE_GUESTS," ip='$ip'",'');
					$this->calcNumActiveUsers();
				}
			}
			
			/* removeInactiveUsers */
			public function removeInactiveUsers() {
				if ($this->ANIDBTYPE==='MySQLi') {
					if (!TRACK_VISITORS)
						return;
					
					$timeout=time()-USER_TIMEOUT*60;
					$q="DELETE FROM ".TBL_ACTIVE_USERS." WHERE (timestamp<$timeout)";
					$this->query($q);
					$this->calcNumActiveUsers();
				}
				else if ($this->ANIDBTYPE==='PDO') {
					if (!TRACK_VISITORS)
						return;
					
					$timeout=time()-USER_TIMEOUT*60;
					$this->ANIDB->DeletePTC(TBL_ACTIVE_USERS," (timestamp<$timeout)",'');
					$this->calcNumActiveUsers();
				}
			}
			
			/* removeInactiveGuests */
			public function removeInactiveGuests() {
				if ($this->ANIDBTYPE==='MySQLi') {
					if (!TRACK_VISITORS)
						return;
					
					$timeout=time()-GUEST_TIMEOUT*60;
					$q="DELETE FROM ".TBL_ACTIVE_GUESTS." WHERE (timestamp<$timeout)";
					$this->query($q);
					$this->calcNumActiveGuests();
				}
				else if ($this->ANIDBTYPE==='PDO') {
					if (!TRACK_VISITORS)
						return;
					
					$timeout=time()-GUEST_TIMEOUT*60;
					$this->ANIDB->DeletePTC(TBL_ACTIVE_GUESTS," (timestamp<$timeout)",'');
					$this->calcNumActiveGuests();
				}
			}
			
			/**
			* query - Performs the given query on the database and
			* returns the result, which may be false, true or a
			* resource identifier.
			*/
			public function query($query) {
				if ($this->ANIDBTYPE==='MySQLi') {
					return ($this->ANIDB->ExecuteCommand($query));
				}
				else if ($this->ANIDBTYPE==='PDO') {
					return ($this->ANIDB->ExecuteCommand($query,''));
				}
			}
			
			/** 
			 * fetchArray - get active username(s) from TBL_USERS table
			 * and return with usernames between semicolon
			 * or only a string with all of usernames without semicolon
			*/
			public function fetchArray($query='',$completeArray='') {
				$uname='';
				
				if ($this->ANIDBTYPE==='MySQLi') {
					if ($completeArray==='array') {
						while ($row=$this->ANIDB->FetchArray($query))
							$uname.=$row['username'].';';
						
						return ($uname);
				 }
					
					return ($this->ANIDB->FetchArray($query));
				}
				else if ($this->ANIDBTYPE==='PDO') {
					if ($completeArray==='array') {
						foreach ($query as $result)
							$uname.=$result['username'].';';
						
						return ($uname);
					}
				}
			}
			
			/** 
			 * numRows - get the number of rows in a result
			*/
			public function numRows($query) {
				if ($this->ANIDBTYPE==='MySQLi') {
					return ($this->ANIDB->NumRows($query));
				}
				else if ($this->ANIDBTYPE==='PDO') {
					return ($this->ANIDB->affectedRows());
				}
			}
			
			/** 
			 * fetchAssoc - return an associative array
			 * that corresponds to the fetched row or NULL
			 * if there are no more rows.
			*/
			public function fetchAssoc($query) {
				if ($this->ANIDBTYPE==='MySQLi') {
					return ($this->ANIDB->FetchAssoc($query));
				}
				else if ($this->ANIDBTYPE==='PDO') {
					$res=array();
					
					foreach ($query as $a) {
						foreach ($a as $b) {
							$res[]=$b;
						}
					}
					
					return ($res);
				}
			}
			
			/**
			 * getCurrentConnection - get the current connection
			*/
			public function getCurrentConnection() {
				if ($this->ANIDBTYPE==='MySQLi') {
					return ($this->ANIDB->GetLink());
				}
				else if ($this->ANIDBTYPE==='PDO') {
					
				}
			}
			
			/**
			 * getCurrentInterface - get the current connection interface
			*/
			public function getCurrentInterface() {
				if ($this->ANIDBTYPE==='MySQLi') {
					return ($this->ANIDB->IFace());
				}
				else if ($this->ANIDBTYPE==='PDO') {
					
				}
			}
			
			/**
			 * correctBlogContent - if the current blog content contains
			 * an apostrophe (') then we need to insert a backslash
			 * before any apostrophe to accept the current SQL command
			*/
			public function correctBlogContent($currContent) {
				$result='';
				
				for ($i=0;$i<strlen($currContent);$i++) {
					if ($currContent[$i]=='\'') {
						$result.='\\'.'\'';
					}
					else
						$result.=$currContent[$i];
				 }
				
				return ($result);
			}
			
			/**
			 * correctImagePath - if the current image path contains
			 * a backslash (\) then we need to insert a new one
			 * before any backslash to store the current SQL command
			*/
			public function correctImagePath($currImagePath) {
				$result='';
				
				/**
         * any Windows operating system always uses the backslash (\) to sign
         * all directories and files pathes. if we want to store it in a database
         * then we need to supplement our full path with a new backslash (\) sign
         * in every places where to find backslash at all
				**/
        for ($i=0;$i<strlen($currImagePath);$i++) {
					if ($currImagePath[$i]=='\\') {
						$result.='\\\\';
					}
					else
						$result.=$currImagePath[$i];
				 }
        
				return $result;
			}
			
			/**
			 * addNewBlog - insert into the table a new blogm which can be
			 * a new note or a new complete blog
			*/
			public function addNewBlog($username,$timestamp,$ipAddress,$title,$content,$note,$link,$image) {
				$image=$this->correctImagePath($image);
				$content=$this->correctBlogContent($content);
				 
				if ($this->ANIDBTYPE==='MySQLi') {
					$q="INSERT INTO ".TBL_BLOGS."(username,timestamp,ipAddress,title,content,note,link,image,active)
							VALUES ('$username','$timestamp','$ipAddress','$title','$content','$note','$link','$image','1')";
					
					return ($this->query($q));
				}
				else if ($this->ANIDBTYPE==='PDO') {
					echo $this->ANIDBTYPE;
					$q=array(
							"username" => "$username",
							"timestamp" => "$timestamp",
							"ipAddress" => "$ipAddress",
							"title" => "$title",
							"content" => "$content",
							"note" => "$note",
							"link" => "$link",
							"image" => "$image",
							"active" => "1"
					);
					return ($this->ANIDB->InsertPTC(TBL_BLOGS,$q));
				}
			}
			
			/**
			* readSavedBlog - Returns the result array from a mysql
			* query asking for all information stored regarding
			* the saved blogs. If query fails, NULL is returned.
			*/
			public function readSavedBlog($currCommand) {
				if ($this->ANIDBTYPE==='MySQLi') {
					if ($currCommand!='')
						$result=$this->query($currCommand);
					
					return ($result);
				}
				else if ($this->ANIDBTYPE==='PDO') {
					if ($currCommand!='')
						$result=$this->query($currCommand);
					
					return ($result);
				}
			}
	 };
	 
	/* Create database connection */
	$database = new ANISQLDB(API);
?>