<?php
  /**
   * Session Manager Tool class
   * a session manager which can be used with files and databases
  */
  
  class SessionFileManagerTool {
    /* session name */
    private static $sess_Name;
    /* session lifetime */
    private static $sess_Limit;
    /* session path */
    private static $sess_Path;
    /* session domain name */
    private static $sess_Domain;
    /* any message from the class */
    private static $sess_Message;
    
		/* private constructor - cannot make a new object from the class */
    private function __construct() {
		}
		
		/* init a running session: add new parameter(s) */
		public static function InitSession($name='',$limit=0,$path='/',$domain=null) {
			self::$sess_Name=$name;
			self::$sess_Limit=$limit;
			self::$sess_Path=$path;
			self::$sess_Domain=$domain;
			
      // set the cookie name before we start
      session_name(self::$sess_Name.'_session');
      // set the domain to default to the current domain
			$domain=isset(self::$sess_Domain) ? self::$sess_Domain : isset($_SERVER['SERVER_NAME']);
      // Set the cookie settings and start the session
			session_set_cookie_params(self::$sess_Limit,self::$sess_Path,self::$sess_Domain);
			
			// Reset session data and regenerate ID
			$_SESSION=array();
			// set the current IP address and browser
			$_SESSION['IPaddress']=$_SERVER['REMOTE_ADDR'];
			$_SESSION['userAgent']=$_SERVER['HTTP_USER_AGENT'];
    }
    
    /* returns with the actual message */
    public static function GetMessageSession() {
      return (self::$sess_Message);
    }
    
    /* returns with the current name of a session */
    public static function GetSessionName() {
			return (self::$sess_Name);
    }
    
    /**
     * returns with a session parameters:
     * "lifetime" - the lifetime of the cookie in seconds
     * "path" - the path where information is stored.
     * "domain" - the domain of the cookie
     * "secure" - the cookie should only be sent over secure connections
     * "httponly" - the cookie can only be accessed through the HTTP protocol
     */
    public static function GetSessionParameters() {
      return (session_get_cookie_params());
    }
		
		/* http://stackoverflow.com/questions/3770150/php-make-session-expire-after-x-minutes */
    /* http://stackoverflow.com/questions/520237/how-do-i-expire-a-php-session-after-30-minutes */
		/* check wheter the current session has been expired */
		public static function CheckSessionExpiration($lastActivityName,$createdName,$lastActivityTimeStamp,
																									$uidName='userID',$uid='',$name,$limit,$path,$domain) {
			/* if the session has been created and the session has been expired after last request
				 then the session will be destroyed */
			if (isset($_SESSION[$lastActivityName])&&(time()-$_SESSION[$lastActivityName]>$lastActivityTimeStamp)) {
				/* unset $_SESSION variable for the run-time */
				session_unset();
				/* destroy session data in storage */
				session_destroy();
				/* create the new session with standard parameters */
				self::InitSession($name,$limit,$path,$domain);
			}
			/* update always last activity time stamp */
			$_SESSION[$lastActivityName]=time();
			
			/* if the session created time has not been created then it will do it */
			if (!isset($_SESSION[$createdName])) {
				/* create in the session the userID */
				if (!isset($_SESSION[$uidName]))
					$_SESSION[$uidName]=$uid;
				/* create the session start time stamp in the session */
				$_SESSION[$createdName]=time();
			}
			/* if the current session has been expired and is active then it will be regenerated */
			else if (time()-$_SESSION[$createdName]>$lastActivityTimeStamp) {
				/* change session ID for the current session an invalidate old session ID */
				session_regenerate_id(true);
				/* update creation time */
				$_SESSION[$createdName]=time();
			}
		}
    
		/* add a new parameter and a new value to a session */
    public static function StartSession($sessParam,$sessValue) {
      // Ensure session has not expired, destroying it if it has
			if (SessionFileManagerTool::ValidateSession()) {
        // Check to see if the current session is new or a hijack attempt
				if (SessionFileManagerTool::SecurityCheck()) {
					$_SESSION[$sessParam]=$sessValue;
          //$_SESSION[$sessParam]=$this->MD5Value($sessValue);
				}
				else if (rand(1,100)<=5) {
					SessionFileManagerTool::RegenerateSession();
				}
			}
			else {
				$_SESSION=array();
				session_destroy();
				session_start();
			}
    }
    
    /**
		 * Regenerates the session, allowing time for AJAX requests to complete.
		*/
		public static function RegenerateSession() {
			// If this session is obsolete it means that there's already a new id.
			if(isset($_SESSION['OBSOLETE']) || $_SESSION['OBSOLETE'] == true)
				return;
			
			// Set the current session to expire in 10 seconds (AJAX fix)
			$_SESSION['OBSOLETE']=true;
			$_SESSION['EXPIRES']=time() + 10;
			// Create a new session without destroying the old one
			session_regenerate_id(false);
			// Grab the current SESSIONID and close both sessions so other scripts may use them
			$new_session=session_id();
			session_write_close();
			// Set SESSIONID to the new session, starting it back up again
			session_id($new_session);
			session_start();
			// Finally, unset the obsolete and expiration flags for the new session we're keeping
			unset($_SESSION['OBSOLETE']);
			unset($_SESSION['EXPIRES']);
		}
		
		/**
		 * Security checking module.
		 * Checks to see if either:
		 * <ol>
		 * <li>A new session has been started</li>
		 * <li>The current session is loaded by a host with a different IP or user-agent</li>
		 * </ol>
		 * 
		 * If either of the above two cases are met, the method returns FALSE.  Else, it
		 * returns TRUE.
		*/
		protected static function SecurityCheck() {
			if(!isset($_SESSION['IPaddress']) || !isset($_SESSION['userAgent']))
				return false;
			
			if($_SESSION['IPaddress']!=$_SERVER['REMOTE_ADDR'])
				return false;
			if($_SESSION['userAgent']!=$_SERVER['HTTP_USER_AGENT'])
				return false;
			
			return true;
		}
		
		/**
		 * Validates the session.
		 * Checks whether the session is valid by checking whether
		 * the OBSOLETE and/or EXPIRES flags are set.
		*/
		protected static function ValidateSession() {
			if (isset($_SESSION['OBSOLETE']) && !isset($_SESSION['EXPIRES']))
				return false;
			
			if (isset($_SESSION['EXPIRES']) && $_SESSION['EXPIRES'] < time())
				return false;
			
			return true;
		}
  }
  
?>