<?php
   /**
   * UserInfo.php
   *
   * This page is for users to view their account information
   * with a link added for them to edit the information.
   *
   */
   include('_include/session.php');
   if (PROG_LANG=='') {
      die ("Current language has not been set!");
   }
   else {
      if (file_exists('_lang/'.PROG_LANG.'.php')) {
         include('_lang/'.PROG_LANG.'.php');
      }
      else {
         die ("Current language file (_lang/".PROG_LANG.".php) does not exist!");
      }
   }
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" >
<html xmlns="http://www.w3.org/1999/xhtml" lang="hu" xml:lang="hu">
<head>
<?php include('header.php'); ?>
<title><?php echo PROG_NAME."'s Userinfo Page"; ?></title>
</head>

<body>
<!-- FULL CONTENT DIV -->
<div id="fullContent"><?php echo $LNG_018; ?>
<?php
   /* Requested Username error checking */
   //$req_user = trim($_GET['user']);
   $req_user = trim($session->username);
   if (!$req_user || strlen($req_user) == 0 ||
      !preg_match("/^([áéíóöőúüűÁÉÍÓÖŐÚÜŰ0-9.a-zA-Z\s])+$/", $req_user) ||
      !$database->usernameTaken($req_user)) {
      die($LNG_048);
   }

   /* Logged in user viewing own account */
   if (strcmp($session->username,$req_user) == 0) {
      echo "<div id=\"headerUserInfo\">";
      echo '<h1>'.$LNG_049.'</h1>';
      echo "</div>";
   }
   /* Visitor not viewing own account */
   else {
      echo "<div id=\"headerUserInfo\">";
      echo '<h1>'.$LNG_050.'</h1>';
      echo "</div>";
   }

   /* Display requested user information */
   $req_user_info = $database->getUserInfo($req_user);
   
   /* Username */
   echo "<div id=\"dataUserInfo\">";
   echo '<b>'.$STD_001.'&nbsp;</b>'.$req_user_info['username'].'<br>';
   
   /* Email */
   echo '<b>'.$STD_006.'</b> '.$req_user_info['email'].'<br>';
   echo "</div>";
   
   /**
    * Note: when you add your own fields to the users table
    * to hold more information, like homepage, location, etc.
    * they can be easily accessed by the user info array.
    *
    * $session->user_info['location']; (for logged in users)
    *
    * ..and for this page,
    *
    * $req_user_info['location']; (for any user)
    */
   
   /* If logged in user viewing own account, give link to edit */
   echo "<div id=\"buttonUserInfo\">";
   if (strcmp($session->username,$req_user) == 0) {
      if (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE')) {
         echo "<input type=\"button\" onclick=\"window.location.href('useredit.php?u=".$session->username."');\" value=\"$LNG_051\">";
         /* Link back to main */
         //echo "<button onclick=\"window.location.href('entry.php');\">$LNG_004</button>";
         echo "<input type=\"button\" onclick=\"window.location.href('entry.php?u=".$session->username."');\" value=\"$LNG_004\">";
      }
      else {
         echo "<a href=\"useredit.php?u=".$session->username."\"><input type=\"button\" value=\"".$LNG_051."\" /></a>";
         /* Link back to main */
         echo "<a href=\"entry.php?u=".$session->username."\"><input type=\"button\" value=\"".$LNG_004."\" /></a>";
      }
   }
   echo "</div>";
?>
</div>
</body>
</html>