<?php
class HtpasswdTool {
	// Globally accessable variables
	var	$VERSION='Revision 0.1.1';
	// Set this to the user ID of the process this program runs as
  // Used for sanity checking. Defaults to same ID as the file calling it
  //var $UID=getmyuid();
	// Set to true for M$ BloatWare servers
  var $WIN32=false;
	// Filename Holder
  var $FILE='';
	// Last error message
  var $ERROR='';
	// Is the FILE empty?
  var $EMPTY=false;
	// Raw htpasswd contents
  var $CONTENTS='';
	// check whether $FILE exists or not
  var $EXISTS=false;
	// check whether $FILE passes all tests or not
  var $SANE=false;
	// check whether a user is an idiot or not
  var $IDIOT=false;
	// logs errors to error_log if set
  var $DEBUG=false;
	// Array of [index#][(user|pass)]=value
  var $USERS=array();
	// Counter - total number of users in $FILE
  // Zero based indexing on $USERS
  var $USERCOUNT=0;

  //	An auto-constructor, can initilize the filename when
  //	called from new()
  public function __construct($passwdFile='') {
		global $php_errormsg;
		ini_set('track_errors',1);
		
		if (!empty($passwdFile)) {
			$this->initialize($passwdFile);
		}
		
		if (strtoupper(substr(PHP_OS, 0, 3))==='WIN') {
			$this->WIN32=true;
		}
		
		return;
	}
  
  // The Initialize function sets up the FILE, checks it
  // for sanity, then loads it into the processes memory
  // htReadFile() should only be called using this method
	private function Initialize($passwdFile) {
		$this->FILE=$passwdFile;
		// Seed the random number gen
    srand((double)microtime()*1000000);
		if (empty($passwdFile)) {
			// PHP is going to bitch about this, this is here just because
			$this->error('Invalid initialize() or new() method:
                   No file specified!',1);
			// just in case
      exit;
		}
		if (file_exists($this->FILE)) {
			$this->EXISTS=true;
			if ($this->sane($this->FILE)) {
				$this->SANE=true;
				$this->htReadFile();
			}
			else {
				// Preserve the error generated by sane()
				return;
			}
		}
		else {
			// Non-existant files are safe
      $this->SANE=true;
		}
		return;
	}
  
  // Turns off sanity checking. Needless to say if you do this
  // you're an idiot, but I'll give you the rope...
	public function DoNotBlameCDI() {
		$this->IDIOT=true;
		$this->error('No sanity checking on files.',0);
		return;
	}
  
  // Checks file sanity. Can be called publicly, giving the
  // full path to the file to be checked.
  // Can be disabled if you're an idiot by
  // calling $Htpasswd->do_not_blame_cdi()
	public function Sane($filename) {
		if ($this->IDIOT) {
			return true;
		}
		// If it's a Win32 box, there's no sense in doing all this
		if ($this->WIN32) {
			// You're on your own
			return true;
		}
		//	Some kind of *nix machine - let's do some
		//	rudimentary checks
		if (!(is_readable($filename))) {
			$this->error('File ['.$filename.'] not readable.',0);
			return false;
		}
		if (!(is_writeable($filename))) {
			$this->error('File ['.$filename.'] not writeable.',0);
			return false;
		}
		if (is_dir($filename)) {
			$this->error('File ['.$filename.'] is a directory.',0);
			return false;
		}
		if (is_link($filename)) {
			$this->error('File ['.$filename.'] is a symlink.',0);
			return false;
		}
		// I had a lot of routines in here to do a lot of checking
		// on the file permissions and you know what? That
		// ain't my job. It's yours
		// File is assumed to be sane - too bad I'm not.
		return true;
	}
  
  //	Not really needed but it's a legacy thing...
	public function Version() {
		return $this->VERSION;
	}
  
  // Error handling. Fatals immediately exit the program (very
  // few errors generate a fatal exit. Most just carp a warning
  // and continue. Logged via error_log method
	public function Error($errMsg,$die) {
		$this->ERROR = $errMsg;
		// croak or carp?
		// If logging is turned off AND this is not
		// a Fatal error, just return
		if ((!($this->DEBUG)) && ($die!=1)) {
			return;
		}
		if ($this->DEBUG) {
			error_log($this->ERROR,0);
		}
		if ($die==1) {
			echo '<b>ERROR : '.$this->ERROR.'</b><br><br>';
			exit;
		}
		return;
	}
  
  // Internal function to read the FILE and process it's contents
  // Can be called publicly to re-read the file, but why would
  // you want to introduce another series of system calls like that?
  // This does the lions share of the work. This should only be
  // called once per process, and it should be called internally
  // by the initialize method. Have I mentioned that enough yet?
	public function HtReadFile() {
		$Mytemp=array();
		$Myjunk=array();
		$Junk=array();
		$count=0;
		$user='';
		$pass='';
		$temp='';
		$key='';
		$val='';
		$filesize=0;
		$errno=0;
		$empty=false;
		$contents='';
		$filename=$this->FILE;
		$filesize=filesize($filename);
		if ($filesize<3) {
      $empty=true;
    }
		// Why did I pick 3? I do not know - seemed like the number
		// to use at the time
		// (Actually, think [char]:[\n], the absolute smallest
		// size a "legitimate" password file can ever be.)
		if (!($empty)) {
			$this->EMPTY=false;
			$fd=fopen($filename,"r");
			if (empty($fd)) {
				$this->error('FATAL File access error ['.$php_errormsg.']',1);
				// Just in case
        exit;
			}
			$contents=fread($fd,filesize($filename));
			fclose($fd);
			$this->CONTENTS=$contents;
			$Mytemp=preg_split("/\n/",$contents);
			for($count=0;$count<count($Mytemp);$count++) {
				$user='';
				$pass='';
				if (empty($Mytemp[$count])) {
          break;
        }
				if (preg_match("/^(\n|\W)(.?)/",$Mytemp[$count]))	{
          break;
        }
				if (!(preg_match("/:/",$Mytemp[$count]))) {
					$user=$Mytemp[$count];
					$errno=($count+1);
					$this->error('FATAL invalid user ['.$user.']
                       on line ['.$errno.'] in ['.$filename.']',1);
				}
				list($user,$pass)=preg_split("/:/",$Mytemp[$count]);
				if (($user!='') && ($pass!='')) {
					$Myjunk[$count]['user']=$user;
					$Myjunk[$count]['pass']=$pass;
				}
			}
			$this->USERS=$Myjunk;
			$this->USERCOUNT=$count;
		}
		else {
			// Empty file. Label it as such
			$this->USERS=$Myjunk;
			$this->USERCOUNT=-1;
			$this->EMPTY=true;
		}
		return;
	}
  
  // Given a plain text password and salt, returns crypt() encrypted
  // version. If salt is not passed or referenced, it will generate
  // a random salt automatically
	public function CryptPass($passwd,$salt='') {
		if (!($passwd)) {
			// Return what we were given
			// If calling this directly, do something like
			// $enc_pass = $Htpasswd->cryptPass($pass);
			// if (empty($enc_pass)) { BARF! }
			// You should really verify the data before calling
			// this though - I do.			
			return '';
		}
		if (!empty($salt)) {
			// Make sure only use 2 chars
			$salt=substr($salt,0,2);
		}
		else {
			// If no salt, generate a (pseudo) random one
			$salt=$this->genSalt();
		}
		
    return (crypt($passwd, $salt));
	}
  
  //	Returns true if UserID is found in the password file, false otherwise
	public function IsUser($UserID) {
		$key='';
		$val='';
		$user='';
		$pass='';
		$found=false;
		if (empty($UserID))	{
      return false;
    }
		if ($this->EMPTY)	{
      return false;
    }
		for ($count=0;$count<=$this->USERCOUNT;$count++) {
			if ($UserID==$this->USERS[$count]['user']) {
				$found=true;
			}
    }
		
    return $found;
  }
  
  // Fetches the encrypted password from the password
  // file and returns it. Returns null on failure
	public function GetPass($UserID) {
		$key='';
		$val='';
		$user='';
		$pass='';
		$usernum=-1;
		if ($this->EMPTY) {
      return $pass;
    }
		if (empty($UserID)) {
      return $pass;
    }
		if (!($this->isUser($UserID))) {
      return $pass;
    }
		$usernum=$this->getUserNum($UserID);
		if($usernum == -1) {
      return false;
    }
		$pass=$this->USERS[$usernum]['pass'];
		
    return $pass;
  }
  
  //	Returns true if Users' password is authenticated, false otherwise
  //	$Pass should be passed in un-encrypted
	public function VerifyUser($UserID,$Pass) {
		$pass='';
		$match=false;
		$usernum=-1;
		$salt='';
		if ($this->EMPTY) {
      return false;
    }
		if (empty($UserID)) {
      return false;
    }
		if (empty($Pass)) {
      return false;
    }
		if (!($this->isUser($UserID))) {
      return false;
    }
		$usernum=$this->getUserNum($UserID);
		if($usernum==-1) {
      return false;
    }
		$pass=$this->USERS[$usernum]['pass'];
		$salt=substr($pass,0,2);
		$Pass=$this->cryptPass($Pass,$salt); 
		if ($pass==$Pass) {
			$match=true;
		}
		
    return $match;
  }
  
  // Changes an existing users password
  // If "oldPass" is null or if oldPass is not passed to this method,
  // there is no checking to be sure it matches their old password
  // Needless to say, you shouldn't do that, but I'll give you the rope...
  // NewPass should be passed to this method un-encrypted
  // Returns true on success, false on failure
	public function ChangePass($UserID,$newPass,$oldPass='') {
		$passwdFile=$this->FILE;
		$pass='';
		$newname;
		$newpass;
    
		// Can't very well change the password of a non-existant
		// user now can we?
		if ($this->EMPTY) {
      return false;
    }
		if (empty($UserID)) {
      return false;
    }
		if (!($this->isUser($UserID))) {
			// No sniffing for valid user IDs please
			$this->error('changePass failure for ['.$UserID.']:
                   Authentication Failure.',0);
			return false;
		}
		if (empty($newPass)) {
			$this->error('changePass failure - no new password submitted.',0);
			return false;
		}
		$newname=strtolower($UserID);
		$newpass=strtolower($newPass);
		if ($newname==$newpass) {
			$this->error('changePass failure: UserID and
                   password cannot be the same.',0);
			return false;
		}
		// If no old Password, don't force it to match
		// their existing password. NOT RECOMMENDED!
		// Be SURE to always send the oldPass!
		if (!(empty($oldPass))) {
			//	Must validate the user now
			if (!($this->verifyUser($UserID,$oldPass))) {
				$this->error('changePass failure for ['.$UserID.'] :
                     Authentication Failed.',0);
				return false;
			}
			// OK - so the password is valid
      // Are we planning on actually changing it?
			if ($newPass==$oldPass) {
				// Passwords are the same, no sense wasting time here
				return true;
			}
		}
		// Valid user with new password, OK to change
		$usernum=$this->getUserNum($UserID);
		if ($usernum==-1) {
      return false;
    }
		// No salt to cryptPass - generates a random one for us
		$this->USERS[$usernum]['pass']=$this->cryptPass($newPass);
		if (!($this->htWriteFile())) {
			$this->error('FATAL could not save new password file!
                   ['.$php_errormsg.']',1);
			// Just in case
      exit;
		}
    
		return true;
  }
  
  // A modified copy of changePass - changes the users name.
  // If $Pass is sent, it authenticates before allowing the change
  // Returns true on success, false if:
  // - The OldID is not found
  // - The NewID already exists
  // - The Password is sent and auth fails
	public function RenameUser($OldID,$NewID,$Pass='') {
    if ($this->EMPTY) {
      return false;
    }
		if (empty($OldID)) {
      return false;
    }
		if (empty($NewID)) {
      return false;
    }
		if (!($this->isUser($OldID))) {
			// Send an auth failure - prevents people from fishing for
			// valid userIDs.
			// YOU will know its's because User is Unknown - 
			// this error is slightly different than the real
			// authentication failure message. Compare the two
			$this->error('renameUser failure for ['.$OldID.']:
                   Authentication Failure.',0);
			return false;
		}
		if ($this->isUser($NewID)) {
			$this->error('Cannot change UserID, ['.$NewID.'] already exists.',0);
			return false;
		}
		// If no Password, force a name change, otherwise authenticate first.
		// Be SURE to always send the Pass!
		if (!(empty($Pass))) {
			//	Must validate the user now
			if (!($this->verifyUser($OldID,$Pass))) {
				$this->error('renameUser failure for ['.$OldID.'] :
                     Authentication Failed',0);
				return false;
			}
			// OK - so the password is valid - are we planning
			// on actually changing our name ?
			if ($NewID==$OldID) {
				// Nice new name ya got there Homer...
				return true;
			}
		}
		// Valid user, OK to change
		$usernum=$this->getUserNum($OldID);
		if ($usernum==-1)	{
      return false;
    }
		$this->USERS[$usernum]['user']=$NewID;
		if (!($this->htWriteFile())) {
			$this->error('FATAL could not save password file! ['.$php_errormsg.']',1);
			exit;	// just in case
		}
    
		return true;
  }
  
  // Writes the new password file. Writes a temp file first,
  // then attempts to copy the temp file over the existing file
  // Original file not harmed if this fails.
  // On success, re-calls the initialize method to re-read
  // the new password file and returns true. False on failure
	public function HtWriteFile() {
		$filename=$this->FILE;
		// On WIN32 box this should -still- work OK,
		// but it'll generate the tempfile in the system
		// temporary directory (usually c:\windows\temp)
		// YMMV - your opinion may another
		$tempfile=tempnam("/tmp","fort");
		$name='';
		$pass='';
		$count=0;
		$fd;
		$myerror='';
		if ($this->EMPTY) {
			$this->USERCOUNT=0;
		}
		if (!copy($filename, $tempfile)) {
			$this->error('FATAL cannot create backup file
                   ['.$tempfile.'] ['.$php_errormsg.']',1);
			// Just in case
      exit;
		}
		$fd=fopen($tempfile,"w");
		if (empty($fd)) {
			// In case the unlink generates a new one - we don't care if
			// the unlink fails - we're already screwed anyway
      $myerror=$php_errormsg;
			unlink($tempfile);
			$this->error('FATAL File ['.$tempfile.'] access error ['.$myerror.']',1);
			// Just in case
      exit;
		}
		for ($count=0;$count<=$this->USERCOUNT;$count++) {
			$name=$this->USERS[$count]['user'];
			$pass=$this->USERS[$count]['pass'];
			if (($name!='') && ($pass!='')) {
				fwrite($fd, "$name:$pass\n");
			}
		}
		fclose($fd);
		if (!copy($tempfile,$filename)) {
			// Stash the error, see above
			unlink($tempfile);
			$this->error('FATAL cannot copy file
                   ['.$filename.'] ['.$php_errormsg.']',1);
			// Just in case
      exit;
		}
		// Update successful
		unlink($tempfile);
		if (file_exists($tempfile)) {
			// Not fatal but it should be noted
			$this->error('Could not unlink ['.$tempfile.'] : ['.$php_errormsg.']',0);
		}
		// Update the information in memory with the new file contents
		$this->initialize($filename);
    
		return true;
	}
  
  // Should be fairly obvious - adds a user to the htpasswd file
  // Returns true on success, false on failure
	public function AddUser($UserID, $newPass) {
		$count=$this->USERCOUNT;
		if (empty($UserID)) {
			$this->error('addUser fail. No UserID.',0);
			return false;
		}
		if (empty($newPass)) {
			$this->error('addUser fail. No password.',0);
			return false;
		}
		if ($this->isUser($UserID)) {
			$this->error('addUser fail. UserID already exists.',0);
			return false;
    }
		if ($this->EMPTY) {
			$count=0;
		}
		$this->USERS[$count]['user']=$UserID;
		//	No salt to cryptPass() - will generate a random one for us
		$this->USERS[$count]['pass']=$this->cryptPass($newPass);
		if (!($this->htWriteFile())) {
			$this->error('FATAL could not add user due to file error!
                   ['.$php_errormsg.']',1);
			// Just in case
      exit;
		}
		// Successfully added user
		return true;
  }
  
  // Same as addUser, but adds the user to the password file
  // with a randomly generated password
  // Returns plain text password on success, null on failure
	public function AssignPass($UserID) {
		$pass='';
		$count=$this->USERCOUNT;
		if (empty($UserID)) {
			$this->error('assignPass fail. No UserID.',0);
			return '';
		}
		if ($this->EMPTY) {
			$count=0;
		}
		if ($this->isUser($UserID)) {
			$this->error('assignPass fail. UserID already exists.
                   Use genPass instead.',0);
			return '';
		}
		$pass=$this->genPass();
		$this->USERS[$count]['user']=$UserID;
		//	No salt to cryptPass() - will generate a random one for us
		$this->USERS[$count]['pass']=$this->cryptPass($pass);
		if (!($this->htWriteFile())) {
			$this->error('FATAL could not add user due to file error!
                   ['.$php_errormsg.']',1);
			// Just in case
      exit;
		}
		// Successfully added user
		return ($pass);
  }
  
  // Again, fairly obvious - deletes a user from the htpasswd file
  // Returns true on success, false on failure
	public function DeleteUser($UserID) {
		$found=false;
		// Can't delete non-existant UserIDs
		if ($this->EMPTY)	{
      return false;
    }
		if (empty($UserID)) {
			// PHP should complain about this, but just in case
			$this->error('deleteUser fail. No UserID to delete.',0);
			return false;
		}
		if (!($this->isUser($UserID))) {
			$this->error('Cannot delete : ['.$UserID.'] not found.',0);
			return false;
		}
		$usernum=$this->getUserNum($UserID);
		if ($usernum==-1) {
      return false;
    }
		$this->USERS[$usernum]['user']='';
		$this->USERS[$usernum]['pass']='';
		if (!($this->htWriteFile())) {
			$this->error('FATAL could not remove user due to file error!
                   ['.$php_errormsg.']',1);
			// Just in case
      exit;
		}
		// Successfully deleted user
		return true;
  }
  
  // Returns the user's UserID in the password file
  // (Glorified line number)
  // Returns -1 if not found or errors
	public function GetUserNum($UserID) {
		$count=0;
		$usernum=-1;
		$name='';
		if ($this->EMPTY) {
      return $usernum;
    }
		if (empty($UserID)) {
      return $usernum;
    }
		if (!($this->isUser($UserID))) {
      return $usernum;
    }
		for ($count=0;$count<=$this->USERCOUNT;$count++) {
			$name=$this->USERS[$count]['user'];
			if ($name!='') {
				if ($name==$UserID) {
					$usernum=$count;
					break;
				}
			}
		}
    
		return $usernum;
	}
  
  // Calculates current microtime
	public function Utime() {
		$time=explode( " ", microtime());
		$usec=(double)$time[0];
		$sec=(double)$time[1];
		
    return ($sec + $usec);
  }
  
  // Generates a pseudo random 2 digit salt
  // Method will generate different salts
  // when called multiple times by the same process
  public function GenSalt() {
		$random=0;
		$rand64='';
		$salt='';
		// Seeded via initialize()
    $random=rand();
		// Crypt(3) can only handle A-Z a-z ./
		$rand64='./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
		$salt=substr($rand64,$random  %  64,1).substr($rand64,($random/64) % 64,1);
		// Just in case
    $salt=substr($salt,0,2);
    
		return($salt);
	}
  
  // Generates a pseudo random 5 to 8 digit password
  // Method will even generate different passwords
  // when called multiple times by the same process
	public function GenPass() {
		$random=0;
		$rand78='';
		$randpass='';
		$pass='';
		$maxcount=rand(4,9);
		// The rand() limits (min 4, max 9) don't actually limit the number
		// returned by rand, so keep looping until we have a password that's
		// more than 4 characters and less than 9
		if (($maxcount>8) || ($maxcount<5)) {
			do {
				$maxcount=rand(4,9);
			} while (($maxcount>8) || ($maxcount<5));
		}
		$rand78='./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ
            !@#$%^&*()-=_+abcdefghijklmnopqrstuvwxyz';
		for ($count=0;$count<=$maxcount;$count++) {
			$random=rand(0,77);
			$randpass=substr($rand78,$random,1);
			$pass=$pass.$randpass;
		}
		// Just in case
    $pass=substr($pass,0,8);
    
		return($pass);
	}
  
  // Generates a pseudo random 5 to 8 digit User ID
  // Method will generate different User IDs
  // when called multiple times by the same process
	public function GenUser() {
		$random=0;
		$rand78='';
		$randuser='';
		$userid='';
		$maxcount=rand(4,9);
		if (($maxcount>8) || ($maxcount<5)) {
			do {
				$maxcount=rand(4,9);
			} while (($maxcount>8) || ($maxcount<5));
		}
		$rand62='0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
		for ($count=0;$count<=$maxcount;$count++) {
			$random=rand(0,61);
			$randuser=substr($rand62,$random,1);
			$userid=$userid.$randuser;
		}
		// Just in case
    $userid=substr($userid,0,8);
    
		return ($userid);
	}
}
?>