<?php
class HashTool {
	private function __construct() {
	}
	
	// URL decoding
	public static function Base64Decode($text) {
		return (base64_decode($text));
	}
	
	// URL encoding
	public static function Base64Encode($text) {
		return (base64_encode($text));
	}
	
	// checksum code
	public static function CRC32Checksum($text) {		
		return (crc32($text));
	}
	
	// encode any text with $alg type algorithm
	// $alg: 
	// md2;md4;md5;sha1;sha256;sha384;sha512;crc32b;crc32;adler32;
	// ripemd128;ripemd160;ripemd256;ripemd320;gost;whirlpool;snefru;
	// tiger128,3;tiger160,3;tiger192,3;tiger192,4;tiger128,4;tiger160,4; 
	// haval128,3;haval160,3;haval192,3;haval224,3;haval256,3;
	// haval128,4;haval160,4;haval192,4;haval224,4;haval256,4;
	// haval128,5;haval160,5;haval192,5haval224,5;haval256,5;
	public static function EncodeText($alg,$text) {
		return (hash($alg,$text));		
	}
	
	// get md5 hash code of a file
	public static function GetMD5File($filename) {
		return (md5_file($filename));	
	}
	
	// get sha1 hash code of a file
	public static function GetSHA1File($filename) {
		return (sha1_file($filename));	
	}
	
	// different hash codes can be used
	public static function MD5Encode($text) {
	  return (md5($text));
	}
	
	public static function SHA1Encode($text) {
		return (sha1($text));
	}
	// end: different hash codes can be used	
}
?>