<?php
class FileTool {
	var $STATCACHE=array();
  var $ERROR;
	var $BUFFER;
	var $TEMPDIR;
	var $REALGID;
  var $REALUID;
  var $MYSYSTEM;
  var $WANTED_PERMS;
	
	public function __construct() {
		global $php_errormsg;
		ini_set('track_errors',1);
    
    $current_user=get_current_user();
    $this->MYSYSTEM=php_uname('s');
    
    $this->ERROR='';
    $this->BUFFER=-1;
    if ($this->MYSYSTEM=='Windows NT') {
      $usrdir='C:\\Documents and Settings\\'.$current_user.
              '\\Local Settings\\Temp';
      $this->TEMPDIR=$usrdir;
    }
    else {
      $this->TEMPDIR='/home/'.$current_user;
    }
    $this->REALGID=-1;
    $this->REALUID=-1;
    $this->WANTED_PERMS='-rw-rw-rw-';
    
		return;
	}
	
	private function check_file_permission($fileName) {
    $perms=fileperms($fileName);
    if (($perms & 0xC000)==0xC000) {
      // Socket
      $info = 's';
    }
    elseif (($perms & 0xA000)==0xA000) {
      // Symbolic Link
      $info = 'l';
    }
    elseif (($perms & 0x8000)==0x8000) {
      // Regular
      $info = '-';
    }
    elseif (($perms & 0x6000)==0x6000) {
      // Block special
      $info = 'b';
    }
    elseif (($perms & 0x4000)==0x4000) {
      // Directory
      $info = 'd';
    }
    elseif (($perms & 0x2000)==0x2000) {
      // Character special
      $info = 'c';
    }
    elseif (($perms & 0x1000)==0x1000) {
      // FIFO pipe
      $info = 'p';
    }
    else {
      // Unknown
      $info = 'u';
    }
    
    // Owner
    $info.=(($perms & 0x0100) ? 'r' : '-');
    $info.=(($perms & 0x0080) ? 'w' : '-');
    $info.=(($perms & 0x0040) ?
           (($perms & 0x0800) ? 's' : 'x' ) :
           (($perms & 0x0800) ? 'S' : '-'));
    // Group
    $info.=(($perms & 0x0020) ? 'r' : '-');
    $info.=(($perms & 0x0010) ? 'w' : '-');
    $info.=(($perms & 0x0008) ?
           (($perms & 0x0400) ? 's' : 'x' ) :
           (($perms & 0x0400) ? 'S' : '-'));
    // World
    $info.=(($perms & 0x0004) ? 'r' : '-');
    $info.=(($perms & 0x0002) ? 'w' : '-');
    $info.=(($perms & 0x0001) ?
            (($perms & 0x0200) ? 't' : 'x' ) :
            (($perms & 0x0200) ? 'T' : '-'));
    
    return ($info);
  }
	
	public function FileMagic($filename) {
		// return the magic portion from the "file" command
		if (!is_file($filename))
			die (__METHOD__.' :: file does not exist');
		$hash=exec('file \"'.$filename.'\"');
		$hash_array=explode($filename.':',$hash);
		
		return (trim($hash_array[1]));
	}
	
	public function FileSize($filename) {
		if (!is_file($filename))
			die (__METHOD__.' :: file does not exist');
		
		// prevent PHP from choking
		clearstatcache();
		$file_stat=stat($filename);
		
		return $file_stat[7];
	}
	
	public function GetCurrentFilename() {
		// contains only current filename
		$myfile='';
		// get current file name: index starts with 0
		$curr_file=$_SERVER['PHP_SELF']; 
		$i=strlen($curr_file);
		while ($curr_file[$i-1]!='/') {
			$myfile.=$curr_file[$i-1]; 
			--$i;
		}
		$myfile=strrev($myfile);
		
		return ($myfile);
	}
	
	public function HumanReadableFileSize($filename) {
		// calculate file size (in human readable format)
		if ((!is_file($filename)) && (!is_integer($filename))) {
			die (__METHOD__.' :: file does not exist');
		}
		
		if (($filename+0)>0) {
			$file_size_num=$filename+0;
		}
		else {
			$file_size_num=$this->FileSize($filename);
		}
		if (($file_size_num > 1024) && ($file_size_num < (1024*750))) {
			return number_format(($file_size_num / (1024)), 3).'kB = '.
							$file_size_num.' bytes';
		}
		else if (($file_size_num > (1024*750)) && 
						 ($file_size_num < (1024*1024*750)) ) {
			return number_format(($file_size_num / (1024*1024)), 3).'MB = '.
							$file_size_num.' bytes';
		}
		else {
			return $file_size_num.' bytes'; 
		}
	}
	
	public function TransferTime($filename,$linespeed) {
		// linespeed is 14.4 for 14400, etc... (kbps)
		// returns transfer time in seconds
		if (($filename+0)>0) {
			$file_size=$filename;
		}
		else {
			$file_size=$this->FileSize($filename);
		}
		$bps=($linespeed*1000)/8;
		
		return (ceil(($file_size/$bps)));
	}
	
	// delete all cache
	public function Clear_Cache() {
		unset($this->STATCACHE);
		$this->STATCACHE=array();
		return true;
	}
  
  public function Get_Message() {
    return ($this->ERROR);
  }

	// check parameters
  // 0 - false; 1 - true
	private function Is_Sane($fileName='',$must_exist=0,$noSymLinks=0,$noDirs=0) {
    $exists=false;
    
		if (empty($fileName)) {
			return false;
		}
		if ($must_exist!=0) {
			if (!file_exists($fileName)) {
				$this->ERROR=__METHOD__.': ['.$fileName.'] does not exist.';
				return false;
			}
			$exists=true;
		}
		if ($exists) {
			if (!is_readable($fileName)) {
				$this->ERROR=__METHOD__.': ['.$fileName.'] is not readable.';
				return false;
			}
      if (!is_writeable($fileName)) {
        //$this->ERROR=__METHOD__.': ['.$fileName.'] is not writable.';
        //return false;
      }
      if ($noDirs!=0) {
				if (is_dir($fileName)) {
					$this->ERROR=__METHOD__.': ['.$fileName.'] is a directory.';
					return false;
				}
			}
			if ($noSymLinks!=0) {
				if (is_link($fileName)) {
					$this->ERROR=__METHOD__.': ['.$fileName.'] is a symlink.';
					return false;
				}
			}
		}
		
		return (true);
	}
	
	public function ReadFile($fileName='',$delimit='',$remark='' ) {
    $contents='';
		$tmpError='';
		
		if (empty($fileName)) {
			$this->ERROR=__METHOD__.': No file specified.'; 
			return false;
		}
		if (!$this->is_sane($fileName,1,0,1)) {
			// Preserve the is_sane() error msg
			return false;
		}
		$fd=fopen($fileName,"r");
		if ((!$fd) || (empty($fd))) {
			$this->ERROR=__METHOD__.': File error: ['.$php_errormsg.']';
			return false;
		}
		
		//$contents=fread($fd, filesize($fileName) );
		$ln=0;
    while ($line=fgets($fd,4096)) {
      ++$ln;
      if ($line===FALSE)
        echo ("FALSE\n");
      else {
        // check the new line, it must not include into th content:
				// [LF] in *nix, [CR] in Mac and [CR][LF] in Windows
				if (($line[2]==='') || ($line[1]==='') || ($line[0]===''))
					$tmpError.=__METHOD__.': File information: in '.$ln.'.row  has a remark.<br />';
				// if a remark character has been found
				// try to check wheter the file has been encoded with BOM
				else if ((strlen($remark)>0) &&
						(($line[0]===$remark) || ($line[3]===$remark) ||
						 ($line[4]===$remark) || ($line[5]===$remark))) {
					$tmpError.=__METHOD__.': File information: in '.$ln.'.row  has a remark.<br />';
				}
				else {
					// the delimiter will be added to the current file line
					$contents.=$line.$delimit;
				}
      }
    }
		
		$this->ERROR=$tmpError;
		fclose($fd);
    return ($contents);
	}
	
	// Read a file via fgetss(), which strips all php/html from the file
	public function StripRead($fileName='',$strip_cr=0) {
    if (empty($fileName)) {
			$this->ERROR=__METHOD__.': No file specified.'; 
			return false;
		}
		if (!$this->is_sane($fileName,1,0,1)) {
			// Preserve the error
			return false;
		}
		if ($this->BUFFER>0) {
			$buffer=$this->BUFFER;
		}
		else {
			$buffer=filesize($fileName);
		}
		
		$contents='';
		$fd=fopen($fileName,"r");
		if ((!$fd) || (empty($fd))) {
			$this->ERROR=__METHOD__.': File error: ['.$php_errormsg.']';
			return false;
		}
		while (!feof($fd)) {
			$contents.=fgetss($fd,$buffer);
		}
		fclose($fd);
    return $contents;
	}
	
	public function WriteFile($fileName,$Data) {
    if (!$this->is_sane($fileName,1,0)) {
			return (false);
    }
		$tempDir=$this->TEMPDIR;
    $tempfile=tempnam($tempDir,'cdi');
    $actualPerms='';
    
		if (!$this->is_sane($fileName,0,1,1)) {
			return false;
		}
		if (file_exists($fileName)) {
			if (!copy($fileName, $tempfile)) {
				$this->ERROR=__METHOD__.': cannot create backup file ['.
											$tempfile.'] :  ['.$php_errormsg.']';
				return false;
			}
		}
		$fd=@fopen($tempfile,"a" );
		if ((!$fd) || (empty($fd))) {
			$myerror=$php_errormsg;
			unlink($tempfile);
			$this->ERROR=__METHOD__.': ['.$tempfile.'] access error ['.$myerror.']';
			return false;
		}
		if (fwrite($fd, $Data)==false) {
      $this->ERROR=__METHOD__.': Cannot write '.$fd.
                   ' file. There is no write permission on it or it cannot be found.';
      return false;
    }
		fclose($fd);
    // check file permission we want to write
    $actualPerms=$this->check_file_permission($fileName);
    if ($this->WANTED_PERMS!=$actualPerms) {
      $this->ERROR=__METHOD__.': Cannot write the \''.$fileName.
                   '\' file. There is no write permission on it.';
      return false;
    }
		if (!copy($tempfile, $fileName)) {
			// Stash the error, see above
			$myerror=$php_errormsg;
			unlink($tempfile);
			$this->ERROR=__METHOD__.': Cannot copy file ['.
										$fileName.'] : ['.$myerror.']';
			return false;
		}
		unlink($tempfile);
		if (file_exists($tempfile)) {
			// Not fatal but it should be noted
			$this->ERROR=__METHOD__.': Could not unlink ['.
										$tempfile.'] : ['.$php_errormsg.']';
		}
		return true;
	}
	
	public function CopyFile($oldFile='',$newFile='') {
    if (empty($oldFile)) {
			$this->ERROR=__METHOD__.': oldFile not specified.';
			return false;
		}
		if (empty($newFile)) {
			$this->ERROR=__METHOD__.': newFile not specified.';
			return false;
		}
		if (!$this->is_sane($oldFile,1,0,1)) {
			// preserve the error
			return false;
		}
		if (!$this->is_sane($newFile,0,1,1)) {
			// preserve it
			return false;
		}
		// check file permission we want to write
    $actualPerms=$this->check_file_permission($newFile);
    if ($this->WANTED_PERMS!=$actualPerms) {
      $this->ERROR=__METHOD__.': Cannot write the \''.$newFile.
                   '\' file. There is no write permission on it.';
      return false;
    }
		if (!(copy($oldFile, $newFile))) {
			$this->ERROR=__METHOD__.': cannot copy file ['.
										$oldFile.'] : ['.$php_errormsg.']';
			return false;
		}
		
		return true;
	}
	
	public function Get_Files($root_dir,$fileExt='ALL_FILES') {
		$fileList=array();
		
		$this->ERROR='';
		if (!is_dir($root_dir)) {
			$this->ERROR=__METHOD__.': Sorry, ['.$root_dir.'] is not a directory.';
			return false;
		}
		
		if (empty($fileExt)) {
			$this->ERROR=__METHOD__.': No file extensions specified.';
			return false;
		}
		$open_dir = @opendir($root_dir);
		if ((!$open_dir) || (empty($open_dir))) {
			$this->ERROR=__METHOD__.': Failed to open dir ['.
										$root_dir.'] : ['.$php_errormsg.']';
			return false;
		}
		
		$fileCount = 0;
		while ($file=readdir($open_dir)) {
			if ((!is_dir($file)) && (!empty($file))) {
				if ($fileExt=='ALL_FILES') {
					$fileList[$fileCount]=$file;
					$fileCount++;
				}
				else {
					if (preg_match("/.\.($fileExt)$/",$file)) {
						$fileList[$fileCount]=$file;
						$fileCount++;
					}
				}
			}
		}
		closedir($open_dir);
		return $fileList;
	}
	
	public function Is_Owner($fileName,$uid='') {
		$this->ERROR='';
		
		if (empty($uid)) {
			if ($this->REALUID<0) {
				$tempDir=$this->TEMPDIR;
				$tempFile=tempnam($tempDir,"cdi");
				if (!touch($tempFile)) {
					$this->ERROR=__METHOD__.': Unable to create ['.$tempFile.']';
					return false;
				}
				$stats=stat($tempFile);
				unlink($tempFile);
				$uid=$stats[4];
			}
			else {
				$uid=$this->REALUID;
			}
		}
		$fileStats=stat($fileName);
		if ((empty($fileStats)) || (!$fileStats)) {
			$this->ERROR=__METHOD__.': Unable to stat ['.$fileName.']';
			return false;
		}
		$this->STATCACHE=$fileStats;
		$owner=$fileStats[4];
		if ($owner==$uid) {
			return true;
		}
		$this->ERROR=__METHOD__.': Owner ['.$owner.'] Uid ['.$uid.'] FAILED';
		return false;
	}

	public function Is_InGroup($fileName,$gid='') {
		$this->ERROR='';
		
		if (empty($gid)) {
			if ($this->REALGID<0) {
				$tempDir=$this->TEMPDIR;
				$tempFile=tempnam($tempDir,"cdi");
				if (!touch($tempFile)) {
					$this->ERROR=__METHOD__.': Unable to create ['.$tempFile.']';
					return false;
				}
				$stats=stat($tempFile);
				unlink($tempFile);
				$gid=$stats[5];
			}
			else {
				$gid=$this->REALGID;
			}
		}
		$fileStats=stat($fileName);
		if ((empty($fileStats)) || (!$fileStats)) {
			$this->ERROR=__METHOD__.': Unable to stat ['.$fileName.']';
			return false;
		}
		$this->STATCACHE=$fileStats;
		$group=$fileStats[5];
		if ($group==$gid) {
			return true;
		}
		$this->ERROR=__METHOD__.': Group ['.$group.'] Gid ['.$gid.'] FAILED';
		return false;
	}
	
	public function GetRealUID() {
		$this->ERROR='';
		
		$tempDir=$this->TEMPDIR;
		$tempFile=tempnam($tempDir,"cdi");
		if (!touch($tempFile)) {
			$this->ERROR=__METHOD__.': Unable to create ['.$tempFile.']';
			return false;
		}
		$stats=stat($tempFile);
		unlink($tempFile);
		$uid=$stats[4];
		$gid=$stats[5];
		$this->REALUID=$uid;
		$this->REALGID=$gid;
		return $uid;
	}
	
	public function GetRealGID() {
		$uid=$this->get_real_uid();
		if ((!$uid) || (empty($uid))) {
			return false;
		}
		return $this->REALGID;
	}
	
	// chop and get any extension
  public function ChopExtension($filename) {
    $ext=pathinfo($filename, PATHINFO_EXTENSION);
    
		return (preg_replace('/\.'.preg_quote($ext,'/').'$/','',$filename));
  }
	
	// get a filename without the extension
	public function FileNameWithoutExt($file) {
		$info=pathinfo($file);
    $file_name=basename($file,'.'.$info['extension']);
		
		return($file_name);
	}
}
?>