<?php
class EBuilderTool {
	private function __construct() {
	}
	
	public static function ArrayElement($array,$element) {
		return ((is_array($array)) ? $array[$element] : $array );
	}
	
	// Recursively flatten multidimensional arrays into a single
	// dimension array.
	// Parameters:
	// $inital_array - Array to be flattened.
	// Returns:
	// Single dimensional array.
	public static function FlattenArray($initial_array) {
		// handle non-array parameters
		if (!is_array($initial_array)) {
			$result_array[]=$intial_array;
			return $result_array;
		}
		// loop through entire array
		reset ($initial_array);
		$result_array=array();
		while (list($key, $val)=each($initial_array)) {
			if (is_array($val)) {
				$sub_array=EBuilderTool::FlattenArray($val);
				$result_array=((is_array($result_array)) ? 
					array_merge($result_array, $sub_array) : $sub_array);
			}
			else { 
				// if scalar
				// Use strlen instead of empty to handle "0"s
				if (!strlen($val)<1) {
					// if it is a non-numeric key...
					if (($key+0)==0) {
						$result_array[$key]=$val;
					}
					else {
						$result_array[]=$val;
					}
				}
			}
		}
				
		// return result array
		asort($result_array);
		return ($result_array);
	}
	
	// Determines if a value is in or equal to a variable
	// Parameters:
	// $haystack - Variable to search in
	// $needle - Variable to search for
	// Returns:
	// Boolean, whether variable is found.
	public static function InThis($var,$val) {
		if (!is_array($var)) {
			// handle as scalar
			if ($var==$val)
				return (true);
		}
		else {
			// handle as array
			reset($var);
			while (list ($k, $v)=each ($var)) {
				if ($v==$val)
					return (true);
			}
		}
		
		return (false);
	}
	
	// Converts email addresses and URLs into links.
	// Parameters:
	// $original - Original string to be translated.
	// Returns:
	// Linked text.
	public static function Linkify($original) {
		$s=$original;
		
		// Linkify mail addresses
		$mylink=preg_replace("/\ ([-^!#$%&'*+\/=?`{|}~.\w]+@([-a-zA-Z0-9.]+\.)[-a-z
										A-Z0-9]{2,6})/", ' <a href="mailto:\\1">\\1</a>', $s);
		
		// Linkify web addresses
		$mylink=preg_replace("/\s([a-z]*\:\/\/[A-Za-z0-9\.\/\?\&\~\%]*)\s/i", ' <a
										href="\\1">\\1</a> ', $s);
		
		return ($mylink);
	}
	
	// Prepares a string (possibly with slashes) to be displayed in
	// an HTML context.
	// Parameters:
	// $string - String to be displayed
	// $force_conversion - (optional) Do we force conversion of
	// embedded HTML tags? Defaults to false.
	// Returns:
	// HTML safe string
	public static function Prepare($string,$force_conversion=false) {
		return ((!$force_conversion && 
			(preg_match('/<[A-Z/]*>/', $string) || preg_match('/&quot;/', $string)) )
			? stripslashes($string) :	htmlentities(stripslashes($string)));
	}
	
	public static function WebLink($text, $link='') {
		if ($link=='')
			$link=$text;
			
			return ("<a href=\"$link\" "."onMouseOver=\"window.status=\".
							$text.; return true;\".onMouseOut=\"window.status=;
							return true;\">$text</a>");
	}
	
	// 1) show whether suhosin patch is available on the current webserver - analyze phpinfo()
	public static function CheckSuhosinPatchMethodOne() {
		ob_start();
		phpinfo();
		$phpinfo = ob_get_contents();
		ob_end_clean();
		// has been found 'Suhosin' string
		if (strpos($phpinfo, 'Suhosin') !== FALSE)
			return (true);
		// has not been found 'Suhosin' string
		else
			return (false);
	}
	
	// 2) show whether suhosin patch is available on the current webserver - only Linux
	public static function CheckSuhosinPatchMethodTwo() {
		if (strtoupper(substr(PHP_OS, 0, 3))==='LIN') {
      if (!extension_loaded('suhosin')) {
				if (!dl('suhosin.so')) {
        // extension not loaded
        return (false);
			}
		}
		
		// extension loaded
		return (true);
		}
		else {
			return (false);
		}
	}
	
	// 3) show whether suhosin patch is available on the current webserver - check a special value
	public static function CheckSuhosinPatchMethodThree() {
		// get length of 'suhosin.session.max_id_length' string
		// if it is not en empty string then Suhosin is installed
		return
			($isSuhosinInstalled = ini_get('suhosin.session.max_id_length') !== '');
	}
	
	// displays details of GD support on the current webserver
	public static function GDSupport() {
		echo '<div style="margin: 10px;">';
		echo '<p style="color: #444444; font-size: 130%;">GD is ';
		if (function_exists("gd_info")) {
			echo '<span style="color: #00AA00; font-weight: bold;">
						supported</span> by your server!</p>';
			$gd = gd_info();      
			foreach ($gd as $k => $v) {
				echo '<div style="width: 340px; border-bottom: 1px
							solid #DDDDDD; padding: 2px;">';
				echo '<span style="float: left;width: 300px;">' . $k . '</span> ';
				if ($v)
					echo '<span style="color: #00AA00; font-weight: bold;">Yes</span>';
				else
					echo '<span style="color: #EE0000; font-weight: bold;">No</span>';
				echo '<div style="clear:both;"><!-- --></div></div>';
			}
		}
		else {
			echo '<span style="color: #EE0000; font-weight: bold;">
				not supported</span> by your server!</p>';
		}
		echo '</div>';		
	}
	
	// get date and time location of the current webserver
	public static function GetDateTimeLocation($strAbout) {
		if ($strAbout!='') {
			$currTimeZone=new DateTimeZone($strAbout);
			
			return ($currTimeZone->getLocation());
		}
	}
  
	// get the current PHP version
	public static function PHPVersion() {
		// PHP main version
		$mainVer=0;
		// PHP sub version
		$minorVer=0;
		// PHP minor version
		$releaseVer=0;
		// complet PHP version is a double variable
		$fullVer=0.0;
		
		if (!defined('PHP_VERSION_ID')) {
			$version=explode('.', PHP_VERSION);
			define('PHP_VERSION_ID', ($version[0] * 10000 + $version[1] * 100 + $version[2]));
			define('PHP_MAJOR_VERSION',   $version[0]);
			define('PHP_MINOR_VERSION',   $version[1]);
			define('PHP_RELEASE_VERSION', $version[2]);
			
			$mainVer=(float)PHP_MAJOR_VERSION;
			$minorVer=(float)PHP_MINOR_VERSION;
			$releaseVer=(float)PHP_RELEASE_VERSION;
			$fullVer=$mainVer+$minorVer+$releaseVer;
		}
		
		return ($fullVer);
	}
	
	public static function CheckPHPVersion() {
		if (PHP_VERSION_ID < 50207) {
			define('PHP_MAJOR_VERSION',   $version[0]);
			define('PHP_MINOR_VERSION',   $version[1]);
			define('PHP_RELEASE_VERSION', $version[2]);
		}
	}
  // get current resolution
  public static function FullScreenResolution() {
    if (isset($_GET['width']) AND isset($_GET['height'])) {
      // output the geometry variables
      echo "Screen width is: ". $_GET['width'] ."<br />\n";
      echo "Screen height is: ". $_GET['height'] ."<br />\n";
    }
    else {
      // pass the geometry variables
      // (preserve the original query string
      //   -- post variables will need to handled differently)
      echo "<script language='javascript'>\n";
      echo "  location.href=\"${_SERVER['SCRIPT_NAME']}?${_SERVER['QUERY_STRING']}"
              . "&width=\" + screen.width + \"&height=\" + screen.height;\n";
      echo "</script>\n";
      exit();
    }
  }
  
  // get current height of the current full resolution in pixel
  public static function FullScreenHeight() {
    if ($_GET['height']) {
      // output the geometry variables
      return ($_GET['height']);
    }
    else {
      // pass the geometry variables
      // (preserve the original query string
      //   -- post variables will need to handled differently)
      echo "<script language='javascript'>\n";
      echo "  location.href=\"${_SERVER['SCRIPT_NAME']}?${_SERVER['QUERY_STRING']}"
              . "&width=\" + screen.width + \"&height=\" + screen.height;\n";
      echo "</script>\n";
			exit();
    }
  }
  
  // get current width of the current full resolution in pixel
  public static function FullScreenWidth() {
    if ($_GET['width']) {
      // output the geometry variables
      return ($_GET['width']);
    }
    else {
      // pass the geometry variables
      // (preserve the original query string
      //   -- post variables will need to handled differently)
      echo "<script language='javascript'>\n";
      echo "  location.href=\"${_SERVER['SCRIPT_NAME']}?${_SERVER['QUERY_STRING']}"
              . "&width=\" + screen.width + \"&height=\" + screen.height;\n";
      echo "</script>\n";
			exit();
    }
  }
  
	// get current height of the current inner resolution in pixel
  public static function InnerScreenHeight() {
    if ($_GET['innerHeight']) {
      // output the geometry variables
      return ($_GET['innerHeight']);
    }
    else {
      // pass the geometry variables
      // (preserve the original query string
      //   -- post variables will need to handled differently)
      echo "<script language='javascript'>\n";
      echo "  location.href=\"${_SERVER['SCRIPT_NAME']}?${_SERVER['QUERY_STRING']}"
              . "&innerWidth=\" + window.innerWidth + \"&innerHeight=\" + window.innerHeight;\n";
      echo "</script>\n";
			exit();
    }
  }
  
  // get current width of the current inner resolution in pixel
  public static function InnerScreenWidth() {
    if ($_GET['innerWidth']) {
      // output the geometry variables
      return ($_GET['innerWidth']);
    }
    else {
      // pass the geometry variables
      // (preserve the original query string
      //   -- post variables will need to handled differently)
      echo "<script language='javascript'>\n";
      echo "  location.href=\"${_SERVER['SCRIPT_NAME']}?${_SERVER['QUERY_STRING']}"
              . "&innerWidth=\" + window.innerWidth + \"&innerHeight=\" + window.innerHeight;\n";
      echo "</script>\n";
			exit();
    }
  }
	
	// get current height of the current inner resolution in pixel
  public static function InnerScreenHeightWithSession() {
    if ($_GET['innerHeight']) {
      $_SESSION['innerHeight']=$_GET['innerHeight'];
			echo "<script language='javascript'>\n";
      echo "  location.href=\"${_SERVER['SCRIPT_NAME']}?\\n";
      echo "</script>\n";
    }
    else {
      // pass the geometry variables
      // (preserve the original query string
      //   -- post variables will need to handled differently)
      echo "<script language='javascript'>\n";
      echo "  location.href=\"${_SERVER['SCRIPT_NAME']}?${_SERVER['QUERY_STRING']}"
              . "&innerWidth=\" + window.innerWidth + \"&innerHeight=\" + window.innerHeight;\n";
      echo "</script>\n";
			exit();
    }
  }
  
  // get current width of the current inner resolution in pixel
  public static function InnerScreenWidthWithSession() {
    if ($_GET['innerWidth']) {
      $_SESSION['innerWidth']=$_GET['innerWidth'];
			echo "<script language='javascript'>\n";
      echo "  location.href=\"${_SERVER['SCRIPT_NAME']}?\\n";
      echo "</script>\n";
    }
    else {
      // pass the geometry variables
      // (preserve the original query string
      //   -- post variables will need to handled differently)
      echo "<script language='javascript'>\n";
      echo "  location.href=\"${_SERVER['SCRIPT_NAME']}?${_SERVER['QUERY_STRING']}"
              . "&innerWidth=\" + window.innerWidth + \"&innerHeight=\" + window.innerHeight;\n";
      echo "</script>\n";
			exit();
    }
  }
}
?>