<?php
   /**
   * Mailer.php
   *
   * The Mailer class is meant to simplify the task of sending
   * emails to users. Note: this email system will not work
   * if your server is not setup to send mail.
   *
   * If you are running Windows and want a mail server, check
   * out this website to see a list of freeware programs:
   * <http://www.snapfiles.com/freeware/server/fwmailserver.html>
   *
   */
   
   class Mailer {
      /**
      * sendWelcome - Sends a welcome message to the newly
      * registered user, also supplying the username and
      * password.
      */
      var $owner='';
      
      public function __construct() {
         $this->owner=PROG_NAME;
      }
      
      public function sendWelcome($user, $email, $pass) {
         $from = "From: ".EMAIL_FROM_NAME." <".EMAIL_FROM_ADDR.">";
         $subject = $this->owner.$LNG_073;
         $body = $user.",\n\n"
                .$LNG_074.$this->owner.$LNG_075.$LNG_076
                .$STD_001.' '.$user."<br>".$STD_002.' '.$pass."<br><br>"
                .$LNG_077.$LNG_078.$LNG_079.$LNG_080.$LNG_081
                .$LNG_082.$this->owner.$LNG_075;
         
         //return mail($email,$subject,$body,$from);
         return imap_mail($email,$subject,$body,$from);
      }
      
      /**
      * sendNewPass - Sends the newly generated password
      * to the user's email address that was specified at
      * sign-up.
      */
      public function sendNewPass($user, $email, $pass){
         $from = "From: ".EMAIL_FROM_NAME." <".EMAIL_FROM_ADDR.">";
         $subject = $this->owner.$LNG_083;
         $body = $user.",<br><br>"
                .$LNG_084.$LNG_085.$LNG_086.$this->owner.$LNG_075.'<br><br>'
                .$STD_001.' '.$user."<br>"."New ".$STD_002.' '.$pass."<br><br>"
                .$LNG_087.$LNG_088.$LNG_089.$LNG_090."<br><br>"
                .$LNG_082.$this->owner.$LNG_075;
         
         //return mail($email,$subject,$body,$from);
         return imap_mail($email,$subject,$body,$from);
      }
   };
   
   /* Initialize mailer object */
   $mailer = new Mailer;
?>