<?php
  /**
   * A SMALL PICTURE GALLERY ENGINE HAS BEEN WRITTEN BY GARAI, 2013 august.
   * IT IS BASED ON EBUILDER CLASS LIBRARY COLLECTION (EBuilder CLC).
   * THIS ENGINE USES THE FileTool CLASS OF Ebuilder CLC.
   * IT CONTAINS A CONFIRURATOR AND A PROCESS SECTION.
   * I. CONFIGURATOR
   * - INCLUDE EBuilder CLC
   * - INCLUDE FileTool CLASS
   * - SET UP VARIABLES
   * II. PROCESS SECTION
   * IN THIS AREA CAN BE FOUND THE PROCESS ENGINE, WHICH IN SUCCESSFULLY
   * CASE WILL BE RETURNED AN ARRAY WITH THE CURRENT PICTURE ORDER, IN
   * UNSUCCESSFULLY CASE WILL BE RETURNED WITH AN ERROR MESSAGE. TO CALL
   * THIS ROUTINE CAN BE SUCCESSFULLY SHOW ALL NEEDED PICTURES OF ANY
   * GALLERY WITH THE CORRECT ORDER.
   * TO MAKE THE PROCESS MORE COMFORTABLE THE FOUR BASE PARAMETERS IS
   * READ FROM _display.txt FILE. TO MODIFY THE GALLERY STYLE NEED TO
   * MODIFY THE _display.txt FILE PARAMETER(S).
  */
  
  /**
   * CONFIGURATOR SECTION
  */
  // include the EBuilder engine
  if (file_exists('ebuilder/ebuilder.php'))
    require('ebuilder/ebuilder.php');
	else if (file_exists('../ebuilder/ebuilder.php'))
    require('../ebuilder/ebuilder.php');
  else if (file_exists('../../ebuilder/ebuilder.php'))
    require('../../ebuilder/ebuilder.php');
	else
		die('The EBuilder class and its database class cannot be found and loaded!');
  // create a new EBuilder object
  $EBUILDER=new Ebuilder();
  // create a new FileTool object
  $MYFILE=new FileTool();
  // current original picture files path
  $currOrigPath='';
  // current thumbs picture files path
  $currThumbsPath='';
  // save in an array all the picture files of the $currThumbsPath directory in original order
  $fileList=array();
  // current gallery name
  $galleryName='';
  // _display.txt file content in a static array
  $currConfig=array();
  
  /**
   * PROCESS SECTION
  */
  /**
   * LoadImages function parameters:
   * 
   * $tmpPicOrder:      picture order in the current gallery
   * $currPicPath:      path of all picture 
   * $currPicThumbPath: path of all thumb pictures
   * $galName:          current gallery name
   * $fileExt:          current file extension ('ALL_FILES' or an extension)
  */
  function LoadImages($tmpPicOrder,$currPicPath,$currPicThumbPath,$galName,$fileExt) {
    global $EBUILDER;
    global $MYFILE;
    global $currOrigPath;
    global $currThumbsPath;
    global $fileList;
    global $galleryName;
    // save in an array all the picture files of the $currThumbsPath directory in a user order
    $tempFileList=array();
    
    // - load the parameters -
    // create a new temporarly array to save any new order inside of the original one
    // the new order can be condescended by an array of numbers - till length of the original array
    $currOrd=$tmpPicOrder;
    // current original order of pictures
    $currOrigPath=$currPicPath;
    // current original order of thumb pictures
    $currThumbsPath=$currPicThumbPath;
    // current gallery name
    $galleryName=$galName;
    
    // get all thumbs - may be with a special extension - from the current thumbs directory
    $fileList=$MYFILE->Get_Files($currThumbsPath,$fileExt=$fileExt);
    if ($fileList) {
      if (!is_dir($currOrigPath))
        die(__METHOD__.':: '.getcwd().$currOrigPath.' directory does not exist!');
      
      // check the original and current order arrays arrays lenght
      if (count($fileList)===count($currOrd)) {
        // count the current array pointer
        $counter=0;
        while ($counter<count($fileList)) {
          // save the current picture of the original array in the temporarly one
          $tempFileList[$counter]=$fileList[$currOrd[$counter]];
          ++$counter;
        }
        // load the temporarly array into the original one
        $fileList=$tempFileList;
      }
      else {
        // if current order array is empty
        if (count($currOrd)===0)
          die(__METHOD__.':: '.'The current order array is empty!');
        // the original and current order arrays arrays lenght are different
        else
          die(__METHOD__.':: '.'Arrays have different length!');
      }
    }
    else {
      // if fileList array has problem then show the error message of the FileTool class
      die($MYFILE->Get_Message());
    }
  }
  
  function ReadDisplay($filename) {
    global $EBUILDER;
    global $MYFILE;
    // temporarly string
    $tmpString='';
    // a pointer
    $currConfigCounter=0;
    // string delimiter
    $delimit='|';
    
    if ($filename!='') {
      $fileContent=$MYFILE->ReadFile($filename,$delimit);
      
      // read the current string content
      for ($i=0; $i<strlen($fileContent); $i++) {
        // check if it can be found: '=' or ';' character
        if (($fileContent[$i]==='=') || ($fileContent[$i]===$delimit)) {
          // if there is a space char in the tmpString temporarly string
          // then it cannot be return with the correct picture path
          if (($currConfigCounter===1) || ($currConfigCounter===3)) {
            // delete last 2 characters from the current substring
            // when the currConfigCounter pointer shows 1 or 3 value
            // 1: the second parameter from the file
            // 3: the fourth parameter from the file
            $tmpString=substr($tmpString, 0, -2);
            //$tmpString=mb_substr($tmpString, 0, -2);
          }
          // save the current string into the currConfig array
          $currConfig[$currConfigCounter]=$tmpString;
          // increase the currConfigCounter pointer
          ++$currConfigCounter;
          // clear the tmpString temporarly string value
          $tmpString='';
          
        }
        // it cannot be found '=' or ';' character
        else {
          // save the next character of the fileContent string
          // in the tmpString temporarly string
          $tmpString.=$fileContent[$i];
        }
      }
    }
    else {
      die(__METHOD__.':: '.'The filename which must read is missing!!');
    }
    
    return ($currConfig);
  }
?>