<?php
class FileTool {
	var $STATCACHE=array();
  var $ERROR;
	var $BUFFER;
	var $TEMPDIR;
	var $REALGID;
  var $REALUID;
  var $MYSYSTEM;
  var $WANTED_PERMS;
	
	public function __construct() {
		global $php_errormsg;
		ini_set('track_errors',1);
    
    $current_user=get_current_user();
    $this->MYSYSTEM=php_uname('s');
    
    $this->ERROR='';
    $this->BUFFER=-1;
    if ($this->MYSYSTEM=='Windows NT') {
      $usrdir='C:\\Documents and Settings\\'.$current_user.
              '\\Local Settings\\Temp';
      $this->TEMPDIR=$usrdir;
    }
    else {
      $this->TEMPDIR='/home/'.$current_user;
    }
    $this->REALGID=-1;
    $this->REALUID=-1;
    $this->WANTED_PERMS='-rw-rw-rw-';
    
		return;
	}
	
	private function check_file_permission($fileName) {
    $perms=fileperms($fileName);
    if (($perms & 0xC000)==0xC000) {
      // Socket
      $info = 's';
    }
    elseif (($perms & 0xA000)==0xA000) {
      // Symbolic Link
      $info = 'l';
    }
    elseif (($perms & 0x8000)==0x8000) {
      // Regular
      $info = '-';
    }
    elseif (($perms & 0x6000)==0x6000) {
      // Block special
      $info = 'b';
    }
    elseif (($perms & 0x4000)==0x4000) {
      // Directory
      $info = 'd';
    }
    elseif (($perms & 0x2000)==0x2000) {
      // Character special
      $info = 'c';
    }
    elseif (($perms & 0x1000)==0x1000) {
      // FIFO pipe
      $info = 'p';
    }
    else {
      // Unknown
      $info = 'u';
    }
    
    // Owner
    $info.=(($perms & 0x0100) ? 'r' : '-');
    $info.=(($perms & 0x0080) ? 'w' : '-');
    $info.=(($perms & 0x0040) ?
           (($perms & 0x0800) ? 's' : 'x' ) :
           (($perms & 0x0800) ? 'S' : '-'));
    // Group
    $info.=(($perms & 0x0020) ? 'r' : '-');
    $info.=(($perms & 0x0010) ? 'w' : '-');
    $info.=(($perms & 0x0008) ?
           (($perms & 0x0400) ? 's' : 'x' ) :
           (($perms & 0x0400) ? 'S' : '-'));
    // World
    $info.=(($perms & 0x0004) ? 'r' : '-');
    $info.=(($perms & 0x0002) ? 'w' : '-');
    $info.=(($perms & 0x0001) ?
            (($perms & 0x0200) ? 't' : 'x' ) :
            (($perms & 0x0200) ? 'T' : '-'));
    
    return ($info);
  }
	
	public function FileMagic($filename) {
		// return the magic portion from the "file" command
		if (!is_file($filename))
			die ('File_Magic :: file does not exist');
		$hash=exec('file \"'.$filename.'\"');
		$hash_array=explode($filename.':',$hash);
		
		return (trim($hash_array[1]));
	}
	
	public function FileSize($filename) {
		if (!is_file($filename))
			die ("file_size :: file does not exist");
		
		// prevent PHP from choking
		clearstatcache();
		$file_stat=stat($filename);
		
		return $file_stat[7];
	}
	
	public function GetCurrentFilename() {
		// contains only current filename
		$myfile='';
		// get current file name: index starts with 0
		$curr_file=$_SERVER['PHP_SELF']; 
		$i=strlen($curr_file);
		while ($curr_file[$i-1]!='/') {
			$myfile.=$curr_file[$i-1]; 
			--$i;
		}
		$myfile=strrev($myfile);
		
		return ($myfile);
	}
	
	public function HumanReadableFileSize($filename) {
		// calculate file size (in human readable format)
		if ((!is_file($filename)) && (!is_integer($filename))) {
			die ('human_readable_filesize :: file does not exist');
		}
		
		if (($filename+0)>0) {
			$file_size_num=$filename+0;
		}
		else {
			$file_size_num=$this->FileSize($filename);
		}
		if (($file_size_num > 1024) && ($file_size_num < (1024*750))) {
			return number_format(($file_size_num / (1024)), 3).'kB = '.
							$file_size_num.' bytes';
		}
		else if (($file_size_num > (1024*750)) && 
						 ($file_size_num < (1024*1024*750)) ) {
			return number_format(($file_size_num / (1024*1024)), 3).'MB = '.
							$file_size_num.' bytes';
		}
		else {
			return $file_size_num.' bytes'; 
		}
	}
	
	public function TransferTime($filename,$linespeed) {
		// linespeed is 14.4 for 14400, etc... (kbps)
		// returns transfer time in seconds
		if (($filename+0)>0) {
			$file_size=$filename;
		}
		else {
			$file_size=$this->FileSize($filename);
		}
		$bps=($linespeed*1000)/8;
		
		return (ceil(($file_size/$bps)));
	}
	
	// delete all cache
	public function clear_cache() {
		unset($this->STATCACHE);
		$this->STATCACHE=array();
		return true;
	}
  
  public function get_message() {
    return ($this->ERROR);
  }

	// check parameters
  // 0 - false; 1 - true
	private function is_sane($fileName='',$must_exist=0,$noSymLinks=0,$noDirs=0) {
    $exists=false;
    
		if (empty($fileName)) {
			return false;
		}
		if ($must_exist!=0) {
			if (!file_exists($fileName)) {
				$this->ERROR='is_sane: ['.$fileName.'] does not exist.';
				return false;
			}
			$exists=true;
		}
		if ($exists) {
			if (!is_readable($fileName)) {
				$this->ERROR='is_sane: ['.$fileName.'] is not readable.';
				return false;
			}
      if (!is_writeable($fileName)) {
        //$this->ERROR='is_sane: ['.$fileName.'] is not writable.';
        //return false;
      }
      if ($noDirs!=0) {
				if (is_dir($fileName)) {
					$this->ERROR='is_sane: ['.$fileName.'] is a directory.';
					return false;
				}
			}
			if ($noSymLinks!=0) {
				if (is_link($fileName)) {
					$this->ERROR='is_sane: ['.$fileName.'] is a symlink.';
					return false;
				}
			}
		}
		
		return (true);
	}
	
	public function read_file($fileName='' ) {
    $contents='';
		if (empty($fileName)) {
			$this->ERROR='read_file: No file specified.'; 
			return false;
		}
		if (!$this->is_sane($fileName,1,0,1)) {
			// Preserve the is_sane() error msg
			return false;
		}
		$fd=fopen($fileName,"r");
		if ((!$fd) || (empty($fd))) {
			$this->ERROR='read_file: File error: ['.$php_errormsg.']';
			return false;
		}
		
		$contents=fread($fd, filesize($fileName) );
		fclose($fd);
    return ($contents);
	}
	
	// Read a file via fgetss(), which strips all php/html from the file
	public function strip_read($fileName='',$strip_cr=0) {
    if (empty($fileName)) {
			$this->ERROR='strip_read: No file specified.'; 
			return false;
		}
		if (!$this->is_sane($fileName,1,0,1)) {
			// Preserve the error
			return false;
		}
		if ($this->BUFFER>0) {
			$buffer=$this->BUFFER;
		}
		else {
			$buffer=filesize($fileName);
		}
		
		$contents='';
		$fd=fopen($fileName,"r");
		if ((!$fd) || (empty($fd))) {
			$this->ERROR='strip_read: File error: ['.$php_errormsg.']';
			return false;
		}
		while (!feof($fd)) {
			$contents.=fgetss($fd,$buffer);
		}
		fclose($fd);
    return $contents;
	}
	
	public function write_file($fileName,$Data) {
    if (!$this->is_sane($fileName,1,0)) {
			return (false);
    }
		$tempDir=$this->TEMPDIR;
    $tempfile=tempnam($tempDir,'cdi');
    $actualPerms='';
    
		if (!$this->is_sane($fileName,0,1,1)) {
			return false;
		}
		if (file_exists($fileName)) {
			if (!copy($fileName, $tempfile)) {
				$this->ERROR='write_file: cannot create backup file ['.
											$tempfile.'] :  ['.$php_errormsg.']';
				return false;
			}
		}
		$fd=@fopen($tempfile,"a" );
		if ((!$fd) || (empty($fd))) {
			$myerror=$php_errormsg;
			unlink($tempfile);
			$this->ERROR='write_file: ['.$tempfile.'] access error ['.$myerror.']';
			return false;
		}
		if (fwrite($fd, $Data)==false) {
      $this->ERROR='write_file: Cannot write '.$fd.
                   ' file. There is no write permission on it or it cannot be found.';
      return false;
    }
		fclose($fd);
    // check file permission we want to write
    $actualPerms=$this->check_file_permission($fileName);
    if ($this->WANTED_PERMS!=$actualPerms) {
      $this->ERROR='write_file: Cannot write the \''.$fileName.
                   '\' file. There is no write permission on it.';
      return false;
    }
		if (!copy($tempfile, $fileName)) {
			// Stash the error, see above
			$myerror=$php_errormsg;
			unlink($tempfile);
			$this->ERROR='write_file: Cannot copy file ['.
										$fileName.'] : ['.$myerror.']';
			return false;
		}
		unlink($tempfile);
		if (file_exists($tempfile)) {
			// Not fatal but it should be noted
			$this->ERROR='write_file: Could not unlink ['.
										$tempfile.'] : ['.$php_errormsg.']';
		}
		return true;
	}
	
	public function copy_file($oldFile='',$newFile='') {
    if (empty($oldFile)) {
			$this->ERROR='copy_file: oldFile not specified.';
			return false;
		}
		if (empty($newFile)) {
			$this->ERROR='copy_file: newFile not specified.';
			return false;
		}
		if (!$this->is_sane($oldFile,1,0,1)) {
			// preserve the error
			return false;
		}
		if (!$this->is_sane($newFile,0,1,1)) {
			// preserve it
			return false;
		}
		// check file permission we want to write
    $actualPerms=$this->check_file_permission($newFile);
    if ($this->WANTED_PERMS!=$actualPerms) {
      $this->ERROR='write_file: Cannot write the \''.$newFile.
                   '\' file. There is no write permission on it.';
      return false;
    }
		if (!(copy($oldFile, $newFile))) {
			$this->ERROR='copy_file: cannot copy file ['.
										$oldFile.'] : ['.$php_errormsg.']';
			return false;
		}
		
		return true;
	}
	
	public function get_files($root_dir,$fileExt='ALL_FILES') {
		$fileList=array();
		
		if (!is_dir($root_dir)) {
			$this->ERROR='get_files: Sorry, ['.$root_dir.'] is not a directory.';
			return false;
		}
		
		if (empty($fileExt)) {
			$this->ERROR='get_files: No file extensions specified.';
			return false;
		}
		$open_dir = @opendir($root_dir);
		if ((!$open_dir) || (empty($open_dir))) {
			$this->ERROR='get_files: Failed to open dir ['.
										$root_dir.'] : ['.$php_errormsg.']';
			return false;
		}
		
		$fileCount = 0;
		while ($file=readdir($open_dir)) {
			if ((!is_dir($file)) && (!empty($file))) {
				if ($fileExt=='ALL_FILES') {
					$fileList[$fileCount]=$file;
					$fileCount++;
				}
				else {
					if (preg_match("/.\.($fileExt)$/",$file)) {
						$fileList[$fileCount]=$file;
						$fileCount++;
					}
				}
			}
		}
		closedir($open_dir);
		return $fileList;
	}
	
	public function is_owner($fileName,$uid='') {
		if (empty($uid)) {
			if ($this->REALUID<0) {
				$tempDir=$this->TEMPDIR;
				$tempFile=tempnam($tempDir,"cdi");
				if (!touch($tempFile)) {
					$this->ERROR='is_owner: Unable to create ['.$tempFile.']';
					return false;
				}
				$stats=stat($tempFile);
				unlink($tempFile);
				$uid=$stats[4];
			}
			else {
				$uid=$this->REALUID;
			}
		}
		$fileStats=stat($fileName);
		if ((empty($fileStats)) || (!$fileStats)) {
			$this->ERROR='is_owner: Unable to stat ['.$fileName.']';
			return false;
		}
		$this->STATCACHE=$fileStats;
		$owner=$fileStats[4];
		if ($owner==$uid) {
			return true;
		}
		$this->ERROR='is_owner: Owner ['.$owner.'] Uid ['.$uid.'] FAILED';
		return false;
	}

	public function is_inGroup($fileName,$gid='') {
		if (empty($gid)) {
			if ($this->REALGID<0) {
				$tempDir=$this->TEMPDIR;
				$tempFile=tempnam($tempDir,"cdi");
				if (!touch($tempFile)) {
					$this->ERROR='is_inGroup: Unable to create ['.$tempFile.']';
					return false;
				}
				$stats=stat($tempFile);
				unlink($tempFile);
				$gid=$stats[5];
			}
			else {
				$gid=$this->REALGID;
			}
		}
		$fileStats=stat($fileName);
		if ((empty($fileStats)) || (!$fileStats)) {
			$this->ERROR='is_inGroup: Unable to stat ['.$fileName.']';
			return false;
		}
		$this->STATCACHE=$fileStats;
		$group=$fileStats[5];
		if ($group==$gid) {
			return true;
		}
		$this->ERROR='is_inGroup: Group ['.$group.'] Gid ['.$gid.'] FAILED';
		return false;
	}
	
	public function get_real_uid() {
		$tempDir=$this->TEMPDIR;
		$tempFile=tempnam($tempDir,"cdi");
		if (!touch($tempFile)) {
			$this->ERROR='is_owner: Unable to create ['.$tempFile.']';
			return false;
		}
		$stats=stat($tempFile);
		unlink($tempFile);
		$uid=$stats[4];
		$gid=$stats[5];
		$this->REALUID=$uid;
		$this->REALGID=$gid;
		return $uid;
	}
	
	public function get_real_gid() {
		$uid=$this->get_real_uid();
		if ((!$uid) || (empty($uid))) {
			return false;
		}
		return $this->REALGID;
	}
}
?>