<?php
   /**
   * Register.php
    * 
   * Displays the registration form if the user needs to sign-up,
    * or lets the user know, if he's already logged in, that he
   * can't register another name.
    *
   */
   include('_include/session.php');
   if (PROG_LANG=='') {
      die ("Current language has not been set!");
   }
   else {
      if (file_exists('_lang/'.PROG_LANG.'.php')) {
         include('_lang/'.PROG_LANG.'.php');
      }
      else {
         die ("Current language file (_lang/".PROG_LANG.".php) does not exist!");
      }
   }
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" >
<html xmlns="http://www.w3.org/1999/xhtml" lang="hu" xml:lang="hu">
<head>
<?php include('header.php'); ?>
<title><?php echo PROG_NAME.'\'s Registration Page'; ?></title>
</head>

<body>
<!-- HEADER DIV -->
<div id="headerHead">
<!-- HEADER PICTURE DIV -->
<div id="pictureHead"></div>
<!-- END: HEADER PICTURE DIV -->

<!-- MAIN MENU -->
<div id="menuHead"><?php echo $LNG_018; ?></div>
<!-- END: MAIN MENU -->

<!-- MENU UNDERLINE DIVE -->
<div id="savHead"></div>
<!-- END: MENU UNDERLINE DIVE -->
</div>
<!-- END: HEADER DIV -->

<?php
   /**
    * The user has submitted the registration form and the
    * results have been processed.
   */
   if (isset($_SESSION['regsuccess'])) {
      /* Registration was successful */
      if ($_SESSION['regsuccess']) {
         echo "<div id=\"regsuccessReg\">";
         echo '<h1>'.$STD_005.'!</h1>';
         echo '<p>'.$LNG_033.'<b>'.$_SESSION['reguname'].'</b>'.$LNG_034.$LNG_035.'</p>';
         // check the browser
         if (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE'))
            echo "<input type=\"button\" onclick=\"window.location.href('entry.php?u=".$session->username."');\" value=\"$LNG_004\">";
         else 
            echo "<a href=\"entry.php?u=".$session->username."\"><input type=\"button\" value=\"".$LNG_036."\" /></a>";
         echo "</div>";
      }
      /* Registration failed */
      else {
         echo "<div id=\"regfailedReg\">";
         echo '<h1>'.$LNG_037.'</h1>';
         echo '<p>'.$LNG_038.'<b>'.$_SESSION['reguname'].'</b>, '.$LNG_039.'</p>';
         echo "</div>";
      }
      unset($_SESSION['regsuccess']);
      unset($_SESSION['reguname']);
   }
   /**
    * The user has not filled out the registration form yet.
    * Below is the page with the sign-up form, the names
    * of the input fields are important and should not
    * be changed.
    */
   else {
?>

<!-- HEADER DIV -->
<div id="headerReg">
<h1><?php echo $LNG_040; ?></h1>
</div>
<!-- END: HEADER DIV -->

<!-- ERROR DIV -->
<div id="errorReg">
<?php
      if ($form->num_errors > 0) {
         echo "<td><font size=\"2\" color=\"#ff0000\">".$form->num_errors.$STD_007."</font></td>";
}
?>
</div>
<!-- END: ERROR DIV -->

<!-- REGISTER FORM FOR CREATING A NEW USER -->
<form action="process.php" method="POST">
<!-- DATA DIV -->
<div id="dataReg">
<table align="left" border="0" cellspacing="0" cellpadding="3">
<tr>
   <td><?php echo $STD_001; ?></td>
   <td><input type="text" name="user" maxlength="30" value="<?php echo $form->value("user"); ?>"></td>
   <td><?php echo $form->error("user"); ?></td>
</tr>
<tr>
   <td><?php echo $STD_002; ?></td>
   <td><input type="password" name="pass" maxlength="30" value="<?php echo $form->value("pass"); ?>"></td>
   <td><?php echo $form->error("pass"); ?></td>
</tr>
<tr>
   <td><?php echo $STD_006; ?></td>
   <td><input type="text" name="email" maxlength="50" value="<?php echo $form->value("email"); ?>"></td>
   <td><?php echo $form->error("email"); ?></td>
</tr>
</table>
</div>
<!-- END: DATA DIV -->

<!-- BUTTON DIV -->
<div id="buttonReg">
<input type="hidden" name="subjoin" value="1">
<input type="submit" value="<?php echo $LNG_041; ?>">
<?php
      // check the browser
      if (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE'))
         echo "<input type=\"button\" onclick=\"window.location.href('entry.php?user=".$session->username."');\" value=\"$LNG_004\">";
      else
         echo "<a href=\"entry.php?u=".$session->username."\"><input type=\"button\" value=\"".$LNG_004."\" /></a>";
?>
</div>
<!-- END: BUTTON DIV -->
</form>
<!-- END: REGISTER FORM FOR CREATING A NEW USER -->

<?php
   }
?>
</body>
</html>