<?php
   /**
   * ForgotPass.php
   *
   * This page is for those users who have forgotten their
   * password and want to have a new password generated for
   * them and sent to the email address attached to their
   * account in the database. The new password is not
   * displayed on the website for security purposes.
   *
   * Note: If your server is not properly setup to send
   * mail, then this page is essentially useless and it
   * would be better to not even link to this page from
   * your website.
   *
   */
   include('_include/session.php');
   if (PROG_LANG=='') {
      die ("Current language has not been set!");
   }
   else {
      if (file_exists('_lang/'.PROG_LANG.'.php')) {
         include('_lang/'.PROG_LANG.'.php');
      }
      else {
         die ("Current language file (_lang/".PROG_LANG.".php) does not exist!");
      }
   }
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" >
<html xmlns="http://www.w3.org/1999/xhtml" lang="hu" xml:lang="hu">
<head>
<?php include('header.php'); ?>
<title><?php echo PROG_NAME.'\'s Forgotten Password Page'; ?></title>
</head>

<body>
<!-- HEADER DIV -->
<div id="headerHead">
<!-- HEADER PICTURE DIV -->
<div id="pictureHead"></div>
<!-- END: HEADER PICTURE DIV -->

<!-- MAIN MENU -->
<div id="menuHead"><?php echo $LNG_018; ?></div>
<!-- END: MAIN MENU -->

<!-- MENU UNDERLINE DIVE -->
<div id="savHead"></div>
<!-- END: MENU UNDERLINE DIVE -->
</div>
<!-- END: HEADER DIV -->

<?php
   /**
   * Forgot Password form has been submitted and no errors
   * were found with the form (the username is in the database)
   */
   if (isset($_SESSION['forgotpass'])) {
      /**
      * New password was generated for user and sent to user's
      * email address.
      */
      if ($_SESSION['forgotpass']) {
         echo "<div id=\"forgotpwdPasswd\">";
         echo '<h1>'.$LNG_001.'</h1>';
         echo '<p>'.$LNG_002.$LNG_003;
         // check the browser
         if (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE'))
            echo "<input type=\"button\" onclick=\"window.location.href('entry.php');\" value=\"$LNG_004\">";
         else 
            echo "<a href=\"entry.php\"><input type=\"button\" value=\"".$LNG_004.".\" /></a>";
         echo '</p>';
         echo "</div>";
      }
      /**
      * Email could not be sent, therefore password was not
      * edited in the database.
      */
      else {
         echo "<div id=\"nomailPasswd\">";
         echo '<h1>'.$LNG_005.'</h1>';
         echo '<p>'.$LNG_006.$LNG_007;
         // check the browser
         if (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE'))
            echo "<input type=\"button\" onclick=\"window.location.href('entry.php');\" value=\"$LNG_004\">";
         else 
            echo "<a href=\"entry.php\"><input type=\"button\" value=\"".$LNG_004.".\" /></a>";
         echo "</p>";
         echo "</div>";
      }
      
      unset($_SESSION['forgotpass']);
   }
   else {
   /**
   * Forgot password form is displayed, if error found
   * it is displayed.
   */
?>

<!-- HEADER DIV -->
<div id="headerPasswd">
<h1><?php echo $LNG_008; ?></h1>
</div>
<!-- END: HEADER DIV -->

<!-- DATA DIV -->
<div id="dataPasswd">
<?php
      echo $LNG_009.'<br>'.$LNG_010.'<br><br>'; ?>
</div>
<!-- END: DATA DIV -->

<!-- BUTTON DIV -->
<div id="buttonPasswd">
<?php echo $form->error("user"); ?>
<form action="process.php" method="POST">
   <b><?php echo $STD_001; ?></b>
   <input type="text" name="user" maxlength="30" value="<?php echo $form->value("user"); ?>">
   <input type="hidden" name="subforgot" value="1">
   <input type="submit" value="<?php echo $LNG_011; ?>">
</form>
</div>
<!-- END: BUTTON DIV -->

<?php
   }
?>
</body>
</html>