<?php
  /**
  * blog_save.php
  * Save a new blog into the database
  */
  include('_include/session.php');
  if (PROG_LANG=='') {
    die ('Current language has not been set!');
  }
  else {
    if (file_exists('_lang/'.PROG_LANG.'.php')) {
      include('_lang/'.PROG_LANG.'.php');
    }
    else {
      die ('Current language file (_lang/'.PROG_LANG.'.php) does not exist!');
    }
  }
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" >
<html xmlns="http://www.w3.org/1999/xhtml" lang="hu" xml:lang="hu">
<head>
<?php include('header.php'); ?>
<link href="_css/blogsave.css" rel="stylesheet" type="text/css" />
<title><?php echo PROG_NAME.'\'s Blog Save Page'; ?></title>
<script type="text/javascript">
function close_window() {
    close();
}
</script>
</head>

<body>
<!-- HEADER DIV -->
<div id="headerHeadSave">
<!-- HEADER PICTURE DIV -->
<div id="pictureHeadSave"></div>
<!-- END: HEADER PICTURE DIV -->

<!-- MAIN MENU -->
<div id="menuHeadSave"><?php echo $LNG_018; ?></div>
<!-- END: MAIN MENU -->

<!-- MENU UNDERLINE DIVE -->
<div id="savHeadSave"></div>
<!-- END: MENU UNDERLINE DIVE -->
</div>
<!-- END: HEADER DIV -->

<?php
  /**
    * The user has submitted the new blog form and the
    * results have been processed.
   */
  if (isset($_SESSION['newblogsuccess'])) {
    /* Create a new blog was successful */
    if ($_SESSION['newblogsuccess']) {
      echo "<div id=\"blogsuccessBlogSave\">";
      echo '<h1>'.$LNG_BLOG_13.'</h1>';
      echo '<p>'.$LNG_BLOG_14.$LNG_BLOG_15.'</p>';
      echo "<input type=\"button\" onclick=\"window.location.href('entry.php?u=".$session->username."');\" value=\"$LNG_004\">";
      echo "</div>";
    }
    /* Create a new blog was not successful */
    else {
      echo "<div id=\"blogfailedBlogSave\">";
      echo '<h1>'.$LNG_BLOG_10.'</h1>';
      echo '<p>'.$LNG_BLOG_11.'<b>'.$_SESSION['reguname'].'</b>, '.$LNG_BLOG_12.'</p>';
      echo "</div>";
    }
    unset($_SESSION['newblogsuccess']);
  }
   /**
    * The user has not filled out the new blog form yet.
    * Below is the page with the creating form, the names
    * of the input fields are important
    */
  else {
    //die('a');
    /**
    * User has already logged in, so display relavent input types
    */
    if ($session->logged_in) {
?>

<!-- HEADER DIV -->
<div id="headerBlogSave">
<?php
      echo "<font size=\"10\">".$LNG_BLOG_01."</font>";
?>
</div>
<!-- END: HEADER DIV -->

<!-- ERROR DIV -->
<div id="errorBlogSave">
<?php
      /**
      * User not created a blog, display the new blog error form.
      * If user has already tried to create, but errors were
      * found, display the total number of errors.
      * If errors occurred, they will be displayed.
      */
      if ($form->num_errors > 0)
        echo "<font size=\"2\" color=\"#ff0000\">".$form->num_errors.$STD_007."</font>";
?>
</div>
<!-- END: ERROR DIV -->

<!-- UPLOAD AN IMAGE FORM -->
<form action="process.php" method="post" enctype="multipart/form-data">
<!-- IMAGE DIV -->
<div id="dataBlogImageSave">
<!-- THE UPLOADED MAXIMUM FILE SIZE IS 3 MB -->
<input type="hidden" name="MAX_FILE_SIZE" value="3000000" />
<label for="file"><b><?php echo $LNG_BLOG_18; ?></b></label><br />
<input id="file" type="file" name="file" size="48" value="<?php echo $form->value("blog_image"); ?>" />
<input type="submit" name="blog_image_submit" value="<?php echo $LNG_BLOG_20; ?>" />
<input type="hidden" name="subblogimage" value="1">
<div id="blog_image_error_Save"><?php echo $form->error("blog_image_error"); ?></div>
<div id="blog_image_correct_Save"><?php echo $form->correct("blog_image_correct"); ?></div>
</div>
<!-- END: IMAGE DIV -->
</form>
<!-- UPLOAD AN IMAGE FORM -->

<!-- NEW BLOG FORM FOR CREATING A NEW BLOG -->
<form action="process.php" method="post">

<!-- CONTENT DIV -->
<div id="dataBlogSave">

<!-- USERNAME DIV -->
<div id="dataBlogNameSave">
<table align="left" border="0" cellspacing="0" cellpadding="3"><tr>
<td><b><?php echo $LNG_BLOG_02; ?></b></td>
<td><input type="text" name="blog_user" maxlength="30" size="46" readonly value="<?php echo $session->username; ?>"></td>
</tr></table>
</div>
<!-- END: USERNAME DIV -->

<!-- TITLE DIV -->
<div id="dataBlogTitleSave">
<table align="left" border="0" cellspacing="0" cellpadding="3"><tr>
<td><b><?php echo $LNG_BLOG_03; ?></b></td><td></td><td></td><td></td><td></td><td></td>
<td><input type="text" name="blog_title" maxlength="30" size="46" value="<?php echo $form->value("blog_title"); ?>"></td>
<?php echo $form->error("blog_title"); ?>
</tr></table>
</div>
<!-- END: TITLE DIV -->

<!-- LINK DIV -->
<div id="dataBlogLinkSave">
<table align="left" border="0" cellspacing="0" cellpadding="3"><tr>
<td><b><?php echo $LNG_BLOG_17; ?></b></td>
<td></td><td></td><td></td><td></td><td></td>
<td></td><td></td><td></td><td></td><td></td><td></td>
<td></td><td></td><td></td><td></td><td></td><td></td>
<td><input type="text" name="blog_link" size="46" value="<?php echo $form->value("blog_link"); ?>"></td>
<td><?php echo $form->error("blog_link"); ?></td>
</tr></table>
</div>
<!-- END: LINK DIV -->

<!-- COMMENT DIV -->
<div id="dataBlogCommentSave">
<table align="left" border="0" cellspacing="0" cellpadding="3"><tr>
<td><b><?php echo $LNG_BLOG_04; ?></b><td>
<td><textarea name="blog_comment" cols="45" rows="17"><?php echo $form->value("blog_comment"); ?></textarea><td>
<?php echo $form->error("blog_comment"); ?>
</tr></table>
</div>
<!-- END COMMENT DIV -->

<!-- BUTTON DIV -->
<div id="buttonBlogSave">
<input type="hidden" name="subblogcreate" value="1">
<input type="checkbox" name="blog_note" value="Note" /><b><?php echo $LNG_BLOG_16; ?></b>
<input type="submit" value="<?php echo $LNG_BLOG_05; ?>">
<button a href="#" onclick="close_window();return false;"><?php echo $LNG_004; ?></a></button>
</div>
<!-- END: BUTTON DIV -->

</div>
<!-- END: CONTENT DIV -->
</form>
<!-- END: NEW BLOG FORM FOR CREATING A NEW BLOG -->

<?php
    }
  }
?>

</body>
</html>