<?php
   /**
   * Admin.php
   *
   * This is the Admin Center page. Only administrators
   * are allowed to view this page. This page displays the
   * database table of users and banned users. Admins can
   * choose to delete specific users, delete inactive users,
   * ban users, update user levels, etc.
   *
   */
   include('_include/session.php');
   
   if (PROG_LANG=='') {
      die ('Current language has not been set!');
   }
   else {
      if (file_exists('_lang/'.PROG_LANG.'.php')) {
         include('_lang/'.PROG_LANG.'.php');
      }
      else {
         die ('Current language file (_lang/'.PROG_LANG.'.php) does not exist!');
      }
   }
   
   /* fillOutUsername - This will fill out any combo box
    * with not deleted and banned usernames which come from
    * the database
   */
   function fillOutUsername($status) {
      global $database, $form;
      $currName = '';
      
      $sql = mysql_query("SELECT * FROM ".TBL_USERS." WHERE username!='admin' ORDER BY username ASC");
      $myfetch = $database->fetchArray($sql);
      echo "<select name=\"$status\">";
      for ($i=0; $i<strlen($myfetch); $i++) {
         if ($myfetch[$i]==';') {
            echo "<option>".$currName;
            $currName = '';
         }
         else {
            $currName .= $myfetch[$i];
         }
      }
      echo "</select>";
   }
   
   /* fillOutBannedUsername - This will fill out any combo box
    * only with banned usernames which come from the database
   */
   function fillOutBannedUsername($status) {
      global $database, $form;
      $currName = '';
      
      $sql = mysql_query("SELECT * FROM ".TBL_BANNED_USERS." ORDER BY username ASC");
      $myfetch = $database->fetchArray($sql);
      echo "<select name=\"$status\">";
      for ($i=0; $i<strlen($myfetch); $i++) {
         if ($myfetch[$i]==';') {
            echo "<option>".$currName;
            $currName = '';
         }
         else {
            $currName .= $myfetch[$i];
         }
      }
      echo "</select>";
   }
   
   /**
   * displayUsers - Displays the users database table in
   * a nicely formatted html table.
   */
   function displayUsers() {
      include('_lang/'.PROG_LANG.'.php');
      global $database;
      $ulevelText = '';
      
      $q = "SELECT username,userlevel,email,timestamp "
          ."FROM ".TBL_USERS." ORDER BY userlevel DESC,username";
      $result = $database->query($q);
      /* Error occurred, return given name by default */
      $num_rows = mysql_numrows($result);
      if (!$result || ($num_rows < 0)) {
         echo $LNG_053;
         return;
      }
      if ($num_rows == 0) {
         echo $LNG_054;
         return;
      }
      /* Display table contents */
      echo "<table align=\"left\" border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n";
      echo "<tr><td><b>$STD_001</b></td><td><b>$STD_008</b></td><td><b>$STD_006</b></td><td><b>$STD_009</b></td></tr>\n";
      for ($i=0; $i<$num_rows; $i++) {
         $uname  = mysql_result($result,$i,"username");
         $ulevel = mysql_result($result,$i,"userlevel");
         if ($ulevel == 1)
            $ulevelText = $LNG_055;
         else if ($ulevel == 9)
            $ulevelText = $LNG_056;
         $email  = mysql_result($result,$i,"email");
         $time   = mysql_result($result,$i,"timestamp");
         if (PROG_LANG=='hu')
            $datetime = date('Y.m.d H:i:s', $time);
         else
            $datetime = date('d.m.Y H:i:s', $time);
         
         echo "<tr><td>$uname</td><td>$ulevelText</td><td>$email</td><td>$datetime</td></tr>\n";
      }
      echo "</table>";
   }
   
   /**
   * displayBannedUsers - Displays the banned users
   * database table in a nicely formatted html table.
   */
   function displayBannedUsers() {
      include('_lang/'.PROG_LANG.'.php');
      global $database;
      
      $q = "SELECT username,timestamp "
          ."FROM ".TBL_BANNED_USERS." ORDER BY username";
      $result = $database->query($q);
      /* Error occurred, return given name by default */
      $num_rows = mysql_numrows($result);
      if (!$result || ($num_rows < 0)) {
         echo $LNG_053;
         return;
      }
      if ($num_rows == 0) {
         echo $LNG_054;
         return;
      }
      /* Display table contents */
      echo "<table align=\"left\" border=\"1\" cellspacing=\"0\" cellpadding=\"3\">\n";
      echo "<tr><td><b>$STD_001</b></td><td><b>$LNG_057</b></td></tr>\n";
      for ($i=0; $i<$num_rows; $i++) {
         $uname = mysql_result($result,$i,"username");
         $time  = mysql_result($result,$i,"timestamp");
         if (PROG_LANG=='hu')
            $datetime = date('Y.m.d H:i:s', $time);
         else
            $datetime = date('d.m.Y H:i:s', $time);
         echo "<tr><td>$uname</td><td>$datetime</td></tr>\n";
      }
      echo "</table><br>\n";
   }
      
   /**
   * User not an administrator, redirect to main page
   * automatically.
   */
   if (!$session->isAdmin()) {
      header("Location: entry.php");
   }
   else {
   /**
    * Administrator is viewing page, so display all
    * forms.
    */
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" >
<html xmlns="http://www.w3.org/1999/xhtml" lang="hu" xml:lang="hu">
<head>
<?php include('header.php'); ?>
<title><?php echo PROG_NAME.'\'s Login Page'; ?></title>
</head>

<body>
<!-- HEADER DIV -->
<div id="headerHead">
<!-- HEADER PICTURE DIV -->
<div id="pictureHead"></div>
<!-- END: HEADER PICTURE DIV -->

<!-- MAIN MENU -->
<div id="menuHead"><?php echo $LNG_018; ?></div>
<!-- END: MAIN MENU -->

<!-- MENU UNDERLINE DIVE -->
<div id="savHead"></div>
<!-- END: MENU UNDERLINE DIVE -->
</div>
<!-- END: HEADER DIV -->

<!-- HEADER ADMIN DIV -->
<div id="headerAdmin">
<h1><?php echo $LNG_058; ?></h1>
</div>
<!-- END: HEADER DIV -->

<!-- LOGGED USER DIV -->
<div id="loggedUserAdmin">
<font size="4"><?php echo $STD_013; ?><b><?php echo $session->username; ?></b>.</font>
<?php
      // check the browser
      if (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE'))
         echo "<input type=\"button\" onclick=\"window.location.href('entry.php');\" value=\"$LNG_004\">";
      else 
         echo "<a href=\"entry.php\"><input type=\"button\" value=\"".$LNG_004."\" /></a>";
?>
</div>
<!-- END: LOGGED USER DIV -->

<!-- ERROR DIV -->
<div id="errorAdmin">
<?php
      if ($form->num_errors > 0)
         echo "<font size=\"4\" color=\"#ff0000\">"."$LNG_059</font><br><br>";
?>
</div>
<!-- END: ERROR DIV -->

<!-- USER TABLE DIV -->
<div id="userTableAdmin">
<h3><?php echo $LNG_060; ?></h3>
<form>
<?php displayUsers(); ?>
</form>
</div>
<!-- END: USER TABLE DIV -->

<!-- UPDATE USER LEVEL DIV -->
<div id="updateUserLevelAdmin">
   <h3><?php echo $LNG_061; ?></h3>
   <?php echo $form->error("upduser"); ?>
   <form action="_include/adminprocess.php" method="post">
      <table>
         <tr>
            <!-- Username -->
            <td>
            <?php echo $STD_001; ?><br>
            <?php fillOutUsername('upduser'); ?>
            </td>
            <!-- User level -->
            <td>
            <?php echo $STD_008; ?><br>
            <select name="updlevel">
            <option value="user">user
            <option value="admin">admin
            </select>
            </td>
            <!-- Update level button -->
            <td>
            <br>
            <input type="hidden" name="subupdlevel" value="1">
            <input type="submit" value="<?php echo $LNG_062; ?>">
            </td>
         </tr>
      </table>
   </form>
</div>
<!-- END: UPDATE USER LEVEL DIV -->

<!-- DELETE USER DIV -->
<div id="deleteUserAdmin">
   <h3><?php echo $LNG_063; ?></h3>
   <?php echo $form->error("deluser"); ?>
   <form action="_include/adminprocess.php" method="POST">
      <?php echo $STD_001; ?><br>
      <?php fillOutUsername('deluser'); ?>
      <input type="hidden" name="subdeluser" value="1">
      <input type="submit" value="<?php echo $LNG_063; ?>">
   </form>
</div>
<!-- END: DELETE USER DIV -->

<!-- DELETE INACTIVE USER DIV -->
<div id="deleteInactiveUserAdmin">
   <h3><?php echo $LNG_064; ?></h3>
   <?php echo $LNG_065.'<br>'.$LNG_066.'<br><br>'; ?>
   <form action="_include/adminprocess.php" method="post">
      <table>
         <tr>
            <td>
            <?php echo $STD_012;?><br>
            <select name="inactdays">
            <option value="1">1
            <option value="3">3
            <option value="7">7
            <option value="14">14
            <option value="30">30
            <option value="100">100
            <option value="365">365
            </select>
            </td>
            <td>
            <br>
            <input type="hidden" name="subdelinact" value="1">
            <input type="submit" value="<?php echo $LNG_067; ?>">
            </td>
         </tr>
      </table>
   </form>
</div>
<!-- END: DELETE INACTIVE USER DIV -->

<!-- BAN USER DIV -->
<div id="banUserAdmin">
   <h3><?php echo $LNG_068; ?></h3>
   <?php echo $form->error("banuser"); ?>
   <form action="_include/adminprocess.php" method="post">
      <?php echo $STD_001; ?><br>
      <?php fillOutUsername('banuser'); ?>
      <input type="hidden" name="subbanuser" value="1">
      <input type="submit" value="<?php echo $LNG_069; ?>">
   </form>
</div>
<!-- END: BAN USER DIV -->

<!-- DISPLAY BANNED USERS TABLE DIV -->
<div id="displayBanUsersTableAdmin">
   <h3><?php echo $LNG_070; ?></h3>
   <?php displayBannedUsers(); ?>
</div>
<!-- END: DISPLAY BANNED USERS TABLE DIV -->

<!-- DELETE BANNED USER DIV -->
<div id="deleteBannedUserAdmin">
   <h3><?php echo $LNG_071; ?></h3>
   <?php echo $form->error("delbanuser"); ?>
   <form action="_include/adminprocess.php" method="POST">
      <?php echo $STD_001; ?><br>
      <?php fillOutBannedUsername('delbanuser'); ?>
      <input type="hidden" name="subdelbanned" value="1">
      <input type="submit" value="<?php echo $LNG_071; ?>">
   </form>
</div>
<!-- END: DELETE BANNED USER DIV -->

<!-- RESTORE BANNED USER DIV -->
<div id="restoreBannedUserAdmin">
   <h3><?php echo $LNG_072; ?></h3>
   <?php echo $form->error("rstbanuser"); ?>
   <form action="_include/adminprocess.php" method="POST">
      <?php echo $STD_001; ?><br>
      <?php fillOutBannedUsername('rstbanuser'); ?>
      <input type="hidden" name="subrstbanned" value="1">
      <input type="submit" value="<?php echo $LNG_072; ?>">
   </form>
</div>
<!-- END: RESTORE BANNED USER DIV -->

<?php
   }
?>
</body>
</html>