<?php
   /**
   * AdminProcess.php
   * 
   * The AdminProcess class is meant to simplify the task of processing
   * admin submitted forms from the admin center, these deal with
   * member system adjustments.
   *
   */
   include('session.php');
   
   class AdminProcess {
      /* Class constructor */
      public function __construct() {
         global $session;
         
         /* Make sure administrator is accessing page */
         if (!$session->isAdmin()) {
            header("Location: ../entry.php");
            return;
         }
         
         /* Admin submitted update user level form */
         if (isset($_POST['subupdlevel'])) {
            $this->procUpdateLevel();
         }
         /* Admin submitted delete user form */
         else if (isset($_POST['subdeluser'])) {
            $this->procDeleteUser();
         }
         /* Admin submitted delete inactive users form */
         else if (isset($_POST['subdelinact'])) {
            $this->procDeleteInactive();
         }
         /* Admin submitted ban user form */
         else if (isset($_POST['subbanuser'])) {
            $this->procBanUser();
         }
         /* Admin submitted delete banned user form */
         else if (isset($_POST['subdelbanned'])) {
            $this->procDeleteBannedUser();
         }
         /* Admin submitted restore banned user form */
         else if (isset($_POST['subrstbanned'])) {
            $this->procRestoreBannedUser();
         }
         /* Should not get here, redirect to home page */
         else {
            header("Location: ../entry.php");
         }
      }
   
      /**
      * procUpdateLevel - If the submitted username is correct,
      * their user level is updated according to the admin's
      * request.
      */
      public function procUpdateLevel() {
         global $session, $database, $form;
         
         /* Username error checking */
         $subuser = $this->checkUsername("upduser");
         
         /* Errors exist, have user correct them */
         if ($form->num_errors > 0) {
            $_SESSION['value_array'] = $_POST;
            $_SESSION['error_array'] = $form->getErrorArray();
            header("Location: ".$session->referrer);
         }
         /* Update user level */
         else {
            if (isset($_POST['updlevel'])) {
               $newlevel = $_POST['updlevel'];
               if ($newlevel == 'user')
                  $newlevel = 1;
               else if ($newlevel == 'admin')
                  $newlevel = 9;
            }
            $database->updateUserField($subuser, "userlevel", $newlevel);
            header("Location: ".$session->referrer);
         }
      }
      
      /**
      * procDeleteUser - If the submitted username is correct,
      * the user is deleted from the database.
      */
      public function procDeleteUser() {
         global $session, $database, $form;
         
         /* Username error checking */
         $subuser = $this->checkUsername("deluser");
         
         /* Errors exist, have user correct them */
         if ($form->num_errors > 0) {
            $_SESSION['value_array'] = $_POST;
            $_SESSION['error_array'] = $form->getErrorArray();
            header("Location: ".$session->referrer);
         }
         /* Delete user from database */
         else{
            $q = "DELETE FROM ".TBL_USERS." WHERE username = '$subuser'";
            $database->query($q);
            header("Location: ".$session->referrer);
         }
      }
      
      /**
      * procDeleteInactive - All inactive users are deleted from
      * the database, not including administrators. Inactivity
      * is defined by the number of days specified that have
      * gone by that the user has not logged in.
      */
      public function procDeleteInactive() {
         global $session, $database;
         
         $inact_time = $session->time - $_POST['inactdays']*24*60*60;
         $q = "DELETE FROM ".TBL_USERS." WHERE timestamp < $inact_time "
             ."AND userlevel != ".ADMIN_LEVEL;
         $database->query($q);
         header("Location: ".$session->referrer);
      }
      
      /**
      * procBanUser - If the submitted username is correct,
      * the user is banned from the member system, which entails
      * removing the username from the users table and adding
      * it to the banned users table.
      */
      public function procBanUser() {
         global $session, $database, $form;
         
         /* Username error checking */
         $subuser = $this->checkUsername("banuser");
         
         /* Errors exist, have user correct them */
         if ($form->num_errors > 0) {
            $_SESSION['value_array'] = $_POST;
            $_SESSION['error_array'] = $form->getErrorArray();
            header("Location: ".$session->referrer);
         }
         /* Ban user from member system */
         else {
            $q = "DELETE FROM ".TBL_USERS." WHERE username = '$subuser'";
            $database->query($q);
   
            $q = "INSERT INTO ".TBL_BANNED_USERS." VALUES ('$subuser', $session->time)";
            $database->query($q);
            header("Location: ".$session->referrer);
         }
      }
      
      /**
      * procDeleteBannedUser - If the submitted username is correct,
      * the user is deleted from the banned users table, which
      * enables someone to register with that username again.
      */
      public function procDeleteBannedUser() {
         global $session, $database, $form;
         
         /* Username error checking */
         $subuser = $this->checkUsername("delbanuser", true);
         
         /* Errors exist, have user correct them */
         if ($form->num_errors > 0) {
            $_SESSION['value_array'] = $_POST;
            $_SESSION['error_array'] = $form->getErrorArray();
            header("Location: ".$session->referrer);
         }
         /* Delete user from database */
         else {
            $q = "DELETE FROM ".TBL_BANNED_USERS." WHERE username = '$subuser'";
            $database->query($q);
            header("Location: ".$session->referrer);
         }
      }
      
      /**
      * procRestoreBannedUser - If the submitted username is correct,
      * the user is restored from the banned users table, which
      * enables to him to log into the system again.
      */
      public function procRestoreBannedUser() {
         global $session, $database, $form;
         
         /* Username error checking */
         $subuser = $this->checkUsername("rstbanuser", true);
         
         /* Errors exist, have user correct them */
         if ($form->num_errors > 0) {
            $_SESSION['value_array'] = $_POST;
            $_SESSION['error_array'] = $form->getErrorArray();
            header("Location: ".$session->referrer);
         }
         /* Restore a banned user */
         else {
            $q = "DELETE FROM ".TBL_BANNED_USERS." WHERE username = '$subuser'";
            $database->query($q);
   
            $q = "INSERT INTO ".TBL_USERS." ".
                 "VALUES ('$subuser', '".
                           RESTORE_MD5_PASS."', '".
                           RESTORE_USERID."', '".
                           RESTORE_USERLEVEL."', '".
                           RESTORE_USERMAIL."',
                           $session->time)";
            $database->query($q);
            header("Location: ".$session->referrer);
         }
      }
      
      /**
      * checkUsername - Helper function for the above processing,
      * it makes sure the submitted username is valid, if not,
      * it adds the appropritate error to the form.
      */
      public function checkUsername($uname, $ban=false) {
         include('../_lang/'.PROG_LANG.'.php');
         global $database, $form;
         
         /* Username error checking */
         $subuser = $_POST[$uname];
         $field = $uname;  //Use field name for username
         if (!$subuser || strlen($subuser = trim($subuser)) == 0) {
            $form->setError($field, $STD_010.'<br>');
         }
         else{
            /* Make sure username is in database */
            $subuser = stripslashes($subuser);
            if (strlen($subuser) < 5 || strlen($subuser) > 30 ||
               !preg_match("/^([áéíóöőúüűÁÉÍÓÖŐÚÜŰ0-9.a-zA-Z\s])+$/", $subuser) ||
               (!$ban && !$database->usernameTaken($subuser))) {
               $form->setError($field, $STD_011.'<br>');
            }
         }
         return $subuser;
      }
   };
   
   /* Initialize process */
   $adminprocess = new AdminProcess;
?>