<?php
	require_once('./common/config.php');
	require_once($langdir.$lang_file);
	
	class MainFunctions {
		/*********************
		** Private constructor
		*********************/
		private function __construct() {
		}
		
		/**********************************************
		** If current log.txt log file has been deleted
		** then we need to create a new one to log any
		** events (it will be created in log directory)
		*********************************************/
		public static function create_log_file($strFName) {
			$fileHandle=fopen($strFName, 'w') or die($msg_acc_create);
			fclose($fileHandle);
		}
		
		/******************************************
		** This function is used to determine the
		** script's execution time. It is copied
		** from the PHP help file and DOES NOT 
		** belong to me.
		******************************************/
		public static function getmicrotime()	{
			list($usec, $sec)=explode(' ', microtime());
			
			return ((float)$usec + (float)$sec);
		}

		/***********************************************
		** This function writes a log entry every time
		** a file has been downloaded. The arguments
		** are the data to be written, representing
		** the DNS of the client accessing the file,
		** date of the access and the accessed file.
		***********************************************/
		public static function store_file_acc_info($dns, $data, $acc_file) {
			// specify that the following variables
			// are declared outside the function
			global $logdir, $log_file, $dns_len, $data_len, $acc_file_len;
			
			//open the log file for reading / writing
			$fp=fopen($logdir.$log_file, 'r+b');		
			// read the first line ...
			$nr_inreg_arr=fscanf($fp, '%d\n');
			// ... as an integer representing the number of entries in the log
			$nr_inreg=$nr_inreg_arr[0];
			// increment the number of entries and ...
			$rez=sprintf('%08u\n', ($nr_inreg + 1));
			// ... write it back at the beginning of the log file
			fseek($fp, 0, SEEK_SET);
			fwrite($fp, $rez);
			// go to the end of the log file
			fseek($fp, 0, SEEK_END);
			// bring args to the desired length
			$dns=str_pad($dns, $dns_len);
			$data=str_pad($data, $data_len);
			$acc_file=str_pad($acc_file, $acc_file_len);
			// write each arg to the log file
			fwrite($fp, $dns, $dns_len);
			fwrite($fp, $data, $data_len);
			fwrite($fp, $acc_file, $acc_file_len);
			// a new line to write means "\n" not a '\n'
			fwrite($fp, "\n");
			// close the log file
			fclose($fp);
		}
		
		/****************************************
		** This function returns the script name
		****************************************/
		public static function getScriptName() {
			return ('phpPyxis FD Script');
			
		}
			
		/*******************************************
		** This function returns the script version
		*******************************************/
		public static function getScriptVersion() {
			return ('v1.0.1');
		}
		
		/**********************
		** Try to show an image
		**********************/
		public static function LoadGif($imgname) {
			/* Attempt to open */
			$im=@imagecreatefromgif($imgname);
			/* See if it failed */
	    if(!$im) {
			//if($im=="") {
				/* Create a blank image */
				$im=imagecreatetruecolor (150, 30);
        $bgc=imagecolorallocate ($im, 255, 255, 255);
        $tc=imagecolorallocate ($im, 0, 0, 0);
        imagefilledrectangle ($im, 0, 0, 150, 30, $bgc);
        /* Output an error message */
        imagestring ($im, 1, 5, 5, 'Error loading ' . $imgname, $tc);
			}
			
			return ($im);
		}
	}
?>