<?php
	// include configuration, language, functions and variables
	require_once('./common/config.php');
	require_once($langdir.$lang_file);
	require_once($incdir.'functions.php');
	require_once($incdir.'variables.php');
	
	// variable used to determine the script execution time
	$time_start = MainFunctions::getmicrotime();
?>

<html>
<head>
<meta http-equiv="content-type" content="text/html;charset=utf-8">
<meta http-equiv="refresh" content="1800">
<meta content="dlite,script,download,file,viewer,manxstar" name="keywords">
<meta content="manxstar" name="author">
<meta content="manxstar" name="copyright">
<meta content="ALL,INDEX,FOLLOW" name="robots">
<meta content="document" name="resource-type">
<link href="common/css/pyxis.css" type="text/css" rel="styleSheet">
<title><?php echo $msg_log_title; ?></title>
</head>

<body class="THEBODY">
<?php
	// use my own variable instead of the standard $_GET
	$varget=$_GET;
	// if no value for 'from' (log entry to start with) was passed to the script ...
	if (!isset($varget['from'])) {
		// use 0 as default
		$varget['from']=0;
	}
	// if no value for 'to' (log entry to end with) was passed to the script ...
	if (!isset($varget['to'])) {
		// use '$pas' as default
		$varget['to']=$pas;
	}
	// log entry to start with
	$from_val=$varget['from'];
	// log entry to end with
	$to_val=$varget['to'];
	//open the log file for reading / writing
	$fp=fopen($logdir.$log_file, 'r+b') or die($msg_acc_error);
	// read the first line ...
	$nr_inreg_arr=fscanf($fp, '%d\n');
	// ... as an integer representing the number of entries in the log
	$nr_inreg=$nr_inreg_arr[0];
?>
<!-- START MAIN TABLE -->
<table cellspacing="0" align="center" cellpadding="0">
<tr><td align="left" colspan="2">
<span class="small_text"><?php echo $msg_log_header; ?></span>
</td></tr>
<tr><td align="center" colspan="2" height="10"></td></tr>
<tr><td align="left">
<?php
	// get the current log page
	$pag_curenta=ceil($to_val/$pas);
?>
<span class="small_text"><?php echo $msg_log_page; ?>
<?php
	// get the total number of log pages available
	$nr_total_pag=((($nr_inreg/$pas)-(int)($nr_inreg/$pas)) != 0)
		? (int)($nr_inreg/$pas)+1 : (int)($nr_inreg/$pas);
	// print the page numbers
	for ($np=1; $np<=$nr_total_pag; $np++) {
		if ($np==$pag_curenta) {
			echo $np.' ';
		}
		else {
?>
<a href="log.php?from=<?php (($np-1)*$pas + 1); ?>
	&to=<?php min($np*$pas, $nr_inreg); ?>\>
<span class="page_nr_text"><b><?php echo $np; ?></b>
</span>
</a>
<?php
		}
	}
	// ended the log pages affair
?>
</span>

</td><td align="right">
<span class="small_text">
<?php
	echo $msg_log_total;
?>
<b>
<?php
	echo $nr_inreg.' ';
?>
</b>
<?php
	echo $msg_log_entry;
?>
</span>

</td></tr>
<tr><td valign="top" colspan="2">
<!-- START LOG ENTRIES TABLE -->
<table class="main_table" cellspacing="2" align="center" cellpadding="0">
<tr>
<td width="235" align="center" class="tab_header_cell">
<?php
	echo $msg_dns;
?>
</td>
<td width="170" align="center" class="tab_header_cell">
<?php
	echo $msg_date;
?>
</td>
<td width="305" align="center" class="tab_header_cell">
<?php
	echo $msg_acc_file;
?>
</td>
</tr>
<?php
	// outputing the log entries
	// set the log entry at which it will stop
	$to_val=min($nr_inreg, $to_val);
	// variable used to select row background color
	$j=0;
	// go through the log file ...
	for ($i=$from_val; $i<=$to_val; $i++) {
		// variable used to select row background color
		$j++;
		// ... get the position in the log file according to the log entry number '$i' ...
		$poz=$i*(1+$dns_len+$data_len+$acc_file_len);
		fseek($fp, -$poz, SEEK_END);
		// ... start reading data
		$dns=fread($fp, $dns_len);
		$data=fread($fp, $data_len);
		$acc_file=fread($fp, $acc_file_len);
		// normalize data (eliminate spaces from the beginning and the end of the string)
		$dns=trim($dns);
		$data=trim($data);
		$acc_file=trim($acc_file);
		echo '<tr bgcolor='.$color[$j%2].'>';
		echo '<td>'.$dns.'</td><td align=\'center\'>'.
				 $data.'</td><td align=\'right\'>'.$acc_file.'</td>';
	}
	// close the log file
	fclose($fp);
?>
</tr>
</table>
</td></tr>

<!-- START LOG ENTRIES TABLE -->
<tr><td align="center" colspan="2">
<table cellspacing="0" align="center" cellpadding="0" width="100%">
<?php
	// show script execution time or not (*** see 'common/config.php' ***)
	if ($SHOW_EXEC_TIME) {
?>

<!-- START PRINTING EXEC TIME -->
<td align="left"><span class="small_text">
<?php
		echo $msg_exec_time.':';
?>
</span>
<span class="small_text"><b>
<?php
		$time_end=MainFunctions::getmicrotime();
		$time=$time_end-$time_start;
		printf('%.4f', $time);
	}
?>
</b></span>
<span class="small_text">sec.</span></td>
<!-- STOP PRINTING EXEC TIME -->

<!-- SHOW PHP SCRIPT NAME AND VERSION -->
<?php
	// show script name or not (*** see 'common/config.php' ***)
	if ($SHOW_SCRIPT_NAME) {
?>
<td align="right"><span class="small_text">
<?php
		echo MainFunctions::getScriptName().' '.MainFunctions::getScriptVersion();
	}
?>
</span>
</td>
<!-- STOP SHOW PHP SCRIPT NAME AND VERSION -->

</tr>
</table></td>
</tr>
</table>
<!-- STOP MAIN TABLE -->
</body>
</html>