<?php
	// include configuration, language, functions and variables
	require_once('./common/config.php');
	require_once($langdir.$lang_file);
	require_once($incdir.'functions.php');
	require_once($incdir.'variables.php');
	
	// variable used to determine the script execution time
	$time_start=MainFunctions::getmicrotime();
	// if log.txt file does not exist then create it
	if (file_exists($logdir.$log_file)==false) {
		MainFunctions::create_log_file($logdir.$log_file);
	}
?>

<html>
<head>
<meta http-equiv="content-type" content="text/html;charset=utf-8">
<meta http-equiv="refresh" content="1800">
<meta content="download,manager,script,file,viewer,manxstar" name="keywords">
<meta content="manxstar" name="author">
<meta content="manxstar" name="copyright">
<meta content="ALL,INDEX,FOLLOW" name="robots">
<meta content="document" name="resource-type">
<link href="common/css/pyxis.css" type="text/css" rel="styleSheet">
<!-- START FADED ICONS SCRIPT -->
<!-- This script DOES NOT belong to me -->
<!-- The script is taken from http://www.inflames.com -->
<script type="text/javascript" src="common/js/faded_icons.js"></script>
<!-- STOP FADED ICONS SCRIPT -->
<title><?php echo $msg_index_title; ?></title>
</head>

<body class="THEBODY"
			onload="MM_displayStatusMsg('<?php echo $msg_status; ?>')">
<!-- START CODE FILE VIEWER -->
<?php
	// use my own variable instead of the standard $_GET
	$varget=$_GET;
	// check to see whether a valid directory was passed to the script
	if (isset($varget['dirpath']) && !empty($varget['dirpath'])) {
		// if it is valid, we'll set it as the directory to read data from
		$dirpath=$varget['dirpath'];
		$dirpath=str_replace('*', '&', $dirpath);
	}
	else {
		// if it is invalid, we'll use the default directory
		$dirpath=$defdirpath;
	}
	// if no ordering info was passed i'll use 0 (ascending)
	if (!isset($varget['order'])) {
		$varget['order']=0;
	}
	// check to see whether the ".." is used to open an upper level directory
	if (strpos($dirpath, '..')===false) {
	}
	else {
		// if it is used, we'll use the default directory
		$dirpath=$defdirpath;
	}
	// check to see whether the requested directory
	// is not in the dcript subtree list
	if (strpos($dirpath, './')===false || strpos($dirpath, './')!=0) {
		// we'll use the default directory
		$dirpath=$defdirpath;
	}
	// variable used to keep slashes, so no JavaScript error occurs on line 189
	$jsdir=$dirpath;
	// strip slashes in order to get the REAL name of the file/directory
	$dirpath=stripslashes($dirpath);
	// try to change the current working directory
	// to the one from wich i want to read contents from
	if (!@chdir($dirpath)) {
		// if the change failed, i'll use the default directory
		$dirpath=$defdirpath;
		@chdir($dirpath);
	}
	// once the current working directory is set, it is opened and read from
	if ($dir=@opendir('.')) {
		// while there are still entries
		while (($entry=readdir($dir))!==false) {
			// split the filename into name and extension
			$split_name_ext=explode('.', $entry);
			// store the file extension
			$extensie=(count($split_name_ext)-1 != 0) ?
									$split_name_ext[count($split_name_ext)-1] : '';
			// store the lowercased extenosion
			$lextensie=strtolower($extensie);
			// if the entry is to be shown (not part of the '$not_to_be_shown' array)
			// decide whether it is a directory
			// or a regular file and add it accordingly
			if (!in_array($lextensie, $ext_not_to_be_shown)) {
				if (!in_array($entry, $not_to_be_shown)) {
					if (!is_dir($entry)) {
						$fisiere[]=$entry;
					} else {
						$directoare[]=$entry;
					}
				}
			}
		}
		// close the opened directory
		closedir($dir);
	}
?>

<!-- START OF THE MAIN TABLE-->
<table cellspacing="0" align="center" cellpadding="0">
<?php
	// show current directory path or not (*** see 'common/config.php' ***)
	if ($SHOW_CURRENT_DIRECTORY) {
?>
<tr><td>
<table cellspacing="0" align="center" cellpadding="0" width="100%">

<!-- START PRINTING CURRENT DIRECTORY NAME -->
<tr><td align="left">
<span class="small_text"><?php echo $msg_cwd; ?></span>
<span class="small_text"><b>/
<?php echo substr($dirpath,2,(strlen($dirpath)-2)); ?>
</b></span>
</td></tr>
<!-- STOP PRINTING CURRENT DIRECTORY NAME -->
</table></td></tr>
<?php
	}
?>

<tr><td height="10"></td></tr>
<tr><td valign="top">
<!-- START ORDERING BY NAME -->
<?php
	// sort the arrays ascending
	natcasesort($directoare);
	natcasesort($fisiere);
	// check the order option value
	switch ($varget['order']) {
		// 0 - ascending
		case 0:
			$imgsrc=$imgdir.'arr_up.gif';
			break;
		// 1 - descending
		case 1:
			// reverse the files array
			$fisiere=array_reverse($fisiere);
			$imgsrc=$imgdir.'arr_down.gif';
			break;
	}
	// specify the arraow image we'll use near the NAME column
	$sageata='<img src=\''.$imgsrc.'\'>';
?>
<!-- STOP ORDERING BY NAME -->

<!-- START PRINTING THE DIRECTORY'S CONTENTS -->
<table class="main_table" cellspacing="2" align="center" cellpadding="0">
<?php
	// if config.php->$SHOW_TAB_HEADER_ROW variable is true
	// which shows the tabel header row
	if ($SHOW_TAB_HEADER_ROW) {
?>
<tr>
<?php
		if ($SHOW_ICON) {
?>
<td width="30" align="center" class="tab_header_cell">
<?php echo $msg_ico; ?>
</td>
<?php
		}
?>
<td width="200" align="center" class="tab_header_cell"
onclick="window.location=index.php?dirpath=
<?php $jsdir; ?>&order=1-<?php $varget['order']; ?>\">
<?php
	echo $msg_name;
	echo $sageata;
?>
</td>

<td width="40" align="center" class="tab_header_cell">
<?php echo $msg_ext; ?>
</td>

<?php
		if ($SHOW_SIZE) {
?>
<td width="80" align="center" class="tab_header_cell">
<?php echo $msg_size; ?>
</td>
<?php
		}
		if ($SHOW_MODIFIED) {
?>
<td width="110" align="center" class="tab_header_cell">
<?php echo $msg_modified; ?>
</td>
<?php
		}
		if ($SHOW_DESCRIPTION) {
?>
<td width="150" align="center" class="tab_header_cell">
<?php echo $msg_description; ?>
</td>
<?php
		}
?>
</tr>

<?php
	}
	// if config.php->$SHOW_TAB_HEADER_ROW is false
	else {
?>
<tr>
<?php
		if ($SHOW_ICON) {
?>
<td width="30"></td>
<?php
		}
?>
<td width="200"></td>
<td width="40"></td>
<?php
		if ($SHOW_SIZE) {
?>
<td width="80"></td>
<?php
		}
		if ($SHOW_MODIFIED) {
?>
<td width="110"></td>
<?php
		}
		if ($SHOW_DESCRIPTION) {
?>
<td width="150"></td></tr>
<?php
		}
	}
?>

<?php
	// variable used to select row background color
	$j=-1;
	// read each element of the directories array
	foreach($directoare as $key => $director) {
		// ignore the parent directory '..' when printing
		// the contents of the root directory
		if (!strcmp($director, '..') && !strcmp($dirpath, '.')) {
			continue;
		}
		// variable used to select row background color
		$j++;
		// array to keep each directory's stats
		$dta=stat($director);
		// the directories are treated this way...
		// except '..' which has a different icon from the other directories
		if (strcmp($director,'..')) {
?>
<tr bgcolor="<?php $color[$j%2]; ?>" height="20">
<?php
			if ($SHOW_ICON) {
?>
<td align="center"><img src="<?php echo $imgdir.'dir.gif'; ?>"></td>
<?php
			}
?>
<td align="left">
<a href="index.php?dirpath=<?php echo $dirpath.'/'.
	str_replace('&', '*', $director); ?>&order=<?php echo $varget['order']; ?>">
<span class="dir_text">[<?php echo $director; ?>]</span>
</a>
<?php			
			if (((time()-$dta[9])/1E+5)<$new_period) {
?>
<span class="small_red_text"><?php echo $msg_new; ?></span>
<?php
			}
?>
</td>
<td align="right"></td>
<?php
			if ($SHOW_SIZE) {
?>
<td align="right"><span class="text">&lt;DIR&gt;</span></td>
<?php
			}
			if ($SHOW_MODIFIED) {
?>
<td align="right">
<span class="text">
<?php
				if ($lang_file=='hu.php') {
					echo date('Y.m.d H:i', $dta[9]);	
				}
				else {
					echo date('d.m.Y H:i', $dta[9]);
				}
			}
?>
</td>
<?php
			if ($SHOW_DESCRIPTION) {
?>
<td align="right"></td>
<?php
			}
?>
</tr>
<?php
		}
		else {
?>
<tr bgcolor="<?php echo $color[$j%2]; ?>" height="20">
<?php
			if ($SHOW_ICON) {
?>
<td align="center"><img src="<?php echo $imgdir.'back.gif'; ?>"></td>
<?php
			}
?>
<td align="left">
<a href="index.php?dirpath=<?php echo dirname($dirpath); ?>
		&order=<?php echo $varget['order']; ?>">
<span class="dir_text">[<?php echo $director; ?>]</span>
</a>
</td>
<td align="right"></td>
<?php			
			if ($SHOW_SIZE) {
?>
<td align="right"><span class="text">&lt;DIR&gt;</span></td>
<?php
			}
			if ($SHOW_MODIFIED) {
?>
<td align="right">
<span class="text">
<?php
				if ($lang_file=='hu.php') {
					echo date('Y.m.d H:i', $dta[9]);	
				}
				else {
					echo date('d.m.Y H:i', $dta[9]);
				}
			}
?>
</td>
<?php
			if ($SHOW_DESCRIPTION) {
?>
<td align="right"></td>
</tr>
<?php
			}
		}
		// clear the stats of the entry
		clearstatcache();
	}
	// read each element of the files array
	foreach($fisiere as $key => $file) {
		$j++;
		// array to keep each directory's stats
		$dta=stat($file);
		// split the filename into name and extension
		$split_name_ext=explode('.', $file);
		// store the file extension
		$extensie=(count($split_name_ext)-1 != 0) ?
							$split_name_ext[count($split_name_ext)-1] : '';
		// store the lowercased extenosion
		$lextensie=strtolower($extensie);
		// if there is a custom icon and descrpition for this type of files
		// use them instead of the default ones
		if (array_key_exists($lextensie, $exts)) {
			$descriere=$exts[$lextensie][0];
			$iconita=$exts[$lextensie][1];
		}
		else {
			// these are the default icon and description
			$descriere='';
			$iconita='unknown.gif';
		}
?>
<tr bgcolor="<?php echo $color[$j%2]; ?>" height="20">
<?php
		// print the icon
		if ($SHOW_ICON) {
?>
<td align="center"><img src="<?php echo $imgdir.$iconita; ?>"></td>
<?php
		}
		// print the filename
		if (in_array($lextensie, $not_to_be_dloaded)) {
			// for the files that should not be downloaded use a direct link
?>
<td align="left">
<a href="<?php echo $dirpath.'/.'.$file.'\\'; ?>
<span class="text"><?php echo $split_name_ext[0] ?>
<?php
		}
		else {
			// for the files that should be downloaded use the 'download.php' script
?>
<td align="left">
<a href="download.php?fname=<?php	echo str_replace('&','*',$dirpath.'/'.$file); ?>"
	onmouseover="MM_displayStatusMsg('')"
	onmouseout="MM_displayStatusMsg(<?php echo $msg_status; ?>)\">
<span class="text"><?php echo $split_name_ext[0]; ?>
<?php
		}
		for($i=1; $i<count($split_name_ext)-1; $i++) {
			echo ($split_name_ext[$i]);
		}
?>
</span></a>
<?php
		// print '$msg_new' for new files
		if (((time()-$dta[9])/1E+5)<$new_period) {
?>
<span class="small_red_text"><?php echo $msg_new; ?></span> 
<?php
		}
?>
</td>
<td align="right"><span class="text">
<?php
		// print the extension
		echo $extensie;
?>
</td>
<?php
		// print the file size
		if ($SHOW_SIZE) {
?>
<td align="right">
<span class="text">
<?php
			printf('<span class=\'text\'>%.2f kB</span>', $dta[7]/1024);
		}
?>
</span></td>
<?php
		// print the date the file was last modified
		if ($SHOW_MODIFIED) {
?>
<td align="right">
<span class="text">
<?php
			if ($lang_file=='hu.php') {
				echo date('Y.m.d H:i', $dta[9]);	
			}
			else {
				echo date('d.m.Y H:i', $dta[9]);
			}
		}
?>
</td>
<?php
		// print the file type description
		if ($SHOW_DESCRIPTION) {
?>
<td align="right">
<span class="text">
<?php
			echo $descriere;
		}
		// clear the stats of the entry
		clearstatcache();
	}
?>
</span>
</td>
</tr>
</table>
<!-- STOP PRINTING THE DIRECTORY'S CONTENTS -->
</td>
<td width="3"></td>

<!-- START TOOLBAR -->
<td valign="top" align="center">
<table cellspacing="3" cellpadding="0" border="0" class="main_table">
<!-- SHOW LOG FILE -->
<?php
	if ($LOG_TRAFFIC) {
?>
<tr><td align="center">
<img src="<?php echo $imgdir; ?>log.gif" width="16" height="16" border="0" 
onmouseover="high(this);MM_displayStatusMsg('<?php echo $msg_log; ?>')" 
style="FILTER: alpha(opacity=40)" 
onmouseout="low(this);MM_displayStatusMsg('<?php echo $msg_status; ?>')" 
onclick="window.open('log.php','logWin','width=745 height=350 scrollbars=yes')">
</td></tr>
<?php
	}
?>
<!-- REDIRECT APPLICATION WEBSITE -->
<tr><td align="center">
<img src="<?php echo $imgdir; ?>info.gif" width="16" height="16" border="0" 
onmouseover="high(this);MM_displayStatusMsg('<?php echo $msg_info; ?>')" 
style="FILTER: alpha(opacity=40)" 
onmouseout="low(this);MM_displayStatusMsg('<?php echo $msg_status; ?>')" 
onclick="window.open('<?php echo $msg_home_url; ?>')">
</td></tr>
<!-- PRINT THE PAGE -->
<?php
	if ($PRINT_PAGE) {
?>
<tr><td align="center">
<img src="<?php echo $imgdir; ?>print.gif" width="16" height="16" border="0" 
onmouseover="high(this);MM_displayStatusMsg('<?php echo $msg_print; ?>')" 
style="FILTER: alpha(opacity=40)" 
onmouseout="low(this);MM_displayStatusMsg('<?php echo $msg_status; ?>')" 
onclick="window.print()">
</td></tr>
<?php
	}
?>
</table>
</td>
<!-- STOP TOOLBAR -->
</tr>

<tr><td height="10"></td></tr>
<tr><td align="center">
<table cellspacing="0" align="center" cellpadding="0" width="100%">
<tr>
<?php
	// show script execution time or not (*** see 'common/config.php' ***)
	if ($SHOW_EXEC_TIME) {
?>
<!-- START PRINTING EXEC TIME -->
<td align="left">
<span class="small_text">
<?php
		echo $msg_exec_time.':';
?>
</span>
<span class="small_text"><b>
<?php
		$time_end=MainFunctions::getmicrotime();
		$time=$time_end-$time_start;
		printf('%.4f', $time);
	}
?>
</b></span>
<span class="small_text">sec.</span>
</td>
<!-- STOP PRINTING EXEC TIME -->

<?php
	// show script name or not (*** see 'common/config.php' ***)
	if ($SHOW_SCRIPT_NAME) {
?>
<td align="right">
<span class="small_text">
<?php
		echo MainFunctions::getScriptName().' '.MainFunctions::getScriptVersion();
	}
?>
</span>
</td>
</tr>
</table>
</td>
</tr>
</table>
<!-- STOP OF THE MAIN TABLE-->
<!-- STOP CODE FILE VIEWER -->
</body>
</html>