<?php
class FileTool {
	private function __construct() {
	}
	
	public static function FileMagic($filename) {
		// return the magic portion from the "file" command
		if (!is_file($filename))
			die ('File_Magic :: file does not exist');
		$hash=exec('file \"'.$filename.'\"');
		$hash_array=explode($filename.':',$hash);
		
		return (trim($hash_array[1]));
	}
	
	public static function FileSize($filename) {
		if (!is_file($filename))
			die ("file_size :: file does not exist");
		
		// prevent PHP from choking
		clearstatcache();
		$file_stat=stat($filename);
		
		return $file_stat[7];
	}
	
	public static function GetCurrentFilename() {
		// contains only current filename
		$myfile='';
		// get current file name: index starts with 0
		$curr_file=$_SERVER['PHP_SELF']; 
		$i=strlen($curr_file);
		while ($curr_file[$i-1]!='/') {
			$myfile.=$curr_file[$i-1]; 
			--$i;
		}
		$myfile=strrev($myfile);
		
		return ($myfile);
	}
	
	public static function HumanReadableFileSize($filename) {
		// calculate file size (in human readable format)
		if ((!is_file($filename)) && (!is_integer($filename))) {
			die ('human_readable_filesize :: file does not exist');
		}
		
		if (($filename+0)>0) {
			$file_size_num=$filename+0;
		}
		else {
			$file_size_num=FileTool::FileSize($filename);
		}
		if (($file_size_num > 1024) && ($file_size_num < (1024*750))) {
			return number_format(($file_size_num / (1024)), 3).'kB = '.
							$file_size_num.' bytes';
		}
		else if (($file_size_num > (1024*750)) && 
						 ($file_size_num < (1024*1024*750)) ) {
			return number_format(($file_size_num / (1024*1024)), 3).'MB = '.
							$file_size_num.' bytes';
		}
		else {
			return $file_size_num.' bytes'; 
		}
	}
	
	public static function TransferTime($filename,$linespeed) {
		// linespeed is 14.4 for 14400, etc... (kbps)
		// returns transfer time in seconds
		if (($filename+0)>0) {
			$file_size=$filename;
		}
		else {
			$file_size=FileTool::FileSize($filename);
		}
		$bps=($linespeed*1000)/8;
		
		return (ceil(($file_size/$bps)));
	}
}
?>